/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tango.pogo.pogoDsl.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.OldModelParser;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoParser;
import org.tango.pogo.pogo_gui.tools.Utils;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoClass;
import pogo.gene.PropertyTable;

public class OldPogoModel {
    private PogoDeviceClass new_model = OAWutils.factory.createPogoDeviceClass();
    private PogoClass old_model = null;
    public static final String[] cppFilenames = new String[]{"Makefile", "main.cpp", "ClassFactory.cpp", "ClassName.h", "ClassName.cpp", "ClassNameClass.h", "ClassNameClass.cpp", "ClassNameStateMachine.cpp"};

    public OldPogoModel(String filename) throws DevFailed {
        this.new_model.setDescription(OAWutils.factory.createClassDescription());
        try {
            String inherClass;
            int pos;
            System.out.println("Trying to load " + filename);
            if (System.getProperty("TEMPL_HOME") == null) {
                System.setProperty("TEMPL_HOME", "");
            }
            this.old_model = new PogoClass(filename);
            this.new_model.setName(this.old_model.class_name);
            this.new_model.getDescription().setDescription(this.old_model.class_desc);
            this.new_model.getDescription().setLanguage(PogoConst.strLang[this.old_model.language]);
            this.new_model.getDescription().setSourcePath(Utils.getPath(filename));
            this.new_model.getDescription().setTitle(this.old_model.title);
            Inheritance inheritance = OAWutils.factory.createInheritance();
            String inherPath = System.getProperty("SUPER_HOME");
            if (inherPath == null) {
                inherPath = "";
            }
            if ((pos = (inherClass = this.old_model.inherited_from).lastIndexOf(47)) < 0) {
                pos = inherClass.lastIndexOf(92);
            }
            if (pos > 0) {
                inherPath = inherClass.substring(0, pos);
                inherClass = inherClass.substring(pos + 1);
            }
            inheritance.setClassname(inherClass);
            inheritance.setSourcePath(inherPath);
            EList<Inheritance> inher = this.new_model.getDescription().getInheritances();
            inher.add(inheritance);
            if (this.old_model.device_id != null) {
                if (!this.old_model.device_id.failed) {
                    ClassIdentification ident = OAWutils.factory.createClassIdentification();
                    DeviceIdDialog.buildIdContact(ident, this.old_model.device_id.contact);
                    ident.setPlatform(this.old_model.device_id.platform);
                    ident.setBus(this.old_model.device_id.bus);
                    ident.setManufacturer(this.old_model.device_id.manufacturer);
                    ident.setReference(this.old_model.device_id.reference);
                    ident.setClassFamily(this.old_model.device_id.family);
                    ident.setSiteSpecific(this.old_model.device_id.site);
                    this.new_model.getDescription().setIdentification(ident);
                } else {
                    System.err.println("old_model.device_id Failed !");
                }
            }
            EList<Property> classprops = this.new_model.getClassProperties();
            EList<Property> devprops = this.new_model.getDeviceProperties();
            EList<Command> commands = this.new_model.getCommands();
            EList<Attribute> attributes = this.new_model.getAttributes();
            EList<State> states = this.new_model.getStates();
            this.manageOldProperties(classprops, this.old_model.class_properties);
            this.manageOldProperties(devprops, this.old_model.dev_properties);
            this.manageOldCommands(commands, this.old_model.commands);
            this.manageOldAttributes(attributes, this.old_model.attributes);
            this.manageOldStates(states, this.old_model.states);
            System.out.println(String.valueOf(filename) + "  Loaded !!!");
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception("Loading OLD Pogo Class Failed", String.valueOf(e.toString()) + "\n\n" + "Loading OLD Pogo Class Failed\n", "OldPogoModel.OldPogoModel()");
        }
    }

    public PogoDeviceClass getPogoDeviceClass() {
        return this.new_model;
    }

    public boolean isAbsAbstract() {
        return this.old_model.is_abstractclass;
    }

    public void recoverCppCodeFromOldPogoModel(PogoDeviceClass new_model) throws Exception {
        String classname = new_model.getName();
        String filename = String.valueOf(new_model.getDescription().getSourcePath()) + "/" + new_model.getName();
        PogoParser new_parser = new PogoParser(String.valueOf(filename) + ".h");
        OldModelParser old_parser = new OldModelParser(this.old_model.projectFiles.getServer_h(), this.old_model);
        String code = this.getIncludeFiles(".h");
        if ((code = String.valueOf(code) + this.getDefinitions()) != null && code.length() > 0) {
            new_parser.insertIncludeFiles(code);
        }
        code = "public:\n" + old_parser.getDataMembers();
        new_parser.insertInProtectedZone(classname, "Data Members", code);
        code = old_parser.getAdditionalMethodPrototypes();
        new_parser.insertAdditionalMethodPrototypes(classname, code);
        code = old_parser.getAdditionalClassDeclarations();
        new_parser.insertAdditionalClassDefs(classname, code);
        code = old_parser.getAdditionalClasses();
        new_parser.insertAdditionalClasses(classname, code);
        new_parser.write();
        System.out.println(String.valueOf(filename) + ".h  updated");
        new_parser = new PogoParser(String.valueOf(filename) + ".cpp");
        old_parser = new OldModelParser(this.old_model.projectFiles.getServer(), this.old_model);
        code = this.getIncludeFiles(".cpp");
        new_parser.insertIncludeFiles(code);
        code = this.getStaticInit(old_parser);
        new_parser.insertInProtectedZone(classname, "namespace_starting", code);
        code = this.getInitDeviceCodeBefore(old_parser);
        new_parser.insertInProtectedZone(classname, "init_device_before", code);
        code = this.getInitDeviceCodeAfter(old_parser);
        new_parser.insertInProtectedZone(classname, "init_device", code);
        code = this.getDeleteDeviceCode(old_parser);
        new_parser.insertInProtectedZone(classname, "delete_device", code);
        code = this.getInitPropertyCode(old_parser, true);
        new_parser.insertInProtectedZone(classname, "get_device_property_before", code);
        code = this.getEndPropertyCode(old_parser, true);
        new_parser.insertInProtectedZone(classname, "get_device_property_after", code);
        code = this.getAlwaysExecutedHookCode(old_parser);
        new_parser.insertInProtectedZone(classname, "always_executed_hook", code);
        EList<Command> commands = new_model.getCommands();
        for (Command cmd : commands) {
            code = this.getCommandCode(old_parser, cmd);
            if (code != null && code.length() > 0) {
                System.out.println("inserting code for command" + cmd.getName());
            }
            new_parser.insertInProtectedZone(classname, cmd.getExecMethod(), code);
        }
        code = this.getReadAttrHardwareCode(old_parser);
        new_parser.insertInProtectedZone(classname, "read_attr_hardware", code);
        EList<Attribute> attributes = new_model.getAttributes();
        for (Attribute att : attributes) {
            code = this.getReadAttributeCode(old_parser, att);
            if (code != null && code.length() > 0) {
                System.out.println("inserting code for attribute " + att.getName());
            }
            new_parser.removeProtectedZone(classname, "read_" + att.getName());
            new_parser.insertInProtectedZone(classname, "read_" + att.getName(), code);
            code = this.getWriteAttributeCode(old_parser, att);
            new_parser.removeProtectedZone(classname, "write_" + att.getName());
            new_parser.insertInProtectedZone(classname, "write_" + att.getName(), code);
        }
        code = old_parser.getUnexpectedMethods();
        new_parser.insertInProtectedZone(classname, "namespace_ending", code);
        new_parser.write();
        System.out.println(String.valueOf(filename) + ".cpp  updated");
        new_parser = new PogoParser(String.valueOf(filename) + "Class.cpp");
        old_parser = new OldModelParser(this.old_model.projectFiles.getServerClass(), this.old_model);
        code = this.getIncludeFiles("Class.cpp");
        new_parser.insertIncludeFiles(code);
        code = this.getConstructorCode(old_parser);
        new_parser.insertInProtectedZone(classname, "Class::constructor", code);
        code = this.getInitPropertyCode(old_parser, false);
        new_parser.insertInProtectedZone(classname, "Class::get_class_property_before", code);
        code = this.getEndPropertyCode(old_parser, false);
        new_parser.insertInProtectedZone(classname, "Class::get_class_property_after", code);
        code = this.getDserverAdditionnalMethods(old_parser);
        new_parser.insertInProtectedZone(classname, "Class::Additional Methods", code);
        code = this.getDeviceFactoryCode(old_parser, true);
        new_parser.insertInProtectedZone(classname, "Class::device_factory_before", code);
        code = this.getDeviceFactoryCode(old_parser, false);
        new_parser.insertInProtectedZone(classname, "Class::device_factory_after", code);
        new_parser.write();
        System.out.println(String.valueOf(filename) + "Class.cpp  updated");
        new_parser = new PogoParser(String.valueOf(filename) + "Class.h");
        old_parser = new OldModelParser(this.old_model.projectFiles.getServerClass_h(), this.old_model);
        code = this.getIncludeFiles("Class.h");
        new_parser.insertIncludeFiles(code);
        code = this.getDserverDataMembers(old_parser);
        new_parser.insertInProtectedZone(classname, "Additionnal DServer data members", code);
        code = this.getDserverDynamicClasses(old_parser);
        new_parser.insertInProtectedZone(classname, "classes for dynamic creation", code);
        new_parser.write();
        System.out.println(String.valueOf(filename) + "Class.h  updated");
        new_parser = new PogoParser(String.valueOf(filename) + "StateMachine.cpp");
        old_parser = new OldModelParser(this.old_model.projectFiles.getAllowed(), this.old_model);
        for (Command cmd : commands) {
            code = this.getIsAllowedCode(old_parser, cmd.getName());
            new_parser.insertInProtectedZone(classname, String.valueOf(cmd.getName()) + "StateAllowed", code);
        }
        for (Attribute att : attributes) {
            code = this.getIsAllowedCode(old_parser, att.getName());
            new_parser.insertInProtectedZone(classname, "read_" + att.getName() + "StateAllowed_READ", code);
        }
        new_parser.write();
        System.out.println(String.valueOf(filename) + "StateMachine.cpp  updated");
        try {
            new_parser = new PogoParser(String.valueOf(new_model.getDescription().getSourcePath()) + "/main.cpp");
            old_parser = new OldModelParser(String.valueOf(this.old_model.projectFiles.getPath()) + "/main.cpp", this.old_model);
            code = this.getMainCode(old_parser);
            new_parser.removeProtectedZoneAtEnd(classname, "main.cpp", "#i");
            new_parser.insertInProtectedZoneAtEnd(classname, "main.cpp", code);
            new_parser.write();
            System.out.println("main.cpp  updated");
        }
        catch (DevFailed e) {
            System.err.println("================================================================");
            System.err.println("\t" + e.errors[0].desc);
            System.err.println("================================================================");
        }
    }

    private String getMainCode(OldModelParser parser) {
        String code = parser.getCode();
        int start = code.indexOf("Program Obviously used to Generate tango Object");
        if (start > 0) {
            start = code.indexOf("\n", start) + 1;
            start = code.indexOf("\n", start) + 1;
            start = code.indexOf("\n", start) + 1;
            start = code.indexOf("\n", start) + 1;
            code = code.substring(start);
        }
        return code;
    }

    public void manageCppAdditionalFiles(PogoDeviceClass new_model) throws Exception {
        File makefile;
        ArrayList<String> generated = new ArrayList<String>();
        String[] stringArray = cppFilenames;
        int n = cppFilenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            generated.add(Utils.strReplace(filename, "ClassName", this.old_model.class_name));
            ++n2;
        }
        String new_path = new_model.getDescription().getSourcePath();
        String old_path = this.old_model.projectFiles.getPath();
        ArrayList<String> files = Utils.getInstance().getFileList(old_path);
        ArrayList<String> addFiles = new ArrayList<String>();
        for (String filename : files) {
            boolean found = false;
            for (String cppFile : generated) {
                if (!filename.equals(cppFile)) continue;
                found = true;
            }
            if (found) continue;
            addFiles.add(filename);
        }
        for (String filename : addFiles) {
            System.out.println("Copiing " + filename);
            ParserTool.writeFile(String.valueOf(new_path) + "/" + filename, ParserTool.readFile(String.valueOf(old_path) + "/" + filename));
        }
        String oldCFfile = String.valueOf(old_path) + "/ClassFactory.cpp";
        if (new File(oldCFfile).exists()) {
            String newCFfile = String.valueOf(new_model.getDescription().getSourcePath()) + "/ClassFactory.cpp";
            ParserTool.writeFile(newCFfile, "/*----- PROTECTED REGION ID(ClassFactory.cpp) ENABLED START -----*/\n" + ParserTool.readFile(oldCFfile) + "/*----- PROTECTED REGION END -----*/\n");
            System.out.println("ClassFactory.cpp  updated");
        }
        if ((makefile = new File(String.valueOf(old_path) + "/Makefile")).exists()) {
            String new_makefile_name = String.valueOf(new_path) + "/Makefile";
            String code = "#PROTECTED REGION ID(" + new_model.getName() + "Makefile) ENABLED START#\n" + ParserTool.readFile(makefile.toString()) + "#PROTECTED REGION END#\n";
            ParserTool.writeFile(new_makefile_name, code);
        } else {
            StringBuilder objFiles = new StringBuilder();
            for (String filename : addFiles) {
                if (!filename.endsWith(".cpp")) continue;
                objFiles.append("\t\\\n\t\t$(OBJS_DIR)/");
                objFiles.append(filename.substring(0, filename.length() - 3));
                objFiles.append("o");
            }
            if (objFiles.length() > 0) {
                try {
                    PogoParser new_parser = new PogoParser(String.valueOf(new_path) + "/Makefile");
                    new_parser.addObjFiles(objFiles.toString());
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }
    }

    public void swapDirectories(PogoDeviceClass new_model) throws Exception {
        String in_test = System.getenv("TEST_MODE");
        if (in_test != null && in_test.toLowerCase().equals("true")) {
            return;
        }
        String old_path = this.old_model.projectFiles.getPath();
        File old_dir = new File(String.valueOf(old_path) + "/old_src");
        old_dir.mkdir();
        ArrayList<String> files = Utils.getInstance().getFileList(old_path);
        for (String filename : files) {
            new File(String.valueOf(old_path) + "/" + filename).renameTo(new File(String.valueOf(old_path) + "/old_src/" + filename));
        }
        String gene_path = new_model.getDescription().getSourcePath();
        files = Utils.getInstance().getFileList(gene_path);
        for (String filename : files) {
            new File(String.valueOf(gene_path) + "/" + filename).renameTo(new File(String.valueOf(old_path) + "/" + filename));
        }
        new File(gene_path).delete();
    }

    private void manageOldProperties(EList<Property> properties, PropertyTable oldProps) {
        int i = 0;
        while (i < oldProps.size()) {
            pogo.gene.Property old_prop = oldProps.propertyAt(i);
            Property property = OAWutils.factory.createProperty();
            property.setName(old_prop.name);
            property.setDescription(Utils.strReplaceSpecialCharToCode(old_prop.description));
            EList<String> list = property.getDefaultPropValue();
            if (old_prop.default_value != null) {
                StringTokenizer st = new StringTokenizer(old_prop.default_value, "\n");
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
            }
            property.setType(PropertyDialog.tango2pogoType(old_prop.type.cpp));
            InheritanceStatus status = OAWutils.factory.createInheritanceStatus();
            status.setAbstract("false");
            status.setInherited("false");
            status.setConcrete("true");
            status.setConcreteHere("true");
            property.setStatus(status);
            properties.add(property);
            ++i;
        }
    }

    private void manageOldStates(EList<State> states, DevStateTable oldStates) {
        int i = 0;
        while (i < oldStates.size()) {
            DevState old_state = oldStates.stateAt(i);
            State state = OAWutils.factory.createState();
            String name = old_state.name;
            if (name.startsWith("Tango::")) {
                name = name.substring("Tango::".length());
            }
            state.setName(name);
            state.setDescription(old_state.description);
            InheritanceStatus status = OAWutils.factory.createInheritanceStatus();
            status.setAbstract("false");
            status.setInherited("false");
            status.setConcrete("true");
            status.setConcreteHere("true");
            state.setStatus(status);
            states.add(state);
            ++i;
        }
    }

    private void manageOldCommands(EList<Command> commands, CmdTable oldCmds) {
        int i = 0;
        while (i < oldCmds.size()) {
            Cmd old_cmd = oldCmds.cmdAt(i);
            Command cmd = OAWutils.factory.createCommand();
            cmd.setName(old_cmd.name);
            cmd.setDescription(old_cmd.description);
            InheritanceStatus status = OAWutils.factory.createInheritanceStatus();
            if (this.old_model.is_abstractclass) {
                status.setAbstract("true");
            } else {
                status.setAbstract("false");
                if (this.old_model.inherited_from.startsWith("Device_") && this.old_model.inherited_from.endsWith("Impl")) {
                    status.setInherited("false");
                } else {
                    status.setInherited("true");
                }
                status.setConcrete("true");
                status.setConcreteHere("true");
            }
            if (old_cmd.virtual_method) {
                status.setAbstract("true");
                status.setInherited("true");
                if (old_cmd.override_method == 0) {
                    if (old_cmd.name.equals("State") || old_cmd.name.equals("Status")) {
                        status.setConcrete("true");
                    } else {
                        status.setConcrete("false");
                    }
                    status.setConcreteHere("false");
                }
            }
            cmd.setStatus(status);
            Argument argin = OAWutils.factory.createArgument();
            Argument argout = OAWutils.factory.createArgument();
            argin.setType(OAWutils.tango2pogoType(old_cmd.argin.cpp));
            argin.setDescription(old_cmd.argin.description);
            argout.setType(OAWutils.tango2pogoType(old_cmd.argout.cpp));
            argout.setDescription(old_cmd.argout.description);
            cmd.setArgin(argin);
            cmd.setArgout(argout);
            cmd.setDisplayLevel(PogoConst.strLevel[old_cmd.level.value()]);
            if (old_cmd.polled_period > 0) {
                cmd.setPolledPeriod(Integer.toString(old_cmd.polled_period));
            }
            EList<String> new_states = cmd.getExcludedStates();
            DevStateTable old_states = old_cmd.notAllowedFor;
            int st = 0;
            while (st < old_states.size()) {
                String name = old_states.stateAt((int)st).name;
                if (name.startsWith("Tango::")) {
                    name = name.substring("Tango::".length());
                }
                new_states.add(name);
                ++st;
            }
            cmd.setExecMethod(Utils.buildExcecMethodName(cmd.getName()));
            commands.add(cmd);
            ++i;
        }
    }

    private void manageOldAttributes(EList<Attribute> attributes, AttribTable oldAttribTable) {
        int i = 0;
        while (i < oldAttribTable.size()) {
            Attrib old_attr = oldAttribTable.attributeAt(i);
            Attribute attribute = OAWutils.factory.createAttribute();
            attribute.setName(old_attr.name);
            attribute.setAttType(PogoConst.AttrTypeArray[old_attr.attrType]);
            attribute.setRwType(PogoConst.AttrRWtypeArray[old_attr.rwType]);
            Type pogoDataType = OAWutils.tango2pogoType(old_attr.dataType.cpp);
            attribute.setDataType(pogoDataType);
            attribute.setMaxX(Integer.toString(old_attr.xSize));
            attribute.setMaxY(Integer.toString(old_attr.ySize));
            int n = 0;
            AttrProperties prop = OAWutils.factory.createAttrProperties();
            prop.setLabel(old_attr.getPropValue(n++));
            prop.setUnit(old_attr.getPropValue(n++));
            prop.setStandardUnit(old_attr.getPropValue(n++));
            prop.setDisplayUnit(old_attr.getPropValue(n++));
            prop.setFormat(old_attr.getPropValue(n++));
            prop.setMaxValue(old_attr.getPropValue(n++));
            prop.setMinValue(old_attr.getPropValue(n++));
            prop.setMaxAlarm(old_attr.getPropValue(n++));
            prop.setMinAlarm(old_attr.getPropValue(n++));
            prop.setMaxWarning(old_attr.getPropValue(n++));
            prop.setMinWarning(old_attr.getPropValue(n++));
            prop.setDeltaTime(old_attr.getPropValue(n++));
            prop.setDeltaValue(old_attr.getPropValue(n));
            prop.setDescription(old_attr.getDescription());
            attribute.setProperties(prop);
            attribute.setPolledPeriod(Integer.toString(old_attr.polled_period));
            attribute.setDisplayLevel(PogoConst.strLevel[old_attr.disp_level.value()]);
            if (old_attr.memorized) {
                attribute.setMemorized("true");
                if (old_attr.memorized_init) {
                    attribute.setMemorizedAtInit("true");
                }
            }
            FireEvents fe_change = OAWutils.factory.createFireEvents();
            boolean[] b_change = old_attr.getFireEvent(0);
            fe_change.setFire("" + b_change[0]);
            fe_change.setLibCheckCriteria("" + b_change[1]);
            attribute.setChangeEvent(fe_change);
            FireEvents fe_archive = OAWutils.factory.createFireEvents();
            boolean[] b_archive = old_attr.getFireEvent(1);
            fe_archive.setFire("" + b_archive[0]);
            fe_archive.setLibCheckCriteria("" + b_archive[1]);
            attribute.setArchiveEvent(fe_archive);
            EList<String> new_states = attribute.getReadExcludedStates();
            DevStateTable old_states = old_attr.notAllowedFor;
            int st = 0;
            while (st < old_states.size()) {
                String name = old_states.stateAt((int)st).name;
                if (name.startsWith("Tango::")) {
                    name = name.substring("Tango::".length());
                }
                new_states.add(name);
                ++st;
            }
            InheritanceStatus status = OAWutils.factory.createInheritanceStatus();
            if (this.old_model.is_abstractclass) {
                status.setAbstract("true");
            } else {
                status.setAbstract("false");
                if (this.old_model.inherited_from.startsWith("Device_") && this.old_model.inherited_from.endsWith("Impl")) {
                    status.setInherited("false");
                } else {
                    status.setInherited("true");
                }
                status.setConcrete("true");
                status.setConcreteHere("true");
                attribute.setStatus(status);
            }
            attribute.setStatus(status);
            attributes.add(attribute);
            ++i;
        }
    }

    private String getIncludeFiles(String ext) throws Exception {
        String filename;
        if (ext.equals(".h")) {
            filename = this.old_model.projectFiles.getServer_h();
        } else if (ext.equals(".cpp")) {
            filename = this.old_model.projectFiles.getServer();
        } else if (ext.equals("Class.h")) {
            filename = this.old_model.projectFiles.getServerClass_h();
        } else if (ext.equals("Class.cpp")) {
            filename = this.old_model.projectFiles.getServerClass();
        } else {
            return "";
        }
        OldModelParser parser = new OldModelParser(filename, this.old_model);
        return parser.getIncludeFiles();
    }

    private String getDefinitions() throws Exception {
        OldModelParser parser = new OldModelParser(this.old_model.projectFiles.getServer_h(), this.old_model);
        String defs = parser.getDefinitions();
        if (defs != null && defs.length() > 0) {
            defs = "\n\n" + defs;
        }
        return defs;
    }

    private String getEndPropertyCode(OldModelParser parser, boolean is_dev) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = is_dev ? "void " + this.old_model.class_name + "::get_device_property()" : "void " + this.old_model.class_name + "Class::get_class_property()";
                code = parser.getCppMethodCode(signature);
                if (code == null) {
                    System.out.println("Cannot read post code from " + signature);
                    break;
                }
                int start = code.indexOf("End of Automatic code generation");
                if (start < 0) {
                    return null;
                }
                if ((start = code.indexOf(10, start)) < 0) {
                    return null;
                }
                if ((start = code.indexOf(10, start + 1)) < 0) {
                    return null;
                }
                code = "\t" + code.substring(start).trim();
            }
        }
        return code;
    }

    private String getConstructorCode(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = String.valueOf(this.old_model.class_name) + "Class::" + this.old_model.class_name + "Class(string &s):DeviceClass(s)";
                code = parser.getCppMethodCode(signature);
                if (code == null) {
                    System.err.println("Cannot read init code from " + signature);
                    break;
                }
                int start = code.indexOf("write_class_property();");
                if (start < 0) {
                    System.err.println("Cannot read code from " + signature);
                    return null;
                }
                start = code.indexOf(10, start);
                start = code.indexOf(10, start + 1);
                int end = code.indexOf("Leaving " + this.old_model.class_name + "Class constructor");
                if (end > 0) {
                    end = code.lastIndexOf(10, end);
                    code = "\t" + code.substring(start, end).trim();
                    break;
                }
                code = "\t" + code.substring(start).trim();
            }
        }
        return code;
    }

    private String getInitPropertyCode(OldModelParser parser, boolean is_dev) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = is_dev ? "void " + this.old_model.class_name + "::get_device_property()" : "void " + this.old_model.class_name + "Class::get_class_property()";
                code = parser.getCppMethodCode(signature);
                if (code == null) {
                    System.err.println("Cannot read init code from " + signature);
                    break;
                }
                int start = code.indexOf("Initialize your default values here");
                if (start < 0) {
                    System.err.println("Cannot read init code from " + signature);
                    return null;
                }
                start = code.indexOf(10, start);
                start = code.indexOf(10, start + 1);
                int end = code.indexOf("properties from database.(Automatic code generation)");
                if (end < 0) {
                    System.err.println("Cannot read init code from " + signature);
                    return null;
                }
                end = code.lastIndexOf(10, end);
                code = "\t" + code.substring(start, end).trim();
            }
        }
        return code;
    }

    private String getDserverDataMembers(OldModelParser parser) throws Exception {
        String code = parser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int start = code.indexOf("Class : public Tango::DeviceClass");
                if (start < 0) {
                    return null;
                }
                if ((start = code.indexOf("add your own data members here", start)) < 0) {
                    return null;
                }
                start = code.indexOf(10, start);
                start = code.indexOf(10, start + 1);
                int end = code.indexOf("public:", start);
                code = "public:\n\t" + code.substring(start, end).trim();
            }
        }
        return code;
    }

    private String getDserverDynamicClasses(OldModelParser parser) throws Exception {
        String code = parser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int start = code.indexOf("namespace " + this.old_model.class_name + "_ns");
                if (start < 0) {
                    return null;
                }
                int end = code.indexOf("Define classes for attributes", start = code.indexOf("{\n", start) + 2);
                if (end < 0) {
                    return null;
                }
                end = code.lastIndexOf("//========", end);
                code = code.substring(start, end).trim();
            }
        }
        return code;
    }

    private String getDserverAdditionnalMethods(OldModelParser parser) throws Exception {
        String code = parser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int start = code.indexOf("get_db_class()->put_property(data);");
                if (start < 0) {
                    return null;
                }
                start = code.indexOf(125, start);
                int end = code.indexOf("}\t// namespace", start += 2);
                code = code.substring(start, end).trim();
            }
        }
        return code;
    }

    private String getDeviceFactoryCode(OldModelParser parser, boolean pre_processing) throws Exception {
        String code = parser.getCode();
        switch (this.old_model.language) {
            case 1: {
                if (pre_processing) {
                    int end = code.indexOf("Create all devices.(Automatic code generation)");
                    if (end < 0) {
                        return null;
                    }
                    end = code.lastIndexOf(10, end) + 1;
                    int start = code.lastIndexOf(123, end) + 1;
                    code = "\t" + code.substring(start, end).trim();
                    break;
                }
                int start = code.indexOf("Create all devices.(Automatic code generation)");
                if (start < 0) {
                    return null;
                }
                if ((start = code.indexOf("End of Automatic code generation", start)) < 0) {
                    return null;
                }
                start = code.indexOf(10, start) + 1;
                start = code.indexOf(10, start) + 1;
                int end = code.indexOf("\n}", start);
                code = "\t" + code.substring(start, end).trim();
            }
        }
        return code;
    }

    private String getStaticInit(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                code = parser.getCppStaticInit(this.old_model.class_name);
            }
        }
        return code;
    }

    private String getInitDeviceCodeBefore(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = "void " + this.old_model.class_name + "::init_device()";
                code = parser.getCppMethodCode(signature);
                int end = code.indexOf("get_device_property();");
                if (end > 0) {
                    int start = (code = code.substring(0, end = code.lastIndexOf("\n", end) + 1)).indexOf("Initialise variables to default values");
                    if (start < 0) break;
                    end = code.indexOf(10, start);
                    if ((start = code.lastIndexOf(10, start)) < 0) {
                        start = 0;
                    }
                    if (!(code = String.valueOf(code.substring(0, start)) + code.substring(end + 1)).trim().startsWith("//-----------------------")) break;
                    start = code.indexOf("//----------------------");
                    end = code.indexOf(10, start + 1);
                    code = String.valueOf(code.substring(0, start)) + code.substring(end + 1);
                    break;
                }
                code = "";
            }
        }
        return code;
    }

    private String getInitDeviceCodeAfter(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = "void " + this.old_model.class_name + "::init_device()";
                code = parser.getCppMethodCode(signature);
                int start = code.indexOf("get_device_property();");
                if (start <= 0) break;
                start = code.indexOf("\n", start) + 1;
                code = code.substring(start);
            }
        }
        return code;
    }

    private String getDeleteDeviceCode(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = "void " + this.old_model.class_name + "::delete_device()";
                code = parser.getCppMethodCode(signature);
            }
        }
        return code;
    }

    private String getCommandCode(OldModelParser parser, Command cmd) throws Exception {
        String code = null;
        CmdTable old_commands = this.old_model.commands;
        int i = 0;
        while (i < old_commands.size()) {
            Cmd old_cmd = old_commands.cmdAt(i);
            if (old_cmd.name.equals(cmd.getName())) {
                switch (this.old_model.language) {
                    case 1: {
                        String signature = old_cmd.buildCppExecCmdMethodSignature(this.old_model.class_name);
                        code = parser.getCppMethodCode(signature);
                        if (code == null) break;
                        code = this.checkLinesToRemove(old_cmd, code);
                        String argin_def = parser.getCppMethodArginDef(signature);
                        if (argin_def == null || argin_def.contains("argin")) break;
                        int pos = argin_def.lastIndexOf(42);
                        if (pos < 0) {
                            pos = argin_def.lastIndexOf(32);
                        }
                        if (pos < 0) {
                            pos = argin_def.lastIndexOf(9);
                        }
                        if (pos <= 0) break;
                        String vartype = argin_def.substring(0, pos);
                        String varname = argin_def.substring(pos);
                        code = "\t" + vartype + " " + varname + " = argin;\n" + code;
                    }
                }
            }
            ++i;
        }
        return code;
    }

    private String checkLinesToRemove(Cmd old_cmd, String code) {
        int end;
        int start = (code = code.trim()).indexOf(old_cmd.argout.cpp);
        if (start > 0) {
            String line;
            if ((start = code.lastIndexOf(10, start)) < 0) {
                start = 0;
            }
            if ((line = code.substring(start, end = code.indexOf(10, start + 1))).indexOf(" argout;") > 0 || line.indexOf("\targout;") > 0) {
                code = String.valueOf(code.substring(0, start)) + code.substring(end);
            }
        }
        if (code.endsWith("return argout;")) {
            start = code.lastIndexOf(10);
            code = code.substring(0, start).trim();
        }
        if (code.startsWith("INFO_STREAM") || code.startsWith("DEBUG_STREAM")) {
            end = code.indexOf(10);
            code = code.substring(end).trim();
        }
        if ((code.startsWith("//  Add your own code") || code.startsWith("//\tAdd your own code")) && (end = code.indexOf(10)) > 0) {
            code = code.substring(end).trim();
        }
        return "\t" + code;
    }

    private String getReadAttributeCode(OldModelParser parser, Attribute att) throws Exception {
        String code = null;
        AttribTable old_attributes = this.old_model.attributes;
        int i = 0;
        while (i < old_attributes.size()) {
            Attrib old_att = old_attributes.attributeAt(i);
            if (old_att.name.equals(att.getName())) {
                switch (this.old_model.language) {
                    case 1: {
                        String signature = "void " + this.old_model.class_name + "::read_" + old_att.name + "(Tango::Attribute &attr)";
                        code = parser.getCppMethodCode(signature);
                    }
                }
            }
            ++i;
        }
        return code;
    }

    private String getReadAttrHardwareCode(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = "void " + this.old_model.class_name + "::read_attr_hardware(vector<long> &attr_list)";
                code = parser.getCppMethodCode(signature);
            }
        }
        return code;
    }

    private String getAlwaysExecutedHookCode(OldModelParser parser) throws Exception {
        String code = null;
        switch (this.old_model.language) {
            case 1: {
                String signature = "void " + this.old_model.class_name + "::always_executed_hook()";
                code = parser.getCppMethodCode(signature);
            }
        }
        return code;
    }

    private String getWriteAttributeCode(OldModelParser parser, Attribute att) throws Exception {
        String code = null;
        AttribTable old_attributes = this.old_model.attributes;
        int i = 0;
        while (i < old_attributes.size()) {
            Attrib old_att = old_attributes.attributeAt(i);
            if (old_att.name.equals(att.getName())) {
                switch (this.old_model.language) {
                    case 1: {
                        String signature = "void " + this.old_model.class_name + "::write_" + old_att.name + "(Tango::WAttribute &attr)";
                        code = parser.getCppMethodCode(signature);
                        code = parser.manageWriteValue(code, att.getName());
                    }
                }
            }
            ++i;
        }
        return code;
    }

    private String getIsAllowedCode(OldModelParser parser, String name) throws Exception {
        String code = parser.getCode();
        switch (this.old_model.language) {
            case 1: {
                String signature = "bool " + this.old_model.class_name + "::is_" + name + "_allowed(Tango::AttReqType type)";
                int start = code.indexOf(signature);
                if (start < 0) {
                    return null;
                }
                if ((start = code.indexOf("End of Generated Code", start)) < 0) {
                    return null;
                }
                int end = code.indexOf("Re-Start of Generated Code", start = code.indexOf("\n", start));
                if (end < 0) {
                    return null;
                }
                if ((code = code.substring(start, end = code.lastIndexOf("\n", end)).trim()).length() <= 0) break;
                code = "\t\t" + code;
            }
        }
        return code;
    }

    public void generateDocFromOldModel(String oldDescFilename, String targetDir) throws DevFailed, IOException {
        try {
            String newDescFilename = String.valueOf(targetDir) + "/index.html";
            System.out.println("Trying to add description from " + oldDescFilename + "\n to  " + newDescFilename);
            PogoParser new_parser = new PogoParser(String.valueOf(targetDir) + "/index.html");
            OldModelParser old_parser = new OldModelParser(oldDescFilename, this.old_model);
            String code = old_parser.getHtmlDescripion();
            if (code != null && code.length() > 0) {
                if (!new_parser.codeExists(code.trim())) {
                    new_parser.insertInProtectedZone("", "./doc_html/index.html", code);
                }
                new_parser.write();
            }
        }
        catch (DevFailed e) {
            System.err.println("Cannot add description: " + e.errors[0].desc);
        }
    }

    public static int checkForInheritance(JFrame parent, DeviceClass devclass) throws DevFailed {
        PogoDeviceClass pg = devclass.getPogoDeviceClass();
        String className = pg.getName();
        Inheritance inheritance = (Inheritance)pg.getDescription().getInheritances().get(0);
        if (DeviceClass.isDefaultInheritance(inheritance)) {
            if (devclass.getPogoDeviceClass().getDescription().getLanguage().toLowerCase().equals("java")) {
                inheritance.setClassname("Device_2Impl");
            }
            System.out.println(String.valueOf(className) + " has no inheritance -> " + inheritance.getClassname());
        } else {
            String inheritName = inheritance.getClassname();
            String message = String.valueOf(className) + " inherite from " + inheritName + "\n" + "The class " + inheritName + " needs to be converted before !!!\n\n";
            Object[] options = new Object[]{"Specified path for converted abstract class", "Remove inheritance", "Cancel"};
            int choice = JOptionPane.showOptionDialog(parent, message, "Confirmation Window", -1, 2, null, options, options[0]);
            switch (choice) {
                case 0: {
                    String path = OldPogoModel.getInheritanceDirectory(inheritance);
                    if (path == null) {
                        return 2;
                    }
                    inheritance.setSourcePath(path);
                    break;
                }
                case 1: {
                    devclass.removeInheritance();
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        return 0;
    }

    private static String getInheritanceDirectory(Inheritance inher) throws DevFailed {
        File file;
        String className = inher.getClassname();
        String path = InheritanceUtils.checkInheritanceFileFromEnv(null);
        if (path == null) {
            path = inher.getSourcePath();
        }
        JFileChooser chooser = new JFileChooser(new File(path).getAbsolutePath());
        PogoFileFilter filter = new PogoFileFilter("xmi", String.valueOf(className) + " Class");
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(new JFrame()) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String filename = file.getAbsolutePath();
            if (filename.endsWith(String.valueOf(className) + ".xmi")) {
                DeviceClass devClass = new DeviceClass(filename);
                return devClass.getPogoDeviceClass().getDescription().getSourcePath();
            }
            JOptionPane.showMessageDialog(new JFrame(), String.valueOf(filename) + "\n     is NOT the file defining " + className + " class", "Error Window", 2);
        }
        return null;
    }
}

