/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tango.pogo.pogoDsl.Preferences;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.ServerDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.TangoServer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class MultiClassesTree
extends JTree
implements TangoConst {
    private DefaultMutableTreeNode root;
    private DefaultTreeModel treeModel;
    private MultiClassesTreePopupMenu menu;
    private JFrame parent;
    private EditClasses editedClasses = new EditClasses();
    private boolean modified = false;
    private LoadedClasses loadedClasses = new LoadedClasses();
    private static JFileChooser chooser = null;
    private static final Color background = Color.white;
    private DeviceClass copiedClass = null;
    private static final int EDIT_SERVER = 0;
    private static final int EDIT_CLASS = 1;
    private static final int ADD_CLASS = 2;
    private static final int COPY_CLASS = 3;
    private static final int PASTE_CLASS = 4;
    private static final int REMOVE_CLASS = 5;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Edit Server", "Edit class", "Add  class", "Copy  class", "Paste class", "Remove class"};

    public MultiClassesTree(JFrame parent, PogoMultiClasses pmc) throws DevFailed {
        this.parent = parent;
        this.initComponenta();
        this.buildTree(new TangoServer(pmc));
        this.createClassNodes(this.root, pmc.getClasses());
        this.expandChildren(this.root);
        this.setSelectionPath(null);
    }

    public MultiClassesTree(JFrame parent, TangoServer server) throws DevFailed {
        this.parent = parent;
        this.initComponenta();
        this.buildTree(server);
    }

    private void initComponenta() {
        String homeDir = System.getenv("SOURCE_PATH");
        if (homeDir == null && (homeDir = System.getProperty("SOURCE_PATH")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(homeDir).getAbsolutePath());
        chooser.setFileFilter(PogoGUI.pogo6Filter);
        chooser.setFileFilter(PogoGUI.pogoFilter);
        this.menu = new MultiClassesTreePopupMenu(this);
        this.setBackground(background);
    }

    private void buildTree(TangoServer server) throws DevFailed {
        this.root = new DefaultMutableTreeNode(server);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MultiClassesTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if ((evt.getClickCount() != 2 || (mask & 0x10) == 0) && (mask & 4) != 0) {
            if (node == this.root) {
                this.menu.showMenu(evt, (TangoServer)o);
            } else if (o instanceof DeviceClass) {
                this.menu.showMenu(evt, (DeviceClass)o);
            }
        }
    }

    private DeviceClass loadDeviceClass(OneClassSimpleDef _class) throws DevFailed {
        String xmiFile = String.valueOf(_class.getSourcePath()) + "/" + _class.getClassname();
        xmiFile = Utils.isTrue(_class.getPogo6()) ? String.valueOf(xmiFile) + ".h" : String.valueOf(xmiFile) + ".xmi";
        DeviceClass deviceClass = null;
        while (deviceClass == null) {
            try {
                deviceClass = this.loadedClasses.getDeviceClass(xmiFile);
                if (deviceClass.getPogoDeviceClass().getName().equals(_class.getClassname())) continue;
                Except.throw_exception("BAD_FILE", String.valueOf(_class.getClassname()) + " file expected !", "MultiClassesTree.loadDeviceClass()");
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, e);
                int retval = chooser.showOpenDialog(this);
                if (retval == 0) {
                    File file = chooser.getSelectedFile();
                    if (file == null || file.isDirectory()) continue;
                    xmiFile = file.getAbsolutePath();
                    continue;
                }
                Except.throw_exception("NO_FILE", "Canceled", "MultiClassesTree.loadDeviceClass()");
            }
        }
        return deviceClass;
    }

    private void createClassNodes(DefaultMutableTreeNode parentNode, EList<OneClassSimpleDef> classes) throws DevFailed {
        String parentName = parentNode == this.root ? "root" : parentNode.toString();
        for (OneClassSimpleDef _class : classes) {
            EList<String> parentClasses = _class.getParentClasses();
            if (parentClasses.size() == 0) {
                parentClasses.add("root");
            }
            for (String parentClass : parentClasses) {
                if (!parentClass.equals(parentName)) continue;
                DeviceClass deviceClass = this.loadDeviceClass(_class);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(deviceClass);
                parentNode.add(node);
                this.createClassNodes(node, classes);
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        int i = 0;
        while (i < node.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (!level_done) {
                    this.expandNode(child);
                    level_done = true;
                }
            } else {
                this.expandChildren(child);
            }
            ++i;
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        int i = 0;
        while (i < v.size()) {
            tn[i] = (TreeNode)v.get(i);
            ++i;
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private void editSelectedClass() {
        Object obj = this.getSelectedObject();
        if (obj instanceof DeviceClass) {
            try {
                this.editedClasses.addClass((DeviceClass)obj);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, e);
            }
        }
    }

    boolean allEditorsAreClosed() {
        return this.editedClasses.everythingClosed();
    }

    private void editServer() {
        TangoServer server = (TangoServer)this.root.getUserObject();
        ServerDialog serverDialog = new ServerDialog(this.parent, server);
        if (serverDialog.showDialog() == 0) {
            this.setModified(true);
        }
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean b2) {
        this.modified = b2;
    }

    public boolean isANodeSelected() {
        return this.getSelectedNode() != null;
    }

    public boolean isAClassSelected() {
        Object obj = this.getSelectedObject();
        return obj instanceof DeviceClass;
    }

    public void addClass() {
        try {
            File file;
            if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
                String fileName = file.getAbsolutePath();
                DeviceClass deviceClass = this.loadedClasses.getDeviceClass(fileName);
                DefaultMutableTreeNode parentNode = this.getSelectedNode();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(deviceClass);
                this.treeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
                this.setModified(true);
                this.expandChildren(parentNode);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    public void removeClass() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (JOptionPane.showConfirmDialog(this, "Remove " + node.getUserObject() + " class  ?", "Confirmation Window", 0) == 0) {
            this.treeModel.removeNodeFromParent(node);
            this.setModified(true);
        }
    }

    public boolean pasteAvailable() {
        return this.isANodeSelected() && this.copiedClass != null;
    }

    public void copySelectedClass() {
        Object obj = this.getSelectedObject();
        if (obj instanceof DeviceClass) {
            this.copiedClass = (DeviceClass)obj;
        }
    }

    public void pasteClass() {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.copiedClass);
        DefaultMutableTreeNode parentNode = this.getSelectedNode();
        this.treeModel.insertNodeInto(node, parentNode, parentNode.getChildCount());
        this.setModified(true);
        this.expandChildren(parentNode);
    }

    private ArrayList<DeviceClass> getClasses(DefaultMutableTreeNode node) {
        ArrayList<DeviceClass> classes = new ArrayList<DeviceClass>();
        int i = 0;
        while (i < node.getChildCount()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            DeviceClass _class = (DeviceClass)childNode.getUserObject();
            classes.add(_class);
            if (node != this.root) {
                _class.addParentClass(node.getUserObject().toString());
            }
            ArrayList<DeviceClass> children = this.getClasses(childNode);
            for (DeviceClass child : children) {
                classes.add(child);
            }
            ++i;
        }
        return classes;
    }

    public String getServerFileName() {
        TangoServer server = (TangoServer)this.root.getUserObject();
        if (server.sourcePath != null) {
            return String.valueOf(server.sourcePath) + "/" + server.name + ".multi.xmi";
        }
        return null;
    }

    public PogoMultiClasses getServer() {
        this.loadedClasses.resetParentClasses();
        TangoServer server = (TangoServer)this.root.getUserObject();
        ArrayList<DeviceClass> classes = this.getClasses(this.root);
        ArrayList<DeviceClass> pogoClasses = new ArrayList<DeviceClass>();
        int i = classes.size() - 1;
        while (i >= 0) {
            DeviceClass _class = classes.get(i);
            boolean exists = false;
            String name = _class.getPogoDeviceClass().getName();
            for (DeviceClass pogoClass : pogoClasses) {
                if (!pogoClass.getPogoDeviceClass().getName().equals(name)) continue;
                exists = true;
            }
            if (!exists) {
                pogoClasses.add(0, _class);
            }
            --i;
        }
        for (DeviceClass pc : pogoClasses) {
            System.out.println(pc.getPogoDeviceClass().getName());
        }
        PogoMultiClasses multiClasses = this.buildPogoMultiClassesObject(server.name, pogoClasses);
        multiClasses.setName(server.name);
        multiClasses.setDescription(server.description);
        multiClasses.setSourcePath(server.sourcePath);
        return multiClasses;
    }

    private PogoMultiClasses buildPogoMultiClassesObject(String name, ArrayList<DeviceClass> classes) {
        PogoMultiClasses multiClasses = OAWutils.factory.createPogoMultiClasses();
        multiClasses.setName(name);
        Preferences pref = OAWutils.factory.createPreferences();
        pref.setMakefileHome(PogoProperty.makefileHome);
        multiClasses.setPreferences(pref);
        EList<OneClassSimpleDef> definitions = multiClasses.getClasses();
        for (DeviceClass devClass : classes) {
            PogoDeviceClass pogoClass = devClass.getPogoDeviceClass();
            OneClassSimpleDef simple = OAWutils.factory.createOneClassSimpleDef();
            simple.setClassname(pogoClass.getName());
            simple.setSourcePath(pogoClass.getDescription().getSourcePath());
            for (String parentClass : devClass.getParentClasses()) {
                simple.getParentClasses().add(parentClass);
            }
            if (devClass.isOldPogoModel()) {
                simple.setPogo6("true");
            }
            definitions.add(simple);
            EList<Inheritance> multiInheritances = simple.getInheritances();
            EList<Inheritance> monoInheritances = pogoClass.getDescription().getInheritances();
            for (Inheritance monoInheritance : monoInheritances) {
                Inheritance multiInheritance = OAWutils.factory.createInheritance();
                multiInheritance.setClassname(monoInheritance.getClassname());
                multiInheritance.setSourcePath(monoInheritance.getSourcePath());
                multiInheritances.add(multiInheritance);
            }
            EList<AdditionalFile> multiAdditional = simple.getAdditionalFiles();
            EList<AdditionalFile> monoAdditional = pogoClass.getAdditionalFiles();
            for (AdditionalFile monoFile : monoAdditional) {
                multiAdditional.add(OAWutils.cloneAdditionalFile(monoFile));
            }
        }
        return multiClasses;
    }

    @Override
    public String getName() {
        return this.root.getUserObject().toString();
    }

    private class EditClasses
    extends ArrayList<PogoGUI> {
        private EditClasses() {
        }

        private void addClass(DeviceClass _class) throws DevFailed {
            for (PogoGUI pogo : this) {
                if (!pogo.getMainClassName().equals(_class.toString())) continue;
                pogo.setVisible(true);
                return;
            }
            this.add(new PogoGUI(_class, false));
            if (this.size() == 1) {
                Point p = MultiClassesTree.this.parent.getLocation();
                p.x += MultiClassesTree.this.parent.getWidth();
                p.y -= 50;
                ((PogoGUI)this.get(0)).setLocation(p);
            }
        }

        private boolean everythingClosed() {
            for (PogoGUI pogo : this) {
                if (!pogo.isVisible()) continue;
                return false;
            }
            return true;
        }
    }

    private class LoadedClasses
    extends ArrayList<DeviceClass> {
        private LoadedClasses() {
        }

        private DeviceClass getDeviceClass(String xmiFile) throws DevFailed {
            DeviceClass dc2;
            String path = xmiFile.substring(0, xmiFile.lastIndexOf(47));
            for (DeviceClass dc2 : this) {
                if (!dc2.getPogoDeviceClass().getDescription().getSourcePath().equals(path)) continue;
                System.out.println(String.valueOf(xmiFile) + " Already Loaded");
                return dc2;
            }
            dc2 = new DeviceClass(xmiFile);
            this.add(dc2);
            return dc2;
        }

        private void resetParentClasses() {
            for (DeviceClass dc : this) {
                dc.resetParentClasses();
            }
        }
    }

    private class MultiClassesTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private MultiClassesTreePopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            String[] stringArray = menuLabels;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String menuLabel = stringArray[n2];
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                } else {
                    JMenuItem btn = new JMenuItem(menuLabel);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            MultiClassesTreePopupMenu.this.hostActionPerformed(evt);
                        }
                    });
                    this.add(btn);
                }
                ++n2;
            }
        }

        public void showMenu(MouseEvent evt, TangoServer pmc) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(pmc.toString());
            int i = 0;
            while (i < menuLabels.length) {
                this.getComponent(2 + i).setVisible(false);
                ++i;
            }
            this.getComponent(2).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.getComponent(6).setVisible(MultiClassesTree.this.pasteAvailable());
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, DeviceClass collec) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(collec.toString());
            int i = 0;
            while (i < menuLabels.length) {
                this.getComponent(2 + i).setVisible(false);
                ++i;
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.getComponent(5).setVisible(true);
            this.getComponent(6).setVisible(MultiClassesTree.this.pasteAvailable());
            this.getComponent(7).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            int i = 0;
            while (i < menuLabels.length) {
                if (this.getComponent(2 + i) == obj) {
                    cmdidx = i;
                }
                ++i;
            }
            switch (cmdidx) {
                case 0: {
                    MultiClassesTree.this.editServer();
                    break;
                }
                case 1: {
                    MultiClassesTree.this.editSelectedClass();
                    break;
                }
                case 2: {
                    MultiClassesTree.this.addClass();
                    break;
                }
                case 3: {
                    MultiClassesTree.this.copySelectedClass();
                    break;
                }
                case 4: {
                    MultiClassesTree.this.pasteClass();
                    break;
                }
                case 5: {
                    MultiClassesTree.this.removeClass();
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts;
        private final int TITLE = 0;
        private final int CLASS = 1;
        private ImageIcon class_icon = Utils.getInstance().getIcon("TangoClass.gif", 0.4);

        public TangoRenderer() {
            this.fonts = new Font[2];
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 14);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(Utils.getInstance().root_icon);
            } else {
                this.setFont(this.fonts[1]);
                this.setIcon(this.class_icon);
            }
            return this;
        }
    }
}

