/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tango.pogo.pogo_gui.GenerateDialog;
import org.tango.pogo.pogo_gui.MultiClassesTree;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.ServerDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.TangoServer;
import org.tango.pogo.pogo_gui.tools.Utils;

public class MultiClassesPanel
extends JFrame {
    private JFrame parent;
    private static JFileChooser chooser = null;
    public static String homeDir;
    private MultiClassesTree tree;
    private JScrollPane scrollPane;
    private ArrayList<JButton> topButtons = new ArrayList();
    private static final int TOP_RELOAD = 0;
    private static final int TOP_NEW = 1;
    private static final int TOP_OPEN = 2;
    private static final int TOP_GENE = 3;
    private static final PogoFileFilter pogoFilter;
    private JMenuItem addItem;
    private JMenu editMenu;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JMenuItem generateItem;
    private JMenuItem helpItem;
    private JMenu helpMenu;
    private JMenuItem newItem;
    private JMenuItem openItem;
    private JMenu recentMenu;
    private JMenuItem removeItem;
    private JPanel topPanel;

    static {
        pogoFilter = new PogoFileFilter("xmi", "Multi Classes");
    }

    public MultiClassesPanel(JFrame parent, String fileName) throws DevFailed {
        this.parent = parent;
        this.initComponents();
        PogoProperty.init().displayProperties();
        this.customizeMenus();
        this.initOwnComponents();
        if (fileName != null) {
            this.loadXmiFile(fileName);
        }
        PogoGUI.multiClassesPanel = this;
        this.pack();
        ATKGraphicsUtils.centerFrameOnScreen(this);
    }

    private void initOwnComponents() {
        this.setTitle("Multi TANGO Classes Code Generator - Release 8.0.7  -  Fri Jun 29 15:04:39 CEST 2012");
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(350, 400));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        homeDir = System.getenv("SOURCE_PATH");
        if (homeDir == null && (homeDir = System.getProperty("SOURCE_PATH")) == null) {
            homeDir = new File("").getAbsolutePath();
        }
        chooser = new JFileChooser(new File(homeDir).getAbsolutePath());
        chooser.setFileFilter(pogoFilter);
        Utils utils = Utils.getInstance();
        this.addTopPanelButton(utils.reload_icon, "Reload Server");
        this.addTopPanelButton(utils.new_icon, "New Server");
        this.addTopPanelButton(utils.open_icon, "Open Server");
        this.addTopPanelButton(utils.save_icon, "Generate Server");
    }

    private void addTopPanelButton(ImageIcon icon, String tip) {
        JButton btn = new JButton(icon);
        btn.setToolTipText(Utils.buildToolTip(tip));
        btn.setBorder(new SoftBevelBorder(0));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.topButtonActionPerformed(evt);
            }
        });
        this.topPanel.add(btn);
        this.topButtons.add(btn);
    }

    private void customizeMenus() {
        this.fileMenu.setMnemonic('F');
        this.newItem.setMnemonic('N');
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem.setMnemonic('O');
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.generateItem.setMnemonic('G');
        this.generateItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.exitItem.setMnemonic('E');
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.editMenu.setMnemonic('E');
        this.addItem.setMnemonic('A');
        this.addItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.removeItem.setMnemonic('R');
        this.removeItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.helpMenu.setMnemonic('H');
        this.helpItem.setMnemonic('H');
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.manageRecentMenu(null);
    }

    private void manageRecentMenu(String new_proj) {
        try {
            if (new_proj == null && PogoProperty.projectHistory.size() == 0) {
                return;
            }
            if (new_proj != null) {
                PogoProperty.addProject(new_proj, 1);
            }
            this.recentMenu.removeAll();
            for (String project : PogoProperty.multiClassProjectHistory) {
                JMenuItem item = new JMenuItem(project);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiClassesPanel.this.recentItemActionPerformed(evt);
                    }
                });
                this.recentMenu.add(item);
            }
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\t" + e);
        }
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        JMenuBar jMenuBar1 = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newItem = new JMenuItem();
        this.openItem = new JMenuItem();
        this.recentMenu = new JMenu();
        JMenuItem dummyItem = new JMenuItem();
        this.generateItem = new JMenuItem();
        this.exitItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.addItem = new JMenuItem();
        this.removeItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MultiClassesPanel.this.exitForm(evt);
            }
        });
        this.topPanel.setLayout(new FlowLayout(0));
        this.getContentPane().add((Component)this.topPanel, "North");
        this.fileMenu.setText("File");
        this.newItem.setText("New");
        this.newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.newItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newItem);
        this.openItem.setText("Open");
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.openItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openItem);
        this.recentMenu.setText("Open Recent");
        dummyItem.setText("...");
        this.recentMenu.add(dummyItem);
        this.fileMenu.add(this.recentMenu);
        this.generateItem.setText("Generate");
        this.generateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.generateItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.generateItem);
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        jMenuBar1.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MultiClassesPanel.this.editMenuStateChanged(evt);
            }
        });
        this.addItem.setText("Add Class");
        this.addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.addItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.addItem);
        this.removeItem.setText("Remove class");
        this.removeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.removeItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.removeItem);
        jMenuBar1.add(this.editMenu);
        this.helpMenu.setText("help");
        this.helpItem.setText("On Multi Class Manager");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiClassesPanel.this.helpItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpItem);
        jMenuBar1.add(this.helpMenu);
        this.setJMenuBar(jMenuBar1);
        this.pack();
    }

    private void topButtonActionPerformed(ActionEvent evt) {
        JButton src = (JButton)evt.getSource();
        int i = 0;
        while (i < this.topButtons.size()) {
            if (this.topButtons.get(i) == src) {
                switch (i) {
                    case 0: {
                        if (this.tree == null) break;
                        this.reloadProject();
                        break;
                    }
                    case 1: {
                        this.newItemActionPerformed(evt);
                        break;
                    }
                    case 2: {
                        this.openItemActionPerformed(evt);
                        break;
                    }
                    case 3: {
                        if (this.tree == null) break;
                        this.generateItemActionPerformed(evt);
                    }
                }
            }
            ++i;
        }
    }

    private void reloadProject() {
        String filename;
        if (this.checkModifications() == 0 && (filename = this.tree.getServerFileName()) != null) {
            try {
                this.loadXmiFile(filename);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, e);
            }
        }
    }

    private void recentItemActionPerformed(ActionEvent evt) {
        try {
            String proj_name = ((JMenuItem)evt.getSource()).getText();
            this.loadXmiFile(proj_name);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private void openItemActionPerformed(ActionEvent evt) {
        File file;
        int retval;
        if (chooser == null) {
            chooser = new JFileChooser(new File("").getAbsolutePath());
        }
        if ((retval = chooser.showOpenDialog(this)) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String filename = file.getAbsolutePath();
            try {
                this.loadXmiFile(filename);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, e);
            }
        }
    }

    public PogoMultiClasses loadXmiFile(String xmiFileName) throws DevFailed {
        PogoMultiClasses pmc = OAWutils.getInstance().loadMultiClassesModel(xmiFileName);
        this.buildTree(pmc);
        this.manageRecentMenu(xmiFileName);
        return pmc;
    }

    private void buildTree(PogoMultiClasses pmc) {
        try {
            this.tree = new MultiClassesTree((JFrame)this, pmc);
            this.scrollPane.setViewportView(this.tree);
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void exitForm(WindowEvent evt) {
        this.doClose();
    }

    private void generateItemActionPerformed(ActionEvent evt) {
        this.generateFiles();
    }

    private int generateFiles() {
        try {
            PogoMultiClasses multiClasses = this.tree.getServer();
            GenerateDialog dialog = new GenerateDialog(this);
            if (dialog.showDialog(multiClasses) == 0) {
                this.setCursor(new Cursor(3));
                multiClasses.setSourcePath(dialog.getPath());
                multiClasses.setFilestogenerate(dialog.getGenerated());
                OAWutils.getInstance().generate(multiClasses);
                this.tree.setModified(false);
                this.setCursor(new Cursor(0));
                String projectFile = String.valueOf(multiClasses.getSourcePath()) + "/" + multiClasses.getName() + ".multi.xmi";
                this.manageRecentMenu(projectFile);
                return 0;
            }
        }
        catch (DevFailed e) {
            this.setCursor(new Cursor(0));
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
        return 2;
    }

    private void newItemActionPerformed(ActionEvent evt) {
        if (this.tree != null && this.tree.getModified() && this.checkModifications() == 2) {
            return;
        }
        try {
            ServerDialog dialog = new ServerDialog(this, new TangoServer());
            if (dialog.showDialog() == 0) {
                this.tree = new MultiClassesTree((JFrame)this, dialog.getTangoServer());
                this.tree.setModified(true);
                this.scrollPane.setViewportView(this.tree);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private void addItemActionPerformed(ActionEvent evt) {
        if (this.tree.isANodeSelected()) {
            this.tree.addClass();
        }
    }

    private void removeItemActionPerformed(ActionEvent evt) {
        if (this.tree.isAClassSelected()) {
            this.tree.removeClass();
        }
    }

    private void editMenuStateChanged(ChangeEvent evt) {
        boolean visible;
        boolean bl = visible = !this.editMenu.isSelected();
        if (this.tree != null) {
            this.addItem.setEnabled(this.tree.isANodeSelected() || visible);
            this.removeItem.setEnabled(this.tree.isAClassSelected() || visible);
        }
    }

    private void helpItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "             Pogo  (Tango Code Generator)\n    This tool is able to generate, update and modify\n           a server project containing several\n                 Tango device classes.\n\nDefine a new server (Name, description,...)\nThen add classes (Highest classes to lowest ones)\nAnd finally, generate.\n\nThis tool is available only for C++ classes on Linux.\n\nhttp://www.tango-controls.org/     -    tango@esrf.fr", "Help Window", 1);
    }

    private int checkModifications() {
        if (this.tree.getModified()) {
            String name = this.tree.getName();
            Object[] options = new Object[]{"Generate", "Discard", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, String.valueOf(name) + " project has not been generated !\n\n", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    return this.generateFiles();
                }
                case 1: {
                    return 0;
                }
            }
            return 2;
        }
        return 0;
    }

    private void doClose() {
        if (this.tree != null && this.tree.getModified() && this.checkModifications() == 2) {
            return;
        }
        if (this.parent.isVisible()) {
            this.setVisible(false);
        } else if (this.tree == null) {
            System.exit(0);
        } else if (this.tree.allEditorsAreClosed()) {
            System.exit(0);
        } else {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                new MultiClassesPanel(new JFrame(), null).setVisible(true);
            } else {
                new MultiClassesPanel(new JFrame(), args[0]).setVisible(true);
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, e);
        }
    }
}

