/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.tango.pogo.pogo_gui.ClassPanel;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.Utils;

class InheritancePanel
extends JPanel {
    private ArrayList<JTextPane> textPanes = new ArrayList();
    private PogoGUI gui = null;
    private long t0 = 0L;
    private static final Color classBtnBG = new Color(255, 230, 200);
    private static final Color selectedClassBtnBG = new Color(255, 150, 100);
    private static final String deviceImpl = "Tango DeviceImpl";

    public InheritancePanel(DeviceClass devclass) {
        this.setLayout(new GridBagLayout());
        this.addAncestorPanes(devclass);
    }

    public InheritancePanel(DeviceClass devclass, PogoGUI gui) {
        this.gui = gui;
        this.setLayout(new GridBagLayout());
        this.addAncestorPanes(devclass);
    }

    private void addInheritanceIcon(int y) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        JLabel lbl = new JLabel("");
        lbl.setIcon(Utils.getInstance().inherite_icon);
        this.add((Component)lbl, gbc);
    }

    private void addClassPane(DeviceClass dc, int y, boolean addInher) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        ClassPane cp = new ClassPane(dc);
        if (this.gui != null) {
            cp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    InheritancePanel.this.textPaneMouseClicked(evt);
                }
            });
        }
        this.add((Component)cp, gbc);
        this.textPanes.add(cp);
        if (addInher) {
            this.addInheritanceIcon(y + 1);
        }
    }

    private void addAncestorPanes(DeviceClass dc) {
        ArrayList<DeviceClass> ancestors = dc.getAncestors();
        int y = 0;
        this.addClassPane(null, y += 2, true);
        for (DeviceClass ancestor : ancestors) {
            this.addClassPane(ancestor, y += 2, true);
        }
        this.addClassPane(dc, y += 2, false);
        this.textPanes.get(this.textPanes.size() - 1).setBackground(selectedClassBtnBG);
    }

    private void textPaneMouseClicked(MouseEvent evt) {
        JTextPane tp = (JTextPane)evt.getSource();
        String classname = tp.getName();
        if (classname.equals(deviceImpl)) {
            long t = evt.getWhen();
            if (t - this.t0 < 1000L && JOptionPane.showConfirmDialog(this, "Launch a WEB browser on DeviceImpl documentation ?", "Confirmation Window", 0) == 0) {
                Utils.showInHtmBrowser(PogoConst.tangoHTTP[2]);
            }
            this.t0 = t;
            return;
        }
        boolean found = false;
        for (ClassPanel panel : this.gui.getClassPanels()) {
            if (!panel.getName().equals(classname)) continue;
            found = true;
            this.gui.setTabbedPaneSelection(panel);
        }
        if (found) {
            for (JTextPane pane : this.textPanes) {
                if (pane == tp) {
                    pane.setBackground(selectedClassBtnBG);
                    continue;
                }
                pane.setBackground(classBtnBG);
            }
        }
    }

    public void setSelected(String name) {
        for (JTextPane b2 : this.textPanes) {
            if (b2.getName().equals(name)) {
                b2.setBackground(selectedClassBtnBG);
                continue;
            }
            b2.setBackground(classBtnBG);
        }
    }

    private class ClassPane
    extends JTextPane {
        private DeviceClass devClass;

        private ClassPane(DeviceClass dc) {
            this.devClass = dc;
            String classname = dc == null ? InheritancePanel.deviceImpl : this.devClass.getPogoDeviceClass().getName();
            this.setEditable(false);
            this.setName(classname);
            this.setFont(new Font("monospaced", 1, 10));
            this.setBackground(classBtnBG);
            this.insertIcon(Utils.getInstance().class_icon);
            this.setBorder(BorderFactory.createBevelBorder(0));
            String path = null;
            if (this.devClass == null) {
                this.setToolTipText(Utils.buildToolTip("TANGO DeviceImpl model", "See: " + PogoConst.tangoHTTP[2]));
            } else if (this.devClass.getPogoDeviceClass() != null && this.devClass.getPogoDeviceClass().getDescription() != null) {
                path = this.devClass.getPogoDeviceClass().getDescription().getSourcePath();
            }
            if (path != null) {
                this.setToolTipText(Utils.buildToolTip(this.devClass.getPogoDeviceClass().getName(), "Read at: " + path));
            }
            this.showMsg(" " + classname + " ", true);
            this.showMsg("\n + State\n + Status\n + ---", false);
        }

        private void showMsg(String msg, boolean title) {
            Document doc = this.getDocument();
            SimpleAttributeSet attrs = new SimpleAttributeSet();
            int fs = StyleConstants.getFontSize(attrs);
            try {
                StyleConstants.setBold(attrs, title);
                StyleConstants.setUnderline(attrs, title);
                if (title) {
                    StyleConstants.setFontSize(attrs, fs + 2);
                } else {
                    StyleConstants.setFontSize(attrs, fs - 2);
                }
                doc.insertString(doc.getLength(), msg, attrs);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
        }
    }
}

