/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.AdditionalFilesDialog;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.Utils;

public class GenerateDialog
extends JDialog {
    private int mode = 0;
    private static int returnStatus;
    private DeviceClass deviceClass;
    private ArrayList<JRadioButton> rBtn;
    private JRadioButton codeBtn;
    private JLabel docLabel;
    private JRadioButton eclipseProjectBtn;
    private JRadioButton htmlBtn;
    private JLabel javaProjectLabel;
    private JRadioButton makefileBtn;
    private JTextField outPathText;
    private JRadioButton pomBtn;
    private JRadioButton vc10Btn;
    private JRadioButton vc8Btn;
    private JRadioButton vc9Btn;
    private JLabel warningLabel;
    private JPanel warningPanel;
    private JLabel windowsLabel;
    private JRadioButton xmiBtn;

    public GenerateDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.rBtn = new ArrayList();
        this.rBtn.add(this.xmiBtn);
        this.rBtn.add(this.codeBtn);
        this.rBtn.add(this.makefileBtn);
        this.rBtn.add(this.vc8Btn);
        this.rBtn.add(this.vc9Btn);
        this.rBtn.add(this.vc10Btn);
        this.rBtn.add(this.eclipseProjectBtn);
        this.rBtn.add(this.pomBtn);
        this.rBtn.add(this.htmlBtn);
        String dbg = System.getenv("DEBUG_MAKE");
        if (Utils.isTrue(dbg)) {
            this.codeBtn.setSelected(false);
            this.makefileBtn.setSelected(true);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel pathPanel = new JPanel();
        JLabel nameLbl = new JLabel();
        this.outPathText = new JTextField();
        JButton browseBtn = new JButton();
        JPanel buttonsPanel = new JPanel();
        this.xmiBtn = new JRadioButton();
        this.codeBtn = new JRadioButton();
        this.makefileBtn = new JRadioButton();
        this.vc8Btn = new JRadioButton();
        JLabel generateLabel = new JLabel();
        this.htmlBtn = new JRadioButton();
        this.warningPanel = new JPanel();
        this.warningLabel = new JLabel();
        JLabel dummyLbl = new JLabel();
        JButton detailsBtn = new JButton();
        this.vc10Btn = new JRadioButton();
        this.windowsLabel = new JLabel();
        JLabel linuxLabel = new JLabel();
        this.docLabel = new JLabel();
        JLabel classLabel = new JLabel();
        this.javaProjectLabel = new JLabel();
        this.pomBtn = new JRadioButton();
        this.eclipseProjectBtn = new JRadioButton();
        this.vc9Btn = new JRadioButton();
        this.setTitle("Generation Preference  Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GenerateDialog.this.closeDialog(evt);
            }
        });
        bottomPanel.setLayout(new FlowLayout(2));
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerateDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerateDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        pathPanel.setLayout(new GridBagLayout());
        nameLbl.setFont(new Font("Arial", 1, 12));
        nameLbl.setText("Output Path :    ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        pathPanel.add((Component)nameLbl, gridBagConstraints);
        this.outPathText.setMinimumSize(new Dimension(450, 25));
        this.outPathText.setPreferredSize(new Dimension(450, 25));
        this.outPathText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerateDialog.this.okBtnActionPerformed(evt);
            }
        });
        this.outPathText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                GenerateDialog.this.outPathTextKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        pathPanel.add((Component)this.outPathText, gridBagConstraints);
        browseBtn.setText("Browse");
        browseBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerateDialog.this.browsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 40, 0);
        pathPanel.add((Component)browseBtn, gridBagConstraints);
        this.getContentPane().add((Component)pathPanel, "North");
        buttonsPanel.setLayout(new GridBagLayout());
        this.xmiBtn.setSelected(true);
        this.xmiBtn.setText("XMI   file");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.xmiBtn, gridBagConstraints);
        this.codeBtn.setSelected(true);
        this.codeBtn.setText("Code files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.codeBtn, gridBagConstraints);
        this.makefileBtn.setText("Makefile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.makefileBtn, gridBagConstraints);
        this.vc8Btn.setText("VC8 Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.vc8Btn, gridBagConstraints);
        generateLabel.setFont(new Font("Tahoma", 1, 14));
        generateLabel.setText("Files to be generated :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)generateLabel, gridBagConstraints);
        this.htmlBtn.setText("html Pages");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.htmlBtn, gridBagConstraints);
        this.warningPanel.setBackground(new Color(255, 229, 126));
        this.warningLabel.setFont(new Font("Tahoma", 1, 14));
        this.warningLabel.setText("  class  is  abstract !!!");
        this.warningPanel.add(this.warningLabel);
        dummyLbl.setText("             ");
        this.warningPanel.add(dummyLbl);
        detailsBtn.setText("Details");
        detailsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerateDialog.this.detailsBtnActionPerformed(evt);
            }
        });
        this.warningPanel.add(detailsBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        buttonsPanel.add((Component)this.warningPanel, gridBagConstraints);
        this.vc10Btn.setText("VC10 Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.vc10Btn, gridBagConstraints);
        this.windowsLabel.setFont(new Font("Tahoma", 1, 12));
        this.windowsLabel.setText("Windows:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        buttonsPanel.add((Component)this.windowsLabel, gridBagConstraints);
        linuxLabel.setFont(new Font("Tahoma", 1, 12));
        linuxLabel.setText("Linux:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        buttonsPanel.add((Component)linuxLabel, gridBagConstraints);
        this.docLabel.setFont(new Font("Tahoma", 1, 12));
        this.docLabel.setText("Documentation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        buttonsPanel.add((Component)this.docLabel, gridBagConstraints);
        classLabel.setFont(new Font("Tahoma", 1, 12));
        classLabel.setText("Device Class:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        buttonsPanel.add((Component)classLabel, gridBagConstraints);
        this.javaProjectLabel.setFont(new Font("Tahoma", 1, 12));
        this.javaProjectLabel.setText("Projects:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        buttonsPanel.add((Component)this.javaProjectLabel, gridBagConstraints);
        this.pomBtn.setText("pom.xml");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.pomBtn, gridBagConstraints);
        this.eclipseProjectBtn.setText("Eclipse Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.eclipseProjectBtn, gridBagConstraints);
        this.vc9Btn.setText("VC9 Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        buttonsPanel.add((Component)this.vc9Btn, gridBagConstraints);
        this.getContentPane().add((Component)buttonsPanel, "Center");
    }

    private void browsActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser(this.outPathText.getText());
        chooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
        chooser.setFileSelectionMode(1);
        int retval = chooser.showDialog(this, "Target Dir.");
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && file.isDirectory()) {
            this.outPathText.setText(file.getAbsolutePath());
        }
        this.outPathText.requestFocus();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String path = this.outPathText.getText();
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                if (this.makefileBtn.getSelectedObjects() != null || this.vc9Btn.getSelectedObjects() != null || this.vc10Btn.getSelectedObjects() != null) {
                    int ret = this.manageMakefile();
                    if (ret == 0 && this.vc10Btn.getSelectedObjects() != null) {
                        ret = this.manageWindowsPathCase();
                    }
                    this.doClose(ret);
                } else {
                    this.doClose(0);
                }
            } else {
                JOptionPane.showMessageDialog(this, String.valueOf(path) + " is not a directory !", "Error Window", 0);
            }
        } else if (JOptionPane.showConfirmDialog(this, String.valueOf(path) + " Does not exists !\n\n" + "   Would you like to create it ? ", "Error Window", 0) == 0) {
            try {
                if (file.mkdir()) {
                    System.out.println(String.valueOf(path) + " created");
                    this.doClose(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot create: " + path, "Error Window", 0);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Cannot create: " + path + "\n" + e, "Error Window", 0);
            }
        }
    }

    private int manageWindowsPathCase() {
        if (Utils.osIsUnix()) {
            EList<Inheritance> inheritances = this.deviceClass.getPogoDeviceClass().getDescription().getInheritances();
            for (Inheritance inheritance : inheritances) {
                if (DeviceClass.isDefaultInheritance(inheritance)) continue;
                String path = inheritance.getSourcePath();
                String newPath = (String)JOptionPane.showInputDialog(this, "Inheritance class path for " + inheritance.getClassname() + "  is NOT a WINDOWS path !   " + "Please give a valid Windows path.", "Input Dialog", 1, null, null, path);
                if (newPath == null) {
                    return 2;
                }
                inheritance.setSourcePath(newPath);
            }
        }
        return 0;
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private String buidDetailsString(ArrayList<String> items, String name) {
        StringBuilder sb = new StringBuilder();
        if (items.size() > 0) {
            if (items.size() > 1) {
                sb.append("The following ").append(name).append("s are abstract:\n");
                for (String s : items) {
                    sb.append("  - ").append(s).append("\n");
                }
            } else {
                sb.append("The ").append(name).append("  ").append(items.get(0)).append("  is abstract.\n");
            }
        }
        return sb.toString();
    }

    private void detailsBtnActionPerformed(ActionEvent evt) {
        ArrayList<String> commands = this.deviceClass.getAbstractCommandNames();
        ArrayList<String> attributes = this.deviceClass.getAbstractAttributeNames();
        String message = this.buidDetailsString(commands, "command");
        message = String.valueOf(message) + "\n";
        message = String.valueOf(message) + this.buidDetailsString(attributes, "attribute");
        JOptionPane.showMessageDialog(this, message, "Deteails Window", 1);
    }

    private void outPathTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.doClose(2);
        }
    }

    public int showDialog(DeviceClass devclass) {
        this.mode = 0;
        this.deviceClass = devclass;
        String path = devclass.getPogoDeviceClass().getDescription().getSourcePath();
        if (path == null || !new File(path).exists()) {
            path = PogoGUI.homeDir;
        }
        this.outPathText.setText(path);
        this.outPathText.setRequestFocusEnabled(true);
        this.outPathText.requestFocus();
        if (devclass.checkIfAbstractClass()) {
            this.makefileBtn.setEnabled(false);
            this.vc8Btn.setEnabled(false);
            this.vc9Btn.setEnabled(false);
            this.vc10Btn.setEnabled(false);
            this.javaProjectLabel.setVisible(false);
            this.eclipseProjectBtn.setVisible(false);
            this.pomBtn.setVisible(false);
        }
        int lang = Utils.getLanguage(devclass.getPogoDeviceClass().getDescription().getLanguage());
        switch (lang) {
            case 1: {
                this.makefileBtn.setVisible(true);
                this.windowsLabel.setVisible(true);
                this.vc8Btn.setVisible(true);
                this.vc9Btn.setVisible(true);
                this.vc10Btn.setVisible(true);
                this.javaProjectLabel.setVisible(false);
                this.eclipseProjectBtn.setVisible(false);
                this.pomBtn.setVisible(false);
                break;
            }
            case 0: {
                this.makefileBtn.setVisible(true);
                this.windowsLabel.setVisible(false);
                this.vc8Btn.setVisible(false);
                this.vc9Btn.setVisible(false);
                this.vc10Btn.setVisible(false);
                this.javaProjectLabel.setVisible(true);
                this.eclipseProjectBtn.setVisible(true);
                this.pomBtn.setVisible(true);
                break;
            }
            case 2: {
                this.makefileBtn.setVisible(false);
                this.windowsLabel.setVisible(false);
                this.vc8Btn.setVisible(false);
                this.vc9Btn.setVisible(false);
                this.vc10Btn.setVisible(false);
                this.javaProjectLabel.setVisible(false);
                this.eclipseProjectBtn.setVisible(false);
                this.pomBtn.setVisible(false);
            }
        }
        boolean isAbstract = devclass.checkIfAbstractClass();
        if (isAbstract) {
            this.warningLabel.setText(String.valueOf(devclass.getPogoDeviceClass().getName()) + this.warningLabel.getText());
        } else {
            this.warningPanel.setVisible(false);
        }
        this.pack();
        this.setVisible(true);
        return returnStatus;
    }

    public int showDialog(PogoMultiClasses classes) {
        this.mode = 1;
        String path = classes.getSourcePath();
        if (path == null || !new File(path).exists()) {
            path = MultiClassesPanel.homeDir;
        }
        this.outPathText.setText(path);
        this.outPathText.setRequestFocusEnabled(true);
        this.outPathText.requestFocus();
        this.windowsLabel.setVisible(false);
        this.vc8Btn.setVisible(false);
        this.vc9Btn.setVisible(false);
        this.vc10Btn.setVisible(false);
        this.docLabel.setVisible(false);
        this.htmlBtn.setVisible(false);
        this.makefileBtn.setVisible(true);
        this.warningPanel.setVisible(false);
        this.pack();
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public String getPath() {
        return this.outPathText.getText();
    }

    public String getGenerated() {
        String generated = "";
        for (JRadioButton btn : this.rBtn) {
            if (btn.getSelectedObjects() == null) continue;
            generated = String.valueOf(generated) + btn.getText() + ",";
        }
        if (generated.length() == 0) {
            return generated;
        }
        return generated.substring(0, generated.length() - 1);
    }

    public DeviceClass getDevClass() {
        this.deviceClass.getPogoDeviceClass().getDescription().setSourcePath(this.outPathText.getText());
        this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate(this.getGenerated());
        return this.deviceClass;
    }

    private boolean mustBeOverWritten(String fileName) {
        String path = this.outPathText.getText();
        String fullName = String.valueOf(path) + "/" + fileName;
        File file = new File(fullName);
        return file.exists() && JOptionPane.showConfirmDialog(this, String.valueOf(fileName) + " already exists !\n" + "Overwrite it ?", "Confirmation Window", 0) == 0;
    }

    private int manageMakefile() {
        File file;
        String makefile = "Makefile";
        if (this.mode == 1) {
            makefile = String.valueOf(makefile) + ".multi";
        }
        boolean overwriteMakefile = false;
        boolean overwriteVC9 = false;
        boolean overwriteVC10 = false;
        boolean generate = false;
        if (this.makefileBtn.getSelectedObjects() != null) {
            overwriteMakefile = this.mustBeOverWritten(makefile);
        } else {
            generate = true;
        }
        if (this.mode == 0 && this.vc9Btn.getSelectedObjects() != null) {
            overwriteVC9 = this.mustBeOverWritten("vc9_proj");
        } else {
            generate = true;
        }
        if (this.mode == 0 && this.vc10Btn.getSelectedObjects() != null) {
            overwriteVC10 = this.mustBeOverWritten("vc10_proj");
        } else {
            generate = true;
        }
        String path = this.outPathText.getText();
        if (this.mode == 0 && (generate || overwriteMakefile || overwriteVC9 || overwriteVC10)) {
            String lang = this.deviceClass.getPogoDeviceClass().getDescription().getLanguage();
            EList<AdditionalFile> files = this.deviceClass.getPogoDeviceClass().getAdditionalFiles();
            AdditionalFilesDialog dlg = new AdditionalFilesDialog(this, files, path, Utils.getFileExtension(lang));
            if (dlg.showDialog() == 2) {
                return 2;
            }
        }
        if (overwriteMakefile && !(file = new File(String.valueOf(path) + "/" + makefile)).renameTo(new File(String.valueOf(file.toString()) + ".bck"))) {
            System.err.println("Cannot rename " + file);
        }
        if (overwriteVC9 && !(file = new File(String.valueOf(path) + "/vc9_proj")).renameTo(new File(String.valueOf(file.toString()) + ".bck"))) {
            System.err.println("Cannot rename " + file);
        }
        if (overwriteVC10 && !(file = new File(String.valueOf(path) + "/vc10_proj")).renameTo(new File(String.valueOf(file.toString()) + ".bck"))) {
            System.err.println("Cannot rename " + file);
        }
        return 0;
    }
}

