/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class DeviceIdDialog
extends JDialog {
    private int retVal = 0;
    private ClassIdentification id = null;
    private static final String HelpMessage = "During TANGO meeting in Kobe (Japan)\nIt has been decided to create a\ndevice class identification for all TANGO classes.\n\nThe goal of this device class identification\nis to sort and find class by key words.\n\nDo not be afraid to be spammed,\nthe email for contact will not appear clearly in html pages";
    private JComboBox busComboBox;
    private JPanel centerPanel;
    private JTextField contactTxt;
    private JComboBox familyComboBox;
    private JTextField manufacturerTxt;
    private JComboBox platformComboBox;
    private JTextField referenceTxt;
    private JRadioButton siteButton;
    private JPanel topPanel;

    private Vector<String> toVector(ArrayList<String> strings) {
        Vector<String> vs = new Vector<String>();
        for (String str : strings) {
            vs.add(str);
        }
        return vs;
    }

    public DeviceIdDialog(JFrame parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.familyComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.classFamilies)));
        this.platformComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.platformNames)));
        this.busComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.busNames)));
        if (PogoProperty.siteName != null && PogoProperty.siteName.length() > 0 && PogoProperty.siteClassFamilies != null && PogoProperty.siteClassFamilies.size() > 0) {
            this.siteButton.setText(String.valueOf(PogoProperty.siteName) + " Specific");
        } else {
            this.siteButton.setVisible(false);
        }
        this.topPanel.add(new JLabel("        "));
        JButton btn = new JButton("Help");
        btn.setBorder(new SoftBevelBorder(0));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.helpBtnActionPerformed(evt);
            }
        });
        this.topPanel.add(btn);
        String mail = System.getenv("EMAIL");
        if (mail == null || mail.length() == 0) {
            mail = PogoProperty.contactAddress;
        }
        this.contactTxt.setText(mail);
        this.manufacturerTxt.setText("none");
        this.pack();
        this.setReferenceVisible(false);
        ATKGraphicsUtils.centerDialog(this);
    }

    public DeviceIdDialog(JFrame parent, ClassIdentification id) {
        this(parent);
        this.id = id;
        if (id != null) {
            if (this.siteButton.isVisible() && PogoProperty.siteName != null && id.getSiteSpecific() != null && id.getSiteSpecific().equals(PogoProperty.siteName)) {
                this.siteButton.setSelected(true);
                this.familyComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.siteClassFamilies)));
            }
            this.contactTxt.setText(String.valueOf(id.getAuthor()) + "@" + id.getEmailDomain());
            if (id.getAuthor() == null || id.getAuthor().length() == 0) {
                this.contactTxt.setText(id.getContact());
            }
            this.platformComboBox.setSelectedItem(id.getPlatform());
            this.familyComboBox.setSelectedItem(id.getClassFamily());
            this.busComboBox.setSelectedItem(id.getBus());
            this.manufacturerTxt.setText(id.getManufacturer());
            this.referenceTxt.setText(id.getReference());
            this.setReferenceVisible(id.getManufacturer().length() > 0 && !id.getManufacturer().equals("none"));
        }
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    private void setReferenceVisible(boolean b2) {
        this.referenceTxt.setEditable(b2);
        if (b2) {
            this.referenceTxt.setBackground(Color.white);
        } else {
            this.referenceTxt.setBackground(Color.lightGray);
        }
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        JLabel contactLabel = new JLabel();
        JLabel platformLabel = new JLabel();
        JLabel busLabel = new JLabel();
        JLabel manufacturerLabel = new JLabel();
        JLabel referenceLabel = new JLabel();
        this.contactTxt = new JTextField();
        this.manufacturerTxt = new JTextField();
        this.referenceTxt = new JTextField();
        this.platformComboBox = new JComboBox();
        this.busComboBox = new JComboBox();
        this.familyComboBox = new JComboBox();
        JLabel familyLabel = new JLabel();
        this.siteButton = new JRadioButton();
        this.topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DeviceIdDialog.this.closeDialog(evt);
            }
        });
        this.centerPanel.setLayout(new GridBagLayout());
        contactLabel.setText("Contact email *");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.centerPanel.add((Component)contactLabel, gridBagConstraints);
        platformLabel.setText("Platform *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)platformLabel, gridBagConstraints);
        busLabel.setText("Bus *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)busLabel, gridBagConstraints);
        manufacturerLabel.setText("Manufacturer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)manufacturerLabel, gridBagConstraints);
        referenceLabel.setText("Product Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 0);
        this.centerPanel.add((Component)referenceLabel, gridBagConstraints);
        this.contactTxt.setColumns(20);
        this.contactTxt.setFont(new Font("Dialog", 1, 12));
        this.contactTxt.setToolTipText(Utils.buildToolTip("Programmer or contact email address"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        this.centerPanel.add((Component)this.contactTxt, gridBagConstraints);
        this.manufacturerTxt.setColumns(20);
        this.manufacturerTxt.setFont(new Font("Dialog", 1, 12));
        this.manufacturerTxt.setToolTipText(Utils.buildToolTip("manufacturer name"));
        this.manufacturerTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DeviceIdDialog.this.manufacturerTxtKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.manufacturerTxt, gridBagConstraints);
        this.referenceTxt.setColumns(20);
        this.referenceTxt.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        this.centerPanel.add((Component)this.referenceTxt, gridBagConstraints);
        this.platformComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"All Platforms", "Unix Like", "Windows"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.platformComboBox, gridBagConstraints);
        this.busComboBox.setEditable(true);
        this.busComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "Not Applicable", "Compact PCI", "Data Socket", "Ethernet", "FireWire", "GPIB", "Modbus", "PCI", "PCI Express", "Serial Line", "Socket", "TCP/UDP", "USB", "VME"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.busComboBox, gridBagConstraints);
        this.familyComboBox.setEditable(true);
        this.familyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Miscellaneous", "AbstractClasses", "Acquisition", "Application", "BeamDiag", "Calculation", "Communication", "Controllers", "InputOutput", "Instrumentation", "Interlock", "Motion", "PowerSupply", "Process", "RadioProtection", "Sequencer", "Simulators", "Training", "Vacuum"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.familyComboBox, gridBagConstraints);
        familyLabel.setText("Class family *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)familyLabel, gridBagConstraints);
        this.siteButton.setText("Site button");
        this.siteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.siteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 35, 0);
        this.centerPanel.add((Component)this.siteButton, gridBagConstraints);
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Device Class Identification");
        this.topPanel.add(titleLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.centerPanel.add((Component)this.topPanel, gridBagConstraints);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeviceIdDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void manufacturerTxtKeyReleased(KeyEvent evt) {
        String s = this.manufacturerTxt.getText();
        this.setReferenceVisible(s.length() > 0 && !s.equals("none"));
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.checkInputs();
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(new JFrame(), HelpMessage, "Help Window", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void siteButtonActionPerformed(ActionEvent evt) {
        this.manageSiteFamilies();
    }

    private void manageSiteFamilies() {
        if (PogoProperty.siteName != null && PogoProperty.siteName.length() > 0 && PogoProperty.siteClassFamilies != null && PogoProperty.siteClassFamilies.size() > 0) {
            this.siteButton.setText(String.valueOf(PogoProperty.siteName) + " Specific");
            this.siteButton.setVisible(true);
        } else {
            this.siteButton.setVisible(false);
        }
        String family = (String)this.familyComboBox.getSelectedItem();
        if (this.siteButton.getSelectedObjects() == null) {
            this.familyComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.classFamilies)));
        } else {
            this.familyComboBox.setModel(new DefaultComboBoxModel<String>(this.toVector(PogoProperty.siteClassFamilies)));
        }
        this.familyComboBox.setSelectedItem(family);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public void checkInputs() throws DevFailed {
        String bus;
        String family;
        int pos2;
        if (Utils.isTrue(System.getenv("TEST_MODE"))) {
            return;
        }
        String contact = this.contactTxt.getText().trim();
        int pos = contact.indexOf(64);
        if (pos <= 0) {
            Except.throw_exception("SyntaxError", "email is not available", "DeviceId.CheckInputs()");
        }
        if ((pos2 = contact.indexOf(46, pos)) <= 0 || contact.length() - pos2 < 3) {
            Except.throw_exception("SyntaxError", "email is not available", "DeviceId.CheckInputs()");
        }
        if ((family = (String)this.familyComboBox.getSelectedItem()) == null || family.trim().length() == 0) {
            Except.throw_exception("SyntaxError", "Class family is not available", "DeviceId.CheckInputs()");
        }
        if ((bus = (String)this.busComboBox.getSelectedItem()) == null || bus.trim().length() == 0) {
            Except.throw_exception("SyntaxError", "Bus is not available", "DeviceId.CheckInputs()");
        }
    }

    public static void buildIdContact(ClassIdentification id, String str) {
        StringTokenizer stk = new StringTokenizer(str, "@");
        id.setAuthor(stk.nextToken());
        id.setEmailDomain(stk.nextToken());
        id.setContact("at " + id.getEmailDomain() + " - " + id.getAuthor());
    }

    public ClassIdentification getInputs() {
        if (this.id == null) {
            this.id = OAWutils.factory.createClassIdentification();
        }
        String platform = (String)this.platformComboBox.getSelectedItem();
        String family = (String)this.familyComboBox.getSelectedItem();
        String bus = (String)this.busComboBox.getSelectedItem();
        String site = "";
        if (this.siteButton.isVisible() && this.siteButton.getSelectedObjects() != null) {
            site = PogoProperty.siteName;
        }
        DeviceIdDialog.buildIdContact(this.id, this.contactTxt.getText().trim());
        this.id.setClassFamily(family);
        this.id.setSiteSpecific(site);
        this.id.setPlatform(platform);
        this.id.setBus(bus);
        this.id.setManufacturer(this.manufacturerTxt.getText().trim());
        this.id.setReference(this.referenceTxt.getText().trim());
        return this.id;
    }
}

