/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeletedObjects;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.OldPogoModel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.RenamedObjects;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.ProtectedAreaManager;
import org.tango.pogo.pogo_gui.tools.Utils;

public class DeviceClass {
    private OldPogoModel old_pogo_class = null;
    private PogoDeviceClass pogo_class = null;
    private ArrayList<DeviceClass> ancestors = new ArrayList();
    private static final String defaultInheritanceStart = "Device_";
    private static final String defaultInheritanceEnd = "Impl";
    private static final String defaultInheritance = "Device_Impl";
    private ArrayList<String> parentClasses = new ArrayList();

    public DeviceClass() {
        this.pogo_class = OAWutils.factory.createPogoDeviceClass();
        this.pogo_class.setDescription(OAWutils.factory.createClassDescription());
        this.pogo_class.getDescription().getInheritances().add(DeviceClass.getDefaultInheritance());
    }

    public DeviceClass(String name, DeviceClass devclass) {
        this.pogo_class = OAWutils.factory.createPogoDeviceClass();
        this.pogo_class.setDescription(OAWutils.factory.createClassDescription());
        this.pogo_class.setName(name);
        EList<Inheritance> inheritances = this.pogo_class.getDescription().getInheritances();
        if (inheritances.size() == 0) {
            inheritances.add(DeviceClass.getDefaultInheritance());
        }
        if (devclass != null) {
            Inheritance inheritance = OAWutils.factory.createInheritance();
            inheritance.setClassname(devclass.pogo_class.getName());
            inheritance.setSourcePath(devclass.pogo_class.getDescription().getSourcePath());
            inheritances.add(0, inheritance);
        }
    }

    public DeviceClass(String filename) throws DevFailed {
        this(filename, true);
    }

    public DeviceClass(String filename, boolean loadInheritance) throws DevFailed {
        if (filename.endsWith(".xmi")) {
            this.pogo_class = OAWutils.getInstance().loadDeviceClassModel(filename);
            EList<Inheritance> inheritances = this.pogo_class.getDescription().getInheritances();
            if (inheritances.size() == 0) {
                inheritances.add(DeviceClass.getDefaultInheritance());
            }
            String path = Utils.getPath(filename);
            this.pogo_class.getDescription().setSourcePath(path);
            Utils.getInstance().stopSplashRefresher();
            if (loadInheritance && !this.loadInheritanceClasses()) {
                Except.throw_exception("CANCEL", "", "");
            }
        } else {
            String str = ParserTool.readFile(filename);
            if (!str.contains("This file is generated by POGO")) {
                Except.throw_exception("UNKNOWN_FILE", String.valueOf(filename) + "\n\n has not been generated by Pogo ", "DeviceClass.DeviceClass()");
            }
            this.old_pogo_class = new OldPogoModel(filename);
            this.pogo_class = this.old_pogo_class.getPogoDeviceClass();
        }
        DeviceClass.checkIfAbstractClass(this.pogo_class, true);
    }

    public static boolean isDefaultInheritance(Inheritance inher) {
        if (inher.getClassname() == null) {
            return true;
        }
        return inher.getClassname().startsWith(defaultInheritanceStart) && inher.getClassname().endsWith(defaultInheritanceEnd);
    }

    public static Inheritance getDefaultInheritance() {
        Inheritance inher = OAWutils.factory.createInheritance();
        inher.setClassname(defaultInheritance);
        inher.setSourcePath("");
        return inher;
    }

    public ArrayList<String> getAbstractAttributeNames() {
        ArrayList<String> attnames = new ArrayList<String>();
        EList<Attribute> attributes = this.pogo_class.getAttributes();
        for (Attribute att : attributes) {
            if (Utils.isTrue(att.getStatus().getConcrete()) || Utils.isTrue(att.getStatus().getConcreteHere())) continue;
            attnames.add(att.getName());
        }
        return attnames;
    }

    public ArrayList<String> getAbstractCommandNames() {
        ArrayList<String> cmdnames = new ArrayList<String>();
        EList<Command> commands = this.pogo_class.getCommands();
        for (Command cmd : commands) {
            if (Utils.isTrue(cmd.getStatus().getConcrete()) || Utils.isTrue(cmd.getStatus().getConcreteHere())) continue;
            cmdnames.add(cmd.getName());
        }
        return cmdnames;
    }

    public boolean checkIfAbstractClass() {
        return DeviceClass.checkIfAbstractClass(this.pogo_class, false);
    }

    public static boolean checkIfAbstractClass(PogoDeviceClass pc, boolean update) {
        EList<Command> commands = pc.getCommands();
        EList<Attribute> attributes = pc.getAttributes();
        if (update) {
            pc.getDescription().setHasAbstractCommand("false");
            pc.getDescription().setHasAbstractAttribute("false");
            for (Command cmd : commands) {
                if (cmd.getStatus() == null || Utils.isTrue(cmd.getStatus().getConcrete()) || Utils.isTrue(cmd.getStatus().getConcreteHere())) continue;
                pc.getDescription().setHasAbstractCommand("true");
            }
            for (Attribute att : attributes) {
                if (att.getStatus() == null || Utils.isTrue(att.getStatus().getConcrete()) || Utils.isTrue(att.getStatus().getConcreteHere())) continue;
                pc.getDescription().setHasAbstractAttribute("true");
            }
        }
        return Utils.isTrue(pc.getDescription().getHasAbstractCommand()) || Utils.isTrue(pc.getDescription().getHasAbstractAttribute());
    }

    public boolean isOldPogoModel() {
        return this.old_pogo_class != null;
    }

    public boolean isOldPogoModelAbstract() throws DevFailed {
        if (this.old_pogo_class == null) {
            Except.throw_exception("NOT_OLD_MODEL", "This class is not an old POGO model.", "DeviceClass.isOldPogoModelAbstarct()");
        }
        return this.old_pogo_class.isAbsAbstract();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkInheritanceFile(String filename, String className) throws DevFailed {
        System.out.println("checkInheritanceFile for  " + filename);
        if (new File(filename).exists()) return filename;
        String from_env = InheritanceUtils.checkInheritanceFileFromEnv(filename);
        if (from_env != null) {
            return from_env;
        }
        if (!PogoGUI.useDisplay) {
            Except.throw_exception("NO_INHERITANCE", String.valueOf(filename) + ": inheritance file not found", "DeviceClass.checkInheritanceFile()");
        }
        JOptionPane.showMessageDialog(new JFrame(), String.valueOf(filename) + "\nInheritance class Not Found !", "Error Window", 0);
        String path = this.pogo_class.getDescription().getSourcePath();
        JFileChooser chooser = new JFileChooser(new File(path).getAbsolutePath());
        PogoFileFilter filter = new PogoFileFilter("xmi", String.valueOf(className) + " class");
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(new JFrame()) != 0) return null;
        File file = chooser.getSelectedFile();
        if (file == null) return null;
        if (file.isDirectory()) return null;
        return file.getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadInheritanceClasses() throws DevFailed {
        try {
            EList<Inheritance> inheritances = this.pogo_class.getDescription().getInheritances();
            Iterator iterator = inheritances.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Inheritance inheritance = (Inheritance)iterator.next();
                if (DeviceClass.isDefaultInheritance(inheritance)) continue;
                String className = inheritance.getClassname();
                String filename = String.valueOf(inheritance.getSourcePath()) + System.getProperty("file.separator") + className + ".xmi";
                if ((filename = this.checkInheritanceFile(filename, className)) == null) {
                    return false;
                }
                Utils.getInstance().startSplashRefresher("Loading  " + Utils.getRelativeFilename(filename));
                this.ancestors.add(new DeviceClass(filename, false));
                inheritance.setSourcePath(Utils.getPath(filename));
                Utils.getInstance().stopSplashRefresher();
            }
        }
        catch (DevFailed e) {
            if (!PogoGUI.useDisplay) throw e;
            Utils.getInstance().stopSplashRefresher();
            ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
            return true;
        }
        catch (Exception e) {
            if (PogoGUI.useDisplay) {
                Utils.getInstance().stopSplashRefresher();
                ErrorPane.showErrorMessage((Component)new JFrame(), null, e);
            }
            e.printStackTrace();
            return false;
        }
    }

    public void removeInheritance() {
        EList<Inheritance> inheritances = this.pogo_class.getDescription().getInheritances();
        inheritances.clear();
        Inheritance inheritance = OAWutils.factory.createInheritance();
        inheritance.setClassname(DeviceClass.getDefaultInheritance().getClassname());
        inheritance.setSourcePath("");
        inheritances.add(inheritance);
        EList<Property> classprops = this.pogo_class.getClassProperties();
        EList<Property> devprops = this.pogo_class.getDeviceProperties();
        EList<Command> commands = this.pogo_class.getCommands();
        EList<Attribute> attributes = this.pogo_class.getAttributes();
        EList<State> states = this.pogo_class.getStates();
        for (Property property : classprops) {
            property.getStatus().setInherited("false");
        }
        for (Property property : devprops) {
            property.getStatus().setInherited("false");
        }
        for (Command command : commands) {
            if (command.getName().equals("State") || command.getName().equals("Statuse")) continue;
            command.getStatus().setInherited("false");
        }
        for (Attribute attribute : attributes) {
            attribute.getStatus().setInherited("false");
        }
        for (State state : states) {
            state.getStatus().setInherited("false");
        }
    }

    public String getProjectFilename() {
        return String.valueOf(this.pogo_class.getDescription().getSourcePath()) + "/" + this.pogo_class.getName() + ".xmi";
    }

    public PogoDeviceClass getPogoDeviceClass() {
        return this.pogo_class;
    }

    public ArrayList<DeviceClass> getAncestors() {
        return this.ancestors;
    }

    public void setAncestors(ArrayList<DeviceClass> ancestors) {
        this.ancestors = ancestors;
    }

    public void addAncestor(DeviceClass ancestor) {
        for (DeviceClass anAncestor : ancestor.ancestors) {
            this.ancestors.add(anAncestor);
            Inheritance inheritance = OAWutils.factory.createInheritance();
            inheritance.setClassname(anAncestor.getPogoDeviceClass().getName());
            inheritance.setSourcePath(anAncestor.getPogoDeviceClass().getDescription().getSourcePath());
            this.pogo_class.getDescription().getInheritances().add(inheritance);
        }
        this.ancestors.add(ancestor);
        Inheritance inheritance = OAWutils.factory.createInheritance();
        inheritance.setClassname(ancestor.getPogoDeviceClass().getName());
        inheritance.setSourcePath(ancestor.getPogoDeviceClass().getDescription().getSourcePath());
        this.pogo_class.getDescription().getInheritances().add(inheritance);
    }

    public String getCppFile() {
        return String.valueOf(this.pogo_class.getDescription().getSourcePath()) + System.getProperty("file.separator") + this.pogo_class.getName() + ".cpp";
    }

    public void generateWithNewName(String newClassName, boolean modified, DeletedObjects deleted, RenamedObjects renamed) throws SecurityException, IOException, DevFailed {
        String srcClassName = this.getPogoDeviceClass().getName();
        if (modified) {
            this.getPogoDeviceClass().getDescription().setFilestogenerate("XMI File, Code files");
            this.generate(deleted, renamed);
        }
        deleted.clear();
        renamed.clear();
        this.getPogoDeviceClass().setName(newClassName);
        this.getPogoDeviceClass().getDescription().setFilestogenerate("XMI File, Code files");
        this.generate(new DeletedObjects(), new RenamedObjects());
        if (this.getPogoDeviceClass().getDescription().getLanguage().toLowerCase().equals("cpp")) {
            String extension;
            String[] extensions;
            String path = this.getPogoDeviceClass().getDescription().getSourcePath();
            String[] stringArray = extensions = new String[]{".h", ".cpp", "Class.h", "Class.cpp", "StateMachine.cpp"};
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                extension = stringArray[n2];
                String inFileName = String.valueOf(path) + "/" + srcClassName + extension;
                String outFileName = String.valueOf(path) + "/" + newClassName + extension;
                ProtectedAreaManager pam = new ProtectedAreaManager(inFileName);
                pam.setClassName(newClassName, outFileName);
                ++n2;
            }
            stringArray = extensions;
            n = extensions.length;
            n2 = 0;
            while (n2 < n) {
                extension = stringArray[n2];
                if (!new File(String.valueOf(path) + "/" + srcClassName + extension).delete()) {
                    System.err.println("failed to delete" + srcClassName + extension);
                }
                ++n2;
            }
        }
    }

    public void generate(DeletedObjects deleted, RenamedObjects renamed) throws SecurityException, IOException, DevFailed {
        String className = this.pogo_class.getName();
        if (renamed != null) {
            renamed.readCode(className, this.getCppFile());
        }
        if (deleted != null) {
            deleted.readCode(this.getCppFile());
        }
        OAWutils oaw = OAWutils.getInstance();
        oaw.generate(this.pogo_class);
        if (deleted != null && deleted.size() > 0) {
            deleted.insertCode(this.getCppFile());
        }
        if (renamed != null && renamed.size() > 0) {
            renamed.insertCode(className, this.getCppFile());
        }
    }

    public void generateDocFromOldModel(String oldSrcFilename, String targetDir) throws DevFailed {
        try {
            String descFilename = Utils.getPath(oldSrcFilename);
            descFilename = String.valueOf(descFilename) + "/" + PogoProperty.docHome + "/Description.html";
            if (targetDir == null) {
                targetDir = Utils.getPath(descFilename);
            }
            this.old_pogo_class.generateDocFromOldModel(descFilename, targetDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_exception("FAILED", e.toString(), "DeviceClass.generateDocFromOldModel()");
        }
    }

    public void generateFromOldModel(String filename, boolean recoverCode) throws DevFailed {
        try {
            String path = Utils.getPath(filename);
            path = String.valueOf(path) + "/new_src";
            if (!new File(path).exists() && !new File(path).mkdir()) {
                throw new Exception("Cannot create " + path);
            }
            this.pogo_class.getDescription().setFilestogenerate("XMI file,Code files,Linux Makefile");
            this.pogo_class.getDescription().setSourcePath(path);
            System.out.println("\n===============================================================\n\n");
            OAWutils.getInstance().generate(this.pogo_class);
            if (recoverCode) {
                this.recoverCodeFromOldPogoModel();
            }
            this.old_pogo_class.swapDirectories(this.pogo_class);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            Except.throw_exception("FAILED", e.toString(), "DeviceClass.generateFromOldModel()");
        }
    }

    private void recoverCodeFromOldPogoModel() throws Exception {
        if (this.old_pogo_class == null) {
            Except.throw_exception("NOT_AN_OLD_MODEL", "This is not an old POGO model", "DeviceClass.recoverCodeFromOldPogoModel()");
        }
        if (Utils.getLanguage(this.pogo_class.getDescription().getLanguage()) == 1) {
            this.old_pogo_class.recoverCppCodeFromOldPogoModel(this.pogo_class);
            this.old_pogo_class.manageCppAdditionalFiles(this.pogo_class);
        }
    }

    public void resetParentClasses() {
        this.parentClasses.clear();
    }

    public ArrayList<String> getParentClasses() {
        return this.parentClasses;
    }

    public void addParentClass(String name) {
        this.parentClasses.add(name);
    }

    public String toString() {
        if (this.pogo_class.getName() == null || this.pogo_class.getName().length() == 0) {
            return "This class";
        }
        return this.pogo_class.getName();
    }

    public static void main(String[] args) {
        String path = "/segfs/tango/tools/pogo/test/cpp/test_oaw";
        String filename = String.valueOf(path) + "/TestOaw.xmi";
        try {
            OAWutils oaw = OAWutils.getInstance();
            PogoDeviceClass pogo_class = oaw.loadDeviceClassModel(filename);
            System.err.println("\n\n\n");
            pogo_class.getDescription().setSourcePath(path);
            oaw.generate(pogo_class);
        }
        catch (DevFailed e) {
            Except.print_exception(e);
        }
    }
}

