/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Type;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.tango.pogo.pogo_gui.EditDialog;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class CommandDialog
extends JDialog {
    private int retVal = 0;
    private static String[] commandNames = new String[]{"Reset", "Off", "Warmup", "Standby", "On", "Start", "Stop", "Open", "Close", "Local", "Remote"};
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status = null;
    private boolean isStateStatus = false;
    private JRadioButton abstractBtn;
    private JComboBox arginComboBox;
    private JButton arginDescBtn;
    private JTextArea arginDescText;
    private JComboBox argoutComboBox;
    private JButton argoutDescBtn;
    private JTextArea argoutDescText;
    private JTextArea descText;
    private JRadioButton levelBtn;
    private JComboBox nameComboBox;
    private JRadioButton overloadBtn;
    private JRadioButton polledBtn;
    private JLabel polledLbl;
    private JTextField polledTxt;
    private static int[] columnSize = new int[]{140, 130, 130, 80, 40, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Input Arg", "Output Arg", "Level", "Inherited", "Abstract", "Description"};

    public CommandDialog(PogoGUI parent, Command cmd) {
        super((Frame)parent, true);
        this.pogo_gui = parent;
        this.initComponents();
        this.setCommand(cmd);
        this.manageInheritanceStatus(cmd);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void manageInheritanceStatus(Command cmd) {
        if (cmd != null) {
            this.orig_status = cmd.getStatus();
            if (Utils.isTrue(this.orig_status.getInherited())) {
                this.abstractBtn.setVisible(false);
                this.overloadBtn.setVisible(true);
                boolean oveload = Utils.isTrue(this.orig_status.getConcreteHere());
                this.overloadBtn.setSelected(oveload);
                this.setEditable(false);
            } else {
                this.overloadBtn.setVisible(false);
                this.abstractBtn.setVisible(true);
                this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
                this.setEditable(true);
            }
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setSelected(false);
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
            this.setEditable(true);
        }
    }

    private void setNotEditable(JComboBox jcb) {
        String name = (String)jcb.getSelectedItem();
        if (name != null) {
            jcb.removeAllItems();
            jcb.addItem(name);
        }
    }

    private void setEditable(boolean b2) {
        this.nameComboBox.setEditable(b2);
        if (!b2) {
            this.setNotEditable(this.nameComboBox);
            this.setNotEditable(this.arginComboBox);
            this.setNotEditable(this.argoutComboBox);
            this.levelBtn.setEnabled(b2);
            this.arginDescBtn.setEnabled(b2);
            this.arginDescText.setEditable(b2);
            this.argoutDescBtn.setEnabled(b2);
            this.argoutDescText.setEditable(false);
            this.descText.setEditable(b2);
        }
    }

    private void setCommand(Command cmd) {
        String[] stringArray = commandNames;
        int n = commandNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.nameComboBox.addItem(name);
            ++n2;
        }
        int i = 0;
        while (i < TangoConst.Tango_CmdArgTypeName.length) {
            if (i != 22 && i != 27) {
                String typeName = TangoConst.Tango_CmdArgTypeName[i];
                this.arginComboBox.addItem(typeName);
                this.argoutComboBox.addItem(typeName);
            }
            ++i;
        }
        this.polledTxt.setEnabled(false);
        this.polledTxt.setText("3000");
        if (cmd != null) {
            stringArray = commandNames;
            n = commandNames.length;
            int typeName = 0;
            while (typeName < n) {
                String name = stringArray[typeName];
                if (name.equals(cmd.getName())) {
                    this.nameComboBox.setSelectedItem(name);
                }
                ++typeName;
            }
            if (this.nameComboBox.getSelectedIndex() == 0) {
                String name = cmd.getName();
                this.nameComboBox.addItem(name);
                this.nameComboBox.setSelectedItem(name);
            }
            String desc = Utils.strReplace(cmd.getDescription(), "\\n", "\n");
            desc = Utils.strReplaceSpecialCharToDisplay(desc);
            this.descText.setText(desc);
            desc = Utils.strReplace(cmd.getArgin().getDescription(), "\\n", "\n");
            desc = Utils.strReplaceSpecialCharToDisplay(desc);
            this.arginDescText.setText(desc);
            desc = Utils.strReplace(cmd.getArgout().getDescription(), "\\n", "\n");
            desc = Utils.strReplaceSpecialCharToDisplay(desc);
            this.argoutDescText.setText(desc);
            String argin = OAWutils.pogo2tangoType(cmd.getArgin().getType().toString());
            String argout = OAWutils.pogo2tangoType(cmd.getArgout().getType().toString());
            String[] stringArray2 = TangoConst.Tango_CmdArgTypeName;
            int n3 = TangoConst.Tango_CmdArgTypeName.length;
            int n4 = 0;
            while (n4 < n3) {
                String type = stringArray2[n4];
                if (type.equals(argin)) {
                    this.arginComboBox.setSelectedItem(type);
                }
                if (type.equals(argout)) {
                    this.argoutComboBox.setSelectedItem(type);
                }
                ++n4;
            }
            if (Utils.isEquals(cmd.getDisplayLevel(), PogoConst.strLevel[1])) {
                this.levelBtn.setSelected(true);
            }
            if (cmd.getPolledPeriod() != null && cmd.getPolledPeriod().length() > 0 && !cmd.getPolledPeriod().equals("0")) {
                this.polledBtn.setSelected(true);
                this.polledTxt.setEnabled(true);
                this.polledLbl.setVisible(true);
                this.polledTxt.setText(cmd.getPolledPeriod());
            }
            if (cmd.getName().toLowerCase().equals("state") || cmd.getName().toLowerCase().equals("status")) {
                this.isStateStatus = true;
                this.levelBtn.setEnabled(false);
                this.levelBtn.setSelected(false);
            }
        } else {
            String name = "";
            this.nameComboBox.addItem(name);
            this.nameComboBox.setSelectedItem(name);
        }
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JPanel centerPanel = new JPanel();
        JLabel descLbl = new JLabel();
        JPanel toipPanel = new JPanel();
        JLabel nameLbl = new JLabel();
        this.nameComboBox = new JComboBox();
        this.abstractBtn = new JRadioButton();
        this.overloadBtn = new JRadioButton();
        JLabel arginLbl = new JLabel();
        JLabel argoutLbl = new JLabel();
        this.arginComboBox = new JComboBox();
        this.argoutComboBox = new JComboBox();
        this.arginDescBtn = new JButton();
        this.argoutDescBtn = new JButton();
        JPanel polledPanel = new JPanel();
        this.polledBtn = new JRadioButton();
        this.polledTxt = new JTextField();
        this.polledLbl = new JLabel();
        JPanel levelPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.levelBtn = new JRadioButton();
        JScrollPane descScrollPane = new JScrollPane();
        this.descText = new JTextArea();
        JScrollPane arginScrollPane = new JScrollPane();
        this.arginDescText = new JTextArea();
        JScrollPane argoutScrollPane = new JScrollPane();
        this.argoutDescText = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CommandDialog.this.closeDialog(evt);
            }
        });
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        centerPanel.setLayout(new GridBagLayout());
        descLbl.setFont(new Font("Arial", 1, 12));
        descLbl.setText("Command description:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 10);
        centerPanel.add((Component)descLbl, gridBagConstraints);
        nameLbl.setFont(new Font("Arial", 1, 12));
        nameLbl.setText("Command Name:");
        toipPanel.add(nameLbl);
        this.nameComboBox.setEditable(true);
        this.nameComboBox.setFont(new Font("Arial", 1, 12));
        toipPanel.add(this.nameComboBox);
        this.abstractBtn.setFont(new Font("Arial", 1, 12));
        this.abstractBtn.setText("Abstract");
        this.abstractBtn.setHorizontalAlignment(2);
        this.abstractBtn.setHorizontalTextPosition(2);
        this.abstractBtn.setMargin(new Insets(2, 12, 2, 12));
        this.abstractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.abstractBtnActionPerformed(evt);
            }
        });
        toipPanel.add(this.abstractBtn);
        this.overloadBtn.setFont(new Font("Arial", 1, 12));
        this.overloadBtn.setText("Overload");
        this.overloadBtn.setHorizontalAlignment(2);
        this.overloadBtn.setHorizontalTextPosition(2);
        this.overloadBtn.setMargin(new Insets(2, 12, 2, 12));
        this.overloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.overloadBtnActionPerformed(evt);
            }
        });
        toipPanel.add(this.overloadBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 15, 20, 20);
        centerPanel.add((Component)toipPanel, gridBagConstraints);
        arginLbl.setFont(new Font("Arial", 1, 12));
        arginLbl.setText("Input Argument:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 20, 0, 10);
        centerPanel.add((Component)arginLbl, gridBagConstraints);
        argoutLbl.setFont(new Font("Arial", 1, 12));
        argoutLbl.setText("Output Argument:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 20, 0, 10);
        centerPanel.add((Component)argoutLbl, gridBagConstraints);
        this.arginComboBox.setFont(new Font("Arial", 1, 12));
        this.arginComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.arginComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        centerPanel.add((Component)this.arginComboBox, gridBagConstraints);
        this.argoutComboBox.setFont(new Font("Arial", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        centerPanel.add((Component)this.argoutComboBox, gridBagConstraints);
        this.arginDescBtn.setText("...");
        this.arginDescBtn.setBorder(new SoftBevelBorder(0));
        this.arginDescBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.descBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        centerPanel.add((Component)this.arginDescBtn, gridBagConstraints);
        this.argoutDescBtn.setText("...");
        this.argoutDescBtn.setBorder(new SoftBevelBorder(0));
        this.argoutDescBtn.setHorizontalAlignment(2);
        this.argoutDescBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.descBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        centerPanel.add((Component)this.argoutDescBtn, gridBagConstraints);
        this.polledBtn.setFont(new Font("Arial", 1, 12));
        this.polledBtn.setText("Polled");
        this.polledBtn.setHorizontalAlignment(2);
        this.polledBtn.setHorizontalTextPosition(2);
        this.polledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommandDialog.this.polledBtnActionPerformed(evt);
            }
        });
        polledPanel.add(this.polledBtn);
        this.polledTxt.setColumns(8);
        this.polledTxt.setFont(new Font("Arial", 1, 12));
        polledPanel.add(this.polledTxt);
        this.polledLbl.setText("ms");
        polledPanel.add(this.polledLbl);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 15, 0);
        centerPanel.add((Component)polledPanel, gridBagConstraints);
        jLabel1.setFont(new Font("Arial", 1, 12));
        jLabel1.setText("Controlled by : ");
        levelPanel.add(jLabel1);
        this.levelBtn.setFont(new Font("Arial", 1, 12));
        this.levelBtn.setText("Expert Only");
        levelPanel.add(this.levelBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        centerPanel.add((Component)levelPanel, gridBagConstraints);
        descScrollPane.setPreferredSize(new Dimension(326, 100));
        this.descText.setColumns(35);
        this.descText.setRows(1);
        descScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        centerPanel.add((Component)descScrollPane, gridBagConstraints);
        arginScrollPane.setPreferredSize(new Dimension(246, 60));
        this.arginDescText.setColumns(30);
        this.arginDescText.setRows(2);
        arginScrollPane.setViewportView(this.arginDescText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        centerPanel.add((Component)arginScrollPane, gridBagConstraints);
        argoutScrollPane.setPreferredSize(new Dimension(246, 60));
        this.argoutDescText.setColumns(30);
        this.argoutDescText.setRows(2);
        argoutScrollPane.setViewportView(this.argoutDescText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        centerPanel.add((Component)argoutScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            String name = (String)this.nameComboBox.getSelectedItem();
            boolean overload = this.overloadBtn.getSelectedObjects() != null;
            name = Utils.checkNameSyntax(name, this.isStateStatus);
            if (this.pogo_gui.itemAlreadyExists(name, 2)) {
                Except.throw_exception("CommandExists", "Command \"" + name + "\" Already Exists !", "CommandDialog.okBtnActionPerformed()");
            }
            if (this.polledBtn.getSelectedObjects() != null) {
                try {
                    Integer.parseInt(this.polledTxt.getText());
                }
                catch (NumberFormatException e) {
                    Except.throw_exception(e.toString(), "Bad polling period.", "CommandDialog.okBtnActionPerformed()");
                }
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.retVal = 2;
        this.doClose();
    }

    private void descBtnActionPerformed(ActionEvent evt) {
        String text;
        JButton btn = (JButton)evt.getSource();
        if (btn == this.arginDescBtn) {
            text = this.arginDescText.getText();
        } else if (btn == this.argoutDescBtn) {
            text = this.argoutDescText.getText();
        } else {
            return;
        }
        EditDialog dlg = new EditDialog(this, text);
        if (dlg.showDialog() == 0) {
            if (btn == this.arginDescBtn) {
                this.arginDescText.setText(dlg.getText());
            } else if (btn == this.argoutDescBtn) {
                this.argoutDescText.setText(dlg.getText());
            }
        }
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean polled = this.polledBtn.getSelectedObjects() != null;
        this.polledTxt.setEnabled(polled);
    }

    private void abstractBtnActionPerformed(ActionEvent evt) {
    }

    private void overloadBtnActionPerformed(ActionEvent evt) {
    }

    private void arginComboBoxActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            boolean canBePolled;
            boolean bl = canBePolled = this.arginComboBox.getSelectedIndex() == 0;
            if (!canBePolled) {
                this.polledBtn.setSelected(false);
                this.polledTxt.setEnabled(false);
            }
            this.polledBtn.setEnabled(canBePolled);
        }
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    Command getCommand() {
        Command cmd = OAWutils.factory.createCommand();
        String name = (String)this.nameComboBox.getSelectedItem();
        try {
            boolean overload = this.overloadBtn.getSelectedObjects() != null;
            name = Utils.checkNameSyntax(name, overload);
        }
        catch (DevFailed overload) {
            // empty catch block
        }
        cmd.setName(name);
        cmd.setExecMethod(Utils.buildExcecMethodName(name));
        String desc = Utils.strReplaceSpecialCharToCode(this.descText.getText());
        cmd.setDescription(desc);
        Argument argin = OAWutils.factory.createArgument();
        Argument argout = OAWutils.factory.createArgument();
        Type arginType = OAWutils.tango2pogoType(this.arginComboBox.getSelectedItem().toString());
        Type argoutType = OAWutils.tango2pogoType(this.argoutComboBox.getSelectedItem().toString());
        argin.setType(arginType);
        argout.setType(argoutType);
        desc = Utils.strReplaceSpecialCharToCode(this.arginDescText.getText());
        argin.setDescription(desc);
        desc = Utils.strReplaceSpecialCharToCode(this.argoutDescText.getText());
        argout.setDescription(desc);
        cmd.setArgin(argin);
        cmd.setArgout(argout);
        if (this.levelBtn.getSelectedObjects() == null) {
            cmd.setDisplayLevel(PogoConst.strLevel[0]);
        } else {
            cmd.setDisplayLevel(PogoConst.strLevel[1]);
        }
        if (Utils.isTrue(this.orig_status.getInherited())) {
            if (this.overloadBtn.getSelectedObjects() != null) {
                this.orig_status.setConcrete("true");
                this.orig_status.setConcreteHere("true");
            } else {
                this.orig_status.setConcreteHere("false");
            }
        } else if (this.abstractBtn.getSelectedObjects() != null) {
            this.orig_status.setAbstract("true");
            this.orig_status.setConcrete("false");
            this.orig_status.setConcreteHere("false");
        } else {
            this.orig_status.setAbstract("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
        }
        cmd.setStatus(this.orig_status);
        if (this.polledBtn.getSelectedObjects() != null) {
            cmd.setPolledPeriod(this.polledTxt.getText());
        } else {
            cmd.setPolledPeriod("0");
        }
        return cmd;
    }

    public static Command cloneCommand(Command srcCmd) {
        Command newCmd = OAWutils.cloneCommand(srcCmd);
        InheritanceStatus inher_status = newCmd.getStatus();
        if (!Utils.isTrue(inher_status.getAbstract())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        if (Utils.isTrue(inher_status.getInherited())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        newCmd.setStatus(inher_status);
        return newCmd;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public static void popupSummary(JFrame parent, ArrayList<Command> vc) {
        ArrayList<ArrayList<String>> summary = CommandDialog.buildSummary(vc);
        String title = String.valueOf(Integer.toString(vc.size())) + "  Commands";
        PopupTable ppt = new PopupTable(parent, title, columnTitle, summary);
        int nb = vc.size();
        if (nb > 35) {
            nb = 35;
        }
        ppt.setPreferredSize(columnSize, nb);
        ppt.setVisible(true);
    }

    public static ArrayList<ArrayList<String>> buildSummary(ArrayList<Command> vc) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (Command command : vc) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(command.getName());
            line.add(OAWutils.pogo2tangoType(command.getArgin().getType().toString()));
            line.add(OAWutils.pogo2tangoType(command.getArgout().getType().toString()));
            if (Utils.isEquals(command.getDisplayLevel(), PogoConst.strLevel[1])) {
                line.add(PogoConst.strLevel[1]);
            } else {
                line.add(PogoConst.strLevel[0]);
            }
            InheritanceStatus status = command.getStatus();
            line.add(Utils.strBoolean(status.getInherited()));
            boolean concreate = Utils.isTrue(status.getConcrete()) || Utils.isTrue(status.getConcreteHere());
            line.add("" + !concreate);
            line.add(Utils.strReplace(command.getDescription(), "\\n", "\n"));
            result.add(line);
        }
        return result;
    }
}

