/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.OverlodedPollPeriodObject;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.AttributeDialog;
import org.tango.pogo.pogo_gui.ClassDialog;
import org.tango.pogo.pogo_gui.CommandDialog;
import org.tango.pogo.pogo_gui.DeletedObjects;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.RenamedObjects;
import org.tango.pogo.pogo_gui.StateDialog;
import org.tango.pogo.pogo_gui.StateMachineDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoEditor;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ClassTree
extends JTree
implements TangoConst,
PogoConst {
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private ClassTreePopupMenu menu;
    private PogoGUI parent;
    private static final Color background = Color.white;
    private static final Color dynamicBG = new Color(0xDDFFFF);
    private PogoDeviceClass pogo_class;
    private DeviceClass deviceClass;
    private DeletedObjects deleted_objects = new DeletedObjects();
    private RenamedObjects renamed_objects = new RenamedObjects();
    private InheritanceUtils inherit_utils;
    private boolean modified = false;
    private boolean isInheritedClass;
    private static Object copiedItem = null;
    private static final int EDIT_CLASS = 0;
    private static final int ADD_ITEM = 1;
    private static final int ADD_DYN_ITEM = 2;
    private static final int PASTE_ITEM = 3;
    private static final int SORT_ITEM = 4;
    private static final int SUMMARIZE = 5;
    private static final int EDIT_ITEM = 6;
    private static final int COPY_ITEM = 7;
    private static final int CLONE_ITEM = 8;
    private static final int REMOVE_ITEM = 9;
    private static final int EDIT_SRC_CODE = 10;
    private static final int OFFSET = 2;
    private static String[] menuLabels = new String[]{"Edit Class", "Add Item", "Add Dynamic Item", "Paste", "Sort Items", "Summarize", "Edit Item", "Copy", "Clone  Item", "Remove Item", "Edit Source Code"};

    public ClassTree(PogoGUI parent, DeviceClass deviceClass, boolean isInheritedClass) {
        this.parent = parent;
        this.deviceClass = deviceClass;
        this.isInheritedClass = isInheritedClass;
        this.pogo_class = deviceClass.getPogoDeviceClass();
        this.inherit_utils = InheritanceUtils.getInstance();
        this.buildTree();
        this.setBackground(background);
        this.menu = new ClassTreePopupMenu(this);
        this.expandChildren(this.root);
        this.setSelectionPath(null);
        if (deviceClass.getPogoDeviceClass().getDescription().getIdentification() == null) {
            Utils.getInstance().stopSplashRefresher();
            this.editClass();
        }
    }

    private void buildTree() {
        this.root = new DefaultMutableTreeNode(new PogoRoot(this.pogo_class));
        this.createCollectionClassNodes(this.pogo_class);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ClassTree.this.treeMouseClicked(evt);
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
                ClassTree.this.collapsedPerformed(e);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
            }
        });
    }

    public void collapsedPerformed(TreeExpansionEvent evt) {
        TreePath collapsePath = evt.getPath();
        int idx = collapsePath.getPathCount() - 1;
        DefaultMutableTreeNode colapsedNode = (DefaultMutableTreeNode)collapsePath.getPathComponent(idx);
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null || colapsedNode == null) {
            return;
        }
        if (colapsedNode != selectedNode) {
            return;
        }
        if (selectedNode.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)selectedNode.getChildAt(0);
            Object[] child_path = child.getPath();
            this.setExpandedState(new TreePath(child_path), true);
        }
    }

    public void expandedPerfomed(TreeExpansionEvent evt) {
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            this.setSelectionPath(null);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        if (evt.getClickCount() == 2 && (mask & 0x10) != 0) {
            if (!(o instanceof PogoCollection)) {
                this.editItem();
            } else if (node != this.root) {
                this.addItem(node, false);
            }
        } else if ((mask & 4) != 0) {
            if (node == this.root) {
                this.menu.showMenu(evt, (PogoRoot)node.getUserObject());
            } else if (o instanceof PogoCollection) {
                this.menu.showMenu(evt, (PogoCollection)o);
            } else {
                DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
                this.menu.showMenu(evt, o, parent_node.toString());
            }
        }
    }

    private void createCollectionClassNodes(PogoDeviceClass pogoClass) {
        DefaultMutableTreeNode node;
        PogoAttribute pa;
        DefaultMutableTreeNode node2;
        EList<Property> classprops = pogoClass.getClassProperties();
        EList<Property> devprops = pogoClass.getDeviceProperties();
        EList<Command> commands = pogoClass.getCommands();
        EList<Attribute> attributes = pogoClass.getAttributes();
        EList<Attribute> dynAttrib = pogoClass.getDynamicAttributes();
        EList<State> states = pogoClass.getStates();
        if (commands.size() == 0) {
            Command[] cmd = OAWutils.createStateStatusCommand();
            commands.add(cmd[0]);
            commands.add(cmd[1]);
        }
        Utils utils = Utils.getInstance();
        DefaultMutableTreeNode classprop_node = new DefaultMutableTreeNode(new PogoCollection("Class Properties", utils.classprop_icon));
        DefaultMutableTreeNode devprop_node = new DefaultMutableTreeNode(new PogoCollection("Device Properties", utils.devprop_icon));
        DefaultMutableTreeNode cmd_node = new DefaultMutableTreeNode(new PogoCollection("Commands", utils.cmd_icon));
        DefaultMutableTreeNode scalar_node = new DefaultMutableTreeNode(new PogoCollection("Scalar Attributes", utils.scalar_icon));
        DefaultMutableTreeNode spectrum_node = new DefaultMutableTreeNode(new PogoCollection("Spectrum Attributes", utils.spectrum_icon));
        DefaultMutableTreeNode image_node = new DefaultMutableTreeNode(new PogoCollection("Image Attributes", utils.image_icon));
        DefaultMutableTreeNode states_node = new DefaultMutableTreeNode(new PogoCollection("States", utils.state_icon));
        for (Property prop : classprops) {
            node2 = new DefaultMutableTreeNode(new PogoProperty(prop, false));
            classprop_node.add(node2);
        }
        for (Property prop : devprops) {
            node2 = new DefaultMutableTreeNode(new PogoProperty(prop, true));
            devprop_node.add(node2);
        }
        for (Command cmd : commands) {
            node2 = new DefaultMutableTreeNode(new PogoCommand(cmd));
            cmd_node.add(node2);
        }
        for (State state : states) {
            node2 = new DefaultMutableTreeNode(new PogoState(state));
            states_node.add(node2);
        }
        for (Attribute att : attributes) {
            pa = new PogoAttribute(att);
            node = new DefaultMutableTreeNode(pa);
            switch (pa.attType) {
                case 3: {
                    scalar_node.add(node);
                    break;
                }
                case 4: {
                    spectrum_node.add(node);
                    break;
                }
                case 5: {
                    image_node.add(node);
                }
            }
        }
        for (Attribute att : dynAttrib) {
            pa = new PogoAttribute(att);
            node = new DefaultMutableTreeNode(pa);
            switch (pa.attType) {
                case 3: {
                    scalar_node.add(node);
                    break;
                }
                case 4: {
                    spectrum_node.add(node);
                    break;
                }
                case 5: {
                    image_node.add(node);
                }
            }
        }
        this.root.add(classprop_node);
        this.root.add(devprop_node);
        this.root.add(cmd_node);
        this.root.add(scalar_node);
        this.root.add(spectrum_node);
        this.root.add(image_node);
        this.root.add(states_node);
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    Object getSelectedEditableObject() {
        Object selection = this.getSelectedObject();
        if (selection instanceof PogoProperty) {
            return ((PogoProperty)selection).value;
        }
        if (selection instanceof PogoCommand) {
            Command cmd = ((PogoCommand)selection).value;
            if (cmd.getName().equals("State") || cmd.getName().equals("Status")) {
                return null;
            }
            return cmd;
        }
        if (selection instanceof PogoAttribute) {
            return ((PogoAttribute)selection).value;
        }
        if (selection instanceof PogoState) {
            return ((PogoState)selection).value;
        }
        return null;
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        int i = 0;
        while (i < node.getChildCount()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (!level_done) {
                    this.expandNode(child);
                    level_done = true;
                }
            } else {
                this.expandChildren(child);
            }
            ++i;
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        v.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            v.add(0, node);
        }
        Object[] tn = new DefaultMutableTreeNode[v.size()];
        int i = 0;
        while (i < v.size()) {
            tn[i] = (TreeNode)v.get(i);
            ++i;
        }
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private String[] nameAndCollecObject(Object object) {
        String name = "Unknown name";
        String item = "Unknown Item";
        if (object instanceof PogoProperty) {
            name = ((PogoProperty)object).value.getName();
            item = "Property";
        } else if (object instanceof PogoCommand) {
            name = ((PogoCommand)object).value.getName();
            item = "Command";
        } else if (object instanceof PogoAttribute) {
            name = ((PogoAttribute)object).value.getName();
            item = "Attribute";
        } else if (object instanceof PogoState) {
            name = ((PogoState)object).value.getName();
            item = "State";
        }
        return new String[]{name, item};
    }

    public void setSrcPath(String path) {
        PogoRoot pg_root = (PogoRoot)this.root.getUserObject();
        pg_root.path = path;
    }

    private void editSourceCode() {
        Object selection = this.getSelectedObject();
        if (selection == null) {
            return;
        }
        try {
            PogoRoot pg_root = (PogoRoot)this.root.getUserObject();
            String[] data = new String[]{pg_root.name, pg_root.path, pg_root.language};
            if (pg_root.path == null) {
                Except.throw_exception("NOT_GENERATED", "Source files not generated !", "ClassTree.editSourceCode()");
            }
            if (selection instanceof PogoProperty) {
                Property prop = ((PogoProperty)selection).value;
                boolean is_dev = ((PogoProperty)selection).is_dev;
                PogoEditor.getInstance().editFile(data, prop, is_dev);
            } else if (selection instanceof PogoCommand) {
                Command cmd = ((PogoCommand)selection).value;
                PogoEditor.getInstance().editFile(data, cmd);
            } else if (selection instanceof PogoAttribute) {
                Attribute attribute = ((PogoAttribute)selection).value;
                PogoEditor.getInstance().editFile(data, attribute);
            } else if (selection instanceof PogoState) {
                State state = ((PogoState)selection).value;
                PogoEditor.getInstance().editFile(data, state);
            }
        }
        catch (IOException e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    void removeSelectedItem() {
        this.removeSelectedItem(true, true);
    }

    void removeSelectedItem(boolean askConfirm, boolean setModif) {
        Object selection = this.getSelectedObject();
        if (selection == null) {
            return;
        }
        String[] naco = this.nameAndCollecObject(selection);
        if (!askConfirm || JOptionPane.showConfirmDialog(this, "Remove  \"" + naco[0] + "\"  " + naco[1] + " ?", "Confirmation Window", 0) == 0) {
            if (selection instanceof PogoProperty) {
                Property prop = ((PogoProperty)selection).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, prop)) {
                    return;
                }
                EList<Property> properties = ((PogoProperty)selection).is_dev ? this.pogo_class.getDeviceProperties() : this.pogo_class.getClassProperties();
                int idx = Utils.getPropertyIndex(properties, prop);
                if (idx >= 0) {
                    properties.remove(idx);
                }
            } else if (selection instanceof PogoCommand) {
                Command cmd = ((PogoCommand)selection).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, cmd)) {
                    return;
                }
                EList<Command> commands = this.pogo_class.getCommands();
                int idx = Utils.getCommandIndex(commands, cmd);
                if (idx >= 0) {
                    commands.remove(idx);
                }
                this.deleted_objects.add(cmd);
            } else if (selection instanceof PogoAttribute) {
                Attribute att = ((PogoAttribute)selection).value;
                if (!InheritanceUtils.isRemovable((JFrame)this.parent, att)) {
                    return;
                }
                EList<Attribute> attributes = this.pogo_class.getAttributes();
                int idx = Utils.getAttributeIndex(attributes, att);
                if (idx >= 0) {
                    attributes.remove(idx);
                }
                this.deleted_objects.add(att);
            } else if (selection instanceof PogoState) {
                State state = ((PogoState)selection).value;
                EList<State> states = this.pogo_class.getStates();
                int idx = Utils.getStateIndex(states, state);
                if (idx >= 0) {
                    states.remove(idx);
                }
            }
            DefaultMutableTreeNode node = this.getSelectedNode();
            this.treeModel.removeNodeFromParent(node);
            if (setModif) {
                this.setModified(true);
            }
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
    }

    void moveSelectedItem(boolean to_up) {
        Object selection = this.getSelectedObject();
        if (selection == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getSelectedNode();
        DefaultMutableTreeNode parent_node = (DefaultMutableTreeNode)node.getParent();
        int pos = 0;
        int i = 0;
        while (i < parent_node.getChildCount()) {
            if (parent_node.getChildAt(i).equals(node)) {
                pos = i;
            }
            ++i;
        }
        int pos_min = 0;
        int pos_max = parent_node.getChildCount() - 1;
        if (selection instanceof PogoCommand) {
            pos_min = 2;
        }
        if (to_up) {
            if (pos > pos_min) {
                this.treeModel.removeNodeFromParent(node);
                this.treeModel.insertNodeInto(node, parent_node, pos - 1);
            }
        } else if (pos < pos_max) {
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.insertNodeInto(node, parent_node, pos + 1);
        }
        this.setSelectionNode(node);
    }

    private void sortItems() {
        ArrayList<DefaultMutableTreeNode> v = new ArrayList<DefaultMutableTreeNode>();
        DefaultMutableTreeNode parent_node = this.getSelectedNode();
        int i = 0;
        while (i < parent_node.getChildCount()) {
            v.add((DefaultMutableTreeNode)parent_node.getChildAt(i));
            ++i;
        }
        Collections.sort(v, new NodeComparator());
        while (parent_node.getChildCount() > 0) {
            this.treeModel.removeNodeFromParent((DefaultMutableTreeNode)parent_node.getChildAt(0));
        }
        i = 0;
        while (i < v.size()) {
            this.treeModel.insertNodeInto((MutableTreeNode)v.get(i), parent_node, i);
            ++i;
        }
        this.expandChildren(parent_node);
    }

    private void setSelectionNode(DefaultMutableTreeNode node) {
        Object[] path = node.getPath();
        this.setSelectionPath(new TreePath(path));
    }

    private void editClass() {
        ClassDialog dialog = new ClassDialog(this.parent, this, this.deviceClass, this.isInheritedClass);
        if (dialog.showDialog() == 0) {
            this.deviceClass = dialog.getInputs();
            this.root.setUserObject(new PogoRoot(this.deviceClass.getPogoDeviceClass()));
            if (!dialog.hasForcedToGenerate()) {
                this.setModified(true);
            }
            this.repaint();
        }
    }

    private void copyItem() {
        copiedItem = this.getSelectedObject();
    }

    private void pasteItem() {
        if (copiedItem == null) {
            return;
        }
        DefaultMutableTreeNode newNode = null;
        DefaultMutableTreeNode collecNode = this.getSelectedNode();
        try {
            if (copiedItem instanceof PogoProperty) {
                String target;
                boolean is_dev = collecNode == this.root.getChildAt(1);
                String string = target = is_dev ? "Device " : "Class ";
                if (this.propertyAlreadyExists(copiedItem.toString(), is_dev)) {
                    Except.throw_exception("ALREADY_EXITS", String.valueOf(target) + "Property " + copiedItem + " already exists", "ClassTree.pasteItem()");
                }
                PogoProperty pp = (PogoProperty)copiedItem;
                Property src = PropertyDialog.cloneProperty(pp.value);
                newNode = new DefaultMutableTreeNode(new PogoProperty(src, is_dev));
            } else if (copiedItem instanceof PogoCommand) {
                if (this.itemAlreadyExists(copiedItem.toString(), 2)) {
                    Except.throw_exception("ALREADY_EXITS", "Command " + copiedItem + " already exists", "ClassTree.pasteItem()");
                }
                PogoCommand pc = (PogoCommand)copiedItem;
                Command src = CommandDialog.cloneCommand(pc.value);
                newNode = new DefaultMutableTreeNode(new PogoCommand(src));
            } else if (copiedItem instanceof PogoAttribute) {
                if (this.itemAlreadyExists(copiedItem.toString(), 3)) {
                    Except.throw_exception("ALREADY_EXITS", "Attribute " + copiedItem + " already exists", "ClassTree.pasteItem()");
                }
                PogoAttribute pa = (PogoAttribute)copiedItem;
                Attribute src = AttributeDialog.cloneAttribute(pa.value);
                newNode = new DefaultMutableTreeNode(new PogoAttribute(src));
                collecNode = pa.attType == 3 ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (pa.attType == 4 ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
            } else if (copiedItem instanceof PogoState) {
                if (this.itemAlreadyExists(copiedItem.toString(), 2)) {
                    Except.throw_exception("ALREADY_EXITS", "State " + copiedItem + " already exists", "ClassTree.pasteItem()");
                }
                PogoState ps = (PogoState)copiedItem;
                State src = StateDialog.cloneState(ps.value);
                newNode = new DefaultMutableTreeNode(new PogoState(src));
            }
            if (newNode != null) {
                this.treeModel.insertNodeInto(newNode, collecNode, collecNode.getChildCount());
                this.setSelectionNode(newNode);
                this.setModified(true);
                this.editItem();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
        }
    }

    private boolean canPaste() {
        if (copiedItem == null) {
            return false;
        }
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (copiedItem instanceof PogoProperty) {
            if (selectedNode == this.root.getChildAt(1)) {
                return true;
            }
            if (selectedNode == this.root.getChildAt(0)) {
                return true;
            }
        } else if (copiedItem instanceof PogoCommand) {
            if (selectedNode == this.root.getChildAt(2)) {
                return true;
            }
        } else if (copiedItem instanceof PogoAttribute) {
            if (selectedNode == this.root.getChildAt(3)) {
                return true;
            }
            if (selectedNode == this.root.getChildAt(4)) {
                return true;
            }
            if (selectedNode == this.root.getChildAt(5)) {
                return true;
            }
        } else if (copiedItem instanceof PogoState && selectedNode == this.root.getChildAt(6)) {
            return true;
        }
        return false;
    }

    private void cloneItem() {
        DefaultMutableTreeNode newNode = null;
        DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.getSelectedNode().getParent();
        Object obj = this.getSelectedObject();
        if (obj instanceof PogoProperty) {
            Property srcProp = ((PogoProperty)obj).value;
            Property newProp = PropertyDialog.cloneProperty(srcProp);
            boolean is_dev = ((PogoProperty)obj).is_dev;
            if (is_dev) {
                this.pogo_class.getDeviceProperties().add(newProp);
            } else {
                this.pogo_class.getClassProperties().add(newProp);
            }
            newNode = new DefaultMutableTreeNode(new PogoProperty(newProp, is_dev));
        } else if (obj instanceof PogoCommand) {
            Command srcCmd = ((PogoCommand)obj).value;
            Command newCmd = CommandDialog.cloneCommand(srcCmd);
            this.pogo_class.getCommands().add(newCmd);
            newNode = new DefaultMutableTreeNode(new PogoCommand(newCmd));
        } else if (obj instanceof PogoAttribute) {
            Attribute srcAttribute = ((PogoAttribute)obj).value;
            Attribute newAttribute = AttributeDialog.cloneAttribute(srcAttribute);
            this.pogo_class.getAttributes().add(newAttribute);
            newNode = new DefaultMutableTreeNode(new PogoAttribute(newAttribute));
        } else if (obj instanceof PogoState) {
            State srcState = ((PogoState)obj).value;
            State newState = StateDialog.cloneState(srcState);
            this.pogo_class.getStates().add(newState);
            newNode = new DefaultMutableTreeNode(new PogoState(newState));
        }
        if (newNode != null) {
            boolean editOk;
            this.treeModel.insertNodeInto(newNode, collecNode, collecNode.getChildCount());
            this.setSelectionNode(newNode);
            boolean bl = editOk = this.editItem() == 0;
            if (editOk) {
                this.setModified(true);
            } else {
                this.removeSelectedItem(false, false);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int editItem() {
        Object obj = this.getSelectedObject();
        if (obj instanceof PogoRoot) {
            this.editClass();
        } else if (obj instanceof PogoState) {
            State state = ((PogoState)obj).value;
            StateDialog dlg = new StateDialog(this.parent, state);
            if (dlg.showDialog() != 0) return 2;
            EList<State> states = this.pogo_class.getStates();
            int idx = Utils.getStateIndex(states, state);
            state = dlg.getState();
            if (idx >= 0) {
                states.remove(idx);
                states.add(idx, state);
            } else {
                states.add(state);
            }
            this.getSelectedNode().setUserObject(new PogoState(state));
            this.setModified(true);
        } else if (obj instanceof PogoProperty) {
            Property property = ((PogoProperty)obj).value;
            boolean is_dev = ((PogoProperty)obj).is_dev;
            PropertyDialog dlg = new PropertyDialog(this.parent, property, is_dev);
            if (dlg.showDialog() != 0) return 2;
            EList<Property> properties = ((PogoProperty)obj).is_dev ? this.pogo_class.getDeviceProperties() : this.pogo_class.getClassProperties();
            int idx = Utils.getPropertyIndex(properties, property);
            property = dlg.getProperty();
            if (idx >= 0) {
                properties.remove(idx);
                properties.add(idx, property);
            } else {
                properties.add(property);
            }
            this.getSelectedNode().setUserObject(new PogoProperty(property, is_dev));
            this.setModified(true);
        } else if (obj instanceof PogoCommand) {
            Command cmd = ((PogoCommand)obj).value;
            String name = cmd.getName();
            CommandDialog dlg = new CommandDialog(this.parent, cmd);
            if (dlg.showDialog() != 0) return 2;
            EList<Command> commands = this.pogo_class.getCommands();
            int idx = Utils.getCommandIndex(commands, cmd);
            Command new_cmd = dlg.getCommand();
            if (idx >= 0) {
                commands.remove(idx);
                commands.add(idx, new_cmd);
            } else {
                commands.add(new_cmd);
            }
            this.getSelectedNode().setUserObject(new PogoCommand(new_cmd));
            this.setModified(true);
            new_cmd.getStatus().setHasChanged("false");
            String new_name = new_cmd.getName();
            if (!name.equals(new_name)) {
                this.renamed_objects.add(cmd, new_cmd);
            }
        } else if (obj instanceof PogoAttribute) {
            Attribute attribute = ((PogoAttribute)obj).value;
            String name = attribute.getName();
            AttributeDialog dlg = new AttributeDialog(this.parent, attribute);
            String attTypeOrg = attribute.getAttType();
            if (dlg.showDialog() != 0) return 2;
            Attribute new_attribute = dlg.getAttribute();
            String attType = new_attribute.getAttType();
            if (attType.equals(attTypeOrg)) {
                ((PogoAttribute)obj).value = new_attribute;
            } else {
                DefaultMutableTreeNode node = this.getSelectedNode();
                this.treeModel.removeNodeFromParent(node);
                PogoAttribute pa = new PogoAttribute(new_attribute);
                node = new DefaultMutableTreeNode(pa);
                DefaultMutableTreeNode collecNode = attType.equals("Scalar") ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (attType.equals("Spectrum") ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
                this.treeModel.insertNodeInto(node, collecNode, collecNode.getChildCount());
            }
            this.setModified(true);
            new_attribute.getStatus().setHasChanged("false");
            String new_name = new_attribute.getName();
            if (!name.equals(new_name)) {
                this.renamed_objects.add(attribute, new_attribute);
            }
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
        return 0;
    }

    private boolean checkIfAbstractClass() {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            switch (i) {
                case 2: {
                    DefaultMutableTreeNode node;
                    int j = 0;
                    while (j < collecNode.getChildCount()) {
                        node = (DefaultMutableTreeNode)collecNode.getChildAt(j);
                        Command cmd = ((PogoCommand)node.getUserObject()).value;
                        if (!Utils.isTrue(cmd.getStatus().getConcrete()) && !Utils.isTrue(cmd.getStatus().getConcreteHere())) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    DefaultMutableTreeNode node;
                    int j = 0;
                    while (j < collecNode.getChildCount()) {
                        node = (DefaultMutableTreeNode)collecNode.getChildAt(j);
                        Attribute att = ((PogoAttribute)node.getUserObject()).value;
                        if (!Utils.isTrue(att.getStatus().getConcrete()) && !Utils.isTrue(att.getStatus().getConcreteHere())) {
                            return true;
                        }
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        return false;
    }

    void addItem(String itemClass) {
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            switch (i) {
                case 0: {
                    if (itemClass.toLowerCase().indexOf("class prop") <= 0) break;
                    this.addItem(collecNode, false);
                    break;
                }
                case 1: {
                    if (itemClass.toLowerCase().indexOf("device prop") <= 0) break;
                    this.addItem(collecNode, false);
                    break;
                }
                case 2: {
                    if (itemClass.toLowerCase().indexOf("command") <= 0) break;
                    this.addItem(collecNode, false);
                    break;
                }
                case 6: {
                    if (itemClass.toLowerCase().indexOf("state") <= 0) break;
                    this.addItem(false);
                    break;
                }
                case 3: {
                    if (itemClass.toLowerCase().indexOf("scalar") <= 0) break;
                    this.addItem(collecNode, false);
                    break;
                }
                case 4: {
                    if (itemClass.toLowerCase().indexOf("spectrum") <= 0) break;
                    this.addItem(collecNode, false);
                    break;
                }
                case 5: {
                    if (itemClass.toLowerCase().indexOf("image") <= 0) break;
                    this.addItem(collecNode, false);
                }
            }
            ++i;
        }
    }

    private void addItem(boolean isDynamic) {
        this.addItem(this.getSelectedNode(), isDynamic);
    }

    private void addItem(DefaultMutableTreeNode collecNode, boolean isDynamic) {
        int attType;
        AttributeDialog dlg;
        DefaultMutableTreeNode new_node = null;
        if (collecNode.toString().equals("Commands")) {
            CommandDialog dlg2 = new CommandDialog(this.parent, null);
            if (dlg2.showDialog() == 0) {
                Command cmd = dlg2.getCommand();
                this.pogo_class.getCommands().add(cmd);
                new_node = new DefaultMutableTreeNode(new PogoCommand(cmd));
                this.treeModel.insertNodeInto(new_node, collecNode, collecNode.getChildCount());
                this.setModified(true);
            }
        } else if (collecNode.toString().indexOf("Properties") > 0) {
            boolean is_dev = collecNode.toString().indexOf("Device") == 0;
            PropertyDialog dlg3 = new PropertyDialog(this.parent, null, is_dev);
            if (dlg3.showDialog() == 0) {
                Property prop = dlg3.getProperty();
                if (is_dev) {
                    this.pogo_class.getDeviceProperties().add(prop);
                } else {
                    this.pogo_class.getClassProperties().add(prop);
                }
                new_node = new DefaultMutableTreeNode(new PogoProperty(prop, is_dev));
                this.treeModel.insertNodeInto(new_node, collecNode, collecNode.getChildCount());
                this.setModified(true);
            }
        } else if (collecNode.toString().equals("States")) {
            StateDialog dlg4 = new StateDialog(this.parent, null);
            if (dlg4.showDialog() == 0) {
                State state = dlg4.getState();
                this.pogo_class.getStates().add(state);
                new_node = new DefaultMutableTreeNode(new PogoState(state));
                this.treeModel.insertNodeInto(new_node, collecNode, collecNode.getChildCount());
                this.setModified(true);
            }
        } else if (collecNode.toString().indexOf("Attribute") > 0 && (dlg = new AttributeDialog(this.parent, attType = collecNode.toString().startsWith("Scalar") ? 0 : (collecNode.toString().startsWith("Spectrum") ? 1 : 2), isDynamic)).showDialog() == 0) {
            Attribute att = dlg.getAttribute();
            this.pogo_class.getAttributes().add(att);
            new_node = new DefaultMutableTreeNode(new PogoAttribute(att));
            String strType = att.getAttType();
            collecNode = strType.equals("Scalar") ? (DefaultMutableTreeNode)this.root.getChildAt(3) : (strType.equals("Spectrum") ? (DefaultMutableTreeNode)this.root.getChildAt(4) : (DefaultMutableTreeNode)this.root.getChildAt(5));
            this.treeModel.insertNodeInto(new_node, collecNode, collecNode.getChildCount());
            this.setModified(true);
        }
        if (new_node != null) {
            this.expandNode(new_node);
        }
        ((PogoRoot)this.root.getUserObject()).isAbstract = this.checkIfAbstractClass();
        this.repaint();
    }

    DeletedObjects getDeletedObjects() {
        return this.deleted_objects;
    }

    RenamedObjects getRenamedObjects() {
        return this.renamed_objects;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setModified(boolean b2) {
        this.modified = b2;
        this.parent.fireClassHaveChanged();
    }

    DeviceClass getDeviceClass() {
        DeviceClass devclass = new DeviceClass();
        devclass.setAncestors(this.deviceClass.getAncestors());
        PogoDeviceClass pg_class = devclass.getPogoDeviceClass();
        PogoRoot pg_root = (PogoRoot)this.root.getUserObject();
        if (pg_root.id == null) {
            this.editClass();
            pg_root = (PogoRoot)this.root.getUserObject();
            if (pg_root.id == null) {
                return null;
            }
        }
        pg_class.setName(pg_root.name);
        pg_class.getDescription().setDescription(pg_root.description);
        pg_class.getDescription().setTitle(pg_root.title);
        pg_class.getDescription().setSourcePath(pg_root.path);
        pg_class.getDescription().setIdentification(OAWutils.cloneClassIdentification(pg_root.id));
        pg_class.getDescription().setLanguage(pg_root.language);
        EList<Inheritance> inheritances = pg_class.getDescription().getInheritances();
        inheritances.clear();
        for (Inheritance inheritance : pg_root.inheritances) {
            Inheritance inher = OAWutils.factory.createInheritance();
            inher.setClassname(inheritance.getClassname());
            inher.setSourcePath(inheritance.getSourcePath());
            inheritances.add(inher);
        }
        EList<Property> classprop = pg_class.getClassProperties();
        EList<Property> devprop = pg_class.getDeviceProperties();
        EList<Command> commands = pg_class.getCommands();
        EList<Attribute> attributes = pg_class.getAttributes();
        EList<Attribute> dynAttrib = pg_class.getDynamicAttributes();
        EList<State> states = pg_class.getStates();
        int i = 0;
        while (i < this.root.getChildCount()) {
            DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(i);
            switch (i) {
                case 0: {
                    this.setPropertyToPogoDeviceClass(classprop, collecNode);
                    break;
                }
                case 1: {
                    this.setPropertyToPogoDeviceClass(devprop, collecNode);
                    break;
                }
                case 2: {
                    this.setCommandsToPogoDeviceClass(commands, collecNode);
                    break;
                }
                case 6: {
                    this.setStateToPogoDeviceClass(states, collecNode);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.setAttributeToPogoDeviceClass(attributes, dynAttrib, collecNode);
                }
            }
            ++i;
        }
        DeviceClass.checkIfAbstractClass(pg_class, true);
        EList<AdditionalFile> newFileList = pg_class.getAdditionalFiles();
        EList<AdditionalFile> orgFileList = this.deviceClass.getPogoDeviceClass().getAdditionalFiles();
        for (AdditionalFile file : orgFileList) {
            newFileList.add(OAWutils.cloneAdditionalFile(file));
        }
        this.checkForPollingPeriodOverloaded(devclass.getPogoDeviceClass());
        return devclass;
    }

    private void checkForPollingPeriodOverloaded(PogoDeviceClass pogoDeviceClass) {
        ArrayList<DeviceClass> ancestors = this.deviceClass.getAncestors();
        if (ancestors.size() == 0) {
            return;
        }
        EList<OverlodedPollPeriodObject> newPollPeriods = pogoDeviceClass.getOverlodedPollPeriodObject();
        EList<Attribute> attributes = this.pogo_class.getAttributes();
        for (Attribute attribute : attributes) {
            for (DeviceClass ancestor : ancestors) {
                EList<Attribute> ancestorAttributes = ancestor.getPogoDeviceClass().getAttributes();
                for (Attribute ancestorAttribute : ancestorAttributes) {
                    if (ancestorAttribute.getPolledPeriod() == null) {
                        ancestorAttribute.setPolledPeriod("0");
                    }
                    if (!ancestorAttribute.getName().equals(attribute.getName()) || attribute.getPolledPeriod().equals(ancestorAttribute.getPolledPeriod())) continue;
                    OverlodedPollPeriodObject pollPeriodObject = OAWutils.factory.createOverlodedPollPeriodObject();
                    pollPeriodObject.setName(attribute.getName());
                    pollPeriodObject.setType("attribute");
                    pollPeriodObject.setPollPeriod(attribute.getPolledPeriod());
                    newPollPeriods.add(pollPeriodObject);
                }
            }
        }
        EList<Command> commands = this.pogo_class.getCommands();
        for (Command command : commands) {
            for (DeviceClass ancestor : ancestors) {
                EList<Command> ancestorCommands = ancestor.getPogoDeviceClass().getCommands();
                for (Command ancestorCommand : ancestorCommands) {
                    if (ancestorCommand.getPolledPeriod() == null) {
                        ancestorCommand.setPolledPeriod("0");
                    }
                    if (!ancestorCommand.getName().equals(command.getName()) || command.getPolledPeriod().equals(ancestorCommand.getPolledPeriod())) continue;
                    OverlodedPollPeriodObject pollPeriodObject = OAWutils.factory.createOverlodedPollPeriodObject();
                    pollPeriodObject.setName(command.getName());
                    pollPeriodObject.setType("command");
                    pollPeriodObject.setPollPeriod(command.getPolledPeriod());
                    newPollPeriods.add(pollPeriodObject);
                }
            }
        }
    }

    private DefaultMutableTreeNode getCollectionNode(int collecNum) {
        return (DefaultMutableTreeNode)this.root.getChildAt(collecNum);
    }

    private void setPropertyToPogoDeviceClass(EList<Property> properties, DefaultMutableTreeNode collecNode) {
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            Property prop = ((PogoProperty)node.getUserObject()).value;
            properties.add(OAWutils.cloneProperty(prop));
            ++i;
        }
    }

    private void setCommandsToPogoDeviceClass(EList<Command> commands, DefaultMutableTreeNode collecNode) {
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            Command command = ((PogoCommand)node.getUserObject()).value;
            command.setExecMethod(Utils.buildExcecMethodName(command.getName()));
            if (command.getPolledPeriod() == null || command.getPolledPeriod().length() == 0) {
                command.setPolledPeriod("0");
            }
            commands.add(OAWutils.cloneCommand(command));
            ++i;
        }
    }

    private void setAttributeToPogoDeviceClass(EList<Attribute> attributes, EList<Attribute> dynAttrib, DefaultMutableTreeNode collecNode) {
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            Attribute attribute = ((PogoAttribute)node.getUserObject()).value;
            if (attribute.getPolledPeriod() == null || attribute.getPolledPeriod().length() == 0) {
                attribute.setPolledPeriod("0");
            }
            if (Utils.isTrue(attribute.getIsDynamic())) {
                dynAttrib.add(OAWutils.cloneAttribute(attribute));
            } else {
                attributes.add(OAWutils.cloneAttribute(attribute));
            }
            ++i;
        }
    }

    private void setStateToPogoDeviceClass(EList<State> states, DefaultMutableTreeNode collecNode) {
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            State state = ((PogoState)node.getUserObject()).value;
            states.add(OAWutils.cloneState(state));
            ++i;
        }
    }

    boolean itemAlreadyExists(String name, int type) {
        ArrayList<Integer> collec = new ArrayList<Integer>();
        if (type == 2) {
            collec.add(2);
        } else if (type == 3 || type == 4 || type == 5) {
            collec.add(3);
            collec.add(4);
            collec.add(5);
        } else if (type == 6) {
            collec.add(6);
        }
        if (collec.size() == 0) {
            return false;
        }
        Iterator iterator = collec.iterator();
        while (iterator.hasNext()) {
            int col = (Integer)iterator.next();
            DefaultMutableTreeNode selectedNode = this.getSelectedNode();
            DefaultMutableTreeNode collecNode = this.getCollectionNode(col);
            int i = 0;
            while (i < collecNode.getChildCount()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
                if (node.toString().equals(name) && node != selectedNode) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    boolean propertyAlreadyExists(String name, boolean is_dev) {
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        DefaultMutableTreeNode collecNode = is_dev ? this.getCollectionNode(1) : this.getCollectionNode(0);
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            if (node.toString().equals(name) && node != selectedNode) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void editStateMachine() {
        try {
            ArrayList<State> vs = this.getAllStates();
            ArrayList<Attribute> va = this.getAllAttributes();
            ArrayList<Command> vc = this.getAllCommands();
            if (vs.size() == 0) {
                throw new Exception("Thre is no states defined !");
            }
            if (vc.size() == 0 && va.size() == 0) {
                throw new Exception("Thre is no commands and no attributes defined !");
            }
        }
        catch (Exception e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        StateMachineDialog dialog = new StateMachineDialog(this.parent, this.pogo_class);
        if (dialog.showDialog() == 0) {
            this.pogo_class = dialog.getPogoClass();
            this.setModified(true);
        }
    }

    private void summarize() {
        Object obj = this.getSelectedObject();
        if (obj instanceof PogoRoot) {
            JOptionPane.showMessageDialog(this.parent, this.summarizeClass((PogoRoot)obj), "information Window", 1);
        } else if (obj.toString().indexOf("Properties") > 0) {
            boolean is_dev = obj.toString().startsWith("Device");
            ArrayList<Property> vp = this.getAllProperties(is_dev);
            PropertyDialog.popupSummary(this.parent, vp, is_dev);
        } else if (obj.toString().equals("Commands")) {
            ArrayList<Command> vc = this.getAllCommands();
            CommandDialog.popupSummary(this.parent, vc);
        } else if (obj.toString().indexOf("Attributes") > 0) {
            ArrayList<Attribute> va = this.getAllAttributes();
            AttributeDialog.popupSummary(this.parent, va);
        } else if (obj.toString().equals("States")) {
            ArrayList<State> vs = this.getAllStates();
            StateDialog.popupSummary(this.parent, vs);
        }
    }

    private String summarizeClass(PogoRoot _class) {
        int nb_att;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.root.getChildAt(0);
        int nb_class_prop = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(1);
        int nb_dev_prop = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(2);
        int nb_cmd = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(3);
        int nb_scalars = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(4);
        int nb_spectra = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(5);
        int nb_images = node.getChildCount();
        node = (DefaultMutableTreeNode)this.root.getChildAt(6);
        int nb_states = node.getChildCount();
        StringBuilder sb = new StringBuilder(_class.toInfoString());
        sb.append("\n\n");
        if (nb_class_prop > 0) {
            sb.append(nb_class_prop).append("  Class properties\n");
        }
        if (nb_dev_prop > 0) {
            sb.append(nb_dev_prop).append("  Device properties\n");
        }
        if (nb_cmd > 0) {
            sb.append(nb_cmd).append("  Commands\n");
        }
        if ((nb_att = nb_scalars + nb_spectra + nb_images) > 0) {
            sb.append(nb_att).append("  Attributes:\n");
            if (nb_scalars > 0) {
                sb.append("    ").append(nb_scalars).append("  Scalars\n");
            }
            if (nb_spectra > 0) {
                sb.append("    ").append(nb_spectra).append("  Spectrums\n");
            }
            if (nb_images > 0) {
                sb.append("    ").append(nb_images).append("  Images\n");
            }
        }
        if (nb_states > 0) {
            sb.append(nb_states).append("  States\n");
        }
        return sb.toString();
    }

    private ArrayList<Property> getAllProperties(boolean is_dev) {
        ArrayList<Property> vp = new ArrayList<Property>();
        DefaultMutableTreeNode collecNode = is_dev ? (DefaultMutableTreeNode)this.root.getChildAt(1) : (DefaultMutableTreeNode)this.root.getChildAt(0);
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            PogoProperty pp = (PogoProperty)node.getUserObject();
            vp.add(pp.value);
            ++i;
        }
        return vp;
    }

    private ArrayList<Command> getAllCommands() {
        ArrayList<Command> vc = new ArrayList<Command>();
        DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(2);
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            PogoCommand pc = (PogoCommand)node.getUserObject();
            vc.add(pc.value);
            ++i;
        }
        return vc;
    }

    private ArrayList<Attribute> getAllAttributes() {
        PogoAttribute pa;
        DefaultMutableTreeNode node;
        ArrayList<Attribute> va = new ArrayList<Attribute>();
        DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(3);
        int i = 0;
        while (i < collecNode.getChildCount()) {
            node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            pa = (PogoAttribute)node.getUserObject();
            va.add(pa.value);
            ++i;
        }
        collecNode = (DefaultMutableTreeNode)this.root.getChildAt(4);
        i = 0;
        while (i < collecNode.getChildCount()) {
            node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            pa = (PogoAttribute)node.getUserObject();
            va.add(pa.value);
            ++i;
        }
        collecNode = (DefaultMutableTreeNode)this.root.getChildAt(5);
        i = 0;
        while (i < collecNode.getChildCount()) {
            node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            pa = (PogoAttribute)node.getUserObject();
            va.add(pa.value);
            ++i;
        }
        return va;
    }

    private ArrayList<State> getAllStates() {
        ArrayList<State> vs = new ArrayList<State>();
        DefaultMutableTreeNode collecNode = (DefaultMutableTreeNode)this.root.getChildAt(6);
        int i = 0;
        while (i < collecNode.getChildCount()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)collecNode.getChildAt(i);
            PogoState ps = (PogoState)node.getUserObject();
            vs.add(ps.value);
            ++i;
        }
        return vs;
    }

    String getClassFileName() {
        String path = ((PogoRoot)this.root.getUserObject()).path;
        if (path != null) {
            String filename = String.valueOf(((PogoRoot)this.root.getUserObject()).name) + ".xmi";
            return String.valueOf(path) + "/" + filename;
        }
        return null;
    }

    private class ClassTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private ClassTreePopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            String[] stringArray = menuLabels;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String menuLabel = stringArray[n2];
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                } else {
                    JMenuItem btn = new JMenuItem(menuLabel);
                    btn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent evt) {
                            ClassTreePopupMenu.this.menuActionPerformed(evt);
                        }
                    });
                    this.add(btn);
                }
                ++n2;
            }
        }

        private void manageItemMenu(String itemName) {
            int i = 2;
            while (i < this.getComponentCount()) {
                Component component = this.getComponent(i);
                if (component instanceof JMenuItem) {
                    String text = menuLabels[i - 2];
                    int pos = text.indexOf("Item");
                    if (pos > 0) {
                        text = String.valueOf(text.substring(0, pos)) + itemName + text.substring(pos + "Item".length());
                    }
                    ((JMenuItem)component).setText(text);
                }
                ++i;
            }
        }

        public void showMenu(MouseEvent evt, PogoRoot root) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText("Class " + root.name);
            int i = 0;
            while (i < menuLabels.length) {
                this.getComponent(2 + i).setVisible(false);
                ++i;
            }
            this.getComponent(2).setVisible(true);
            this.getComponent(7).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, PogoCollection collec) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.manageItemMenu(collec.toString());
            this.title.setText(collec.toString());
            int i = 0;
            while (i < menuLabels.length) {
                this.getComponent(2 + i).setVisible(false);
                ++i;
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(collec.toString().indexOf("Attribute") > 0);
            this.getComponent(5).setVisible(ClassTree.this.canPaste());
            this.getComponent(6).setVisible(true);
            this.getComponent(7).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Object obj, String collec) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.manageItemMenu(obj.toString());
            this.title.setText(collec);
            int i = 0;
            while (i < menuLabels.length) {
                this.getComponent(2 + i).setVisible(false);
                ++i;
            }
            this.getComponent(8).setVisible(true);
            this.getComponent(9).setVisible(true);
            this.getComponent(10).setVisible(true);
            this.getComponent(11).setVisible(true);
            ((JMenuItem)this.getComponent(8)).setText("Edit " + obj.toString());
            this.getComponent(12).setVisible(true);
            boolean edit_code = obj instanceof PogoProperty ? Utils.isTrue(((PogoProperty)obj).value.getStatus().getConcreteHere()) : (obj instanceof PogoCommand ? Utils.isTrue(((PogoCommand)obj).value.getStatus().getConcreteHere()) : (obj instanceof PogoAttribute ? Utils.isTrue(((PogoAttribute)obj).value.getStatus().getConcreteHere()) : Utils.isTrue(((PogoState)obj).value.getStatus().getConcreteHere())));
            this.getComponent(12).setEnabled(edit_code && PogoEditor.getInstance().isAvailable());
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void menuActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int cmdidx = 0;
            int i = 0;
            while (i < menuLabels.length) {
                if (this.getComponent(2 + i) == obj) {
                    cmdidx = i;
                }
                ++i;
            }
            switch (cmdidx) {
                case 0: {
                    ClassTree.this.editClass();
                    break;
                }
                case 1: {
                    ClassTree.this.addItem(false);
                    break;
                }
                case 2: {
                    ClassTree.this.addItem(true);
                    break;
                }
                case 3: {
                    ClassTree.this.pasteItem();
                    break;
                }
                case 4: {
                    ClassTree.this.sortItems();
                    break;
                }
                case 5: {
                    ClassTree.this.summarize();
                    break;
                }
                case 6: {
                    ClassTree.this.editItem();
                    break;
                }
                case 7: {
                    ClassTree.this.copyItem();
                    break;
                }
                case 8: {
                    ClassTree.this.cloneItem();
                    break;
                }
                case 9: {
                    ClassTree.this.removeSelectedItem();
                }
                case 10: {
                    ClassTree.this.editSourceCode();
                }
            }
        }
    }

    class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        NodeComparator() {
        }

        @Override
        public int compare(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
            if (node1.toString().equals("State") || node1.toString().equals("Status")) {
                return -1;
            }
            if (node2.toString().equals("State") || node2.toString().equals("Status")) {
                return -1;
            }
            return node1.toString().compareTo(node2.toString());
        }
    }

    private class PogoAttribute {
        Attribute value;
        int attType;

        private PogoAttribute(Attribute value) {
            this.value = value;
            this.attType = Utils.isEquals(value.getAttType(), "Spectrum") ? 4 : (Utils.isEquals(value.getAttType(), "Image") ? 5 : 3);
        }

        private String toInfoString() {
            String desc = this.value.getProperties() == null || this.value.getProperties().getDescription().length() == 0 ? "No Description." : Utils.strReplace(this.value.getProperties().getDescription(), "\\n", "\n");
            String s = "Attribute:  ";
            if (Utils.isTrue(this.value.getIsDynamic())) {
                s = "Dynamic " + s;
            }
            return Utils.buildToolTip(String.valueOf(s) + this.value.getName(), desc);
        }

        private void manageDisplay(TangoRenderer renderer) {
            InheritanceStatus status = this.value.getStatus();
            renderer.setIcon(ClassTree.this.inherit_utils.getIcon(status));
            renderer.setFont(ClassTree.this.inherit_utils.getLeafFont(status));
            if (status != null && Utils.isTrue(status.getHasChanged())) {
                renderer.setForeground(Color.red);
            } else if (Utils.isExpert(this.value)) {
                renderer.setForeground(Color.blue);
            } else {
                renderer.setForeground(Color.black);
            }
            renderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoCollection {
        String name;
        ImageIcon icon;

        private PogoCollection(String name, ImageIcon icon) {
            this.name = name;
            this.icon = icon;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PogoCommand {
        Command value;

        private PogoCommand(Command value) {
            this.value = value;
        }

        private String toInfoString() {
            String desc = this.value.getDescription();
            desc = desc != null && desc.length() > 0 ? Utils.strReplace(desc, "\\n", "\n") : "No Description.";
            return Utils.buildToolTip("Command:  " + this.value.getName(), desc);
        }

        private void manageDisplay(TangoRenderer renderer) {
            InheritanceStatus status = this.value.getStatus();
            renderer.setIcon(ClassTree.this.inherit_utils.getIcon(status));
            renderer.setFont(ClassTree.this.inherit_utils.getLeafFont(status));
            if (status != null && Utils.isTrue(status.getHasChanged())) {
                renderer.setForeground(Color.red);
            } else if (Utils.isExpert(this.value)) {
                renderer.setForeground(Color.blue);
            } else {
                renderer.setForeground(Color.black);
            }
            renderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class PogoProperty {
        Property value;
        boolean is_dev;

        private PogoProperty(Property value, boolean is_dev) {
            this.value = value;
            this.is_dev = is_dev;
        }

        private String toInfoString() {
            StringBuilder sb = new StringBuilder(this.is_dev ? "Device" : "Class");
            sb.append(" property:  ").append(this.value.getName());
            return Utils.buildToolTip(sb.toString(), Utils.strReplace(this.value.getDescription(), "\\n", "\n"));
        }

        private void manageDisplay(TangoRenderer renderer) {
            InheritanceStatus status = this.value.getStatus();
            renderer.setIcon(ClassTree.this.inherit_utils.getIcon(status));
            renderer.setFont(ClassTree.this.inherit_utils.getLeafFont(status));
            if (status != null && status.getHasChanged() != null) {
                renderer.setForeground(Color.red);
            } else {
                renderer.setForeground(Color.black);
            }
            renderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    class PogoRoot {
        private String name;
        private String description;
        private String title;
        private String language;
        private String path;
        private boolean isAbstract;
        private ArrayList<Inheritance> inheritances = new ArrayList();
        private ClassIdentification id;

        private PogoRoot(PogoDeviceClass pogo_class) {
            this.name = pogo_class.getName();
            this.description = pogo_class.getDescription().getDescription();
            this.title = pogo_class.getDescription().getTitle();
            this.language = pogo_class.getDescription().getLanguage();
            this.path = pogo_class.getDescription().getSourcePath();
            this.isAbstract = DeviceClass.checkIfAbstractClass(pogo_class, false);
            this.id = pogo_class.getDescription().getIdentification();
            for (Inheritance inher : pogo_class.getDescription().getInheritances()) {
                this.inheritances.add(inher);
            }
        }

        private String toInfoString() {
            String title = "Class name:  " + this.name;
            if (this.isAbstract) {
                title = String.valueOf(title) + "  (class is abstract !)";
            }
            StringBuilder sb = new StringBuilder();
            if (this.path != null && this.path.length() > 0) {
                sb.append("Read at:   ").append(this.path);
            }
            sb.append("\nInherited from: ").append(this.inheritances.get(0).getClassname());
            if (!DeviceClass.isDefaultInheritance(this.inheritances.get(0))) {
                sb.append("\nRead at:   ").append(this.inheritances.get(0).getSourcePath());
            } else {
                sb.append("  the default Tango device object.\n");
            }
            sb.append("\n\nDescription:\n");
            sb.append(Utils.strReplace(this.description, "\\n", "\n")).append("\n");
            return Utils.buildToolTip(title, sb.toString());
        }

        public String toString() {
            return ClassTree.this.pogo_class.getName();
        }
    }

    private class PogoState {
        State value;

        private PogoState(State value) {
            this.value = value;
        }

        private String toInfoString() {
            String desc = this.value.getDescription();
            desc = desc != null && desc.length() > 0 ? Utils.strReplace(desc, "\\n", "\n") : "No Description.";
            return Utils.buildToolTip("State:  " + this.value.getName(), desc);
        }

        private void manageDisplay(TangoRenderer renderer) {
            InheritanceStatus status = this.value.getStatus();
            renderer.setIcon(ClassTree.this.inherit_utils.getIcon(status));
            renderer.setFont(ClassTree.this.inherit_utils.getLeafFont(status));
            if (status != null && status.getHasChanged() != null) {
                renderer.setForeground(Color.red);
            } else {
                renderer.setForeground(Color.black);
            }
            renderer.setToolTipText(this.toInfoString());
        }

        public String toString() {
            return this.value.getName();
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            Utils utils = Utils.getInstance();
            this.setBackgroundNonSelectionColor(background);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            Object user_obj = node.getUserObject();
            if (row == 0) {
                PogoRoot pr = (PogoRoot)user_obj;
                if (pr.isAbstract) {
                    this.setFont(rootFont_abstract);
                } else {
                    this.setFont(rootFont_concrete);
                }
                this.setIcon(utils.root_icon);
                this.setToolTipText(pr.toInfoString());
            } else if (user_obj instanceof PogoProperty) {
                ((PogoProperty)user_obj).manageDisplay(this);
            } else if (user_obj instanceof PogoCommand) {
                ((PogoCommand)user_obj).manageDisplay(this);
            } else if (user_obj instanceof PogoAttribute) {
                ((PogoAttribute)user_obj).manageDisplay(this);
                if (Utils.isTrue(((PogoAttribute)user_obj).value.getIsDynamic())) {
                    this.setBackgroundNonSelectionColor(dynamicBG);
                }
            } else if (user_obj instanceof PogoState) {
                ((PogoState)user_obj).manageDisplay(this);
            } else if (user_obj instanceof PogoCollection) {
                this.setFont(collecFont);
                this.setIcon(((PogoCollection)user_obj).icon);
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

