/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.tango.pogo.pogoDsl.ClassDescription;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.tango.pogo.pogo_gui.ClassTree;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.InheritancePanel;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ClassDialog
extends JDialog {
    private static int returnStatus;
    private DeviceClass devclass;
    private String origClassName = null;
    private InheritancePanel inheritance_panel;
    private JRadioButton[] langBtn;
    private boolean hasForcedGenerate = false;
    private static JFileChooser chooser;
    private DeviceIdDialog IDdialog;
    private ClassTree classTree;
    private JButton addInheritanceBtn;
    private JRadioButton cppBtn;
    private JTextArea descText;
    private JSplitPane horizontalPanel;
    private JScrollPane inheritanceScrollPane;
    private JRadioButton javaBtn;
    private JTextField nameText;
    private JTextField projectText;
    private JRadioButton pythonBtn;

    static {
        chooser = null;
    }

    public ClassDialog(JFrame parent, ClassTree classTree, DeviceClass dc, boolean isInheritedClass) {
        super((Frame)parent, true);
        this.classTree = classTree;
        this.initComponents();
        this.langBtn = new JRadioButton[3];
        this.langBtn[1] = this.cppBtn;
        this.langBtn[0] = this.javaBtn;
        this.langBtn[2] = this.pythonBtn;
        if (dc == null) {
            this.devclass = new DeviceClass("", null);
        } else {
            this.devclass = dc;
            this.origClassName = dc.getPogoDeviceClass().getName();
            this.addInheritanceBtn.setVisible(false);
            if (PogoGUI.dbg_java) {
                ClassDescription desc = dc.getPogoDeviceClass().getDescription();
                if (desc != null) {
                    this.setLanguage(desc.getLanguage());
                }
            } else {
                this.setLanguage(Utils.getLanguage(1));
            }
        }
        PogoDeviceClass pogo_class = this.devclass.getPogoDeviceClass();
        this.nameText.setText(pogo_class.getName());
        this.descText.setText(pogo_class.getDescription().getDescription());
        this.descText.setToolTipText(Utils.buildToolTip("Class Description", "Description for device server documentation."));
        this.projectText.setText(pogo_class.getDescription().getTitle());
        this.projectText.setToolTipText(Utils.buildToolTip("Short description for documentation header"));
        this.IDdialog = new DeviceIdDialog(parent, pogo_class.getDescription().getIdentification());
        this.horizontalPanel.setLeftComponent(this.IDdialog.getCenterPanel());
        if (this.devclass.getPogoDeviceClass().getName().length() == 0) {
            this.devclass.getPogoDeviceClass().setName("New Tango Class");
        }
        this.inheritance_panel = new InheritancePanel(this.devclass);
        this.inheritanceScrollPane.setViewportView(this.inheritance_panel);
        if (isInheritedClass) {
            this.nameText.setEditable(false);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
        this.nameText.requestFocus();
    }

    public ClassDialog(JFrame parent) {
        this(parent, null, null, false);
    }

    private void setLanguage(String lang) {
        int langCode = Utils.getLanguage(lang);
        if (langCode < 0) {
            langCode = 1;
        }
        int i = 0;
        while (i < this.langBtn.length) {
            this.langBtn[i].setSelected(i == langCode);
            ++i;
        }
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.horizontalPanel = new JSplitPane();
        JPanel centerPanel = new JPanel();
        this.addInheritanceBtn = new JButton();
        JLabel nameLbl = new JLabel();
        this.nameText = new JTextField();
        JLabel titleLbl = new JLabel();
        this.projectText = new JTextField();
        JLabel descLbl = new JLabel();
        JScrollPane descScrollPane = new JScrollPane();
        this.descText = new JTextArea();
        JLabel languageLbl = new JLabel();
        JPanel languagePanel = new JPanel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.pythonBtn = new JRadioButton();
        this.inheritanceScrollPane = new JScrollPane();
        this.setTitle("Class Definition Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ClassDialog.this.closeDialog(evt);
            }
        });
        bottomPanel.setLayout(new FlowLayout(2));
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        centerPanel.setLayout(new GridBagLayout());
        this.addInheritanceBtn.setText("Add Inheritance Class");
        this.addInheritanceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.addInheritanceBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        centerPanel.add((Component)this.addInheritanceBtn, gridBagConstraints);
        nameLbl.setFont(new Font("Dialog", 1, 18));
        nameLbl.setText("Class Name :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        centerPanel.add((Component)nameLbl, gridBagConstraints);
        this.nameText.setFont(new Font("Dialog", 1, 18));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.nameTextActionPerformed(evt);
            }
        });
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ClassDialog.this.nameTextKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        centerPanel.add((Component)this.nameText, gridBagConstraints);
        titleLbl.setText("Project Title :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        centerPanel.add((Component)titleLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        centerPanel.add((Component)this.projectText, gridBagConstraints);
        descLbl.setText("Class Description:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        centerPanel.add((Component)descLbl, gridBagConstraints);
        descScrollPane.setForeground(Color.lightGray);
        descScrollPane.setPreferredSize(new Dimension(500, 250));
        this.descText.setColumns(80);
        this.descText.setMinimumSize(new Dimension(0, 100));
        this.descText.setPreferredSize(new Dimension(880, 400));
        descScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        centerPanel.add((Component)descScrollPane, gridBagConstraints);
        languageLbl.setText("Language :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 3, 10, 0);
        centerPanel.add((Component)languageLbl, gridBagConstraints);
        this.cppBtn.setFont(new Font("Dialog", 1, 10));
        this.cppBtn.setSelected(true);
        this.cppBtn.setText("Cpp");
        this.cppBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.languageActionPerformed(evt);
            }
        });
        languagePanel.add(this.cppBtn);
        this.javaBtn.setFont(new Font("Dialog", 1, 10));
        this.javaBtn.setText("Java");
        this.javaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.languageActionPerformed(evt);
            }
        });
        languagePanel.add(this.javaBtn);
        this.pythonBtn.setFont(new Font("Dialog", 1, 10));
        this.pythonBtn.setText("Python");
        this.pythonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassDialog.this.languageActionPerformed(evt);
            }
        });
        languagePanel.add(this.pythonBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        centerPanel.add((Component)languagePanel, gridBagConstraints);
        this.horizontalPanel.setRightComponent(centerPanel);
        this.getContentPane().add((Component)this.horizontalPanel, "Center");
        this.inheritanceScrollPane.setForeground(Color.lightGray);
        this.inheritanceScrollPane.setPreferredSize(new Dimension(230, 250));
        this.getContentPane().add((Component)this.inheritanceScrollPane, "East");
    }

    private void manageOK() {
        String classname = this.checkClassName();
        if (classname == null || classname.length() == 0) {
            return;
        }
        try {
            this.IDdialog.checkInputs();
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        this.nameText.setText(classname);
        if (this.checkClassNameChanged(classname)) {
            this.doClose(0);
        }
    }

    private boolean checkClassNameChanged(String className) {
        if (this.classTree == null) {
            return true;
        }
        if (this.origClassName == null) {
            return true;
        }
        if (this.devclass.getPogoDeviceClass().getDescription().getSourcePath() == null) {
            return true;
        }
        if (className.equals(this.origClassName)) {
            return true;
        }
        Object[] options = new Object[]{"Change Class name", "Create new class files", "Cancel"};
        int choice = JOptionPane.showOptionDialog(this, "Class name has changed", "Confirmation Window", -1, 2, null, options, options[0]);
        switch (choice) {
            case 0: {
                System.out.println("Will generate");
                return this.manageClassNameChanged(className);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean manageClassNameChanged(String className) {
        if (JOptionPane.showConfirmDialog(this, "The " + className + " files (xmi and code) will be generated", "Confirmation Window", 0) != 0) {
            return false;
        }
        this.setCursor(new Cursor(3));
        Utils.getInstance().startSplashRefresher("Generate class: " + className);
        try {
            DeviceClass deviceClass = this.classTree.getDeviceClass();
            deviceClass.generateWithNewName(className, this.classTree.getModified(), this.classTree.getDeletedObjects(), this.classTree.getRenamedObjects());
            this.classTree.setModified(false);
            this.hasForcedGenerate = true;
            this.setCursor(new Cursor(0));
            Utils.getInstance().stopSplashRefresher();
        }
        catch (Exception e) {
            this.setCursor(new Cursor(0));
            Utils.getInstance().stopSplashRefresher();
            ErrorPane.showErrorMessage((Component)this, null, e);
            return false;
        }
        return true;
    }

    public boolean hasForcedToGenerate() {
        return this.hasForcedGenerate;
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        this.manageOK();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.manageOK();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void languageActionPerformed(ActionEvent evt) {
        JRadioButton btn = (JRadioButton)evt.getSource();
        if (btn.getSelectedObjects() == null) {
            btn.setSelected(true);
        }
        if (this.devclass.getAncestors().size() > 0) {
            btn.setSelected(false);
            JOptionPane.showMessageDialog(this, String.valueOf(this.devclass.getPogoDeviceClass().getName()) + " inherite  for " + this.devclass.getAncestors().get(0).getPogoDeviceClass().getName() + ".\n It must be generated in same language !", "Error Window", 0);
        } else if (btn == this.cppBtn) {
            this.setLanguage(btn.getText());
        } else if (btn == this.javaBtn) {
            if (PogoGUI.dbg_java) {
                this.setLanguage(btn.getText());
            } else {
                btn.setSelected(false);
                JOptionPane.showMessageDialog(this, String.valueOf(btn.getText()) + " language is not available !", "Error Window", 0);
            }
        } else if (btn == this.pythonBtn) {
            if (PogoGUI.dbg_python) {
                this.setLanguage(btn.getText());
            } else {
                btn.setSelected(false);
                JOptionPane.showMessageDialog(this, String.valueOf(btn.getText()) + " language is not available !", "Error Window", 0);
            }
        }
    }

    private void addInheritanceBtnActionPerformed(ActionEvent evt) {
        block6: {
            File file;
            int retval;
            if (chooser == null) {
                String path = System.getenv("SOURCE_PATH");
                if (path == null && (path = System.getProperty("SOURCE_PATH")) == null) {
                    path = new File("").getAbsolutePath();
                }
                chooser = new JFileChooser(new File(path).getAbsolutePath());
                PogoFileFilter filter = new PogoFileFilter("xmi", "Tango Classes");
                filter.setExtensionListInDescription(false);
                chooser.setFileFilter(filter);
            }
            if ((retval = chooser.showOpenDialog(this)) == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
                try {
                    DeviceClass dc = new DeviceClass(file.getAbsolutePath());
                    this.devclass.addAncestor(dc);
                    this.inheritanceScrollPane.remove(this.inheritance_panel);
                    String name = this.nameText.getText();
                    if (name.length() > 0) {
                        this.devclass.getPogoDeviceClass().setName(name);
                    }
                    this.inheritance_panel = new InheritancePanel(this.devclass);
                    this.inheritanceScrollPane.setViewportView(this.inheritance_panel);
                    this.addInheritanceBtn.setVisible(false);
                }
                catch (DevFailed e) {
                    if (e.errors[0].reason.equals("CANCEL")) break block6;
                    ErrorPane.showErrorMessage((Component)this, file.getAbsolutePath(), e);
                }
            }
        }
    }

    private void nameTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.doClose(2);
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    DeviceClass getInputs() {
        PogoDeviceClass pogo_class = this.devclass.getPogoDeviceClass();
        pogo_class.setName(this.nameText.getText());
        pogo_class.getDescription().setTitle(this.projectText.getText());
        pogo_class.getDescription().setDescription(this.descText.getText());
        pogo_class.getDescription().setIdentification(this.IDdialog.getInputs());
        if (this.pythonBtn.getSelectedObjects() != null) {
            pogo_class.getDescription().setLanguage(PogoConst.strLang[2]);
        } else if (this.javaBtn.getSelectedObjects() != null) {
            pogo_class.getDescription().setLanguage(PogoConst.strLang[0]);
        } else {
            pogo_class.getDescription().setLanguage(PogoConst.strLang[1]);
        }
        return this.devclass;
    }

    private String checkClassName() {
        if (this.nameText.getText().length() == 0) {
            return null;
        }
        String name = this.nameText.getText().toLowerCase();
        if (name.charAt(0) < 'a' || name.charAt(0) > 'z') {
            Utils.popupError(this, "First char of class name must be a letter");
            return null;
        }
        int i = 0;
        while (i < name.length()) {
            if (!(name.charAt(i) >= 'a' && name.charAt(i) <= 'z' || name.charAt(i) >= '0' && name.charAt(i) <= '9' || name.charAt(i) == '_')) {
                Utils.popupError(this, "Char '" + name.charAt(i) + "' is not authorized in class name");
                return null;
            }
            ++i;
        }
        StringTokenizer stk = new StringTokenizer(this.nameText.getText());
        name = "";
        while (stk.hasMoreTokens()) {
            String tmp = stk.nextToken();
            name = tmp.length() > 1 ? String.valueOf(name) + tmp.substring(0, 1).toUpperCase() + tmp.substring(1) : String.valueOf(name) + tmp.toUpperCase();
        }
        if (name.length() == 0) {
            return null;
        }
        return name;
    }
}

