/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.EventCriteria;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.Type;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PopupTable;
import org.tango.pogo.pogo_gui.tools.Utils;

public class AttributeDialog
extends JDialog
implements PogoConst {
    private int retVal = 0;
    private PogoGUI pogo_gui;
    private InheritanceStatus orig_status = null;
    private boolean isDynamic = false;
    private int poll_period = 0;
    private Attribute attribute;
    private static final String defaultDataType = AttrDataArray[9];
    private static final int EMPTY_FIELD = -1;
    private static final int NEGATIVE_FIELD = -2;
    private static final int INVALID_FIELD = -3;
    private JRadioButton abstractBtn;
    private JRadioButton allocateBtn;
    private JRadioButton archiveEvtChecked;
    private JRadioButton archiveEvtCode;
    private JLabel assAttrLBL;
    private JTextField assAttrTF;
    private JTextField attrPropDeltaTime;
    private JTextField attrPropDeltaValue;
    private JTextArea attrPropDescription;
    private JTextField attrPropDispUnit;
    private JTextField attrPropFormat;
    private JTextField attrPropLabel;
    private JTextField attrPropMaxAlarm;
    private JTextField attrPropMaxValue;
    private JTextField attrPropMaxWarning;
    private JTextField attrPropMinAlarm;
    private JTextField attrPropMinValue;
    private JTextField attrPropMinWarning;
    private JTextField attrPropStdUnit;
    private JTextField attrPropUnit;
    private JComboBox attrTypeCB;
    private JRadioButton changeEvtChecked;
    private JRadioButton changeEvtCode;
    private JRadioButton dataReadyEvtCode;
    private JComboBox dataTypeCB;
    private JPanel definitionPanel;
    private JLabel dynamicLbl;
    private JTextField evAbsChangeTxt;
    private JTextField evArchAbsChangeTxt;
    private JTextField evArchPeriodTxt;
    private JTextField evArchRelChangeTxt;
    private JTextField evPeriodTxt;
    private JTextField evRelChangeTxt;
    private JLabel evTitleLbl;
    private JTextField nameText;
    private JRadioButton overloadBtn;
    private JComboBox rwTypeCB;
    private JLabel xDataLBL;
    private JTextField xDataTF;
    private JLabel yDataLBL;
    private JTextField yDataTF;
    private JRadioButton levelBtn;
    private JRadioButton polledBtn;
    private JRadioButton memorizedBtn;
    private JRadioButton memorizedInitBtn;
    private JLabel periodLabel;
    private JLabel periodUnitLabel;
    private JTextField periodText;
    private static int[] columnSize = new int[]{140, 70, 130, 60, 80, 40, 40, 400};
    private static String[] columnTitle = new String[]{"Name", "Type", "DataType", "Size", "Level", "Inherited", "Abstract", "Description"};

    public AttributeDialog(PogoGUI parent, int attType, boolean isDynamic) {
        this(parent, null);
        this.isDynamic = isDynamic;
        this.attrTypeCB.setSelectedIndex(attType);
        this.updateWindow();
        this.dynamicLbl.setVisible(isDynamic);
    }

    public AttributeDialog(PogoGUI parent, Attribute attribute) {
        super((Frame)parent, true);
        this.pogo_gui = parent;
        this.attribute = attribute;
        if (attribute != null) {
            this.orig_status = attribute.getStatus();
            this.isDynamic = Utils.isTrue(attribute.getIsDynamic());
        }
        this.initComponents();
        this.initOwnComponents();
        this.initializeWindow();
        this.manageInheritanceStatus(attribute);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initOwnComponents() {
        String s;
        String[] stringArray = AttrDataArray;
        int n = AttrDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.dataTypeCB.addItem(s);
            ++n2;
        }
        this.dataTypeCB.setSelectedItem(defaultDataType);
        stringArray = AttrTypeArray;
        n = AttrTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.attrTypeCB.addItem(s);
            ++n2;
        }
        stringArray = AttrRWtypeArray;
        n = AttrRWtypeArray.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            this.rwTypeCB.addItem(s);
            ++n2;
        }
        int y = 14;
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel lbl = new JLabel("Controlled by : ");
        gbc.gridx = 0;
        gbc.gridy = ++y;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.fill = 2;
        this.definitionPanel.add((Component)lbl, gbc);
        this.levelBtn = new JRadioButton();
        this.levelBtn.setToolTipText(Utils.buildToolTip("Display Level", "Expert or Operator"));
        this.levelBtn.setText(" Expert Only  ");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        this.definitionPanel.add((Component)this.levelBtn, gbc);
        this.polledBtn = new JRadioButton();
        this.polledBtn.setToolTipText(Utils.buildToolTip("Attribute polled"));
        this.polledBtn.setText("Polled");
        gbc.gridx = 1;
        gbc.gridy = y++;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        this.definitionPanel.add((Component)this.polledBtn, gbc);
        this.polledBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.polledBtnActionPerformed(evt);
            }
        });
        this.periodLabel = new JLabel("  Polling Period :");
        this.periodLabel.setHorizontalAlignment(4);
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.definitionPanel.add((Component)this.periodLabel, gbc);
        this.periodText = new JTextField();
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.fill = 2;
        this.definitionPanel.add((Component)this.periodText, gbc);
        this.periodText.setRequestFocusEnabled(true);
        this.periodUnitLabel = new JLabel(" ms  ");
        gbc.gridx = 2;
        gbc.gridy = y++;
        this.definitionPanel.add((Component)this.periodUnitLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = y++;
        this.definitionPanel.add((Component)new JLabel(" "), gbc);
        this.setPeriodEnabled(false);
        this.memorizedBtn = new JRadioButton();
        this.memorizedBtn.setToolTipText(Utils.buildToolTip("Attribute memorized", "The write attribute value will be stored in database\nAnd at next startup, the write attribute value will\nbe set to this stored value."));
        this.memorizedBtn.setText(" Memorized  ");
        this.memorizedBtn.setVisible(false);
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.fill = 2;
        this.definitionPanel.add((Component)this.memorizedBtn, gbc);
        this.memorizedBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.memorizedBtnActionPerformed(evt);
            }
        });
        this.memorizedInitBtn = new JRadioButton();
        this.memorizedInitBtn.setToolTipText(Utils.buildToolTip("Write at init", "At each device initialization\nthe write attribute method will be called\nwith the value stored in database at previous write."));
        this.memorizedInitBtn.setText(" Write hardware at init ");
        this.memorizedInitBtn.setVisible(false);
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.fill = 2;
        this.definitionPanel.add((Component)this.memorizedInitBtn, gbc);
    }

    private void setPeriodEnabled(boolean state) {
        this.periodLabel.setVisible(state);
        this.periodText.setVisible(state);
        this.periodUnitLabel.setVisible(state);
        if (state) {
            String txt = this.poll_period == 0 ? "3000" : "" + this.poll_period;
            this.periodText.setText(txt);
            this.pack();
        }
    }

    private void manageAbstractOverloadButtons() {
        this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
        if (this.isDynamic) {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setVisible(false);
            this.setEditable(true);
        } else if (Utils.isTrue(this.orig_status.getInherited())) {
            this.abstractBtn.setVisible(false);
            this.overloadBtn.setVisible(true);
            boolean oveload = Utils.isTrue(this.orig_status.getConcreteHere());
            this.overloadBtn.setSelected(oveload);
            this.setEditable(false);
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setVisible(true);
            this.abstractBtn.setSelected(Utils.isTrue(this.orig_status.getAbstract()));
            this.setEditable(true);
        }
    }

    private void manageInheritanceStatus(Attribute attribute) {
        if (attribute != null) {
            this.manageAbstractOverloadButtons();
        } else {
            this.overloadBtn.setVisible(false);
            this.abstractBtn.setSelected(false);
            this.orig_status = OAWutils.factory.createInheritanceStatus();
            this.orig_status.setAbstract("false");
            this.orig_status.setInherited("false");
            this.orig_status.setConcrete("true");
            this.orig_status.setConcreteHere("true");
            this.setEditable(true);
        }
    }

    private void setNotEditable(JComboBox jcb) {
        String name = (String)jcb.getSelectedItem();
        if (name != null) {
            jcb.removeAllItems();
            jcb.addItem(name);
        }
    }

    private void setEditable(boolean b2) {
        this.nameText.setEditable(b2);
        if (!b2) {
            this.setNotEditable(this.attrTypeCB);
            this.setNotEditable(this.dataTypeCB);
            this.setNotEditable(this.rwTypeCB);
            this.levelBtn.setEnabled(b2);
            this.changeEvtCode.setEnabled(b2);
            this.changeEvtChecked.setEnabled(b2);
            this.archiveEvtCode.setEnabled(b2);
            this.archiveEvtChecked.setEnabled(b2);
            this.evPeriodTxt.setEnabled(b2);
            this.evRelChangeTxt.setEnabled(b2);
            this.evAbsChangeTxt.setEnabled(b2);
            this.evArchPeriodTxt.setEnabled(b2);
            this.evArchRelChangeTxt.setEnabled(b2);
            this.evArchAbsChangeTxt.setEnabled(b2);
            this.dataReadyEvtCode.setEnabled(b2);
            this.memorizedBtn.setEnabled(b2);
            this.attrPropDeltaTime.setEditable(b2);
            this.attrPropDeltaValue.setEditable(b2);
            this.attrPropDescription.setEditable(b2);
            this.attrPropDispUnit.setEditable(b2);
            this.attrPropFormat.setEditable(b2);
            this.attrPropLabel.setEditable(b2);
            this.attrPropMaxAlarm.setEditable(b2);
            this.attrPropMaxValue.setEditable(b2);
            this.attrPropMaxWarning.setEditable(b2);
            this.attrPropMinAlarm.setEditable(b2);
            this.attrPropMinValue.setEditable(b2);
            this.attrPropMinWarning.setEditable(b2);
            this.attrPropStdUnit.setEditable(b2);
            this.attrPropUnit.setEditable(b2);
        }
    }

    private void memorizedBtnActionPerformed(ActionEvent evt) {
        this.memorizedInitBtn.setVisible(this.memorizedBtn.getSelectedObjects() != null);
    }

    private void polledBtnActionPerformed(ActionEvent evt) {
        boolean state = this.polledBtn.getSelectedObjects() != null;
        this.setPeriodEnabled(state);
        if (state) {
            this.periodText.selectAll();
            this.periodText.requestFocus();
        }
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JTabbedPane tabbedPane = new JTabbedPane();
        this.definitionPanel = new JPanel();
        JLabel nameLbl = new JLabel();
        this.attrTypeCB = new JComboBox();
        JLabel attTypeLbl = new JLabel();
        this.nameText = new JTextField();
        JLabel dataTypeLbl = new JLabel();
        this.dataTypeCB = new JComboBox();
        this.xDataLBL = new JLabel();
        this.yDataLBL = new JLabel();
        this.xDataTF = new JTextField();
        this.yDataTF = new JTextField();
        this.rwTypeCB = new JComboBox();
        this.assAttrLBL = new JLabel();
        this.assAttrTF = new JTextField();
        JLabel rwTypeLBL = new JLabel();
        this.abstractBtn = new JRadioButton();
        this.overloadBtn = new JRadioButton();
        JLabel allocateLbl = new JLabel();
        this.allocateBtn = new JRadioButton();
        this.dynamicLbl = new JLabel();
        JPanel propertyPanel = new JPanel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.attrPropLabel = new JTextField();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.attrPropUnit = new JTextField();
        this.attrPropStdUnit = new JTextField();
        this.attrPropDispUnit = new JTextField();
        JLabel jLabel11 = new JLabel();
        JLabel jLabel12 = new JLabel();
        JLabel jLabel13 = new JLabel();
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        this.attrPropFormat = new JTextField();
        this.attrPropMaxValue = new JTextField();
        this.attrPropMinValue = new JTextField();
        this.attrPropMaxAlarm = new JTextField();
        this.attrPropMinAlarm = new JTextField();
        JLabel jLabel16 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.attrPropDescription = new JTextArea();
        JLabel jLabel20 = new JLabel();
        JLabel jLabel21 = new JLabel();
        this.attrPropDeltaTime = new JTextField();
        this.attrPropDeltaValue = new JTextField();
        JLabel jLabel22 = new JLabel();
        JLabel jLabel23 = new JLabel();
        this.attrPropMaxWarning = new JTextField();
        this.attrPropMinWarning = new JTextField();
        JPanel eventsPanel = new JPanel();
        this.evTitleLbl = new JLabel();
        JLabel defaultEventsLbl = new JLabel();
        JLabel periodicLbl = new JLabel();
        JLabel changeLbl = new JLabel();
        JLabel archiveLbl = new JLabel();
        JLabel periodLbl = new JLabel();
        JLabel absChangeLbl = new JLabel();
        JLabel relativeChangeLbl = new JLabel();
        JLabel periodArchiveLbl = new JLabel();
        JLabel relativeArchiveLbl = new JLabel();
        JLabel absArchiveLbl = new JLabel();
        this.evPeriodTxt = new JTextField();
        this.evRelChangeTxt = new JTextField();
        this.evAbsChangeTxt = new JTextField();
        this.evArchPeriodTxt = new JTextField();
        this.evArchRelChangeTxt = new JTextField();
        this.evArchAbsChangeTxt = new JTextField();
        JLabel dummyLbl = new JLabel();
        JLabel pushEventsLbl = new JLabel();
        this.changeEvtCode = new JRadioButton();
        this.changeEvtChecked = new JRadioButton();
        this.archiveEvtCode = new JRadioButton();
        this.archiveEvtChecked = new JRadioButton();
        this.dataReadyEvtCode = new JRadioButton();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.setTitle("Edit Attribute Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AttributeDialog.this.closeDialog(evt);
            }
        });
        bottomPanel.setLayout(new FlowLayout(2));
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        tabbedPane.setToolTipText("");
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                AttributeDialog.this.tabbedPaneStateChanged(evt);
            }
        });
        this.definitionPanel.setLayout(new GridBagLayout());
        nameLbl.setFont(new Font("Arial", 1, 18));
        nameLbl.setText("Attribute name: ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        this.definitionPanel.add((Component)nameLbl, gridBagConstraints);
        this.attrTypeCB.setFont(new Font("Arial", 1, 12));
        this.attrTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.attrTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.attrTypeCB, gridBagConstraints);
        attTypeLbl.setFont(new Font("Arial", 1, 12));
        attTypeLbl.setText("Attribute Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)attTypeLbl, gridBagConstraints);
        this.nameText.setColumns(15);
        this.nameText.setFont(new Font("Arial", 1, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        this.definitionPanel.add((Component)this.nameText, gridBagConstraints);
        dataTypeLbl.setFont(new Font("Arial", 1, 12));
        dataTypeLbl.setText("Data Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)dataTypeLbl, gridBagConstraints);
        this.dataTypeCB.setFont(new Font("Arial", 1, 12));
        this.dataTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.dataTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.dataTypeCB, gridBagConstraints);
        this.xDataLBL.setFont(new Font("Arial", 1, 12));
        this.xDataLBL.setText("Maximum X data size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)this.xDataLBL, gridBagConstraints);
        this.yDataLBL.setFont(new Font("Arial", 1, 12));
        this.yDataLBL.setText("Maximum Y data size: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)this.yDataLBL, gridBagConstraints);
        this.xDataTF.setFont(new Font("Arial", 1, 12));
        this.xDataTF.setMinimumSize(new Dimension(100, 20));
        this.xDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.xDataTF, gridBagConstraints);
        this.yDataTF.setFont(new Font("Arial", 1, 12));
        this.yDataTF.setMinimumSize(new Dimension(100, 20));
        this.yDataTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.yDataTF, gridBagConstraints);
        this.rwTypeCB.setFont(new Font("Arial", 1, 12));
        this.rwTypeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.rwTypeCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.definitionPanel.add((Component)this.rwTypeCB, gridBagConstraints);
        this.assAttrLBL.setFont(new Font("Arial", 1, 12));
        this.assAttrLBL.setText("Associated Attribute:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 0);
        this.definitionPanel.add((Component)this.assAttrLBL, gridBagConstraints);
        this.assAttrTF.setFont(new Font("Arial", 1, 12));
        this.assAttrTF.setMinimumSize(new Dimension(100, 20));
        this.assAttrTF.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        this.definitionPanel.add((Component)this.assAttrTF, gridBagConstraints);
        rwTypeLBL.setFont(new Font("Arial", 1, 12));
        rwTypeLBL.setText("Read/Write Type: ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.definitionPanel.add((Component)rwTypeLBL, gridBagConstraints);
        this.abstractBtn.setFont(new Font("Arial", 1, 12));
        this.abstractBtn.setText("Abstract");
        this.abstractBtn.setHorizontalAlignment(2);
        this.abstractBtn.setHorizontalTextPosition(2);
        this.abstractBtn.setMargin(new Insets(2, 12, 2, 12));
        this.abstractBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.abstractBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 20, 10);
        this.definitionPanel.add((Component)this.abstractBtn, gridBagConstraints);
        this.overloadBtn.setFont(new Font("Arial", 1, 12));
        this.overloadBtn.setText("Overload");
        this.overloadBtn.setHorizontalAlignment(2);
        this.overloadBtn.setHorizontalTextPosition(2);
        this.overloadBtn.setMargin(new Insets(2, 12, 2, 12));
        this.overloadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.overloadBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 20, 10);
        this.definitionPanel.add((Component)this.overloadBtn, gridBagConstraints);
        allocateLbl.setFont(new Font("Arial", 1, 12));
        allocateLbl.setText("Allocate:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 20, 10);
        this.definitionPanel.add((Component)allocateLbl, gridBagConstraints);
        this.allocateBtn.setFont(new Font("Arial", 1, 12));
        this.allocateBtn.setSelected(true);
        this.allocateBtn.setText("Read data member");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 3);
        this.definitionPanel.add((Component)this.allocateBtn, gridBagConstraints);
        this.dynamicLbl.setFont(new Font("Arial", 1, 12));
        this.dynamicLbl.setText("Dynamic Attribute (Add/Remove attribute will be done by code)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 10, 15, 0);
        this.definitionPanel.add((Component)this.dynamicLbl, gridBagConstraints);
        tabbedPane.addTab("Definition", null, this.definitionPanel, "Attribute definition.");
        propertyPanel.setLayout(new GridBagLayout());
        jLabel6.setFont(new Font("Dialog", 0, 12));
        jLabel6.setText("Default Attribute Properties");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        propertyPanel.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setFont(new Font("Dialog", 0, 12));
        jLabel7.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropLabel, gridBagConstraints);
        jLabel8.setFont(new Font("Dialog", 0, 12));
        jLabel8.setText("Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel8, gridBagConstraints);
        jLabel9.setFont(new Font("Dialog", 0, 12));
        jLabel9.setText("Standard Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setFont(new Font("Dialog", 0, 12));
        jLabel10.setText("Display Unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropStdUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropDispUnit, gridBagConstraints);
        jLabel11.setFont(new Font("Dialog", 0, 12));
        jLabel11.setText("Display Format       ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel11, gridBagConstraints);
        jLabel12.setFont(new Font("Dialog", 0, 12));
        jLabel12.setText("Max. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel12, gridBagConstraints);
        jLabel13.setFont(new Font("Dialog", 0, 12));
        jLabel13.setText("Min. Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel13, gridBagConstraints);
        jLabel14.setFont(new Font("Dialog", 0, 12));
        jLabel14.setText("Max. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel14, gridBagConstraints);
        jLabel15.setFont(new Font("Dialog", 0, 12));
        jLabel15.setText("Min. Alarm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel15, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropFormat, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMaxValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMinValue, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMaxAlarm, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMinAlarm, gridBagConstraints);
        jLabel16.setFont(new Font("Dialog", 0, 12));
        jLabel16.setText("Description :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel16, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(350, 100));
        this.attrPropDescription.setColumns(80);
        this.attrPropDescription.setRows(20);
        jScrollPane.setViewportView(this.attrPropDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        propertyPanel.add((Component)jScrollPane, gridBagConstraints);
        jLabel20.setFont(new Font("Dialog", 0, 12));
        jLabel20.setText("Delta time");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel20, gridBagConstraints);
        jLabel21.setFont(new Font("Dialog", 0, 12));
        jLabel21.setText("Delta value   ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel21, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropDeltaTime, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropDeltaValue, gridBagConstraints);
        jLabel22.setFont(new Font("Dialog", 0, 12));
        jLabel22.setText("Max Warning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel22, gridBagConstraints);
        jLabel23.setFont(new Font("Dialog", 0, 12));
        jLabel23.setText("Min Warning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        propertyPanel.add((Component)jLabel23, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMaxWarning, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        propertyPanel.add((Component)this.attrPropMinWarning, gridBagConstraints);
        tabbedPane.addTab("Properties", null, propertyPanel, "Attribute Properties");
        eventsPanel.setLayout(new GridBagLayout());
        this.evTitleLbl.setFont(new Font("Dialog", 1, 18));
        this.evTitleLbl.setText("Attribute");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        eventsPanel.add((Component)this.evTitleLbl, gridBagConstraints);
        defaultEventsLbl.setFont(new Font("Dialog", 1, 14));
        defaultEventsLbl.setText("Default Events:");
        defaultEventsLbl.setToolTipText("Events managed by TANGO library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        eventsPanel.add((Component)defaultEventsLbl, gridBagConstraints);
        periodicLbl.setFont(new Font("Dialog", 1, 12));
        periodicLbl.setText("Periodic Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        eventsPanel.add((Component)periodicLbl, gridBagConstraints);
        changeLbl.setFont(new Font("Dialog", 1, 12));
        changeLbl.setText("Change Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        eventsPanel.add((Component)changeLbl, gridBagConstraints);
        archiveLbl.setFont(new Font("Dialog", 1, 12));
        archiveLbl.setText("Archive Event:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        eventsPanel.add((Component)archiveLbl, gridBagConstraints);
        periodLbl.setFont(new Font("Dialog", 1, 12));
        periodLbl.setText("Period:");
        periodLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        eventsPanel.add((Component)periodLbl, gridBagConstraints);
        absChangeLbl.setFont(new Font("Dialog", 1, 12));
        absChangeLbl.setText("Absolute:");
        absChangeLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        eventsPanel.add((Component)absChangeLbl, gridBagConstraints);
        relativeChangeLbl.setFont(new Font("Dialog", 1, 12));
        relativeChangeLbl.setText("Relative:");
        relativeChangeLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        eventsPanel.add((Component)relativeChangeLbl, gridBagConstraints);
        periodArchiveLbl.setFont(new Font("Dialog", 1, 12));
        periodArchiveLbl.setText("Period:");
        periodArchiveLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        eventsPanel.add((Component)periodArchiveLbl, gridBagConstraints);
        relativeArchiveLbl.setFont(new Font("Dialog", 1, 12));
        relativeArchiveLbl.setText("Relative:");
        relativeArchiveLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        eventsPanel.add((Component)relativeArchiveLbl, gridBagConstraints);
        absArchiveLbl.setFont(new Font("Dialog", 1, 12));
        absArchiveLbl.setText("Absolute:");
        absArchiveLbl.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 10, 0);
        eventsPanel.add((Component)absArchiveLbl, gridBagConstraints);
        this.evPeriodTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        eventsPanel.add((Component)this.evPeriodTxt, gridBagConstraints);
        this.evRelChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        eventsPanel.add((Component)this.evRelChangeTxt, gridBagConstraints);
        this.evAbsChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        eventsPanel.add((Component)this.evAbsChangeTxt, gridBagConstraints);
        this.evArchPeriodTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        eventsPanel.add((Component)this.evArchPeriodTxt, gridBagConstraints);
        this.evArchRelChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        eventsPanel.add((Component)this.evArchRelChangeTxt, gridBagConstraints);
        this.evArchAbsChangeTxt.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 10, 0);
        eventsPanel.add((Component)this.evArchAbsChangeTxt, gridBagConstraints);
        dummyLbl.setFont(new Font("Dialog", 1, 18));
        dummyLbl.setText("           ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        eventsPanel.add((Component)dummyLbl, gridBagConstraints);
        pushEventsLbl.setFont(new Font("Dialog", 1, 14));
        pushEventsLbl.setText("Pushed Events:");
        pushEventsLbl.setToolTipText("Events pushed by user code.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        eventsPanel.add((Component)pushEventsLbl, gridBagConstraints);
        this.changeEvtCode.setFont(new Font("Dialog", 1, 12));
        this.changeEvtCode.setText("Change Event");
        this.changeEvtCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.changeEvtCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        eventsPanel.add((Component)this.changeEvtCode, gridBagConstraints);
        this.changeEvtChecked.setFont(new Font("Dialog", 1, 12));
        this.changeEvtChecked.setText("Criteria managed by library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        eventsPanel.add((Component)this.changeEvtChecked, gridBagConstraints);
        this.archiveEvtCode.setFont(new Font("Dialog", 1, 12));
        this.archiveEvtCode.setText("Archive Event");
        this.archiveEvtCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeDialog.this.archiveEvtCodeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        eventsPanel.add((Component)this.archiveEvtCode, gridBagConstraints);
        this.archiveEvtChecked.setFont(new Font("Dialog", 1, 12));
        this.archiveEvtChecked.setText("Criteria managed by library");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 10);
        eventsPanel.add((Component)this.archiveEvtChecked, gridBagConstraints);
        this.dataReadyEvtCode.setFont(new Font("Dialog", 1, 12));
        this.dataReadyEvtCode.setText("Data Ready Event");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        eventsPanel.add((Component)this.dataReadyEvtCode, gridBagConstraints);
        jLabel1.setText(" ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        eventsPanel.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText(" ms");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 21;
        eventsPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText(" %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 22;
        eventsPanel.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText(" %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        eventsPanel.add((Component)jLabel4, gridBagConstraints);
        tabbedPane.addTab("Events", null, eventsPanel, "Event parameters");
        eventsPanel.getAccessibleContext().setAccessibleDescription("Event parameters");
        this.getContentPane().add((Component)tabbedPane, "Center");
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        String message = null;
        String name = this.nameText.getText();
        try {
            boolean overload = this.overloadBtn.getSelectedObjects() != null;
            name = Utils.checkNameSyntax(name, false);
            if (this.pogo_gui.itemAlreadyExists(name, 3)) {
                Except.throw_exception("AttributeExists", "Attribute \"" + name + "\" Already Exists !", "AttributeDislaog.okBtnActionPerformed()");
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, e);
            return;
        }
        this.nameText.setText(name);
        int attrType = this.attrTypeCB.getSelectedIndex();
        block2 : switch (attrType) {
            case 0: {
                String associatedAttribute;
                if (!this.rwTypeCB.getSelectedItem().equals("READ_WITH_WRITE") || (associatedAttribute = this.assAttrTF.getText()).length() != 0) break;
                message = "READ_WITH_WRITE  attribute must have an associated attribute";
                break;
            }
            case 1: {
                switch (this.checkIntField(this.xDataTF.getText())) {
                    case -1: {
                        message = "Spectrum Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        message = "Spectrum Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for X length !";
                    }
                }
                break;
            }
            case 2: {
                switch (this.checkIntField(this.xDataTF.getText())) {
                    case -1: {
                        message = "Image Attribute needs an X length of data";
                        break;
                    }
                    case -2: {
                        message = "Image Attribute needs a POSITIVE X length of data";
                        break;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for X length !";
                    }
                }
                switch (this.checkIntField(this.yDataTF.getText())) {
                    case -1: {
                        message = "Image Attribute needs an Y length of data";
                        break block2;
                    }
                    case -2: {
                        message = "Image Attribute needs a POSITIVE Y length of data";
                        break block2;
                    }
                    case -3: {
                        message = "Cannot parse an integer value for Y length !";
                    }
                }
            }
        }
        if (this.polledBtn.getSelectedObjects() != null) {
            String strval = this.periodText.getText();
            try {
                this.poll_period = Integer.parseInt(strval);
                if (this.poll_period < 20 && this.poll_period != 0) {
                    message = "The polling period minimum value is  20 ms";
                }
            }
            catch (NumberFormatException e) {
                message = String.valueOf(e.toString()) + "\n\nBad Value in Polling period field !";
            }
        }
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Error Window", 0);
        } else {
            this.doClose(0);
        }
    }

    private void rwTypeCBActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            this.updateWindow();
        }
    }

    private void dataTypeCBActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            this.updateWindow();
        }
    }

    private void attrTypeCBActionPerformed(ActionEvent evt) {
        if (this.isVisible()) {
            this.updateWindow();
        }
        if (this.rwTypeCB.getItemCount() == 0) {
            return;
        }
        String item = "Tango::" + AttrRWtypeArray[AttrRWtypeArray.length - 1];
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                if (this.rwTypeCB.getItemCount() >= AttrRWtypeArray.length) break;
                this.rwTypeCB.addItem(item);
                break;
            }
            default: {
                if (this.rwTypeCB.getItemCount() < AttrRWtypeArray.length) break;
                this.rwTypeCB.removeItem(item);
            }
        }
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose(2);
    }

    private int checkIntField(String s) {
        int value;
        block6: {
            block5: {
                int end = s.indexOf(46);
                if (end >= 0) {
                    s = s.substring(0, end);
                }
                try {
                    if (s.length() != 0) break block5;
                    return -1;
                }
                catch (NumberFormatException e) {
                    return -3;
                }
            }
            value = Integer.parseInt(s);
            if (value >= 0) break block6;
            return -2;
        }
        return value;
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(2);
    }

    private void abstractBtnActionPerformed(ActionEvent evt) {
    }

    private void overloadBtnActionPerformed(ActionEvent evt) {
    }

    private void tabbedPaneStateChanged(ChangeEvent evt) {
        JTabbedPane tabbedPane = (JTabbedPane)evt.getSource();
        int panelIndex = tabbedPane.getSelectedIndex();
        if (panelIndex == 2) {
            boolean inherited;
            String attributeName = this.nameText.getText();
            this.evTitleLbl.setText("Attribute " + attributeName);
            boolean bl = inherited = this.attribute != null && this.attribute.getStatus() != null && Utils.isTrue(this.attribute.getStatus().getInherited());
            if (!inherited) {
                String dataType = (String)this.dataTypeCB.getSelectedItem();
                boolean judicious = !dataType.contains("String") && !dataType.contains("Boolean") && !dataType.contains("State");
                this.evRelChangeTxt.setEnabled(judicious);
                this.evAbsChangeTxt.setEnabled(judicious);
                this.evArchRelChangeTxt.setEnabled(judicious);
                this.evArchAbsChangeTxt.setEnabled(judicious);
                if (!judicious) {
                    this.evRelChangeTxt.setText("");
                    this.evAbsChangeTxt.setText("");
                    this.evArchRelChangeTxt.setText("");
                    this.evArchAbsChangeTxt.setText("");
                }
            }
        }
    }

    private void changeEvtCodeActionPerformed(ActionEvent evt) {
        boolean judicious;
        String dataType = (String)this.dataTypeCB.getSelectedItem();
        boolean bl = judicious = !dataType.contains("String") && !dataType.contains("Boolean") && !dataType.contains("State");
        if (judicious) {
            this.changeEvtChecked.setVisible(this.changeEvtCode.getSelectedObjects() != null);
            this.pack();
        } else {
            this.changeEvtChecked.setSelected(false);
        }
    }

    private void archiveEvtCodeActionPerformed(ActionEvent evt) {
        boolean judicious;
        String dataType = (String)this.dataTypeCB.getSelectedItem();
        boolean bl = judicious = !dataType.contains("String") && !dataType.contains("Boolean") && !dataType.contains("State");
        if (judicious) {
            this.archiveEvtChecked.setVisible(this.archiveEvtCode.getSelectedObjects() != null);
            this.pack();
        } else {
            this.archiveEvtChecked.setSelected(false);
        }
    }

    private void doClose(int retStatus) {
        this.retVal = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    private void setDescriptionText(String desc) {
        String text = Utils.strReplace(desc, "\\n", "\n");
        text = Utils.strReplaceSpecialCharToDisplay(text);
        this.attrPropDescription.setText(text);
    }

    private void initializeWindow() {
        FireEvents dataReadyEvents;
        FireEvents archiveEvents;
        FireEvents changeEvents;
        EventCriteria archiveEventCriteria;
        EventCriteria eventCriteria;
        String s;
        if (this.attribute == null) {
            return;
        }
        this.nameText.setText(this.attribute.getName());
        this.xDataTF.setText(this.attribute.getMaxX());
        this.yDataTF.setText(this.attribute.getMaxY());
        this.assAttrTF.setText(this.attribute.getAssociatedAttr());
        this.attrTypeCB.setSelectedItem(this.attribute.getAttType());
        this.rwTypeCB.setSelectedItem(this.attribute.getRwType());
        this.allocateBtn.setVisible(this.rwTypeCB.getSelectedIndex() != 1);
        this.allocateBtn.setSelected(Utils.isTrue(this.attribute.getAllocReadMember()));
        String dataType = OAWutils.pogo2tangoType(this.attribute.getDataType().toString());
        if (dataType.equals("State")) {
            dataType = "DevState";
        }
        int i = 0;
        while (i < this.dataTypeCB.getItemCount()) {
            String type = (String)this.dataTypeCB.getItemAt(i);
            if (type.equals(dataType)) {
                this.dataTypeCB.setSelectedIndex(i);
            }
            ++i;
        }
        AttrProperties prop = this.attribute.getProperties();
        if (prop != null) {
            String desc = Utils.strReplaceSpecialCharToCode(prop.getDescription());
            this.setDescriptionText(desc);
            this.attrPropLabel.setText(prop.getLabel());
            this.attrPropUnit.setText(prop.getUnit());
            this.attrPropStdUnit.setText(prop.getStandardUnit());
            this.attrPropDispUnit.setText(prop.getDisplayUnit());
            this.attrPropFormat.setText(prop.getFormat());
            this.attrPropMaxValue.setText(prop.getMaxValue());
            this.attrPropMinValue.setText(prop.getMinValue());
            this.attrPropMaxAlarm.setText(prop.getMaxAlarm());
            this.attrPropMinAlarm.setText(prop.getMinAlarm());
            this.attrPropMaxWarning.setText(prop.getMaxWarning());
            this.attrPropMinWarning.setText(prop.getMinWarning());
            this.attrPropDeltaTime.setText(prop.getDeltaTime());
            this.attrPropDeltaValue.setText(prop.getDeltaValue());
        }
        this.updateWindow();
        if (this.attribute.getDisplayLevel() != null && this.attribute.getDisplayLevel().equals(PogoConst.strLevel[1])) {
            this.levelBtn.setSelected(true);
        }
        this.setPeriodEnabled(false);
        String strPeriod = this.attribute.getPolledPeriod();
        if (strPeriod != null && strPeriod.length() > 0) {
            try {
                int period = Integer.parseInt(strPeriod);
                if (period > 0) {
                    this.polledBtn.setSelected(true);
                    this.poll_period = period;
                    this.setPeriodEnabled(true);
                }
            }
            catch (NumberFormatException e) {
                System.err.println(e);
            }
        }
        if ((this.attribute.getRwType().equals(AttrRWtypeArray[2]) || this.attribute.getRwType().equals(AttrRWtypeArray[1])) && (s = this.attribute.getMemorized()) != null && s.equals("true")) {
            this.memorizedBtn.setSelected(true);
            this.memorizedInitBtn.setVisible(true);
            s = this.attribute.getMemorizedAtInit();
            if (s != null && s.equals("true")) {
                this.memorizedInitBtn.setSelected(true);
            }
        }
        if ((eventCriteria = this.attribute.getEventCriteria()) != null) {
            if (eventCriteria.getPeriod() != null) {
                this.evPeriodTxt.setText(eventCriteria.getPeriod());
            }
            if (eventCriteria.getRelChange() != null) {
                this.evRelChangeTxt.setText(eventCriteria.getRelChange());
            }
            if (eventCriteria.getAbsChange() != null) {
                this.evAbsChangeTxt.setText(eventCriteria.getAbsChange());
            }
        }
        if ((archiveEventCriteria = this.attribute.getEvArchiveCriteria()) != null) {
            if (archiveEventCriteria.getPeriod() != null) {
                this.evArchPeriodTxt.setText(archiveEventCriteria.getPeriod());
            }
            if (archiveEventCriteria.getRelChange() != null) {
                this.evArchRelChangeTxt.setText(archiveEventCriteria.getRelChange());
            }
            if (archiveEventCriteria.getAbsChange() != null) {
                this.evArchAbsChangeTxt.setText(archiveEventCriteria.getAbsChange());
            }
        }
        if ((changeEvents = this.attribute.getChangeEvent()) != null) {
            this.changeEvtCode.setSelected(Utils.isTrue(changeEvents.getFire()));
            this.changeEvtChecked.setVisible(Utils.isTrue(changeEvents.getFire()));
            this.changeEvtChecked.setSelected(Utils.isTrue(changeEvents.getLibCheckCriteria()));
        }
        if ((archiveEvents = this.attribute.getArchiveEvent()) != null) {
            this.archiveEvtCode.setSelected(Utils.isTrue(archiveEvents.getFire()));
            this.archiveEvtChecked.setVisible(Utils.isTrue(archiveEvents.getFire()));
            this.archiveEvtChecked.setSelected(Utils.isTrue(archiveEvents.getLibCheckCriteria()));
        }
        if ((dataReadyEvents = this.attribute.getDataReadyEvent()) != null) {
            this.dataReadyEvtCode.setSelected(Utils.isTrue(dataReadyEvents.getFire()));
        }
        if (this.isDynamic) {
            this.abstractBtn.setVisible(false);
            this.overloadBtn.setVisible(false);
        }
        this.dynamicLbl.setVisible(this.isDynamic);
    }

    public Attribute getAttribute() {
        Attribute attr = OAWutils.factory.createAttribute();
        attr.setName(this.nameText.getText().trim());
        String attType = (String)this.attrTypeCB.getSelectedItem();
        attr.setAttType(attType);
        attr.setRwType((String)this.rwTypeCB.getSelectedItem());
        if (this.rwTypeCB.getSelectedItem().equals("READ_WITH_WRITE")) {
            attr.setAssociatedAttr(this.assAttrTF.getText().trim());
        }
        String tangoDataType = (String)this.dataTypeCB.getSelectedItem();
        Type pogoDataType = OAWutils.tango2pogoType(tangoDataType);
        attr.setDataType(pogoDataType);
        attr.setMaxX(this.xDataTF.getText().trim());
        attr.setMaxY(this.yDataTF.getText().trim());
        AttrProperties prop = OAWutils.factory.createAttrProperties();
        prop.setDescription(this.attrPropDescription.getText());
        prop.setLabel(this.attrPropLabel.getText().trim());
        prop.setUnit(this.attrPropUnit.getText().trim());
        prop.setStandardUnit(this.attrPropStdUnit.getText().trim());
        prop.setDisplayUnit(this.attrPropDispUnit.getText().trim());
        prop.setFormat(this.attrPropFormat.getText().trim());
        prop.setMaxValue(this.attrPropMaxValue.getText().trim());
        prop.setMinValue(this.attrPropMinValue.getText().trim());
        prop.setMaxAlarm(this.attrPropMaxAlarm.getText().trim());
        prop.setMinAlarm(this.attrPropMinAlarm.getText().trim());
        prop.setMaxWarning(this.attrPropMaxWarning.getText().trim());
        prop.setMinWarning(this.attrPropMinWarning.getText().trim());
        prop.setDeltaTime(this.attrPropDeltaTime.getText().trim());
        prop.setDeltaValue(this.attrPropDeltaValue.getText().trim());
        attr.setProperties(prop);
        if (this.polledBtn.getSelectedObjects() != null) {
            attr.setPolledPeriod(this.periodText.getText().trim());
        } else {
            attr.setPolledPeriod("0");
        }
        if (this.levelBtn.getSelectedObjects() != null) {
            attr.setDisplayLevel(PogoConst.strLevel[1]);
        }
        if ((attr.getRwType().equals(AttrRWtypeArray[2]) || attr.getRwType().equals(AttrRWtypeArray[1])) && this.memorizedBtn.getSelectedObjects() != null) {
            attr.setMemorized("true");
            if (this.memorizedInitBtn.getSelectedObjects() != null) {
                attr.setMemorizedAtInit("true");
            }
        }
        if (this.isDynamic) {
            attr.setIsDynamic("true");
        } else {
            attr.setIsDynamic("false");
            if (Utils.isTrue(this.orig_status.getInherited())) {
                if (this.overloadBtn.getSelectedObjects() != null) {
                    this.orig_status.setConcreteHere("true");
                } else {
                    this.orig_status.setConcreteHere("false");
                }
            } else if (this.abstractBtn.getSelectedObjects() != null) {
                this.orig_status.setAbstract("true");
                this.orig_status.setConcrete("false");
                this.orig_status.setConcreteHere("false");
            } else {
                this.orig_status.setAbstract("false");
                this.orig_status.setConcrete("true");
                this.orig_status.setConcreteHere("true");
            }
        }
        attr.setStatus(this.orig_status);
        if (this.allocateBtn.getSelectedObjects() != null) {
            if (attr.getRwType().equals(AttrRWtypeArray[1])) {
                attr.setAllocReadMember("false");
            } else {
                attr.setAllocReadMember("true");
            }
        } else {
            attr.setAllocReadMember("false");
        }
        EventCriteria eventCriteria = OAWutils.factory.createEventCriteria();
        eventCriteria.setPeriod(this.evPeriodTxt.getText());
        eventCriteria.setRelChange(this.evRelChangeTxt.getText());
        eventCriteria.setAbsChange(this.evAbsChangeTxt.getText());
        attr.setEventCriteria(eventCriteria);
        EventCriteria archiveEventCriteria = OAWutils.factory.createEventCriteria();
        archiveEventCriteria.setPeriod(this.evArchPeriodTxt.getText());
        archiveEventCriteria.setRelChange(this.evArchRelChangeTxt.getText());
        archiveEventCriteria.setAbsChange(this.evArchAbsChangeTxt.getText());
        attr.setEvArchiveCriteria(archiveEventCriteria);
        FireEvents changeEvents = OAWutils.factory.createFireEvents();
        changeEvents.setFire(Utils.strBoolean(this.changeEvtCode.getSelectedObjects() != null));
        changeEvents.setLibCheckCriteria(Utils.strBoolean(this.changeEvtChecked.getSelectedObjects() != null));
        attr.setChangeEvent(changeEvents);
        FireEvents archiveEvents = OAWutils.factory.createFireEvents();
        archiveEvents.setFire(Utils.strBoolean(this.archiveEvtCode.getSelectedObjects() != null));
        archiveEvents.setLibCheckCriteria(Utils.strBoolean(this.archiveEvtChecked.getSelectedObjects() != null));
        attr.setArchiveEvent(archiveEvents);
        FireEvents dataReadyEvents = OAWutils.factory.createFireEvents();
        dataReadyEvents.setFire(Utils.strBoolean(this.dataReadyEvtCode.getSelectedObjects() != null));
        dataReadyEvents.setLibCheckCriteria("true");
        attr.setDataReadyEvent(dataReadyEvents);
        return attr;
    }

    public static Attribute cloneAttribute(Attribute srcAttribute) {
        Attribute newAttribute = OAWutils.cloneAttribute(srcAttribute);
        InheritanceStatus inher_status = newAttribute.getStatus();
        if (!Utils.isTrue(inher_status.getAbstract())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        if (Utils.isTrue(inher_status.getInherited())) {
            inher_status.setAbstract("false");
            inher_status.setInherited("false");
            inher_status.setConcrete("true");
            inher_status.setConcreteHere("true");
        }
        newAttribute.setStatus(inher_status);
        return newAttribute;
    }

    private void updateWindow() {
        this.xDataTF.setVisible(false);
        this.yDataTF.setVisible(false);
        this.xDataLBL.setVisible(false);
        this.yDataLBL.setVisible(false);
        this.assAttrTF.setVisible(false);
        this.assAttrLBL.setVisible(false);
        this.memorizedBtn.setVisible(false);
        this.memorizedInitBtn.setVisible(false);
        String dataType = this.dataTypeCB.getSelectedItem().toString();
        if (dataType.equals("DevEncoded")) {
            this.attrTypeCB.setSelectedIndex(0);
        }
        switch (this.attrTypeCB.getSelectedIndex()) {
            case 0: {
                switch (this.rwTypeCB.getSelectedIndex()) {
                    case 3: {
                        this.assAttrTF.setVisible(true);
                        this.assAttrLBL.setVisible(true);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.memorizedBtn == null) break;
                        this.memorizedBtn.setVisible(true);
                        this.memorizedInitBtn.setVisible(false);
                    }
                }
                break;
            }
            case 1: {
                this.xDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                break;
            }
            case 2: {
                this.xDataTF.setVisible(true);
                this.yDataTF.setVisible(true);
                this.xDataLBL.setVisible(true);
                this.yDataLBL.setVisible(true);
            }
        }
        if (dataType.equals("Tango::DEV_ENCODED")) {
            this.memorizedBtn.setSelected(false);
            this.memorizedBtn.setVisible(false);
            this.memorizedInitBtn.setVisible(false);
        }
        this.allocateBtn.setVisible(this.rwTypeCB.getSelectedIndex() != 1);
        this.pack();
    }

    public static void popupSummary(JFrame parent, ArrayList<Attribute> va) {
        ArrayList<ArrayList<String>> summary = AttributeDialog.buildSummary(va);
        String title = String.valueOf(Integer.toString(va.size())) + "  Attributes";
        PopupTable ppt = new PopupTable(parent, title, columnTitle, summary);
        int nb = va.size();
        if (nb > 35) {
            nb = 35;
        }
        ppt.setPreferredSize(columnSize, nb);
        ppt.setVisible(true);
    }

    private static ArrayList<ArrayList<String>> buildSummary(ArrayList<Attribute> va) {
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>();
        for (Attribute attribute : va) {
            ArrayList<String> line = new ArrayList<String>();
            line.add(attribute.getName());
            line.add(attribute.getAttType());
            line.add(OAWutils.pogo2tangoType(attribute.getDataType().toString()));
            if (attribute.getAttType().equals("Scalar")) {
                line.add("1");
            } else if (attribute.getAttType().equals("Spectrum")) {
                line.add(attribute.getMaxX());
            } else if (attribute.getAttType().equals("Image")) {
                line.add(String.valueOf(attribute.getMaxX()) + " x " + attribute.getMaxY());
            }
            String level = attribute.getDisplayLevel();
            if (level == null || level.length() == 0) {
                level = "OPERATOR";
            }
            line.add(level);
            InheritanceStatus status = attribute.getStatus();
            line.add(Utils.strBoolean(status.getInherited()));
            boolean concreate = Utils.isTrue(status.getConcrete()) || Utils.isTrue(status.getConcreteHere());
            line.add("" + !concreate);
            AttrProperties prop = attribute.getProperties();
            line.add(Utils.strReplace(prop.getDescription(), "\\n", "\n"));
            result.add(line);
        }
        return result;
    }
}

