/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;

public class AdditionalFilesDialog
extends JDialog {
    private String path;
    private String fileExtension;
    private EList<AdditionalFile> fileList;
    private int returnValue = 2;
    private JList additionalList;
    private JScrollPane listScrollPane;
    private JButton removeBtn;

    public AdditionalFilesDialog(JFrame parent, EList<AdditionalFile> fileList, String path, String fileExtension) {
        super((Frame)parent, true);
        this.fileList = fileList;
        this.path = path;
        this.fileExtension = fileExtension;
        this.initForm();
    }

    public AdditionalFilesDialog(JDialog parent, EList<AdditionalFile> fileList, String path, String fileExtension) {
        super((Dialog)parent, true);
        this.fileList = fileList;
        this.path = path;
        this.fileExtension = fileExtension;
        this.initForm();
    }

    private void initForm() {
        this.initComponents();
        this.fillJList();
        this.additionalList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AdditionalFilesDialog.this.listSelectionPerformed(e);
            }
        });
        this.removeBtn.setEnabled(false);
        if (this.fileList.size() == 0) {
            this.listScrollPane.setPreferredSize(new Dimension(500, 50));
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void fillJList() {
        this.additionalList.removeAll();
        Vector<String> strList = new Vector<String>();
        for (AdditionalFile file : this.fileList) {
            strList.add(String.valueOf(file.getPath()) + "/" + file.getName() + "." + this.fileExtension);
        }
        this.additionalList.setListData(strList);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cnacelBtn = new JButton();
        this.listScrollPane = new JScrollPane();
        this.additionalList = new JList();
        JPanel rightPanel = new JPanel();
        JButton addBtn = new JButton();
        this.removeBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AdditionalFilesDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Programmer's  Additional  files");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalFilesDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cnacelBtn.setText("Cancel");
        cnacelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalFilesDialog.this.cnacelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cnacelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.listScrollPane.setViewportView(this.additionalList);
        this.getContentPane().add((Component)this.listScrollPane, "Center");
        rightPanel.setLayout(new GridBagLayout());
        addBtn.setText("Add File");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalFilesDialog.this.addBtnActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        rightPanel.add((Component)addBtn, gridBagConstraints);
        this.removeBtn.setText("Remove");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdditionalFilesDialog.this.removeBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        rightPanel.add((Component)this.removeBtn, gridBagConstraints);
        this.getContentPane().add((Component)rightPanel, "After");
        this.pack();
    }

    private void listSelectionPerformed(MouseEvent evt) {
        this.removeBtn.setEnabled(true);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 0;
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    private void addBtnActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser(this.path);
        PogoFileFilter filter = new PogoFileFilter(this.fileExtension, "Additional Code Files");
        chooser.setFileFilter(filter);
        int retval = chooser.showOpenDialog(this);
        if (retval == 0 && (file = chooser.getSelectedFile()) != null && !file.isDirectory()) {
            String name = file.getName();
            String path = file.getAbsolutePath();
            int pos = name.lastIndexOf(".");
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            AdditionalFile addFile = OAWutils.factory.createAdditionalFile();
            addFile.setName(name);
            addFile.setPath(path);
            this.fileList.add(addFile);
            this.fillJList();
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        String item = (String)this.additionalList.getSelectedValue();
        if (JOptionPane.showConfirmDialog(this, "Remove  " + item + " ?", "Confirmation Window", 0) == 0) {
            int idx = this.additionalList.getSelectedIndex();
            this.fileList.remove(idx);
            this.fillJList();
            this.removeBtn.setEnabled(false);
        }
    }

    private void cnacelBtnActionPerformed(ActionEvent evt) {
        this.returnValue = 2;
        this.doClose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

