/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import org.jacorb.notification.util.PatternWrapper;

class EntryList {
    private static final char WILDCARD_CHAR = '*';
    private static final int DEFAULT_INITIAL_SIZE = 2;
    private PatternWrapper myPattern_;
    final char[] key_;
    private final int start_;
    int end_;
    private final int depth_;
    private int splitted = 0;
    private MapEntry myEntry_;
    private EntryList[] entries_;

    EntryList(int n) {
        this(null, 0, 0, 0, null, n);
    }

    private EntryList(char[] cArray, int n, int n2, int n3, MapEntry mapEntry2) {
        this(cArray, n, n2, n3, mapEntry2, 2);
    }

    private EntryList(char[] cArray, int n, int n2, int n3, MapEntry mapEntry2, int n4) {
        this.myEntry_ = mapEntry2;
        this.key_ = cArray;
        this.end_ = n2;
        this.start_ = n;
        this.depth_ = n3;
        this.entries_ = new EntryList[n4];
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private boolean hasEntry() {
        return this.myEntry_ != null;
    }

    void clear() {
        this.entries_ = new EntryList[2];
    }

    Object put(char[] cArray, int n, int n2, Object object) {
        return this.put(new MapEntry(cArray, n, n2, object));
    }

    private Object put(MapEntry mapEntry2) {
        char c2 = mapEntry2.key_[0];
        this.ensureIndexIsAvailable(c2);
        int n = this.computeHashIndex(c2);
        if (this.entries_[n] == null) {
            this.entries_[n] = new EntryList(mapEntry2.key_, 0, mapEntry2.key_.length, 0, mapEntry2);
            return null;
        }
        return this.entries_[n].put(mapEntry2.key_, 0, mapEntry2.key_.length, 0, mapEntry2, false);
    }

    Object put(char[] cArray, int n, int n2, int n3, MapEntry mapEntry2, boolean bl) {
        int n4 = n2 - n;
        int n5 = this.end_ - this.start_;
        int n6 = this.findCommonPrefix(cArray, n, n2);
        if (n6 == n4) {
            if (this.endsWithStar()) {
                EntryList.splitEntryList(this, n6);
            }
            Object object = null;
            if (this.myEntry_ != null) {
                object = this.myEntry_.value_;
            }
            this.myEntry_ = mapEntry2;
            return object;
        }
        if (n6 < n5) {
            EntryList.splitEntryList(this, n6);
            boolean bl2 = false;
            if (this.endsWithStar()) {
                bl2 = true;
            }
            this.put(cArray, n, n2, n3 + n6, mapEntry2, bl2);
        } else {
            char c2 = cArray[n + n6];
            this.ensureIndexIsAvailable(c2);
            int n7 = this.computeHashIndex(c2);
            if (this.entries_[n7] == null) {
                this.entries_[n7] = new EntryList(cArray, n + n6, n2, this.depth_ + n6, mapEntry2);
                if (bl) {
                    this.entries_[n7].addLeadingStar();
                }
            } else {
                this.entries_[n7].put(cArray, n + n6, n2, n3 + n6, mapEntry2, false);
            }
        }
        return null;
    }

    Object getSingle(char[] cArray, int n, int n2) {
        EntryList entryList = this.lookup(cArray[n]);
        int n3 = n;
        while (entryList != null) {
            int n4 = n2 - n3;
            int n5 = entryList.compare(cArray, n + entryList.depth_, n + entryList.depth_ + n4, false);
            if (n5 == n4) {
                return entryList.myEntry_.value_;
            }
            if (n5 <= 0) continue;
            char c2 = cArray[n + entryList.depth_ + n5];
            int n6 = entryList.depth_;
            if ((entryList = entryList.lookup(c2)) == null) continue;
            n3 += entryList.depth_ - n6;
        }
        return null;
    }

    private boolean endsWithStar() {
        return this.key_[this.end_ - 1] == '*';
    }

    Object[] getMultiple(char[] cArray, int n, int n2) {
        ArrayList<Cursor> arrayList = new ArrayList<Cursor>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        EntryList entryList = this.lookup(cArray[n]);
        if (entryList != null) {
            arrayList.add(new Cursor(n, entryList));
        }
        if ((entryList = this.lookup('*')) != null) {
            Cursor cursor = new Cursor(n, entryList);
            arrayList.add(cursor);
        }
        while (!arrayList.isEmpty()) {
            char c2;
            Cursor cursor = (Cursor)arrayList.get(0);
            int n3 = n2 - cursor.cursor_;
            int n4 = cursor.list_.compare(cArray, n + cursor.list_.depth_, n + cursor.list_.depth_ + n3, true);
            if (n4 >= n3) {
                if (cursor.list_.hasEntry()) {
                    arrayList2.add(cursor.list_.myEntry_.value_);
                }
                if (n3 > 0 && cursor.list_.endsWithStar()) {
                    for (c2 = '\u0000'; c2 < cursor.list_.entries_.length; ++c2) {
                        if (cursor.list_.entries_[c2] == null) continue;
                        arrayList.add(new Cursor(cursor.list_.depth_ + 1, cursor.list_.entries_[c2]));
                    }
                }
                if (cursor.list_.lookup('*') != null) {
                    cursor.list_ = cursor.list_.lookup('*');
                    cursor.cursor_ += n4;
                    continue;
                }
                arrayList.remove(0);
                continue;
            }
            if (n4 > 0) {
                c2 = cArray[n + cursor.list_.depth_ + n4];
                int n5 = cursor.list_.depth_;
                if (cursor.list_.lookup('*') != null) {
                    EntryList entryList2 = cursor.list_.lookup('*');
                    arrayList.add(new Cursor(cursor.cursor_ + entryList2.depth_ - n5, entryList2));
                }
                if ((cursor.list_ = cursor.list_.lookup(c2)) != null) {
                    cursor.cursor_ += cursor.list_.depth_ - n5;
                    continue;
                }
                arrayList.remove(0);
                continue;
            }
            arrayList.remove(0);
        }
        return arrayList2.toArray();
    }

    Object remove(char[] cArray, int n, int n2) {
        return EntryList.remove(this, cArray, n, n2);
    }

    private static Object remove(EntryList entryList, char[] cArray, int n, int n2) {
        int n3;
        char c2;
        int n4 = n;
        EntryList entryList2 = entryList;
        do {
            if ((n4 += (n3 = EntryList.findCommonPrefix(cArray, n4, n2, entryList2.key_, entryList2.start_, entryList2.end_))) != n2) continue;
            Object object = null;
            if (entryList2.myEntry_ != null) {
                object = entryList2.myEntry_.value_;
                entryList2.myEntry_ = null;
            }
            return object;
        } while ((entryList2 = entryList2.lookup(c2 = cArray[n + n3])) != null);
        return null;
    }

    private void addLeadingStar() {
        int n = this.end_ - this.start_ + 1;
        char[] cArray = new char[n];
        System.arraycopy(this.key_, this.start_, cArray, 1, this.end_ - this.start_);
        cArray[0] = 42;
        this.initPattern(cArray, 0, n);
    }

    private void initPattern() {
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private void initPattern(char[] cArray, int n, int n2) {
        this.myPattern_ = null;
        int n3 = EntryList.countStarsInKey(cArray, n, n2);
        if (n3 > 0) {
            char[] cArray2 = new char[n2 - n + n3 + 1];
            cArray2[0] = 94;
            int n4 = 1;
            for (int i = 0; i < n2 - n; ++i) {
                char c2;
                cArray2[i + n4] = c2 = cArray[n + i];
                if (cArray2[i + n4] != '*') continue;
                cArray2[i + n4] = 46;
                cArray2[i + n4 + 1] = 42;
                ++n4;
            }
            String string = new String(cArray2, 0, n2 - n + n3 + 1);
            this.myPattern_ = PatternWrapper.init(string);
        }
    }

    private char key() {
        return this.key_[this.start_];
    }

    private EntryList lookup(char c2) {
        int n = this.computeHashIndex(c2);
        if (this.entries_[n] != null && this.entries_[n].key() == c2) {
            return this.entries_[n];
        }
        return null;
    }

    private void ensureIndexIsAvailable(char c2) {
        int n = this.computeHashIndex(c2);
        while (this.entries_[n] != null && this.entries_[n].key() != c2) {
            this.doubleCapacity();
            n = this.computeHashIndex(c2);
        }
        return;
    }

    private void doubleCapacity() {
        int n = this.entries_.length * 2;
        EntryList[] entryListArray = new EntryList[n];
        for (int i = 0; i < this.entries_.length; ++i) {
            if (this.entries_[i] == null) continue;
            int n2 = EntryList.computeHashIndex(this.entries_[i].key(), n);
            entryListArray[n2] = this.entries_[i];
        }
        this.entries_ = entryListArray;
    }

    private int compare(char[] cArray, int n, int n2, boolean bl) {
        if (bl && this.myPattern_ != null) {
            return EntryList.compareKeyToPattern(cArray, n, n2, this.myPattern_);
        }
        return EntryList.compareKeyToKey(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private int findCommonPrefix(char[] cArray, int n, int n2) {
        return EntryList.findCommonPrefix(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private void printToStringBuffer(StringBuffer stringBuffer, String string) {
        if (this.key_ != null) {
            stringBuffer.append(" --");
            stringBuffer.append(this.key());
            stringBuffer.append("-->\n");
            stringBuffer.append(string);
            stringBuffer.append("depth: ");
            stringBuffer.append(this.depth_);
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("key: ");
            stringBuffer.append(new String(this.key_, this.start_, this.end_ - this.start_));
            stringBuffer.append("\n");
        }
        if (this.myEntry_ != null) {
            stringBuffer.append(string + this.myEntry_);
            stringBuffer.append("\n");
        }
        for (int i = 0; i < this.entries_.length; ++i) {
            stringBuffer.append(string + i);
            stringBuffer.append(":");
            if (this.entries_[i] == null) {
                stringBuffer.append("empty");
            } else {
                this.entries_[i].printToStringBuffer(stringBuffer, string + "   ");
            }
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printToStringBuffer(stringBuffer, "");
        return stringBuffer.toString();
    }

    private static void splitEntryList(EntryList entryList, int n) {
        EntryList entryList2 = new EntryList(entryList.key_, entryList.start_ + n, entryList.end_, entryList.depth_ + n, entryList.myEntry_, entryList.entries_.length);
        System.arraycopy(entryList.entries_, 0, entryList2.entries_, 0, entryList.entries_.length);
        entryList.entries_ = new EntryList[2];
        char c2 = entryList.key_[entryList.start_ + n];
        int n2 = EntryList.computeHashIndex(c2, entryList.entries_.length);
        entryList.entries_[n2] = entryList2;
        entryList.myEntry_ = null;
        ++entryList.splitted;
        entryList.end_ = entryList.start_ + n;
        if (entryList.endsWithStar()) {
            entryList2.addLeadingStar();
        }
        entryList.initPattern();
    }

    private static int computeHashIndex(char c2, int n) {
        return c2 % n;
    }

    private int computeHashIndex(char c2) {
        return EntryList.computeHashIndex(c2, this.entries_.length);
    }

    static int compareKeyToKey(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        int n8 = n6 > n7 ? n7 : n6;
        for (n5 = 0; n5 < n8; ++n5) {
            if (cArray[n + n5] == cArray2[n3 + n5]) continue;
            return n5;
        }
        return n5;
    }

    private static int compareKeyToPattern(char[] cArray, int n, int n2, PatternWrapper patternWrapper) {
        String string = new String(cArray, n, n2 - n);
        return patternWrapper.match(string);
    }

    private static int findCommonPrefix(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n2 - n;
        int n8 = n4 - n3;
        int n9 = n6 = n7 >= n8 ? n8 : n7;
        for (n5 = 0; n5 < n6 && cArray[n] == cArray2[n3]; ++n5) {
            ++n;
            ++n3;
        }
        return n5;
    }

    static int countStarsInKey(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] != '*') continue;
            ++n3;
        }
        return n3;
    }

    private static class MapEntry {
        private final int start_;
        private final int stop_;
        final char[] key_;
        final Object value_;

        MapEntry(char[] cArray, int n, int n2, Object object) {
            this.key_ = cArray;
            this.start_ = n;
            this.stop_ = n2;
            this.value_ = object;
        }

        public int hashCode() {
            return this.key_[this.start_];
        }

        public boolean equals(Object object) {
            try {
                MapEntry mapEntry2 = (MapEntry)object;
                return EntryList.compareKeyToKey(this.key_, this.start_, this.stop_, mapEntry2.key_, mapEntry2.start_, mapEntry2.stop_) > 0;
            }
            catch (ClassCastException classCastException) {
                return super.equals(object);
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("['");
            stringBuffer.append(new String(this.key_, this.start_, this.stop_ - this.start_));
            stringBuffer.append("' => ");
            stringBuffer.append(this.value_);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static class Cursor {
        int cursor_;
        EntryList list_;

        Cursor(int n, EntryList entryList) {
            this.cursor_ = n;
            this.list_ = entryList;
        }

        public String toString() {
            String string = new String(this.list_.key_, this.cursor_, this.list_.end_ - this.cursor_);
            return "Cursor: " + string;
        }
    }
}

