/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfos;
import org.eclipse.xtext.xtext.ecoreInference.ErrorAcceptor;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.UnexpectedClassInfoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHierarchyHelper {
    private final EClassifierInfos infos;
    private final Map<EClassifierInfo.EClassInfo, Set<EClassifierInfo.EClassInfo>> subTypesMap = Maps.newLinkedHashMap();
    private final Set<EClassifierInfo.EClassInfo> rootInfos = Sets.newLinkedHashSet();
    private final Set<EClassifierInfo.EClassInfo> traversedTypes = Sets.newLinkedHashSet();
    private final ErrorAcceptor errorAcceptor;
    private final Grammar grammar;

    public TypeHierarchyHelper(Grammar grammar, EClassifierInfos infos, ErrorAcceptor errorAcceptor) {
        this.grammar = grammar;
        this.infos = infos;
        this.errorAcceptor = errorAcceptor;
        this.collectTypeData();
    }

    private void registerSubType(EClassifierInfo.EClassInfo superType, EClassifierInfo.EClassInfo subType) {
        Set<EClassifierInfo.EClassInfo> subTypes = this.getSubTypesOf(superType);
        subTypes.add(subType);
    }

    private void collectTypeData() {
        for (EClassifierInfo.EClassInfo classInfo : this.infos.getAllEClassInfos()) {
            if (classInfo.getEClass().getESuperTypes().isEmpty()) {
                this.rootInfos.add(classInfo);
            }
            try {
                for (EClassifierInfo.EClassInfo superInfo : this.infos.getSuperTypeInfos(classInfo)) {
                    this.registerSubType(superInfo, classInfo);
                }
            }
            catch (UnexpectedClassInfoException ex) {
                this.reportError(ex.getSuperInfo(), ex.getErrorCode(), "Cannot inherit from DataType " + ex.getInfo().getEClassifier().getName());
            }
        }
    }

    public Set<EClassifierInfo.EClassInfo> getSubTypesOf(EClassifierInfo.EClassInfo info) {
        Set<EClassifierInfo.EClassInfo> result = this.subTypesMap.get(info);
        if (result == null) {
            result = Sets.newLinkedHashSet();
            this.subTypesMap.put(info, result);
        }
        return result;
    }

    public void liftUpFeaturesRecursively(Collection<EClassifierInfo.EClassInfo> infos, Map<EClass, Collection<EStructuralFeature>> featuresToRemove) {
        this.traversedTypes.clear();
        for (EClassifierInfo.EClassInfo info : infos) {
            this.liftUpFeaturesInto(info, featuresToRemove);
        }
    }

    public void liftUpFeaturesInto(EClassifierInfo.EClassInfo superType, Map<EClass, Collection<EStructuralFeature>> featuresToRemove) {
        if (!this.traversedTypes.add(superType)) {
            return;
        }
        Set<EClassifierInfo> subTypes = this.getSubTypesOf(superType);
        if (subTypes.isEmpty()) {
            return;
        }
        for (EClassifierInfo.EClassInfo eClassInfo : subTypes) {
            this.liftUpFeaturesInto(eClassInfo, featuresToRemove);
        }
        if (!superType.isGenerated()) {
            return;
        }
        Set<EClassifierInfo> set = subTypes;
        if (superType.equals(this.infos.getCompatibleTypeOf(set))) {
            Collection<EStructuralFeature> commonFeatures = this.getCommonDirectFeatures(subTypes);
            Collection<EStructuralFeature> liftedFeatures = this.joinFeaturesInto(commonFeatures, superType);
            for (EClassifierInfo.EClassInfo eClassInfo : subTypes) {
                this.removeFeatures(eClassInfo, liftedFeatures, featuresToRemove);
            }
        }
    }

    private void removeFeatures(EClassifierInfo.EClassInfo info, Collection<EStructuralFeature> features, Map<EClass, Collection<EStructuralFeature>> featuresToRemove) {
        EClass clazz = info.getEClass();
        EList<EStructuralFeature> featuresToBeModified = clazz.getEStructuralFeatures();
        LinkedHashSet<EStructuralFeature> removeUs = Sets.newLinkedHashSet();
        for (EStructuralFeature feature : featuresToBeModified) {
            if (info.containsSemanticallyEqualFeature(features, feature) != EClassifierInfo.EClassInfo.FindResult.FeatureExists) continue;
            removeUs.add(feature);
        }
        if (!removeUs.isEmpty()) {
            Collection<EStructuralFeature> prevRemoveUs = featuresToRemove.get(clazz);
            if (prevRemoveUs == null) {
                featuresToRemove.put(clazz, removeUs);
            } else {
                prevRemoveUs.addAll(removeUs);
            }
        }
    }

    private Collection<EStructuralFeature> joinFeaturesInto(Collection<EStructuralFeature> commonFeatures, EClassifierInfo.EClassInfo info) {
        LinkedHashSet<EStructuralFeature> result = Sets.newLinkedHashSet();
        for (EStructuralFeature feature : commonFeatures) {
            EClassifierInfo.EClassInfo.FindResult findResult = info.containsSemanticallyEqualFeature(feature);
            if (findResult == EClassifierInfo.EClassInfo.FindResult.FeatureDoesNotExist) {
                info.addFeature(feature);
                result.add(feature);
                continue;
            }
            if (findResult != EClassifierInfo.EClassInfo.FindResult.FeatureExists) continue;
            result.add(feature);
        }
        return result;
    }

    private Collection<EStructuralFeature> getCommonDirectFeatures(Collection<EClassifierInfo.EClassInfo> infos) {
        Collection<EStructuralFeature> result = Sets.newLinkedHashSet();
        Iterator<EClassifierInfo.EClassInfo> iterator = infos.iterator();
        if (iterator.hasNext()) {
            EClass eClass = iterator.next().getEClass();
            result.addAll(eClass.getEStructuralFeatures());
        }
        while (iterator.hasNext()) {
            result = this.getCommonFeatures(iterator.next(), result);
        }
        return result;
    }

    public Collection<EStructuralFeature> getCommonFeatures(EClassifierInfo.EClassInfo info, Collection<EStructuralFeature> features) {
        LinkedHashSet<EStructuralFeature> result = Sets.newLinkedHashSet();
        for (EStructuralFeature f : features) {
            if (info.containsSemanticallyEqualFeature(f) != EClassifierInfo.EClassInfo.FindResult.FeatureExists) continue;
            EStructuralFeature equalFeature = info.getEClass().getEStructuralFeature(f.getName());
            SourceAdapter otherAdapter = SourceAdapter.find(equalFeature);
            if (otherAdapter != null) {
                for (EObject source : otherAdapter.getSources()) {
                    SourceAdapter.adapt(f, source);
                }
            }
            result.add(f);
        }
        return result;
    }

    public void liftUpFeaturesRecursively() {
        this.traversedTypes.clear();
        LinkedHashMap<EClass, Collection<EStructuralFeature>> featuresToRemove = Maps.newLinkedHashMap();
        this.liftUpFeaturesRecursively(this.rootInfos, featuresToRemove);
        for (Map.Entry entry : featuresToRemove.entrySet()) {
            ((EClass)entry.getKey()).getEStructuralFeatures().removeAll((Collection)entry.getValue());
        }
        this.traversedTypes.clear();
        this.pushFeaturesUp(this.infos.getAllEClassInfos());
    }

    private void pushFeaturesUp(Collection<EClassifierInfo.EClassInfo> infos) {
        LinkedHashSet<EClass> traversedClasses = Sets.newLinkedHashSet();
        for (EClassifierInfo.EClassInfo info : infos) {
            this.pushFeaturesUp(info, traversedClasses);
        }
    }

    private void pushFeaturesUp(EClassifierInfo.EClassInfo info, Collection<EClass> traversedClasses) {
        EClass eClass = info.getEClass();
        if (info.isGenerated() && traversedClasses.add(eClass)) {
            if (eClass.getESuperTypes().isEmpty()) {
                return;
            }
            for (EClass superType : eClass.getESuperTypes()) {
                EClassifierInfo.EClassInfo superInfo = (EClassifierInfo.EClassInfo)this.infos.getInfoOrNull(superType);
                this.pushFeaturesUp(superInfo, traversedClasses);
            }
            LinkedHashMap<String, EStructuralFeature> allFeatures = Maps.newLinkedHashMap();
            LinkedHashSet<String> skippedNames = Sets.newLinkedHashSet();
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (feature.getEContainingClass() == eClass) continue;
                if (allFeatures.containsKey(feature.getName())) {
                    allFeatures.remove(feature.getName());
                    continue;
                }
                if (!skippedNames.add(feature.getName())) continue;
                allFeatures.put(feature.getName(), feature);
            }
            Iterator iter = eClass.getEStructuralFeatures().iterator();
            while (iter.hasNext()) {
                EClassifier compatibleType;
                EStructuralFeature declared = (EStructuralFeature)iter.next();
                EStructuralFeature existing = (EStructuralFeature)allFeatures.get(declared.getName());
                if (existing == null || (compatibleType = EcoreUtil2.getCompatibleType(declared.getEType(), existing.getEType())) == null) continue;
                iter.remove();
                existing.setEType(compatibleType);
            }
        }
    }

    public void removeDuplicateDerivedFeatures() {
        this.removeDuplicateDerivedFeaturesOf(this.infos.getAllEClassInfos());
    }

    private void removeDuplicateDerivedFeaturesOf(Collection<EClassifierInfo.EClassInfo> classInfos) {
        for (EClassifierInfo.EClassInfo classInfo : classInfos) {
            this.removeDuplicateDerivedFeaturesOf(classInfo);
        }
    }

    private void removeDuplicateDerivedFeaturesOf(EClassifierInfo.EClassInfo classInfo) {
        if (!classInfo.isGenerated()) {
            return;
        }
        EList<EStructuralFeature> features = classInfo.getEClass().getEStructuralFeatures();
        Iterator iterator = features.iterator();
        while (iterator.hasNext()) {
            if (!this.anySuperTypeContainsSemanticallyEqualFeature(classInfo, (EStructuralFeature)iterator.next())) continue;
            iterator.remove();
        }
    }

    private boolean anySuperTypeContainsSemanticallyEqualFeature(EClassifierInfo.EClassInfo classInfo, EStructuralFeature feature) {
        LinkedHashSet<EStructuralFeature> allSupertypesFeatures = Sets.newLinkedHashSet();
        for (EClass superType : classInfo.getEClass().getEAllSuperTypes()) {
            allSupertypesFeatures.addAll(superType.getEAllStructuralFeatures());
        }
        return classInfo.containsSemanticallyEqualFeature(allSupertypesFeatures, feature) == EClassifierInfo.EClassInfo.FindResult.FeatureExists;
    }

    private void reportError(EClassifierInfo info, TransformationErrorCode errorCode, String message) {
        if (this.grammar == null) {
            this.reportError(errorCode, message, null);
            return;
        }
        List<TypeRef> typeRefs = EcoreUtil2.getAllContentsOfType(this.grammar, TypeRef.class);
        for (TypeRef typeRef : typeRefs) {
            EClassifierInfo otherInfo = this.infos.getInfo(typeRef);
            if (otherInfo != info) continue;
            this.reportError(errorCode, message, typeRef);
        }
    }

    private void reportError(TransformationErrorCode errorCode, String message, EObject object) {
        this.errorAcceptor.acceptError(errorCode, message, object);
    }
}

