/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xtext.ecoreInference.EClassifierInfo;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.UnexpectedClassInfoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EClassifierInfos {
    private final Map<Triple<String, String, String>, EClassifierInfo> infoMap;
    private final List<EClassifierInfos> parents;
    private final Grammar grammar;

    public List<EClassifierInfos> getParents() {
        return this.parents;
    }

    public EClassifierInfos(Grammar grammar) {
        this.grammar = grammar;
        this.infoMap = Maps.newLinkedHashMap();
        this.parents = Lists.newArrayList();
    }

    public void addParent(EClassifierInfos parent) {
        this.parents.add(parent);
    }

    public boolean addInfo(TypeRef typeRef, EClassifierInfo metatypeInfo) {
        if (typeRef.getMetamodel() == null || typeRef.getClassifier() == null) {
            throw new NullPointerException();
        }
        return this.addInfo(typeRef.getMetamodel(), typeRef.getClassifier().getName(), metatypeInfo);
    }

    public boolean addInfo(AbstractMetamodelDeclaration alias, String name, EClassifierInfo metatypeInfo) {
        return this.infoMap.put(this.getKey(alias, name), metatypeInfo) == null;
    }

    private Triple<String, String, String> getKey(AbstractMetamodelDeclaration metamodelDecl, String name) {
        if (metamodelDecl == null || name == null) {
            throw new NullPointerException("metamodelDecl: " + metamodelDecl + " / name: " + name);
        }
        return Tuples.create(metamodelDecl.getEPackage().getNsURI(), Strings.emptyIfNull(metamodelDecl.getAlias()), name);
    }

    public EClassifierInfo getInfo(TypeRef typeRef) {
        if (typeRef.getClassifier() == null) {
            return null;
        }
        EClassifierInfo result = this.getInfo(typeRef.getMetamodel(), typeRef.getClassifier().getName());
        if (result == null) {
            Grammar declaringGrammar = GrammarUtil.getGrammar(typeRef);
            if (this.grammar.equals(declaringGrammar)) {
                return result;
            }
            for (EClassifierInfos parent : this.parents) {
                result = parent.getInfo(typeRef);
                if (result == null) continue;
                return result;
            }
        }
        return result;
    }

    public EClassifierInfo getInfoOrNull(TypeRef typeRef) {
        EClassifierInfo result = this.getInfo(typeRef);
        if (result != null) {
            return result;
        }
        for (EClassifierInfos parent : this.parents) {
            result = parent.getInfoOrNull(typeRef);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public EClassifierInfo getInfo(AbstractMetamodelDeclaration alias, String name) {
        Triple<String, String, String> key = this.getKey(alias, name);
        return this.getInfo(key);
    }

    private EClassifierInfo getInfo(Triple<String, String, String> qualifiedName) {
        return this.infoMap.get(qualifiedName);
    }

    public EClassifierInfo getInfo(EClassifier eClassifier) {
        for (EClassifierInfo info : this.infoMap.values()) {
            if (!info.getEClassifier().equals(eClassifier)) continue;
            return info;
        }
        throw new NullPointerException("cannot find type info for classifier '" + eClassifier.getName() + "'");
    }

    public EClassifierInfo getInfoOrNull(EClassifier eClassifier) {
        for (EClassifierInfo info : this.infoMap.values()) {
            if (!info.getEClassifier().equals(eClassifier)) continue;
            return info;
        }
        for (EClassifierInfos parent : this.parents) {
            EClassifierInfo result = parent.getInfoOrNull(eClassifier);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private EClassifierInfo getCompatibleType(EClassifierInfo infoA, EClassifierInfo infoB) {
        if (infoA.equals(infoB)) {
            return infoA;
        }
        if (infoA.getEClassifier() instanceof EDataType || infoB.getEClassifier() instanceof EDataType) {
            throw new IllegalArgumentException("Simple Datatypes (lexer rules or keywords) do not have a common supertype (" + infoA + ", " + infoB + ")");
        }
        EClassifier compatibleType = EcoreUtil2.getCompatibleType(infoA.getEClassifier(), infoB.getEClassifier());
        return this.getInfoOrNull(compatibleType);
    }

    public EClassifierInfo getCompatibleTypeOf(Collection<EClassifierInfo> types) {
        Iterator<EClassifierInfo> i = types.iterator();
        if (!i.hasNext()) {
            throw new IllegalArgumentException("Empty set of types cannot have a compatible type.");
        }
        EClassifierInfo result = i.next();
        while (i.hasNext()) {
            result = this.getCompatibleType(result, i.next());
        }
        return result;
    }

    public EClassifier getCompatibleTypeNameOf(Collection<EClassifier> classifiers, boolean useParent) {
        LinkedHashSet<EClassifierInfo> types = Sets.newLinkedHashSet();
        for (EClassifier classifier : classifiers) {
            EClassifierInfo info = this.getInfoOrNull(classifier);
            if (info == null) {
                return null;
            }
            types.add(info);
        }
        EClassifierInfo compatibleType = this.getCompatibleTypeOf(types);
        if (compatibleType != null) {
            return compatibleType.getEClassifier();
        }
        return EcorePackage.Literals.EOBJECT;
    }

    public List<EClassifierInfo.EClassInfo> getAllEClassInfos() {
        ArrayList<EClassifierInfo.EClassInfo> result = new ArrayList<EClassifierInfo.EClassInfo>();
        for (EClassifierInfo classifier : this.infoMap.values()) {
            if (!(classifier instanceof EClassifierInfo.EClassInfo)) continue;
            result.add((EClassifierInfo.EClassInfo)classifier);
        }
        return Collections.unmodifiableList(result);
    }

    public List<EClassifierInfo.EClassInfo> getSuperTypeInfos(EClassifierInfo.EClassInfo subTypeInfo) throws UnexpectedClassInfoException {
        ArrayList<EClassifierInfo.EClassInfo> result = new ArrayList<EClassifierInfo.EClassInfo>();
        for (EClass superType : subTypeInfo.getEClass().getESuperTypes()) {
            EClassifierInfo info = this.getInfoOrNull(superType);
            if (info != null) {
                if (info instanceof EClassifierInfo.EClassInfo) {
                    result.add((EClassifierInfo.EClassInfo)info);
                    continue;
                }
                throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, info, null);
            }
            if (superType.eIsProxy()) {
                throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, null, "Cannot load all supertypes of  '" + subTypeInfo.getEClass().getName() + "'");
            }
            if (!this.isPackageKnown(superType.getEPackage().getNsURI())) continue;
            throw new UnexpectedClassInfoException(TransformationErrorCode.InvalidSupertype, subTypeInfo, null, "Cannot find info for type '" + superType.getName() + "'");
        }
        return result;
    }

    private boolean isPackageKnown(String nsURI) {
        for (Triple<String, String, String> key : this.infoMap.keySet()) {
            if (!((String)key.getFirst()).equals(nsURI)) continue;
            return true;
        }
        for (EClassifierInfos parent : this.parents) {
            if (!parent.isPackageKnown(nsURI)) continue;
            return true;
        }
        return false;
    }
}

