/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ecoreInference;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.ReflectionUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.ecoreInference.SourceAdapter;
import org.eclipse.xtext.xtext.ecoreInference.TransformationErrorCode;
import org.eclipse.xtext.xtext.ecoreInference.TransformationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EClassifierInfo {
    private final EClassifier eClassifier;
    private final boolean isGenerated;

    protected EClassifierInfo(EClassifier metaType, boolean isGenerated) {
        this.isGenerated = isGenerated;
        this.eClassifier = metaType;
    }

    public static EClassifierInfo createEClassInfo(EClass eClass, boolean isGenerated, Set<String> generatedEPackageURIs) {
        return new EClassInfo(eClass, isGenerated, generatedEPackageURIs);
    }

    public static EClassifierInfo createEDataTypeInfo(EDataType eDataType, boolean isGenerated) {
        return new EDataTypeInfo(eDataType, isGenerated);
    }

    public EClassifier getEClassifier() {
        return this.eClassifier;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public boolean isAssignableFrom(EClassifierInfo subTypeInfo) {
        return this.getEClassifier().equals(subTypeInfo.getEClassifier());
    }

    public abstract boolean addSupertype(EClassifierInfo var1);

    public abstract boolean addFeature(String var1, EClassifierInfo var2, boolean var3, boolean var4, AbstractElement var5) throws TransformationException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EClassInfo
    extends EClassifierInfo {
        private Set<String> generatedEPackageURIs;

        public EClassInfo(EClassifier metaType, boolean isGenerated, Set<String> generatedEPackageURIs) {
            super(metaType, isGenerated);
            this.generatedEPackageURIs = generatedEPackageURIs;
        }

        @Override
        public boolean isAssignableFrom(EClassifierInfo subTypeInfo) {
            return super.isAssignableFrom(subTypeInfo) || subTypeInfo instanceof EClassInfo && EcoreUtil2.isAssignableFrom(this.getEClass(), (EClass)subTypeInfo.getEClassifier());
        }

        @Override
        public boolean addSupertype(EClassifierInfo superTypeInfo) {
            EClass eClass = this.getEClass();
            EClass superEClass = (EClass)superTypeInfo.getEClassifier();
            if (superEClass.isSuperTypeOf(eClass)) {
                return true;
            }
            if (!this.isGenerated()) {
                throw new IllegalStateException("Type " + this.getEClassifier().getName() + " is not generated and cannot be modified.");
            }
            if (!(superTypeInfo instanceof EClassInfo)) {
                throw new IllegalArgumentException("superTypeInfo must represent EClass");
            }
            if (eClass.equals(superEClass)) {
                return false;
            }
            return eClass.getESuperTypes().add(superEClass);
        }

        @Override
        public boolean addFeature(String featureName, EClassifierInfo featureType, boolean isMultivalue, boolean isContainment, AbstractElement parserElement) throws TransformationException {
            EClassifier featureClassifier = featureType.getEClassifier();
            return this.addFeature(featureName, featureClassifier, isMultivalue, isContainment, parserElement);
        }

        public boolean addFeature(EStructuralFeature prototype) {
            try {
                boolean result;
                boolean isContainment = false;
                if (prototype instanceof EReference) {
                    EReference reference = (EReference)prototype;
                    isContainment = reference.isContainment();
                }
                if (result = this.addFeature(prototype.getName(), prototype.getEType(), prototype.isMany(), isContainment, null)) {
                    EStructuralFeature newFeature = this.getEClass().getEStructuralFeature(prototype.getName());
                    SourceAdapter oldAdapter = SourceAdapter.find(prototype);
                    if (oldAdapter != null) {
                        for (EObject source : oldAdapter.getSources()) {
                            SourceAdapter.adapt(newFeature, source);
                        }
                    }
                }
                return result;
            }
            catch (TransformationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public boolean containsCompatibleFeature(String name, boolean isMulti, boolean isContainment, EClassifier featureType, StringBuilder errorMessage) {
            EStructuralFeature existingFeature = this.getEClass().getEStructuralFeature(name);
            if (existingFeature != null) {
                boolean many = existingFeature.isMany();
                if (many == isMulti) {
                    if (featureType instanceof EClass && existingFeature.getEType() instanceof EClass) {
                        EClass expected = (EClass)featureType;
                        EClass actual = (EClass)existingFeature.getEType();
                        boolean result = EcoreUtil2.isAssignableFrom(actual, expected);
                        if (!result) {
                            errorMessage.append("The existing reference '" + name + "' has an incompatible type '" + actual.getName() + "'.");
                            return result;
                        }
                        if (!(result &= isContainment == ((EReference)existingFeature).isContainment())) {
                            errorMessage.append("The existing reference '" + name + "' has a different containment status.");
                            return result;
                        }
                        if (!(result &= !((EReference)existingFeature).isContainer())) {
                            errorMessage.append("The existing reference '" + name + "' is a container reference.");
                            return result;
                        }
                        return result;
                    }
                    if (featureType instanceof EDataType && existingFeature.getEType() instanceof EDataType) {
                        boolean result;
                        EDataType expected = (EDataType)featureType;
                        EDataType actual = (EDataType)existingFeature.getEType();
                        Class<?> expectedInstanceClass = ReflectionUtil.getObjectType(expected.getInstanceClass());
                        Class<?> actualInstanceClass = ReflectionUtil.getObjectType(actual.getInstanceClass());
                        boolean bl = result = actual.equals(expected) || expectedInstanceClass != null && actualInstanceClass != null && actualInstanceClass.isAssignableFrom(expectedInstanceClass);
                        if (!result) {
                            errorMessage.append("The existing attribute '" + name + "' has an incompatible type '" + actual.getName() + "'.");
                        }
                        return result;
                    }
                    String msgPart = " has no type.";
                    if (existingFeature.getEType() != null) {
                        msgPart = " has an incompatible type '" + existingFeature.getEType().getName() + "'.";
                    }
                    errorMessage.append("The existing feature '" + name + "'" + msgPart);
                } else {
                    errorMessage.append("The existing feature '" + name + "' has a different cardinality.");
                }
            } else {
                errorMessage.append("The type '" + this.getEClass().getName() + "' does not have a feature '" + name + "'.");
            }
            return false;
        }

        public boolean isFeatureSemanticallyEqualApartFromType(EStructuralFeature f1, EStructuralFeature f2) {
            boolean result = f1.getName().equals(f2.getName());
            result &= f1.isMany() == f2.isMany();
            if (f1 instanceof EReference && f2 instanceof EReference) {
                result &= ((EReference)f1).isContainment() == ((EReference)f2).isContainment();
            }
            return result;
        }

        public boolean isFeatureSemanticallyEqualTo(EStructuralFeature f1, EStructuralFeature f2) {
            boolean result = this.isFeatureSemanticallyEqualApartFromType(f1, f2);
            if (f1 instanceof EReference && f2 instanceof EReference) {
                EClass f1Type = (EClass)f1.getEType();
                EClass f2Type = (EClass)f2.getEType();
                result &= f1Type.isSuperTypeOf(f2Type);
                result &= ((EReference)f1).isContainment() == ((EReference)f2).isContainment();
                result &= ((EReference)f1).isContainer() == ((EReference)f2).isContainer();
            } else {
                result &= f1.getEType().equals(f2.getEType());
            }
            return result;
        }

        public EStructuralFeature findFeatureByName(Collection<EStructuralFeature> features, String name) {
            if (name == null) {
                return null;
            }
            for (EStructuralFeature feature : features) {
                if (!name.equals(feature.getName())) continue;
                return feature;
            }
            return null;
        }

        public FindResult containsSemanticallyEqualFeature(EStructuralFeature feature) {
            return this.containsSemanticallyEqualFeature(this.getEClass().getEAllStructuralFeatures(), feature);
        }

        public FindResult containsSemanticallyEqualFeature(Collection<EStructuralFeature> features, EStructuralFeature feature) {
            EStructuralFeature potentiallyEqualFeature = this.findFeatureByName(features, feature.getName());
            if (potentiallyEqualFeature == null) {
                return FindResult.FeatureDoesNotExist;
            }
            if (this.isFeatureSemanticallyEqualTo(potentiallyEqualFeature, feature)) {
                return FindResult.FeatureExists;
            }
            return FindResult.DifferentFeatureWithSameNameExists;
        }

        private boolean addFeature(String featureName, EClassifier featureClassifier, boolean isMultivalue, boolean isContainment, AbstractElement grammarElement) throws TransformationException {
            if (!this.isGenerated()) {
                StringBuilder errorMessage = new StringBuilder();
                if (!this.containsCompatibleFeature(featureName, isMultivalue, isContainment, featureClassifier, errorMessage)) {
                    throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot find compatible feature " + featureName + " in sealed EClass " + this.getEClass().getName() + " from imported package " + this.getEClass().getEPackage().getNsURI() + ". " + errorMessage.toString(), grammarElement);
                }
                return true;
            }
            EStructuralFeature newFeature = this.createFeatureWith(featureName, featureClassifier, isMultivalue, isContainment);
            FindResult containsSemanticallyEqualFeature = this.containsSemanticallyEqualFeature(newFeature);
            switch (containsSemanticallyEqualFeature) {
                case FeatureDoesNotExist: {
                    if (!this.isGenerated()) {
                        throw new TransformationException(TransformationErrorCode.CannotCreateTypeInSealedMetamodel, "Cannot create feature in sealed metamodel.", grammarElement);
                    }
                    if (grammarElement != null) {
                        SourceAdapter.adapt(newFeature, grammarElement);
                    }
                    return this.getEClass().getEStructuralFeatures().add(newFeature);
                }
                case FeatureExists: {
                    if (this.isGenerated()) {
                        EStructuralFeature existingFeature = this.findFeatureByName(this.getEClass().getEAllStructuralFeatures(), featureName);
                        if (grammarElement != null) {
                            SourceAdapter.adapt(existingFeature, grammarElement);
                        }
                    }
                    return false;
                }
            }
            EStructuralFeature existingFeature = this.getEClass().getEStructuralFeature(featureName);
            if (!this.isFeatureSemanticallyEqualApartFromType(newFeature, existingFeature)) {
                throw new TransformationException(TransformationErrorCode.FeatureWithDifferentConfigurationAlreadyExists, "A feature '" + newFeature.getName() + "' with a different cardinality or containment " + "configuration already exists in type '" + this.getEClass().getName() + "'.", grammarElement);
            }
            EClassifier compatibleType = EcoreUtil2.getCompatibleType(existingFeature.getEType(), newFeature.getEType());
            if (compatibleType == null) {
                throw new TransformationException(TransformationErrorCode.NoCompatibleFeatureTypeAvailable, "Cannot find compatible type for features", grammarElement);
            }
            if (!this.isGenerated(existingFeature)) {
                throw new TransformationException(TransformationErrorCode.FeatureWithDifferentConfigurationAlreadyExists, "Incompatible return type to existing feature", grammarElement);
            }
            existingFeature.setEType(compatibleType);
            return true;
        }

        protected boolean isGenerated(EStructuralFeature existingFeature) {
            return this.generatedEPackageURIs.contains(existingFeature.getEContainingClass().getEPackage().getNsURI());
        }

        private EStructuralFeature createFeatureWith(String featureName, EClassifier featureClassifier, boolean isMultivalue, boolean isContainment) {
            EStructuralFeature newFeature;
            if (featureClassifier instanceof EClass) {
                EReference reference = EcoreFactory.eINSTANCE.createEReference();
                reference.setContainment(isContainment);
                newFeature = reference;
            } else {
                newFeature = EcoreFactory.eINSTANCE.createEAttribute();
            }
            newFeature.setName(featureName);
            newFeature.setEType(featureClassifier);
            newFeature.setLowerBound(0);
            newFeature.setUpperBound(isMultivalue ? -1 : 1);
            newFeature.setUnique(!isMultivalue || isContainment && featureClassifier instanceof EClass);
            if (newFeature.getEType() instanceof EEnum) {
                newFeature.setDefaultValue(null);
            }
            return newFeature;
        }

        public EClass getEClass() {
            return (EClass)this.getEClassifier();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FindResult {
            FeatureDoesNotExist,
            FeatureExists,
            DifferentFeatureWithSameNameExists;

        }
    }

    public static class EDataTypeInfo
    extends EClassifierInfo {
        public EDataTypeInfo(EClassifier metaType, boolean isGenerated) {
            super(metaType, isGenerated);
        }

        public boolean addSupertype(EClassifierInfo superTypeInfo) {
            throw new UnsupportedOperationException("Cannot add supertype " + Strings.emptyIfNull(superTypeInfo.getEClassifier().getName()) + " to simple datatype " + Strings.emptyIfNull(this.getEClassifier().getName()));
        }

        public boolean addFeature(String featureName, EClassifierInfo featureType, boolean isMultivalue, boolean isContainment, AbstractElement parserElement) throws TransformationException {
            throw new UnsupportedOperationException("Cannot add feature " + featureName + " to simple datatype " + Strings.emptyIfNull(this.getEClassifier().getName()));
        }
    }
}

