/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.xbase.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionLiterals {
    public static final <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static final <T> Set<T> emptySet() {
        return Collections.emptySet();
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static final <T> List<T> newImmutableList(T ... elements) {
        return ImmutableList.of(elements);
    }

    public static final <T> Set<T> newImmutableSet(T ... elements) {
        return ImmutableSet.of(elements);
    }

    public static final <K, V> Map<K, V> newImmutableMap(Pair<K, V> ... entries) {
        if (entries.length == 0) {
            return CollectionLiterals.emptyMap();
        }
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        Pair<K, V>[] pairArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<K, V> entry = pairArray[n2];
            builder.put(entry.getKey(), entry.getValue());
            ++n2;
        }
        return builder.build();
    }

    public static final <T> ArrayList<T> newArrayList(T ... initial) {
        return Lists.newArrayList(initial);
    }

    public static final <T> LinkedList<T> newLinkedList(T ... initial) {
        if (initial.length > 0) {
            return Lists.newLinkedList(Arrays.asList(initial));
        }
        return Lists.newLinkedList();
    }

    public static final <T> HashSet<T> newHashSet(T ... initial) {
        return Sets.newHashSet(initial);
    }

    public static final <T> LinkedHashSet<T> newLinkedHashSet(T ... initial) {
        if (initial.length > 0) {
            return Sets.newLinkedHashSet(Arrays.asList(initial));
        }
        return Sets.newLinkedHashSet();
    }

    public static final <T> TreeSet<T> newTreeSet(Comparator<? super T> comparator, T ... initial) {
        TreeSet<T> result = new TreeSet<T>(comparator);
        if (initial.length > 0) {
            result.addAll(Arrays.asList(initial));
        }
        return result;
    }

    public static final <K, V> HashMap<K, V> newHashMap(Pair<K, V> ... initial) {
        HashMap result = Maps.newHashMapWithExpectedSize(initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap(Pair<K, V> ... initial) {
        LinkedHashMap result = new LinkedHashMap(initial.length);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    public static final <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator, Pair<K, V> ... initial) {
        TreeMap result = Maps.newTreeMap(comparator);
        CollectionLiterals.putAll(result, initial);
        return result;
    }

    private static <K, V> void putAll(Map<K, V> result, Pair<K, V> ... entries) {
        Pair<K, V>[] pairArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Pair<K, V> entry = pairArray[n2];
            if (result.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("duplicate key: " + entry.getKey());
            }
            result.put(entry.getKey(), entry.getValue());
            ++n2;
        }
    }
}

