/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.validation.IConcreteSyntaxConstraintProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ConcreteSyntaxConstraintProvider
implements IConcreteSyntaxConstraintProvider {
    protected static final Set<EClass> UNINITIALIZED = Sets.newHashSet();
    protected Grammar grammar;
    protected final IConcreteSyntaxConstraintProvider.ISyntaxConstraint INVALID_RULE = new SyntaxConstraintNode();
    protected Map<ParserRule, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> rule2element = Maps.newHashMap();
    protected Map<EClass, List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>> type2Elements = Maps.newHashMap();
    protected Set<ParserRule> validRules;

    protected void collectReachableRules(ParserRule pr, Set<ParserRule> rules, Set<ParserRule> visited) {
        if (!visited.add(pr)) {
            return;
        }
        for (RuleCall rc : GrammarUtil.containedRuleCalls(pr)) {
            if (!this.isParserRule(rc.getRule())) continue;
            if (GrammarUtil.containingAssignment(rc) != null) {
                rules.add((ParserRule)rc.getRule());
            }
            this.collectReachableRules((ParserRule)rc.getRule(), rules, visited);
        }
    }

    protected boolean containsRelevantElement(AbstractElement ele) {
        Iterator<EObject> i = Iterators.concat(Collections.singleton(ele).iterator(), ele.eAllContents());
        while (i.hasNext()) {
            EObject o = i.next();
            if (o instanceof Action || o instanceof Assignment) {
                return true;
            }
            if (!(o instanceof RuleCall) || !this.containsRelevantElement(((RuleCall)o).getRule().getAlternatives())) continue;
            return true;
        }
        return false;
    }

    protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint createElement(IConcreteSyntaxConstraintProvider.ConstraintType type, AbstractElement ele, EClass semanticType, boolean multiple, boolean optional) {
        EList<AbstractElement> ctns = ele instanceof CompoundElement ? ((CompoundElement)ele).getElements() : null;
        return this.createElement(type, ele, ctns, new ArrayList<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>(), semanticType, multiple, optional);
    }

    protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint createElement(IConcreteSyntaxConstraintProvider.ConstraintType type, AbstractElement ele, List<AbstractElement> lazyContents, List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> contents, EClass semanticType, boolean multiple, boolean optional) {
        if (lazyContents != null) {
            for (EObject eObject : lazyContents) {
                IConcreteSyntaxConstraintProvider.ISyntaxConstraint e = this.createElement(eObject);
                if (e == null) continue;
                contents.add(e);
            }
        }
        return new SyntaxConstraintNode(type, ele, contents, semanticType, multiple, optional);
    }

    protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint createElement(EObject obj) {
        if (!(obj instanceof AbstractElement)) {
            return null;
        }
        AbstractElement ele = (AbstractElement)obj;
        boolean multiple = false;
        boolean optional = false;
        EClass semanticType = null;
        while (true) {
            AbstractRule rule;
            AbstractElement lastChild;
            multiple = multiple || GrammarUtil.isMultipleCardinality(ele);
            boolean bl = optional = optional || GrammarUtil.isOptionalCardinality(ele);
            if (ele.eContainer() instanceof ParserRule && ((ParserRule)ele.eContainer()).getType().getClassifier() instanceof EClass) {
                semanticType = (EClass)((ParserRule)ele.eContainer()).getType().getClassifier();
            }
            if (ele instanceof Assignment) {
                return this.createElement(IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT, ele, semanticType, multiple, optional);
            }
            if (ele instanceof Group || ele instanceof UnorderedGroup) {
                CompoundElement comp = (CompoundElement)ele;
                lastChild = null;
                for (AbstractElement o : comp.getElements()) {
                    if (!this.containsRelevantElement(o)) continue;
                    if (lastChild == null) {
                        lastChild = o;
                        continue;
                    }
                    ArrayList<AbstractElement> c2 = new ArrayList<AbstractElement>(comp.getElements());
                    List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> e = this.createSummarizedAssignments(comp, c2, semanticType, optional);
                    if (e.size() == 1 && c2.size() == 0) {
                        return e.get(0);
                    }
                    return this.createElement(IConcreteSyntaxConstraintProvider.ConstraintType.GROUP, ele, c2, e, semanticType, multiple, optional);
                }
                if (lastChild == null) {
                    return null;
                }
                ele = lastChild;
                continue;
            }
            if (ele instanceof Alternatives) {
                int relevantChildren = 0;
                lastChild = null;
                for (AbstractElement o : ((CompoundElement)ele).getElements()) {
                    if (!this.containsRelevantElement(o)) continue;
                    ++relevantChildren;
                    lastChild = o;
                }
                if (relevantChildren < ((CompoundElement)ele).getElements().size()) {
                    optional = true;
                }
                if (relevantChildren > 1) {
                    return this.createElement(IConcreteSyntaxConstraintProvider.ConstraintType.ALTERNATIVE, ele, semanticType, multiple, optional);
                }
                if (lastChild == null) {
                    return null;
                }
                ele = lastChild;
                continue;
            }
            if (ele instanceof Action) {
                semanticType = (EClass)((Action)ele).getType().getClassifier();
                return this.createElement(IConcreteSyntaxConstraintProvider.ConstraintType.ACTION, ele, semanticType, multiple, optional);
            }
            if (!(ele instanceof RuleCall) || !((rule = ((RuleCall)ele).getRule()).getType().getClassifier() instanceof EClass)) break;
            ele = rule.getAlternatives();
        }
        return null;
    }

    protected List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> createSummarizedAssignments(CompoundElement group, List<AbstractElement> candidates, EClass semanticType, boolean optional) {
        HashMultimap<String, Assignment> feature2ass = HashMultimap.create();
        HashMultimap<String, AbstractElement> feature2child = HashMultimap.create();
        for (AbstractElement c2 : candidates) {
            TreeIterator<EObject> i = EcoreUtil2.eAll(c2);
            while (i.hasNext()) {
                EObject obj = (EObject)i.next();
                if (obj instanceof RuleCall || obj instanceof Action || obj instanceof Alternatives) {
                    return Lists.newArrayList();
                }
                if (obj instanceof Group) {
                    HashSet<String> names = Sets.newHashSet();
                    for (Assignment ass : EcoreUtil2.getAllContentsOfType(obj, Assignment.class)) {
                        names.add(ass.getFeature());
                    }
                    if (names.size() <= 1) continue;
                    i.prune();
                    continue;
                }
                if (!(obj instanceof Assignment)) continue;
                Assignment a2 = (Assignment)obj;
                feature2ass.put(a2.getFeature(), a2);
                feature2child.put(a2.getFeature(), c2);
                i.prune();
            }
        }
        ArrayList<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> result = Lists.newArrayList();
        for (Map.Entry ent : feature2ass.asMap().entrySet()) {
            if (ent.getValue().size() < 2 || feature2child.get((String)ent.getKey()).size() < 2) continue;
            int required = 0;
            int multiplies = 0;
            for (Assignment assignment : ent.getValue()) {
                AbstractElement e = assignment;
                while (e != group) {
                    if (GrammarUtil.isMultipleCardinality(e)) {
                        ++multiplies;
                        break;
                    }
                    e = (AbstractElement)e.eContainer();
                }
                e = assignment;
                while (e != group) {
                    if (GrammarUtil.isOptionalCardinality(e)) break;
                    e = (AbstractElement)e.eContainer();
                }
                if (e != group) continue;
                ++required;
            }
            if (required > 1 || multiplies < 1) continue;
            candidates.removeAll(feature2child.get((String)ent.getKey()));
            optional = optional || required < 1;
            result.add(this.createElement(IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT, (AbstractElement)ent.getValue().iterator().next(), semanticType, true, optional));
        }
        return result;
    }

    @Override
    public IConcreteSyntaxConstraintProvider.ISyntaxConstraint getConstraint(ParserRule rule) {
        IConcreteSyntaxConstraintProvider.ISyntaxConstraint e = this.rule2element.get(rule);
        if (e == null) {
            e = this.isValidateableRule(rule) ? this.createElement(rule.getAlternatives()) : this.INVALID_RULE;
            this.rule2element.put(rule, e);
        }
        return e != this.INVALID_RULE ? e : null;
    }

    @Override
    public Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> getConstraints(EClass cls) {
        List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> eles = this.type2Elements.get(cls);
        if (eles != null) {
            return eles;
        }
        eles = Lists.newArrayList();
        for (ParserRule r : this.getValidRules()) {
            if (!((EClass)r.getType().getClassifier()).isSuperTypeOf(cls)) continue;
            IConcreteSyntaxConstraintProvider.ISyntaxConstraint e = this.getConstraint(r);
            if (e != null) {
                eles.add(e);
                continue;
            }
            eles.clear();
            break;
        }
        this.type2Elements.put(cls, eles);
        return eles;
    }

    protected ParserRule getFirstParserRule(Grammar grammar) {
        for (AbstractRule r : grammar.getRules()) {
            if (!this.isParserRule(r)) continue;
            return (ParserRule)r;
        }
        throw new RuntimeException("Grammar " + grammar.getName() + " contains no parser rules");
    }

    protected Set<ParserRule> getValidRules() {
        if (this.validRules != null) {
            return this.validRules;
        }
        this.validRules = Sets.newHashSet();
        ParserRule first = this.getFirstParserRule(this.grammar);
        this.validRules.add(first);
        this.collectReachableRules(first, this.validRules, new HashSet<ParserRule>());
        return this.validRules;
    }

    protected boolean isParserRule(AbstractRule rule) {
        return rule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)rule);
    }

    protected boolean isValidateableRule(ParserRule rule) {
        return !this.ruleContainsAssignedAction(rule, new HashSet<AbstractRule>()) && !this.ruleContainsRecursiveUnassignedRuleCall(rule, new HashSet<AbstractRule>());
    }

    protected boolean ruleContainsAssignedAction(AbstractRule rule, Set<AbstractRule> visited) {
        if (!visited.add(rule)) {
            return false;
        }
        TreeIterator<EObject> i = rule.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            if (o instanceof Action && ((Action)o).getFeature() != null) {
                return true;
            }
            if (o instanceof Assignment) {
                i.prune();
                continue;
            }
            if (!(o instanceof RuleCall) || !this.isParserRule(((RuleCall)o).getRule()) || !this.ruleContainsAssignedAction(((RuleCall)o).getRule(), visited)) continue;
            return true;
        }
        return false;
    }

    protected boolean ruleContainsRecursiveUnassignedRuleCall(AbstractRule rule, Set<AbstractRule> visited) {
        if (!visited.add(rule)) {
            return true;
        }
        TreeIterator<EObject> i = rule.eAllContents();
        while (i.hasNext()) {
            EObject o = (EObject)i.next();
            if (o instanceof Assignment) {
                i.prune();
                continue;
            }
            if (!(o instanceof RuleCall) || !this.isParserRule(((RuleCall)o).getRule()) || !this.ruleContainsRecursiveUnassignedRuleCall(((RuleCall)o).getRule(), visited)) continue;
            return true;
        }
        return false;
    }

    @Inject
    protected void setGrammar(IGrammarAccess grammar) {
        this.grammar = grammar.getGrammar();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SyntaxConstraintNode
    implements IConcreteSyntaxConstraintProvider.ISyntaxConstraint {
        protected IConcreteSyntaxConstraintProvider.ISyntaxConstraint container = null;
        protected List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> contents;
        protected AbstractElement element;
        protected boolean multiple = false;
        protected boolean optional = false;
        protected EClass semanticType = null;
        protected Set<EClass> semanticTypes = UNINITIALIZED;
        protected IConcreteSyntaxConstraintProvider.ConstraintType type;

        protected SyntaxConstraintNode() {
        }

        public SyntaxConstraintNode(IConcreteSyntaxConstraintProvider.ConstraintType type, AbstractElement ele, List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> contents, EClass semanticType, boolean multiple, boolean optional) {
            if (type == null) {
                throw new NullPointerException("type must not be null");
            }
            this.type = type;
            this.element = ele;
            this.semanticType = semanticType;
            this.multiple = multiple;
            this.optional = optional;
            this.contents = contents;
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : contents) {
                ((SyntaxConstraintNode)e).container = this;
            }
        }

        protected boolean containsType() {
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint c2 : this.getContents()) {
                SyntaxConstraintNode n = (SyntaxConstraintNode)c2;
                if (n.semanticType == null && !n.containsType()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean dependsOn(IConcreteSyntaxConstraintProvider.ISyntaxConstraint ele) {
            IConcreteSyntaxConstraintProvider.ISyntaxConstraint cnt = this.findCommonContainer(ele);
            while (ele != cnt) {
                if (ele.isOptional()) {
                    return false;
                }
                ele = ele.getContainer();
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SyntaxConstraintNode) {
                return ((SyntaxConstraintNode)obj).element == this.element;
            }
            return false;
        }

        @Override
        public IConcreteSyntaxConstraintProvider.ISyntaxConstraint findCommonContainer(IConcreteSyntaxConstraintProvider.ISyntaxConstraint obj1) {
            IConcreteSyntaxConstraintProvider.ISyntaxConstraint cnt1 = obj1;
            while (cnt1 != null) {
                IConcreteSyntaxConstraintProvider.ISyntaxConstraint cnt2 = this;
                while (cnt2 != null) {
                    if (cnt1.equals(cnt2)) {
                        return cnt1;
                    }
                    cnt2 = cnt2.getContainer();
                }
                cnt1 = cnt1.getContainer();
            }
            return null;
        }

        protected Pair<Set<EClass>, Set<EClass>> getAllSemanticTypesPairs(Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> exclude) {
            HashSet<EClass> mandatory = Sets.newHashSet();
            HashSet<EClass> optional = Sets.newHashSet();
            boolean allChildrenContributeMandatoryType = !this.getContents().isEmpty();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint sc : this.getContents()) {
                if (exclude != null && exclude.contains(sc)) continue;
                Pair<Set<EClass>, Set<EClass>> t = ((SyntaxConstraintNode)sc).getAllSemanticTypesPairs(exclude);
                if (sc.isOptional()) {
                    optional.addAll((Collection)t.getFirst());
                    optional.addAll((Collection)t.getSecond());
                    allChildrenContributeMandatoryType = false;
                    continue;
                }
                mandatory.addAll((Collection)t.getFirst());
                optional.addAll((Collection)t.getSecond());
                if (!t.getFirst().isEmpty()) continue;
                allChildrenContributeMandatoryType = false;
            }
            if (this.isRoot() && this.isOptional() || this.type == IConcreteSyntaxConstraintProvider.ConstraintType.ALTERNATIVE && !allChildrenContributeMandatoryType) {
                optional.addAll(mandatory);
                mandatory.clear();
            }
            if (this.semanticType != null) {
                if (mandatory.isEmpty() && (optional.isEmpty() || optional.size() == 1 && optional.contains(this.semanticType))) {
                    mandatory.add(this.semanticType);
                } else {
                    optional.add(this.semanticType);
                }
            }
            if (exclude == null && !this.isRoot() && mandatory.isEmpty() && optional.isEmpty()) {
                optional.addAll(((SyntaxConstraintNode)this.getContainer()).getSemanticTypeByParent(Sets.newHashSet(this)));
            }
            return Tuples.create(mandatory, optional);
        }

        @Override
        public EStructuralFeature getAssignmentFeature(EClass clazz) {
            String name = this.getAssignmentName();
            EStructuralFeature f = clazz.getEStructuralFeature(name);
            if (f == null) {
                throw new RuntimeException("Feature " + name + " not found for " + clazz.getName());
            }
            return f;
        }

        @Override
        public String getAssignmentName() {
            if (this.type != IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT) {
                throw new RuntimeException("Constraint '" + this + "' is not an assignment, but a " + (Object)((Object)this.getType()));
            }
            return ((Assignment)this.element).getFeature();
        }

        @Override
        public String getCardinality() {
            return this.optional ? (this.multiple ? "*" : "?") : (this.multiple ? "+" : "");
        }

        @Override
        public IConcreteSyntaxConstraintProvider.ISyntaxConstraint getContainer() {
            return this.container;
        }

        @Override
        public List<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> getContents() {
            return this.contents;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        protected Set<EClass> getSemanticTypeByParent(Set<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> exclude) {
            if (this.type == IConcreteSyntaxConstraintProvider.ConstraintType.ALTERNATIVE) {
                exclude.addAll(this.getContents());
                if (this.semanticType != null) {
                    return Sets.newHashSet(this.semanticType);
                }
            } else {
                Pair<Set<EClass>, Set<EClass>> types = this.getAllSemanticTypesPairs(exclude);
                if (!types.getFirst().isEmpty()) {
                    return types.getFirst();
                }
                if (this.isRoot()) {
                    return types.getSecond();
                }
            }
            return ((SyntaxConstraintNode)this.getContainer()).getSemanticTypeByParent(exclude);
        }

        @Override
        public Set<EClass> getSemanticTypes() {
            Pair<Set<EClass>, Set<EClass>> types = this.getAllSemanticTypesPairs(null);
            return !types.getFirst().isEmpty() ? types.getFirst() : types.getSecond();
        }

        @Override
        public Set<EClass> getSemanticTypesToCheck() {
            if (this.semanticTypes == UNINITIALIZED) {
                this.semanticTypes = this.getSemanticTypes();
                if (this.semanticTypes.isEmpty() || !this.isRoot() && this.semanticTypes.equals(((SyntaxConstraintNode)this.getContainer()).getSemanticTypes())) {
                    this.semanticTypes = null;
                }
            }
            return this.semanticTypes;
        }

        @Override
        public IConcreteSyntaxConstraintProvider.ConstraintType getType() {
            return this.type;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public boolean isMultiple() {
            return this.multiple;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public boolean isRoot() {
            return this.container == null;
        }

        public String toString() {
            return this.toString(null);
        }

        @Override
        public String toString(final Map<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, String> postfix) {
            String p = postfix != null && postfix.containsKey(this) ? postfix.get(this) : "";
            Iterable<String> contents = Iterables.transform(this.getContents(), new Function<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, String>(){

                @Override
                public String apply(IConcreteSyntaxConstraintProvider.ISyntaxConstraint from) {
                    return from.toString(postfix);
                }
            });
            switch (this.getType()) {
                case ASSIGNMENT: {
                    return String.valueOf(((Assignment)this.element).getFeature()) + p + this.getCardinality();
                }
                case GROUP: {
                    return "(" + Joiner.on(" ").join(contents) + ")" + p + this.getCardinality();
                }
                case ALTERNATIVE: {
                    return "(" + Joiner.on("|").join(contents) + ")" + p + this.getCardinality();
                }
                case ACTION: {
                    return "{" + ((Action)this.element).getType().getClassifier().getName() + "}" + p;
                }
            }
            return "";
        }
    }
}

