/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.parsetree.reconstr.ITransientValueService;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.validation.IAssignmentQuantityAllocator;
import org.eclipse.xtext.validation.IAssignmentQuantityIntervalProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxConstraintProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxDiagnosticProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentQuantityAllocator
implements IAssignmentQuantityAllocator {
    @Inject
    protected IConcreteSyntaxDiagnosticProvider diagnosticProvider;
    @Inject
    protected IAssignmentQuantityIntervalProvider intervalProvider;
    @Inject
    protected ITransientValueService transSrvc;
    @Inject
    protected ITokenSerializer.IValueSerializer valueSerializer;

    protected boolean allowTransient(EObject obj, EStructuralFeature feature, Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> constraint) {
        if (feature.getEType() instanceof EEnum) {
            return true;
        }
        Object value = obj.eGet(feature);
        List<RuleCall> ruleCalls = GrammarUtil.containedRuleCalls(constraint.iterator().next().getGrammarElement());
        if (ruleCalls.isEmpty()) {
            return false;
        }
        return this.valueSerializer.isValid(obj, ruleCalls.get(0), value, null);
    }

    protected void collectAssignments(IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, EObject obj, IConcreteSyntaxConstraintProvider.ISyntaxConstraint ele, Multimap<EStructuralFeature, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> assignments, List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> acceptor) {
        if (ele.getSemanticTypesToCheck() != null && !ele.getSemanticTypesToCheck().contains(obj.eClass())) {
            return;
        }
        if (ele.getType() == IConcreteSyntaxConstraintProvider.ConstraintType.ASSIGNMENT) {
            EStructuralFeature f = obj.eClass().getEStructuralFeature(((Assignment)ele.getGrammarElement()).getFeature());
            if (f == null) {
                acceptor.add(this.diagnosticProvider.createFeatureMissingDiagnostic(rule, obj, ele, Collections.<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>emptySet()));
            } else {
                assignments.put(f, ele);
            }
        }
        for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : ele.getContents()) {
            this.collectAssignments(rule, obj, e, assignments, acceptor);
        }
    }

    protected Quantities createQuantities(EObject obj) {
        return new Quantities(obj);
    }

    @Override
    public IAssignmentQuantityAllocator.IQuantities getAssignmentQuantities(EObject obj, IConcreteSyntaxConstraintProvider.ISyntaxConstraint rule, List<IConcreteSyntaxDiagnosticProvider.IConcreteSyntaxDiagnostic> acceptor) {
        HashMultimap<EStructuralFeature, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> assignments = HashMultimap.create();
        this.collectAssignments(rule, obj, rule, assignments, acceptor);
        Quantities quants = this.createQuantities(obj);
        for (EStructuralFeature f : obj.eClass().getEAllStructuralFeatures()) {
            int n = this.getFeatureQuantity(obj, f);
            if (n > 0 && !assignments.containsKey(f)) {
                acceptor.add(this.diagnosticProvider.createAssignmentMissingDiagnostic(rule, obj, f, Collections.<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>emptySet()));
                continue;
            }
            quants.setFeatureQuantity(f, n);
        }
        HashMultimap<EStructuralFeature, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> multipleAssignments = HashMultimap.create();
        HashMultimap<EStructuralFeature, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> allowTransients = HashMultimap.create();
        for (Map.Entry<EStructuralFeature, Integer> entry : quants.getFeatureQuantities().entrySet()) {
            boolean multiNeeded;
            Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> ass = assignments.get(entry.getKey());
            if (ass.isEmpty()) continue;
            boolean allowTransient = entry.getKey() instanceof EAttribute && !entry.getKey().isMany() && entry.getValue() == 0 && this.allowTransient(obj, entry.getKey(), ass);
            boolean bl = multiNeeded = ass.size() > 1 && entry.getValue() != 0;
            if (allowTransient) {
                allowTransients.putAll(entry.getKey(), ass);
            }
            if (multiNeeded) {
                multipleAssignments.putAll(entry.getKey(), ass);
            }
            if (allowTransient || multiNeeded) continue;
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint a2 : ass) {
                quants.setAssignmentQuantity(a2, entry.getValue());
            }
        }
        if (multipleAssignments.isEmpty() && allowTransients.isEmpty()) {
            return quants;
        }
        for (Map.Entry<EStructuralFeature, Object> entry : allowTransients.asMap().entrySet()) {
            int min = 0;
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint x : (Collection)entry.getValue()) {
                min += this.intervalProvider.getMin(quants, x, Sets.<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>newHashSet());
            }
            int val = min > 0 ? 1 : 0;
            quants.setFeatureQuantity(entry.getKey(), val);
            if (((Collection)entry.getValue()).size() != 1) continue;
            quants.setAssignmentQuantity((IConcreteSyntaxConstraintProvider.ISyntaxConstraint)((Collection)entry.getValue()).iterator().next(), val);
        }
        if (multipleAssignments.isEmpty()) {
            return quants;
        }
        return null;
    }

    @Override
    public int getFeatureQuantity(EObject obj, EStructuralFeature feat) {
        if (feat.isMany()) {
            int count = 0;
            int max = ((List)obj.eGet(feat)).size();
            if (this.transSrvc.isCheckElementsIndividually(obj, feat)) {
                int i = 0;
                while (i < max) {
                    if (!this.transSrvc.isTransient(obj, feat, i)) {
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
            return this.transSrvc.isTransient(obj, feat, 0) ? 0 : max;
        }
        return this.transSrvc.isTransient(obj, feat, 0) ? 0 : 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Quantities
    implements IAssignmentQuantityAllocator.IQuantities {
        protected Map<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, Integer> assignmentQuants = Maps.newHashMap();
        protected EObject delegate;
        protected Map<EStructuralFeature, Integer> featureQuants = Maps.newHashMap();

        public Quantities(EObject delegate) {
            this.delegate = delegate;
        }

        @Override
        public Map<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, Integer> getAssignmentQuantities() {
            return this.assignmentQuants;
        }

        @Override
        public Integer getAssignmentQuantity(IConcreteSyntaxConstraintProvider.ISyntaxConstraint assignement) {
            Integer i = this.assignmentQuants.get(assignement);
            return i == null || i < 0 ? -1 : i;
        }

        @Override
        public EObject getEObject() {
            return this.delegate;
        }

        @Override
        public Map<EStructuralFeature, Integer> getFeatureQuantities() {
            return this.featureQuants;
        }

        @Override
        public Integer getFeatureQuantity(EStructuralFeature feat) {
            Integer i = this.featureQuants.get(feat);
            return i == null || i < 0 ? -1 : i;
        }

        @Override
        public Map<EStructuralFeature, Collection<IConcreteSyntaxConstraintProvider.ISyntaxConstraint>> groupByFeature() {
            HashMultimap<EStructuralFeature, IConcreteSyntaxConstraintProvider.ISyntaxConstraint> map = HashMultimap.create();
            for (IConcreteSyntaxConstraintProvider.ISyntaxConstraint e : this.assignmentQuants.keySet()) {
                map.put(e.getAssignmentFeature(this.delegate.eClass()), e);
            }
            return map.asMap();
        }

        public void setAssignmentQuantity(IConcreteSyntaxConstraintProvider.ISyntaxConstraint assignement, int quantity) {
            this.assignmentQuants.put(assignement, quantity);
        }

        public void setFeatureQuantity(EStructuralFeature feature, int quantity) {
            this.featureQuants.put(feature, quantity);
        }

        public String toString() {
            return this.toString(null);
        }

        public String toString(Map<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, Pair<Integer, Integer>> minmax) {
            HashMap<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, String> postfix = Maps.newHashMap();
            for (Map.Entry<IConcreteSyntaxConstraintProvider.ISyntaxConstraint, Integer> e : this.assignmentQuants.entrySet()) {
                String s = ":" + e.getValue();
                if (minmax != null && minmax.containsKey(e.getKey())) {
                    Pair<Integer, Integer> p = minmax.get(e.getKey());
                    s = String.valueOf(s) + "<" + p.getFirst() + "," + (p.getSecond() == Integer.MAX_VALUE ? "*" : (Serializable)p.getSecond()) + ">";
                }
                postfix.put(e.getKey(), s);
            }
            Iterator<IConcreteSyntaxConstraintProvider.ISyntaxConstraint> i = this.assignmentQuants.keySet().iterator();
            if (!i.hasNext()) {
                return "";
            }
            IConcreteSyntaxConstraintProvider.ISyntaxConstraint root = i.next();
            while (i.hasNext()) {
                root = root.findCommonContainer(i.next());
            }
            return root.toString(postfix);
        }
    }
}

