/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.AbstractInjectableValidator;
import org.eclipse.xtext.validation.CancelableDiagnostician;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IDiagnosticConverter;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.impl.ConcreteSyntaxEValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceValidatorImpl
implements IResourceValidator {
    private static final Logger log = Logger.getLogger(ResourceValidatorImpl.class);
    @Inject
    private Diagnostician diagnostician;
    @Inject
    private IDiagnosticConverter converter;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator mon) {
        CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
        this.resolveProxies(resource, monitor);
        if (monitor.isCanceled()) {
            return null;
        }
        ArrayList<Issue> result = Lists.newArrayListWithExpectedSize(resource.getErrors().size() + resource.getWarnings().size());
        try {
            IAcceptor<Issue> acceptor = this.createAcceptor(result);
            if (mode.shouldCheck(CheckType.FAST)) {
                int i = 0;
                while (i < resource.getErrors().size()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getErrors().get(i), Severity.ERROR, acceptor);
                    ++i;
                }
                i = 0;
                while (i < resource.getWarnings().size()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    this.issueFromXtextResourceDiagnostic((Resource.Diagnostic)resource.getWarnings().get(i), Severity.WARNING, acceptor);
                    ++i;
                }
            }
            if (monitor.isCanceled()) {
                return null;
            }
            boolean syntaxDiagFail = !result.isEmpty();
            this.logCheckStatus(resource, syntaxDiagFail, "Syntax");
            for (EObject ele : resource.getContents()) {
                try {
                    Diagnostic diagnostic;
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    HashMap<Object, Object> options = Maps.newHashMap();
                    options.put("check.mode", mode);
                    options.put(CancelableDiagnostician.CANCEL_INDICATOR, monitor);
                    options.put(ConcreteSyntaxEValidator.DISABLE_CONCRETE_SYNTAX_EVALIDATOR, Boolean.TRUE);
                    options.put(EValidator.class, this.diagnostician);
                    if (resource instanceof XtextResource) {
                        options.put(AbstractInjectableValidator.CURRENT_LANGUAGE_NAME, ((XtextResource)resource).getLanguageName());
                    }
                    if (!(diagnostic = this.diagnostician.validate(ele, options)).getChildren().isEmpty()) {
                        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                            this.issueFromEValidatorDiagnostic(childDiagnostic, acceptor);
                        }
                        continue;
                    }
                    this.issueFromEValidatorDiagnostic(diagnostic, acceptor);
                }
                catch (RuntimeException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), e);
        }
        return result;
    }

    protected void resolveProxies(Resource resource, CancelIndicator monitor) {
        EcoreUtil2.resolveLazyCrossReferences(resource, monitor);
    }

    protected IAcceptor<Issue> createAcceptor(List<Issue> result) {
        return new ListBasedMarkerAcceptor(result);
    }

    private void logCheckStatus(Resource resource, boolean parserDiagFail, String string) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(string) + " check " + (parserDiagFail ? "FAIL" : "OK") + "! Resource: " + resource.getURI());
        }
    }

    protected void issueFromXtextResourceDiagnostic(Resource.Diagnostic diagnostic, Severity severity, IAcceptor<Issue> acceptor) {
        this.converter.convertResourceDiagnostic(diagnostic, severity, acceptor);
    }

    protected void issueFromEValidatorDiagnostic(Diagnostic diagnostic, IAcceptor<Issue> acceptor) {
        this.converter.convertValidatorDiagnostic(diagnostic, acceptor);
    }

    public void setDiagnostician(Diagnostician diagnostician) {
        this.diagnostician = diagnostician;
    }

    public Diagnostician getDiagnostician() {
        return this.diagnostician;
    }

    public void setDiagnosticConverter(IDiagnosticConverter converter) {
        this.converter = converter;
    }

    public IDiagnosticConverter getDiagnosticConverter() {
        return this.converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ListBasedMarkerAcceptor
    implements IAcceptor<Issue> {
        private final List<Issue> result;

        protected ListBasedMarkerAcceptor(List<Issue> result) {
            this.result = result;
        }

        @Override
        public void accept(Issue issue) {
            if (issue != null) {
                this.result.add(issue);
            }
        }
    }
}

