/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.inject.internal.Join;
import com.google.inject.internal.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.xtext.util.formallang.IGrammarFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarStringFactory<TOKEN>
implements IGrammarFactory<String, TOKEN> {
    protected Function<TOKEN, String> token2String;

    public GrammarStringFactory() {
    }

    public GrammarStringFactory(Function<TOKEN, String> token2String) {
        this.token2String = token2String;
    }

    protected String card(boolean many, boolean optional) {
        return many ? (optional ? "*" : "+") : (optional ? "?" : "");
    }

    @Override
    public String createForAlternativeChildren(boolean many, boolean optional, Iterable<String> children) {
        ArrayList<String> childrenSorted = Lists.newArrayList(children);
        Collections.sort(childrenSorted);
        return "(" + Join.join(" | ", childrenSorted) + ")" + this.card(many, optional);
    }

    @Override
    public String createForSequentialChildren(boolean many, boolean optional, Iterable<String> children) {
        if (many || optional) {
            return "(" + Join.join(" ", children) + ")" + this.card(many, optional);
        }
        return String.valueOf(Join.join(" ", children)) + this.card(many, optional);
    }

    @Override
    public String createForToken(boolean many, boolean optional, TOKEN token) {
        if (this.token2String != null) {
            return String.valueOf(this.token2String.apply(token)) + this.card(many, optional);
        }
        if (token == null) {
            return "null" + this.card(many, optional);
        }
        return String.valueOf(token.toString()) + this.card(many, optional);
    }

    @Override
    public String createForUnordertedChildren(boolean many, boolean optional, Iterable<String> children) {
        ArrayList<String> childrenSorted = Lists.newArrayList(children);
        Collections.sort(childrenSorted);
        return "(" + Join.join(" & ", childrenSorted) + ")" + this.card(many, optional);
    }
}

