/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.xtext.util.formallang.IGrammarAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarFormatter<ELEMENT, TOKEN> {
    protected static final int AUTO_WRAP_CHARS = 140;
    protected static final String INDENT = "    ";
    protected IGrammarAdapter<ELEMENT, TOKEN> adapter;
    protected Function<TOKEN, String> tokenToString;

    public static <ELEMENT, TOKEN> GrammarFormatter<ELEMENT, TOKEN> newFormatter(IGrammarAdapter<ELEMENT, TOKEN> adapter) {
        return new GrammarFormatter<ELEMENT, TOKEN>(adapter);
    }

    public static <ELEMENT, TOKEN> GrammarFormatter<ELEMENT, TOKEN> newFormatter(IGrammarAdapter<ELEMENT, TOKEN> adapter, Function<TOKEN, String> tokenToString) {
        return new GrammarFormatter<ELEMENT, TOKEN>(adapter, tokenToString);
    }

    public GrammarFormatter(IGrammarAdapter<ELEMENT, TOKEN> adapter) {
        this.adapter = adapter;
        this.tokenToString = new ObjToStrFunction();
    }

    public GrammarFormatter(IGrammarAdapter<ELEMENT, TOKEN> adapter, Function<TOKEN, String> tokenToString) {
        this.adapter = adapter;
        this.tokenToString = tokenToString;
    }

    public String format(ELEMENT grammarElement) {
        return this.format(grammarElement, false);
    }

    public String format(ELEMENT grammarElement, boolean needParenthesis) {
        TOKEN token = this.adapter.getToken(grammarElement);
        if (token != null) {
            String cardinality = this.getCardinality(grammarElement);
            if (cardinality == null) {
                return this.tokenToString.apply(token);
            }
            return String.valueOf(this.tokenToString.apply(token)) + cardinality;
        }
        Iterable<ELEMENT> alternative = this.adapter.getAlternativeChildren(grammarElement);
        if (alternative != null) {
            return this.format(grammarElement, alternative, " | ", false, needParenthesis, 5);
        }
        Iterable<ELEMENT> group = this.adapter.getSequentialChildren(grammarElement);
        if (group != null) {
            return this.format(grammarElement, group, " ", false, needParenthesis, 5);
        }
        Iterable<ELEMENT> ungroup = this.adapter.getUnorderedChildren(grammarElement);
        if (ungroup != null) {
            return this.format(grammarElement, ungroup, " & ", false, needParenthesis, 5);
        }
        return "<unknown>";
    }

    protected String format(ELEMENT element, Iterable<ELEMENT> children, String separator, boolean needWrap, boolean needParenthesis, int maxChildren) {
        ArrayList<String> childStrs2 = Lists.newArrayList();
        int width2 = 0;
        for (ELEMENT child : children) {
            String childStr = this.format(child, true);
            childStrs2.add(childStr);
            width2 += childStr.length();
            if (!childStr.contains("\n")) continue;
            needWrap = true;
        }
        if (childStrs2.size() > maxChildren) {
            needWrap = true;
        }
        if (width2 > 140) {
            needWrap = true;
        }
        String cardinality = this.getCardinality(element);
        if (needWrap) {
            int i = 0;
            while (i < childStrs2.size()) {
                childStrs2.set(i, ((String)childStrs2.get(i)).replaceAll("\\n", "\n    "));
                ++i;
            }
            String body = Joiner.on(String.valueOf(separator) + "\n" + INDENT).join(childStrs2);
            return "(\n    " + body + "\n)" + (cardinality == null ? "" : cardinality);
        }
        if (cardinality != null && childStrs2.size() > 1) {
            needParenthesis = true;
        }
        String body = Joiner.on(separator).join(childStrs2);
        if (needParenthesis) {
            return "(" + body + ")" + (cardinality == null ? "" : cardinality);
        }
        return body;
    }

    protected String getCardinality(ELEMENT ele) {
        return this.adapter.isMany(ele) ? (this.adapter.isOptional(ele) ? "*" : "+") : (this.adapter.isOptional(ele) ? "?" : null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ObjToStrFunction<TOKEN>
    implements Function<TOKEN, String> {
        protected ObjToStrFunction() {
        }

        @Override
        public String apply(TOKEN from) {
            return from == null ? "null" : from.toString();
        }
    }
}

