/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.xtext.util.Strings;

public class LineFilterOutputStream
extends FilterOutputStream {
    private final byte[] pattern;
    private final byte[] buffer;
    private int index;
    private final byte[] newline;
    private int newlineIndex;
    private boolean searching;

    public LineFilterOutputStream(OutputStream out, String pattern) {
        this(out, pattern, Strings.newLine());
    }

    public LineFilterOutputStream(OutputStream out, String pattern, String newLine) {
        super(out);
        this.pattern = pattern.getBytes();
        this.buffer = new byte[pattern.length()];
        this.newline = newLine.getBytes();
        this.index = 0;
        this.newlineIndex = 0;
        this.searching = true;
    }

    public void write(int b2) throws IOException {
        if (this.searching) {
            if (this.newline[0] == b2) {
                if (this.index == this.pattern.length) {
                    this.index = 0;
                    if (this.newline.length > 1) {
                        ++this.newlineIndex;
                        this.searching = false;
                    } else {
                        this.searching = true;
                    }
                } else {
                    int i = 0;
                    while (i < this.index) {
                        super.write(this.buffer[i]);
                        ++i;
                    }
                    if (this.newline.length > 1) {
                        ++this.newlineIndex;
                        this.searching = false;
                    } else {
                        this.searching = true;
                    }
                    this.index = 0;
                    super.write(b2);
                }
            } else if (this.index >= this.pattern.length || this.pattern[this.index] != b2) {
                int i = 0;
                while (i < this.index) {
                    super.write(this.buffer[i]);
                    ++i;
                }
                this.searching = false;
                this.index = 0;
                super.write(b2);
            } else {
                this.buffer[this.index] = (byte)b2;
                ++this.index;
            }
        } else if (this.newline.length > 1 && this.newlineIndex > 0 && b2 == this.newline[this.newlineIndex]) {
            this.searching = true;
            this.newlineIndex = 0;
            super.write(b2);
        } else if (this.newline[0] == b2) {
            if (this.newline.length > 1) {
                ++this.newlineIndex;
            } else {
                this.searching = true;
            }
            super.write(b2);
        } else {
            super.write(b2);
        }
    }

    public void flush() throws IOException {
        if (this.index != this.pattern.length) {
            int i = 0;
            while (i < this.index) {
                super.write(this.buffer[i]);
                ++i;
            }
        }
        super.flush();
    }
}

