/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.projectWizard;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandFacade;
import org.eclipse.xpand2.output.Outlet;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.Naming;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProjectWizardFragment
extends AbstractGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(SimpleProjectWizardFragment.class);
    private String generatorProjectName;
    private String modelFileExtension;
    private boolean pluginProject = true;

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        String templateName = SimpleProjectWizardFragment.getNewProjectTemplateName(grammar, this.getNaming());
        Outlet outlet = ctx.getOutput().getOutlet("SRC_UI");
        File templateFile = new File(new File(outlet.getPath()), String.valueOf(templateName.replaceAll("::", "/")) + '.' + "xpt");
        boolean templateExisted = templateFile.exists();
        List<Object> parameters = this.getParameters(grammar);
        parameters.add(outlet.getFileEncoding());
        XpandFacade.create(ctx).evaluate2(String.valueOf(this.getTemplate()) + "::generate", grammar, parameters);
        if (!templateExisted && templateFile.exists()) {
            LOG.info("A new template " + templateName + " has been generated into " + outlet.getPath() + ".");
            LOG.info("  Make sure to enable the Xtend/Xpand nature and JavaBeans metamodel to edit this template.");
        }
    }

    @Override
    public String[] getRequiredBundlesUi(Grammar grammar) {
        return new String[]{"org.eclipse.ui", "org.eclipse.core.runtime", "org.eclipse.core.resources", "org.eclipse.ui.ide", "org.eclipse.xtend", "org.eclipse.xpand"};
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        return new BindFactory().addTypeToType("org.eclipse.xtext.ui.wizard.IProjectCreator", String.valueOf(GrammarUtil.getNamespace(grammar)) + ".ui.wizard." + GrammarUtil.getName(grammar) + "ProjectCreator").getBindings();
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Lists.newArrayList(this.getGeneratorProjectName(grammar), this.getModelFileExtension(grammar), this.isPluginProject());
    }

    private String getGeneratorProjectName(Grammar g) {
        if (this.generatorProjectName != null) {
            return this.generatorProjectName;
        }
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " : The property 'generatorProjectName' is mandatory but has not been configured.");
    }

    public String getModelFileExtension(Grammar g) {
        if (this.modelFileExtension == null) {
            this.modelFileExtension = GrammarUtil.getName(g).toLowerCase();
            if (LOG.isInfoEnabled()) {
                LOG.info("No explicit 'modelFileExtension' configured. Using '" + this.modelFileExtension + "'.");
            }
        }
        return this.modelFileExtension;
    }

    public void setGeneratorProjectName(String generatorProjectName) {
        if (generatorProjectName == null || "".equals(generatorProjectName.trim())) {
            return;
        }
        this.generatorProjectName = generatorProjectName.trim();
    }

    public void setModelFileExtension(String modelFileExtension) {
        if (modelFileExtension == null || "".equals(modelFileExtension.trim())) {
            return;
        }
        this.modelFileExtension = modelFileExtension.trim();
    }

    public static String getNewProjectTemplateName(Grammar grammar, Naming n) {
        return String.valueOf(n.basePackageUi(grammar).replace(".", "::")) + "::wizard::" + GrammarUtil.getName(grammar) + "NewProject";
    }

    public void setPluginProject(boolean pluginProject) {
        this.pluginProject = pluginProject;
    }

    public boolean isPluginProject() {
        return this.pluginProject;
    }
}

