/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.sequencer.AbstractSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.IAssignmentFinder;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.TransientValueUtil;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;

public class BacktrackingSemanticSequencer
extends AbstractSemanticSequencer {
    @Inject
    protected IAssignmentFinder assignmentFinder;
    @Inject
    protected ISemanticSequencerDiagnosticProvider diagnosticProvider;
    @Inject
    protected ISemanticSequencerNfaProvider nfaProvider;
    @Inject
    protected ITransientValueService transientValueService;
    @Inject
    protected TransientValueUtil transientValueUtil;

    protected void accept(TraceItem ti, SequenceFeeder feeder) {
        AbstractElement ele = ti.getState().getAssignedGrammarElement();
        if (ti.getState().getFeature().isMany()) {
            if (ele instanceof RuleCall) {
                feeder.accept((RuleCall)ele, ti.getValue(), ti.getIndex(), ti.getNode());
            } else if (ele instanceof Action) {
                feeder.accept((Action)ele, (EObject)ti.getValue(), (ICompositeNode)ti.getNode());
            } else if (ele instanceof Keyword) {
                feeder.accept((Keyword)ele, ti.getValue(), ti.getIndex(), (ILeafNode)ti.getNode());
            }
        } else if (ele instanceof RuleCall) {
            feeder.accept((RuleCall)ele, ti.getValue(), ti.getNode());
        } else if (ele instanceof Action) {
            feeder.accept((Action)ele, (EObject)ti.getValue(), (ICompositeNode)ti.getNode());
        } else if (ele instanceof Keyword) {
            feeder.accept((Keyword)ele, ti.getValue(), (ILeafNode)ti.getNode());
        }
    }

    public void createSequence(EObject context, EObject obj) {
        ISemanticNodeProvider.INodesForEObjectProvider nodes = this.nodeProvider.getNodesForSemanticObject(obj, null);
        Nfa<ISemanticSequencerNfaProvider.ISemState> nfa = this.nfaProvider.getNFA(context, obj.eClass());
        final SerializableObject object = new SerializableObject(obj, nodes);
        TraceItem co = new TraceItem(object);
        List<TraceItem> trace = new NfaUtil().backtrack(nfa, co, new NfaUtil.BacktrackHandler<ISemanticSequencerNfaProvider.ISemState, TraceItem>(){

            @Override
            public TraceItem handle(ISemanticSequencerNfaProvider.ISemState state, TraceItem previous) {
                if (state.getFeature() != null) {
                    return previous.cloneAndConsume(state);
                }
                return previous.clone(state);
            }

            @Override
            public boolean isSolution(TraceItem result) {
                return result.isConsumed();
            }

            @Override
            public Iterable<ISemanticSequencerNfaProvider.ISemState> sortFollowers(TraceItem result, Iterable<ISemanticSequencerNfaProvider.ISemState> followers) {
                INode next = result.getNextNode();
                ArrayList<ISemanticSequencerNfaProvider.ISemState> r = Lists.newArrayList(followers);
                Collections.sort(r, new FollowerSorter(object, next == null ? null : next.getGrammarElement()));
                return r;
            }
        });
        SequenceFeeder feeder = this.feederProvider.create(obj, nodes, this.masterSequencer, this.sequenceAcceptor, this.errorAcceptor);
        if (trace != null) {
            for (TraceItem ti : trace) {
                if (ti.getState() == null || ti.getState().getFeature() == null) continue;
                this.accept(ti, feeder);
            }
        } else if (this.errorAcceptor != null) {
            this.errorAcceptor.accept(this.diagnosticProvider.createBacktrackingFailedDiagnostic(obj, context, nfa));
        }
        feeder.finish();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FollowerSorter
    implements Comparator<ISemanticSequencerNfaProvider.ISemState> {
        protected EObject nodeModelEle;
        protected SerializableObject obj;

        public FollowerSorter(SerializableObject obj, EObject nodeModelEle) {
            this.obj = obj;
            this.nodeModelEle = nodeModelEle;
        }

        @Override
        public int compare(ISemanticSequencerNfaProvider.ISemState o1, ISemanticSequencerNfaProvider.ISemState o2) {
            if (this.nodeModelEle != null) {
                if (o1.getAssignedGrammarElement() == this.nodeModelEle) {
                    return -1;
                }
                if (o2.getAssignedGrammarElement() == this.nodeModelEle) {
                    return 1;
                }
            }
            if (o1.getAssignedGrammarElement() == null && o1.getAssignedGrammarElement() == null) {
                return 0;
            }
            if (o1.getAssignedGrammarElement() == null) {
                return 1;
            }
            if (o2.getAssignedGrammarElement() == null) {
                return -1;
            }
            boolean o1Opt = this.obj.isOptional(o1.getFeatureID());
            boolean o2Opt = this.obj.isOptional(o2.getFeatureID());
            if (o1Opt && o2Opt) {
                return 0;
            }
            if (o1Opt) {
                return 1;
            }
            if (o2Opt) {
                return -1;
            }
            return 0;
        }
    }

    protected class SerializableObject {
        protected EObject eObject;
        protected List<INode>[] nodes;
        protected boolean[] optional;
        protected Map<Pair<AbstractElement, Integer>, Boolean> valid = Maps.newHashMap();
        protected Object[] values;

        public SerializableObject(EObject eObject, ISemanticNodeProvider.INodesForEObjectProvider nodeProvider) {
            this.eObject = eObject;
            EClass clazz = eObject.eClass();
            this.values = new Object[clazz.getFeatureCount()];
            this.nodes = new List[clazz.getFeatureCount()];
            this.optional = new boolean[clazz.getFeatureCount()];
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                int featureID = eObject.eClass().getFeatureID(feature);
                if (feature.isMany()) {
                    switch (BacktrackingSemanticSequencer.this.transientValueService.isListTransient(eObject, feature)) {
                        case NO: {
                            ArrayList<INode> nodes1 = Lists.newArrayList();
                            List values1 = (List)eObject.eGet(feature);
                            int i = 0;
                            while (i < values1.size()) {
                                nodes1.add(nodeProvider.getNodeForMultiValue(feature, i, i, values1.get(i)));
                                ++i;
                            }
                            this.values[featureID] = values1;
                            this.nodes[featureID] = nodes1;
                            break;
                        }
                        case SOME: {
                            ArrayList<INode> nodes2 = Lists.newArrayList();
                            List values2 = (List)eObject.eGet(feature);
                            ArrayList values3 = Lists.newArrayList();
                            int i = 0;
                            int j = 0;
                            while (i < values2.size()) {
                                if (!BacktrackingSemanticSequencer.this.transientValueService.isValueInListTransient(eObject, i, feature)) {
                                    Object value = values2.get(i);
                                    INode node = nodeProvider.getNodeForMultiValue(feature, i, j++, value);
                                    values3.add(value);
                                    nodes2.add(node);
                                }
                                ++i;
                            }
                            this.values[featureID] = values3;
                            this.nodes[featureID] = nodes2;
                        }
                    }
                    continue;
                }
                switch (BacktrackingSemanticSequencer.this.transientValueService.isValueTransient(eObject, feature)) {
                    case PREFERABLY: {
                        Object value1;
                        this.optional[featureID] = true;
                        this.values[featureID] = value1 = eObject.eGet(feature);
                        this.nodes[featureID] = Collections.singletonList(nodeProvider.getNodeForSingelValue(feature, value1));
                        break;
                    }
                    case NO: {
                        Object value2;
                        this.values[featureID] = value2 = eObject.eGet(feature);
                        this.nodes[featureID] = Collections.singletonList(nodeProvider.getNodeForSingelValue(feature, value2));
                    }
                }
            }
        }

        public EObject getEObject() {
            return this.eObject;
        }

        public INode getNode(int featureID, int index) {
            List<INode> featureNodes = this.nodes[featureID];
            if (featureNodes != null && index >= 0 && index < featureNodes.size()) {
                return featureNodes.get(index);
            }
            return null;
        }

        public Object getValue(ISemanticSequencerNfaProvider.ISemState state, int index) {
            Object value = this.values[state.getFeatureID()];
            if (value instanceof List) {
                value = ((List)value).get(index);
            }
            if (!this.isValueValid(state, index, value)) {
                return null;
            }
            return value;
        }

        public int getValueCount(int featureID) {
            Object v = this.values[featureID];
            if (v == null) {
                return 0;
            }
            if (v instanceof List) {
                return ((List)v).size();
            }
            return 1;
        }

        public boolean isList(int featureID) {
            return this.values[featureID] instanceof List;
        }

        public boolean isOptional(int featureID) {
            return this.optional[featureID];
        }

        protected boolean isValueValid(ISemanticSequencerNfaProvider.ISemState state, int index, Object value) {
            if (state.getToBeValidatedAssignedElements().isEmpty()) {
                return true;
            }
            Pair<AbstractElement, Integer> key = Tuples.create(state.getAssignedGrammarElement(), index);
            if (this.valid.get(key) == Boolean.TRUE) {
                return true;
            }
            HashSet<AbstractElement> validAssignments = Sets.newHashSet(BacktrackingSemanticSequencer.this.assignmentFinder.findAssignmentsByValue(this.eObject, state.getToBeValidatedAssignedElements(), value, this.getNode(state.getFeatureID(), index)));
            boolean result = validAssignments.contains(state.getAssignedGrammarElement());
            this.valid.put(key, result);
            return result;
        }

        public String toString() {
            ArrayList<String> mandatory = Lists.newArrayList();
            ArrayList<String> optional = Lists.newArrayList();
            int i = 0;
            while (i < this.values.length) {
                int count = this.getValueCount(i);
                if (count > 0) {
                    EStructuralFeature feature = this.eObject.eClass().getEStructuralFeature(i);
                    if (this.optional[i]) {
                        optional.add(String.valueOf(feature.getName()) + "(" + count + ")");
                    } else {
                        mandatory.add(String.valueOf(feature.getName()) + "(" + count + ")");
                    }
                }
                ++i;
            }
            StringBuilder result = new StringBuilder();
            result.append("EObject: " + EmfFormatter.objPath(this.eObject) + "\n");
            if (!mandatory.isEmpty()) {
                result.append("Mandatory Values: " + Joiner.on(", ").join(mandatory) + "\n");
            }
            if (!optional.isEmpty()) {
                result.append("Optional Values: " + Joiner.on(", ").join(optional) + "\n");
            }
            return result.toString();
        }
    }

    protected static class TraceItem {
        protected int index;
        protected int[] nextIndex;
        protected INode node;
        protected SerializableObject obj;
        protected TraceItem parent;
        protected ISemanticSequencerNfaProvider.ISemState state;
        protected Object value;

        public TraceItem(SerializableObject obj) {
            this(obj, new int[obj.getEObject().eClass().getFeatureCount()]);
        }

        public TraceItem(SerializableObject obj, int[] unconsumed) {
            this.obj = obj;
            this.nextIndex = unconsumed;
        }

        public TraceItem clone(ISemanticSequencerNfaProvider.ISemState state) {
            TraceItem result = new TraceItem(this.obj, this.nextIndex);
            result.parent = this;
            result.state = state;
            result.value = this.value;
            result.index = this.index;
            result.node = this.node;
            return result;
        }

        public TraceItem cloneAndConsume(ISemanticSequencerNfaProvider.ISemState state) {
            int index = this.nextIndex[state.getFeatureID()];
            if (index >= this.obj.getValueCount(state.getFeatureID())) {
                return null;
            }
            Object value = this.obj.getValue(state, index);
            if (value == null) {
                return null;
            }
            int[] unconsumedCopy = new int[this.nextIndex.length];
            System.arraycopy(this.nextIndex, 0, unconsumedCopy, 0, this.nextIndex.length);
            unconsumedCopy[state.getFeatureID()] = index + 1;
            TraceItem result = new TraceItem(this.obj, unconsumedCopy);
            result.parent = this;
            result.state = state;
            result.value = value;
            result.index = index;
            result.node = this.obj.getNode(state.getFeatureID(), index);
            return result;
        }

        public int getIndex() {
            return this.index;
        }

        public INode getNextNode() {
            if (this.node == null) {
                return null;
            }
            NodeIterator ni = new NodeIterator(this.node);
            while (ni.hasNext()) {
                INode n = ni.next();
                if (!(n.getGrammarElement() instanceof AbstractElement)) continue;
                AbstractElement e = (AbstractElement)n.getGrammarElement();
                if ((e instanceof Keyword || e instanceof RuleCall) && GrammarUtil.isAssigned(e)) {
                    return n;
                }
                if (!GrammarUtil.isAssignedAction(e)) continue;
                return n;
            }
            return null;
        }

        public INode getNode() {
            return this.node;
        }

        public SerializableObject getObj() {
            return this.obj;
        }

        public TraceItem getParent() {
            return this.parent;
        }

        public ISemanticSequencerNfaProvider.ISemState getState() {
            return this.state;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isConsumed() {
            int i = 0;
            while (i < this.nextIndex.length) {
                int count = this.nextIndex[i];
                if (!(count >= this.obj.getValueCount(i) || count == 0 && this.obj.isOptional(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            ArrayList<String> mandatory = Lists.newArrayList();
            ArrayList<String> optional = Lists.newArrayList();
            ArrayList<String> consumed = Lists.newArrayList();
            int i = 0;
            while (i < this.nextIndex.length) {
                int count = this.nextIndex[i];
                int max = this.obj.getValueCount(i);
                EStructuralFeature feature = this.obj.getEObject().eClass().getEStructuralFeature(i);
                if (count < max) {
                    if (count == 0 && this.obj.isOptional(i)) {
                        optional.add(String.valueOf(feature.getName()) + "(" + (max - count) + ")");
                    } else {
                        mandatory.add(String.valueOf(feature.getName()) + "(" + (max - count) + ")");
                    }
                } else if (max > 0) {
                    consumed.add(String.valueOf(feature.getName()) + "(" + count + ")");
                }
                ++i;
            }
            StringBuilder result = new StringBuilder();
            result.append("EObject: " + EmfFormatter.objPath(this.obj.getEObject()) + "\n");
            result.append("Remaining Mandatory Values: " + Joiner.on(", ").join(mandatory) + "\n");
            result.append("Remaining Optional Values: " + Joiner.on(", ").join(optional) + "\n");
            result.append("Consumed Values: " + Joiner.on(", ").join(consumed) + "\n");
            return result.toString();
        }
    }
}

