/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.diagnostic;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.Context2NameFunction;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.SerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.util.formallang.GrammarStringFactory;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencerDiagnosticProvider
implements ISemanticSequencerDiagnosticProvider {
    @Inject
    protected Context2NameFunction context2Name;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    protected IGrammarConstraintProvider grammarConstraints;
    @Inject
    protected IContextFinder contextFinder;

    @Override
    public ISerializationDiagnostic createFeatureValueMissing(EObject semanticObject, EStructuralFeature feature) {
        String msg = "A value for feature '" + feature.getName() + "' is missing but required.";
        return new SerializationDiagnostic(semanticObject, msg);
    }

    @Override
    public ISerializationDiagnostic createInvalidContextOrTypeDiagnostic(EObject semanticObject, EObject context) {
        HashSet<EObject> contexts = Sets.newHashSet(this.contextFinder.findContextsByContentsAndContainer(semanticObject, null));
        List<EClass> validTypes = this.getValidTypes(context);
        ArrayList<EObject> recommendedCtxs = Lists.newArrayList();
        ArrayList<EObject> otherValidCtxs = Lists.newArrayList();
        for (EObject ctx : this.getValidContexts(semanticObject.eClass())) {
            if (contexts.contains(ctx)) {
                recommendedCtxs.add(ctx);
                continue;
            }
            otherValidCtxs.add(ctx);
        }
        String contextName = this.context2Name.apply(context);
        String semanticType = semanticObject.eClass().getName();
        String recommendCtxNames = Joiner.on(", ").join(Iterables.transform(recommendedCtxs, this.context2Name));
        String validTypeNames = Joiner.on(", ").join(Iterables.transform(validTypes, new NamedElement2Name()));
        StringBuilder msg = new StringBuilder();
        msg.append("The context '" + contextName + "' is not valid for type '" + semanticType + "'\n");
        msg.append("Recommended contexts for type '" + semanticType + "': " + recommendCtxNames + "\n");
        if (!otherValidCtxs.isEmpty()) {
            msg.append("Other valid contexts for type '" + semanticType + "': " + Joiner.on(", ").join(Iterables.transform(otherValidCtxs, this.context2Name)));
        }
        msg.append("The context '" + contextName + "' is valid for types: " + validTypeNames + "\n");
        return new SerializationDiagnostic(semanticObject, msg.toString());
    }

    protected List<EObject> getValidContexts(EClass clazz) {
        ArrayList<EObject> result = Lists.newArrayList();
        List<IGrammarConstraintProvider.IConstraintContext> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        for (IGrammarConstraintProvider.IConstraintContext ctx : constraints) {
            for (IGrammarConstraintProvider.IConstraint c2 : ctx.getConstraints()) {
                if (c2.getType() != clazz) continue;
                result.add(ctx.getContext());
            }
        }
        return result;
    }

    protected List<EClass> getValidTypes(EObject context) {
        List<IGrammarConstraintProvider.IConstraintContext> constraints = this.grammarConstraints.getConstraints(this.grammarAccess.getGrammar());
        for (IGrammarConstraintProvider.IConstraintContext ctx : constraints) {
            if (ctx.getContext() != context) continue;
            ArrayList<EClass> result = Lists.newArrayList();
            for (IGrammarConstraintProvider.IConstraint c2 : ctx.getConstraints()) {
                result.add(c2.getType());
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public ISerializationDiagnostic createBacktrackingFailedDiagnostic(EObject semanticObject, EObject context, Nfa<ISemanticSequencerNfaProvider.ISemState> nfa) {
        String grammar = (String)new NfaToGrammar().nfaToGrammar(nfa, new Function<ISemanticSequencerNfaProvider.ISemState, AbstractElement>(){

            @Override
            public AbstractElement apply(ISemanticSequencerNfaProvider.ISemState from) {
                return from.getAssignedGrammarElement();
            }
        }, new GrammarStringFactory<AbstractElement>(new GrammarElementTitleSwitch().showAssignments()));
        StringBuilder msg = new StringBuilder();
        msg.append("Could not serialize EObject via backtracking.\n");
        msg.append("Constraint: " + grammar);
        return new SerializationDiagnostic(semanticObject, context, msg.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedElement2Name
    implements Function<ENamedElement, String> {
        @Override
        public String apply(ENamedElement from) {
            return from == null ? "null" : from.getName();
        }
    }
}

