/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.grammaranalysis.INFAState;
import org.eclipse.xtext.grammaranalysis.INFATransition;
import org.eclipse.xtext.grammaranalysis.IPDAState;
import org.eclipse.xtext.grammaranalysis.impl.AbstractCachingNFABuilder;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFAProvider;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFAState;
import org.eclipse.xtext.grammaranalysis.impl.AbstractNFATransition;
import org.eclipse.xtext.grammaranalysis.impl.AbstractPDAProvider;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaToGrammar;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SyntacticSequencerPDAProvider
implements ISyntacticSequencerPDAProvider {
    protected Map<SequencerPDAContext, ISyntacticSequencerPDAProvider.ISynAbsorberState> cache = Maps.newHashMap();
    protected SequencerPDAProvider pdaProvider = this.createSequencerPDAProvider();

    protected boolean canReachAbsorber(IPDAState from, IPDAState to, Set<IPDAState> visited) {
        if (this.isMandatoryAbsorber(from.getGrammarElement()) || !visited.add(from)) {
            return false;
        }
        for (IPDAState follower : from.getFollowers()) {
            if (follower == to) {
                return true;
            }
            if (!this.canReachAbsorber(follower, to, visited)) continue;
            return true;
        }
        return false;
    }

    protected void collectFollowingAbsorberStates(IPDAState state, boolean collect, Set<IPDAState> visited, Set<IPDAState> absorber) {
        if (collect) {
            if (!visited.add(state)) {
                return;
            }
            if (this.isMandatoryAbsorber(state.getGrammarElement()) || state.getType() == IPDAState.PDAStateType.STOP) {
                absorber.add(state);
                return;
            }
            if (this.isOptionalAbsorber(state.getGrammarElement())) {
                absorber.add(state);
            }
        }
        for (IPDAState follower : state.getFollowers()) {
            this.collectFollowingAbsorberStates(follower, true, visited, absorber);
        }
    }

    protected SynAbsorberState createAbsorberState(IPDAState state, Map<IPDAState, SynAbsorberState> absorbers, Map<SynAbsorberState, Map<IPDAState, SynState>> emitters, EObject context, EClass eClass) {
        SynAbsorberState result = absorbers.get(state);
        if (result != null) {
            return result;
        }
        if (state.getType() == IPDAState.PDAStateType.STOP) {
            result = this.createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType.STOP, null, context, eClass);
            absorbers.put(state, result);
            return result;
        }
        result = this.createAbsorberState(this.getType(state), state.getGrammarElement(), context, eClass);
        absorbers.put(state, result);
        HashSet<IPDAState> followers = Sets.newHashSet();
        this.collectFollowingAbsorberStates(state, false, Sets.<IPDAState>newHashSet(), followers);
        for (IPDAState follower : followers) {
            SynAbsorberState target = this.createAbsorberState(follower, absorbers, emitters, context, eClass);
            SynTransition transition = this.createTransition(result, target);
            Map<IPDAState, SynState> emitter = emitters.get(target);
            if (emitter == null) {
                emitter = Maps.newHashMap();
                emitters.put(target, emitter);
            }
            transition.setFollowers(this.createEmitterStates(state, follower, target, emitter));
            result.addTransition(transition);
        }
        return result;
    }

    protected SynAbsorberState createAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EObject context, EClass eClass) {
        return new SynAbsorberState(type, element, context, eClass);
    }

    protected SynState createEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
        return new SynEmitterState(type, element, target);
    }

    protected List<ISyntacticSequencerPDAProvider.ISynState> createEmitterStates(IPDAState from, IPDAState to, SynAbsorberState target, Map<IPDAState, SynState> emitters) {
        ArrayList<ISyntacticSequencerPDAProvider.ISynState> result = Lists.newArrayList();
        for (IPDAState next : from.getFollowers()) {
            if (next == to) {
                result.add(target);
                continue;
            }
            if (!this.canReachAbsorber(next, to, Sets.<IPDAState>newHashSet())) continue;
            SynState emitter = emitters.get(next);
            if (emitter == null) {
                emitter = this.createEmitterState(this.getType(next), next.getGrammarElement(), target);
                emitters.put(next, emitter);
                emitter.setFollowers(this.createEmitterStates(next, to, target, emitters));
            }
            result.add(emitter);
        }
        return result;
    }

    protected SequencerNFAProvider createSequenceParserNFAProvider() {
        return new SequencerNFAProvider();
    }

    protected SequencerPDAProvider createSequencerPDAProvider() {
        return new SequencerPDAProvider(this.createSequenceParserNFAProvider());
    }

    protected SynTransition createTransition(SynAbsorberState source, SynAbsorberState target) {
        return new SynTransition(source, target);
    }

    @Override
    public ISyntacticSequencerPDAProvider.ISynAbsorberState getPDA(EObject context, EClass type) {
        SequencerPDAContext ctx = new SequencerPDAContext(context, type);
        ISyntacticSequencerPDAProvider.ISynAbsorberState result = this.cache.get(ctx);
        if (result == null) {
            HashMap<IPDAState, SynAbsorberState> absorbers = Maps.newHashMap();
            HashMap<SynAbsorberState, Map<IPDAState, SynState>> emitters = Maps.newHashMap();
            result = this.createAbsorberState(this.pdaProvider.getPDA(ctx), absorbers, emitters, context, type);
            this.cache.put(ctx, result);
        }
        return result;
    }

    protected ISyntacticSequencerPDAProvider.SynStateType getType(IPDAState state) {
        switch (state.getType()) {
            case ELEMENT: {
                AbstractElement ele = state.getGrammarElement();
                if (ele instanceof Action) {
                    if (((Action)ele).getFeature() == null) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_ACTION_CALL;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ACTION_CALL;
                }
                if (GrammarUtil.containingCrossReference(ele) != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_CROSSREF_KEYWORD;
                }
                Assignment ass = GrammarUtil.containingAssignment(ele);
                if (ass != null) {
                    if (ele instanceof RuleCall) {
                        RuleCall rc = (RuleCall)ele;
                        if (rc.getRule() instanceof ParserRule) {
                            if (rc.getRule().getType().getClassifier() instanceof EClass) {
                                return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_PARSER_RULE_CALL;
                            }
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_DATATYPE_RULE_CALL;
                        }
                        if (rc.getRule() instanceof TerminalRule) {
                            return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_TERMINAL_RULE_CALL;
                        }
                        if (!(rc.getRule() instanceof EnumRule)) break;
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_ENUM_RULE_CALL;
                    }
                    if (!(ele instanceof Keyword)) break;
                    if (GrammarUtil.isBooleanAssignment(ass)) {
                        return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_BOOLEAN_KEYWORD;
                    }
                    return ISyntacticSequencerPDAProvider.SynStateType.ASSIGNED_KEYWORD;
                }
                if (ele instanceof RuleCall) {
                    RuleCall rc = (RuleCall)ele;
                    if (rc.getRule() instanceof ParserRule) {
                        return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL;
                    }
                    if (!(rc.getRule() instanceof TerminalRule)) break;
                    return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL;
                }
                if (!(ele instanceof Keyword)) break;
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_KEYWORD;
            }
            case RULECALL_ENTER: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_ENTER;
            }
            case RULECALL_EXIT: {
                return ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT;
            }
            case START: {
                return ISyntacticSequencerPDAProvider.SynStateType.START;
            }
            case STOP: {
                return ISyntacticSequencerPDAProvider.SynStateType.STOP;
            }
        }
        throw new RuntimeException("no type found for " + state);
    }

    protected boolean isMandatoryAbsorber(AbstractElement ele) {
        if (ele == null) {
            return true;
        }
        if (GrammarUtil.isAssigned(ele)) {
            return true;
        }
        return GrammarUtil.isAssignedAction(ele);
    }

    protected boolean isOptionalAbsorber(AbstractElement ele) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NavigablePDA
    implements Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> {
        protected ISyntacticSequencerPDAProvider.ISynNavigable navigable;

        public NavigablePDA(ISyntacticSequencerPDAProvider.ISynNavigable navigable) {
            this.navigable = navigable;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynState getStop() {
            return this.navigable.getTarget();
        }

        @Override
        public Iterable<ISyntacticSequencerPDAProvider.ISynState> getFollowers(ISyntacticSequencerPDAProvider.ISynState node) {
            if (node instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                if (this.navigable instanceof ISyntacticSequencerPDAProvider.ISynTransition && ((ISyntacticSequencerPDAProvider.ISynTransition)this.navigable).getSource() == node) {
                    return this.navigable.getFollowers();
                }
                return Collections.emptyList();
            }
            return node.getFollowers();
        }

        @Override
        public RuleCall getPop(ISyntacticSequencerPDAProvider.ISynState state) {
            return state.getType().getSimpleType() == IPDAState.PDAStateType.RULECALL_EXIT ? (RuleCall)state.getGrammarElement() : null;
        }

        @Override
        public RuleCall getPush(ISyntacticSequencerPDAProvider.ISynState state) {
            return state.getType().getSimpleType() == IPDAState.PDAStateType.RULECALL_ENTER ? (RuleCall)state.getGrammarElement() : null;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynState getStart() {
            if (this.navigable instanceof ISyntacticSequencerPDAProvider.ISynTransition) {
                return ((ISyntacticSequencerPDAProvider.ISynTransition)this.navigable).getSource();
            }
            return (ISyntacticSequencerPDAProvider.ISynState)((Object)this.navigable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFAProvider
    extends AbstractNFAProvider<SequencerNFAState, SequencerNFATransition> {
        @Override
        protected IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> createBuilder() {
            return new SequencerNFABuilder();
        }

        public IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> getBuilder() {
            return this.builder;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class SequencerNFABuilder
        extends AbstractCachingNFABuilder<SequencerNFAState, SequencerNFATransition> {
            @Override
            public SequencerNFAState createState(AbstractElement ele) {
                return new SequencerNFAState(ele, this);
            }

            @Override
            protected SequencerNFATransition createTransition(SequencerNFAState source, SequencerNFAState target, boolean isRuleCall, AbstractElement loopCenter) {
                return new SequencerNFATransition(source, target, isRuleCall, loopCenter);
            }

            @Override
            public boolean filter(AbstractElement ele) {
                if (ele instanceof CompoundElement) {
                    return true;
                }
                if (ele instanceof Assignment) {
                    return true;
                }
                return ele instanceof CrossReference;
            }

            @Override
            public IGrammarNFAProvider.NFADirection getDirection() {
                return IGrammarNFAProvider.NFADirection.FORWARD;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFAState
    extends AbstractNFAState<SequencerNFAState, SequencerNFATransition> {
        public SequencerNFAState(AbstractElement element, IGrammarNFAProvider.NFABuilder<SequencerNFAState, SequencerNFATransition> builder) {
            super(element, builder);
        }

        public List<SequencerNFATransition> collectOutgoingTransitions() {
            this.outgoing = Lists.newArrayList();
            this.outgoingRuleCalls = Lists.newArrayList();
            this.collectOutgoing(this.element, Sets.<AbstractElement>newHashSet(), false, null);
            this.removeDuplicates(this.outgoing);
            this.removeDuplicates(this.outgoingRuleCalls);
            return this.outgoingRuleCalls.isEmpty() ? this.outgoing : this.outgoingRuleCalls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerNFATransition
    extends AbstractNFATransition<SequencerNFAState, SequencerNFATransition> {
        public SequencerNFATransition(SequencerNFAState source, SequencerNFAState target, boolean ruleCall, AbstractElement loopCenter) {
            super(source, target, ruleCall, loopCenter);
        }
    }

    public static class SequencerPDAContext {
        protected EObject context;
        protected EClass type;

        public SequencerPDAContext(EObject context, EClass type) {
            this.context = context;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SequencerPDAContext other = (SequencerPDAContext)obj;
            return this.context == other.context && this.type == other.type;
        }

        public EObject getContext() {
            return this.context;
        }

        public EClass getType() {
            return this.type;
        }

        public int hashCode() {
            return this.context.hashCode() + (this.type == null ? 0 : this.type.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SequencerPDAProvider
    extends AbstractPDAProvider<SequencerPDAContext> {
        protected SequencerNFAProvider nfaProvider;

        public SequencerPDAProvider(SequencerNFAProvider nfaProvider) {
            this.nfaProvider = nfaProvider;
        }

        @Override
        protected boolean canEnterRuleCall(INFAState<?, ?> state) {
            if (!(state.getGrammarElement() instanceof RuleCall)) {
                return false;
            }
            RuleCall rc = (RuleCall)state.getGrammarElement();
            if (!(rc.getRule() instanceof ParserRule) || !(rc.getRule().getType().getClassifier() instanceof EClass)) {
                return false;
            }
            return GrammarUtil.containingAssignment(rc) == null;
        }

        @Override
        protected boolean canPass(SequencerPDAContext context, INFAState<?, ?> state, EClass constructedType) {
            AbstractElement ele = state.getGrammarElement();
            if (ele instanceof Action) {
                return ((Action)ele).getType().getClassifier() == context.getType();
            }
            if (constructedType != null) {
                return true;
            }
            if (GrammarUtil.containingAssignment(ele) != null) {
                return GrammarUtil.containingRule(ele).getType().getClassifier() == context.getType();
            }
            return true;
        }

        protected boolean canReachElement(INFAState<?, ?> from, AbstractElement to, Set<Object> visited) {
            if (!visited.add(from)) {
                return false;
            }
            if (from.getGrammarElement() == to) {
                return true;
            }
            for (INFATransition trans : from.getAllOutgoing()) {
                if (trans.isRuleCall() || !this.canReachElement((INFAState<?, ?>)trans.getTarget(), to, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean canReachEndState(INFAState<?, ?> from, Set<Object> visited) {
            if (!visited.add(from)) {
                return false;
            }
            if (from.isEndState()) {
                return true;
            }
            for (INFATransition trans : from.getAllOutgoing()) {
                if (trans.isRuleCall() || !this.canReachEndState((INFAState<?, ?>)trans.getTarget(), visited)) continue;
                return true;
            }
            return false;
        }

        protected List<INFAState<?, ?>> getActionStartFollowers(Action action) {
            ParserRule rule = GrammarUtil.containingParserRule(action);
            ArrayList<INFAState<?, ?>> result = Lists.newArrayList();
            for (INFAState<?, ?> state : this.getAllRuleStartFollowers(rule)) {
                if (!this.canReachElement(state, action, Sets.<Object>newHashSet())) continue;
                result.add(state);
            }
            return result;
        }

        protected List<INFAState<?, ?>> getAllRuleStartFollowers(ParserRule pr) {
            SequencerNFAState startNfa = (SequencerNFAState)this.nfaProvider.getNFA(pr.getAlternatives());
            ArrayList<INFAState<?, ?>> result = Lists.newArrayList();
            if (this.nfaProvider.getBuilder().filter(pr.getAlternatives())) {
                for (SequencerNFATransition transition : startNfa.collectOutgoingTransitions()) {
                    result.add((INFAState<?, ?>)transition.getTarget());
                }
            } else {
                result.add(startNfa);
            }
            for (Action a2 : GrammarUtil.containedActions(pr)) {
                if (!GrammarUtil.isAssignedAction(a2)) continue;
                result.add((INFAState)this.nfaProvider.getNFA(a2));
            }
            return result;
        }

        @Override
        protected List<INFAState<?, ?>> getFollowers(SequencerPDAContext context, INFAState<?, ?> state, boolean returning, boolean canReturn) {
            ArrayList<INFAState<?, ?>> result = Lists.newArrayList();
            for (INFATransition transition : returning ? state.getOutgoingAfterReturn() : state.getOutgoing()) {
                if (!GrammarUtil.isAssignedAction(((INFAState)transition.getTarget()).getGrammarElement())) {
                    result.add((INFAState<?, ?>)transition.getTarget());
                }
                if (!transition.isRuleCall()) continue;
                for (Action action : GrammarUtil.containedActions(GrammarUtil.containingRule(((INFAState)transition.getTarget()).getGrammarElement()))) {
                    if (!GrammarUtil.isAssignedAction(action)) continue;
                    result.add((INFAState)this.nfaProvider.getNFA(action));
                }
            }
            return result;
        }

        protected List<INFAState<?, ?>> getParserRuleStartFollowers(ParserRule rule) {
            ArrayList<INFAState<?, ?>> result = Lists.newArrayList();
            for (INFAState<?, ?> state : this.getAllRuleStartFollowers(rule)) {
                if (!this.canReachEndState(state, Sets.<Object>newHashSet())) continue;
                result.add(state);
            }
            return result;
        }

        @Override
        protected List<INFAState<?, ?>> getStartFollowers(SequencerPDAContext context) {
            if (context.getContext() instanceof ParserRule) {
                return this.getParserRuleStartFollowers((ParserRule)context.getContext());
            }
            if (context.getContext() instanceof Action) {
                return this.getActionStartFollowers((Action)context.getContext());
            }
            return Collections.emptyList();
        }

        @Override
        protected boolean isFinalState(SequencerPDAContext context, INFAState<?, ?> state, boolean returning, boolean canReturn) {
            if (context.getContext() instanceof Action) {
                for (INFATransition transition : returning ? state.getOutgoingAfterReturn() : state.getOutgoing()) {
                    if (((INFAState)transition.getTarget()).getGrammarElement() != context.getContext()) continue;
                    return true;
                }
            } else if (canReturn && context.getContext() instanceof ParserRule && state.isEndState() && GrammarUtil.containingParserRule(state.getGrammarElement()) == context.getContext()) {
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynAbsorberState
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynAbsorberState {
        protected EObject context;
        protected EClass eClass;
        protected Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> outTransitionsByElement = Maps.newHashMap();
        protected List<ISyntacticSequencerPDAProvider.ISynAbsorberState> outAbsorber = Lists.newArrayList();

        public SynAbsorberState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, EObject context, EClass eClass) {
            super(type, element);
            this.context = context;
            this.eClass = eClass;
        }

        protected void addTransition(ISyntacticSequencerPDAProvider.ISynTransition transition) {
            this.addFollower(transition.getFollowers());
            this.outAbsorber.add(transition.getTarget());
            switch (transition.getTarget().getType().getSimpleType()) {
                case START: {
                    throw new UnsupportedOperationException("StartStates can not have incoming transitions");
                }
                case ELEMENT: 
                case STOP: {
                    if (this.outTransitionsByElement.isEmpty()) {
                        this.outTransitionsByElement = Maps.newHashMap();
                    }
                    this.outTransitionsByElement.put(transition.getTarget().getGrammarElement(), transition);
                }
            }
        }

        @Override
        public EObject getContext() {
            return this.context;
        }

        @Override
        public EClass getEClass() {
            return this.eClass;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitions() {
            ArrayList<ISyntacticSequencerPDAProvider.ISynTransition> result = Lists.newArrayList();
            result.addAll(this.outTransitionsByElement.values());
            return result;
        }

        @Override
        public Map<AbstractElement, ISyntacticSequencerPDAProvider.ISynTransition> getOutTransitionsByElement() {
            return this.outTransitionsByElement;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynAbsorberState> getOutAbsorbers() {
            return this.outAbsorber;
        }
    }

    protected static class SynEmitterState
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynEmitterState {
        public SynEmitterState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, SynAbsorberState target) {
            super(type, element, target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynNavigable
    extends SynState
    implements ISyntacticSequencerPDAProvider.ISynNavigable {
        protected static final List<ISyntacticSequencerPDAProvider.ISynState> RULE_EXIT_DEPENDENT = Lists.newArrayList();
        protected int distanceToAbsorber = -1;
        protected Boolean involvesRuleExit;
        protected Boolean involvesUnassignedTokenRuleCalls = null;
        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestPathToAbsorber = null;
        protected Boolean syntacticallyAmbiguous = null;
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState target;

        public SynNavigable(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(type, element);
            this.target = target;
        }

        @Override
        public EObject getContext() {
            return this.target.getContext();
        }

        @Override
        public EClass getEClass() {
            return this.target.getEClass();
        }

        @Override
        public Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> getPathToTarget() {
            return new NavigablePDA(this);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathTo(final AbstractElement ele, RuleCallStack stack) {
            return this.shortestPathTo(stack.iterator(), new Predicate<ISyntacticSequencerPDAProvider.ISynState>(){

                @Override
                public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                    return input.getGrammarElement() == ele;
                }
            }, true);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestPathToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            if (this.shortestPathToAbsorber == null) {
                this.shortestPathToAbsorber = this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            return this.shortestPathToAbsorber;
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestStackpruningPathTo(final AbstractElement ele, RuleCallStack stack) {
            return this.shortestStackpruningPathTo(stack.iterator(), new Predicate<ISyntacticSequencerPDAProvider.ISynState>(){

                @Override
                public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                    return input.getGrammarElement() == ele;
                }
            }, true);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getShortestStackpruningPathToAbsorber(RuleCallStack stack) {
            if (this.involvesRuleExit().booleanValue()) {
                return this.shortestStackpruningPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            if (this.shortestPathToAbsorber == null) {
                this.shortestPathToAbsorber = this.shortestPathTo(stack.iterator(), Predicates.equalTo(this.getTarget()), false);
            }
            return this.shortestPathToAbsorber;
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getTarget() {
            return this.target;
        }

        @Override
        public boolean hasEmitters() {
            return this.getFollowers().size() != 1 || !(this.getFollowers().get(0) instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState);
        }

        protected boolean involves(ISyntacticSequencerPDAProvider.ISynState from, Set<ISyntacticSequencerPDAProvider.SynStateType> types, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (types.contains((Object)from.getType())) {
                return true;
            }
            if (!visited.add(from)) {
                return false;
            }
            for (ISyntacticSequencerPDAProvider.ISynState state : from.getFollowers()) {
                if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState || !this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean involves(Set<ISyntacticSequencerPDAProvider.SynStateType> types) {
            HashSet<ISyntacticSequencerPDAProvider.ISynState> visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : this.followers) {
                if (!this.involves(state, types, visited)) continue;
                return true;
            }
            return false;
        }

        protected Boolean involvesRuleExit() {
            if (this.involvesRuleExit == null) {
                this.involvesRuleExit = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_PARSER_RULE_EXIT));
            }
            return this.involvesRuleExit;
        }

        @Override
        public boolean involvesUnassignedTokenRuleCalls() {
            if (this.involvesUnassignedTokenRuleCalls == null) {
                this.involvesUnassignedTokenRuleCalls = this.involves(EnumSet.of(ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_DATATYPE_RULE_CALL, ISyntacticSequencerPDAProvider.SynStateType.UNASSIGNED_TERMINAL_RULE_CALL));
            }
            return this.involvesUnassignedTokenRuleCalls;
        }

        @Override
        public boolean isSyntacticallyAmbiguous() {
            if (this.syntacticallyAmbiguous == null) {
                this.syntacticallyAmbiguous = this.isSyntacticallyAmbiguous(this.followers);
            }
            return this.syntacticallyAmbiguous;
        }

        protected boolean isSyntacticallyAmbiguous(ISyntacticSequencerPDAProvider.ISynState state, RuleCallStack exits, RuleCallStack stack, List<RuleCallStack> results, Set<ISyntacticSequencerPDAProvider.ISynState> visited) {
            if (!visited.add(state)) {
                return true;
            }
            if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
                results.add(exits);
                return false;
            }
            switch (state.getType().getSimpleType()) {
                case RULECALL_ENTER: {
                    stack = (RuleCallStack)stack.cloneAndPush((RuleCall)state.getGrammarElement());
                    break;
                }
                case RULECALL_EXIT: {
                    RuleCall rc = (RuleCall)state.getGrammarElement();
                    if (!stack.isEmpty()) {
                        if (rc == stack.peek()) {
                            stack = (RuleCallStack)stack.cloneAndPop();
                            break;
                        }
                        return false;
                    }
                    if (exits.contains(rc)) {
                        return false;
                    }
                    visited = Sets.newHashSet();
                    exits = (RuleCallStack)exits.cloneAndPush(rc);
                    break;
                }
            }
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                if (!this.isSyntacticallyAmbiguous(follower, exits, stack, results, visited)) continue;
                return true;
            }
            return false;
        }

        protected boolean isSyntacticallyAmbiguous(List<ISyntacticSequencerPDAProvider.ISynState> states) {
            RuleCallStack exits = new RuleCallStack();
            RuleCallStack stack = new RuleCallStack();
            ArrayList<RuleCallStack> results = Lists.newArrayList();
            HashSet<ISyntacticSequencerPDAProvider.ISynState> visited = Sets.newHashSet();
            for (ISyntacticSequencerPDAProvider.ISynState state : states) {
                if (!this.isSyntacticallyAmbiguous(state, exits, stack, results, visited)) continue;
                return true;
            }
            return results.size() != Sets.newHashSet(results).size();
        }

        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestPathTo(Iterator<RuleCall> stack, Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, boolean includeMatch) {
            List<Predicate<ISyntacticSequencerPDAProvider.ISynState>> pathTo = new PdaUtil().shortestPathTo(this.getPathToTarget(), stack, matches);
            if (pathTo != null) {
                return pathTo.subList(1, pathTo.size() - (includeMatch ? 0 : 1));
            }
            return null;
        }

        protected List<ISyntacticSequencerPDAProvider.ISynState> shortestStackpruningPathTo(Iterator<RuleCall> stack, Predicate<ISyntacticSequencerPDAProvider.ISynState> matches, boolean includeMatch) {
            List<Predicate<ISyntacticSequencerPDAProvider.ISynState>> pathTo = new PdaUtil().shortestStackpruningPathTo(this.getPathToTarget(), stack, matches);
            if (pathTo != null) {
                return pathTo.subList(1, pathTo.size() - (includeMatch ? 0 : 1));
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class SynState
    implements ISyntacticSequencerPDAProvider.ISynState {
        protected AbstractElement element;
        protected List<ISyntacticSequencerPDAProvider.ISynState> followers = Collections.emptyList();
        protected ISyntacticSequencerPDAProvider.SynStateType type;

        public SynState(ISyntacticSequencerPDAProvider.SynStateType type, AbstractElement element) {
            this.type = type;
            this.element = element;
            this.followers = Collections.emptyList();
        }

        protected void addFollower(ISyntacticSequencerPDAProvider.ISynState follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.add(follower);
        }

        protected void addFollower(List<ISyntacticSequencerPDAProvider.ISynState> follower) {
            if (this.followers.isEmpty()) {
                this.followers = Lists.newArrayList();
            }
            this.followers.addAll(follower);
        }

        @Override
        public List<ISyntacticSequencerPDAProvider.ISynState> getFollowers() {
            return this.followers;
        }

        @Override
        public AbstractElement getGrammarElement() {
            return this.element;
        }

        @Override
        public ISyntacticSequencerPDAProvider.SynStateType getType() {
            return this.type;
        }

        protected void setFollowers(List<ISyntacticSequencerPDAProvider.ISynState> followers) {
            this.followers = followers;
        }

        public String toString() {
            return this.toString(new GrammarElementTitleSwitch().showAssignments());
        }

        @Override
        public String toString(Function<AbstractElement, String> elementFormatter) {
            if (this.type == null) {
                return "(type is null)";
            }
            switch (this.type.getSimpleType()) {
                case ELEMENT: {
                    return this.element == null ? "(null)" : elementFormatter.apply(this.element);
                }
                case RULECALL_ENTER: {
                    return ">>" + (this.element == null ? "(null)" : elementFormatter.apply(this.element));
                }
                case RULECALL_EXIT: {
                    return "<<" + (this.element == null ? "(null)" : elementFormatter.apply(this.element));
                }
                case START: {
                    return "start";
                }
                case STOP: {
                    return "stop";
                }
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SynTransition
    extends SynNavigable
    implements ISyntacticSequencerPDAProvider.ISynTransition {
        protected static final GrammarAlias.AbstractElementAlias UNINITIALIZED = new GrammarAlias.TokenAlias(false, false, null);
        protected GrammarAlias.AbstractElementAlias ambiguousSyntax = UNINITIALIZED;
        protected List<GrammarAlias.AbstractElementAlias> ambiguousSyntaxes;
        protected ISyntacticSequencerPDAProvider.ISynAbsorberState source;

        public SynTransition(ISyntacticSequencerPDAProvider.ISynAbsorberState source, ISyntacticSequencerPDAProvider.ISynAbsorberState target) {
            super(ISyntacticSequencerPDAProvider.SynStateType.TRANSITION, null, target);
            this.source = source;
        }

        @Override
        public GrammarAlias.AbstractElementAlias getAmbiguousSyntax() {
            if (this.ambiguousSyntax != UNINITIALIZED) {
                return this.ambiguousSyntax;
            }
            this.ambiguousSyntax = this.getShortSyntax();
            if (this.ambiguousSyntax instanceof GrammarAlias.GroupAlias) {
                GrammarAlias.GroupAlias group = (GrammarAlias.GroupAlias)this.ambiguousSyntax;
                Collection children = group.getChildren();
                int start = 0;
                while (start < children.size() && children.get(start) instanceof GrammarAlias.TokenAlias && !((GrammarAlias.AbstractElementAlias)children.get(start)).isMany() && !((GrammarAlias.AbstractElementAlias)children.get(start)).isOptional()) {
                    ++start;
                }
                int end = children.size() - 1;
                while (end >= 0 && children.get(end) instanceof GrammarAlias.TokenAlias && !((GrammarAlias.AbstractElementAlias)children.get(end)).isMany() && !((GrammarAlias.AbstractElementAlias)children.get(end)).isOptional()) {
                    --end;
                }
                if (start <= end) {
                    group = new GrammarAlias.GroupAlias(false, false, children.subList(start, end + 1));
                    this.ambiguousSyntax = group;
                    if (group.children.size() == 1) {
                        this.ambiguousSyntax = group.children.get(0);
                    }
                } else {
                    this.ambiguousSyntax = null;
                }
            }
            return this.ambiguousSyntax;
        }

        @Override
        public List<GrammarAlias.AbstractElementAlias> getAmbiguousSyntaxes() {
            if (this.ambiguousSyntaxes != null) {
                return this.ambiguousSyntaxes;
            }
            if (!this.isSyntacticallyAmbiguous()) {
                this.ambiguousSyntaxes = Collections.emptyList();
                return this.ambiguousSyntaxes;
            }
            this.ambiguousSyntaxes = Lists.newArrayList();
            Nfa<ISyntacticSequencerPDAProvider.ISynState> nfa = new PdaUtil().filterUnambiguousPaths(this.getPathToTarget());
            GrammarAlias.AbstractElementAlias syntax = new NfaToGrammar().nfaToGrammar(nfa = new NfaUtil().filter(nfa, new Filter()), new ISyntacticSequencerPDAProvider.GetGrammarElement(), new GrammarAlias.GrammarAliasFactory());
            if (syntax instanceof GrammarAlias.GroupAlias) {
                GrammarAlias.GroupAlias group = (GrammarAlias.GroupAlias)syntax;
                for (GrammarAlias.AbstractElementAlias child : group.getChildren()) {
                    if (!child.isMany() && !child.isOptional() && !(child instanceof GrammarAlias.AlternativeAlias)) continue;
                    this.ambiguousSyntaxes.add(child);
                }
            } else {
                this.ambiguousSyntaxes.add(syntax);
            }
            return this.ambiguousSyntaxes;
        }

        public GrammarAlias.AbstractElementAlias getShortSyntax() {
            Nfa<ISyntacticSequencerPDAProvider.ISynState> path = new NfaUtil().filter(this.getPathToTarget(), new Filter());
            return new NfaToGrammar().nfaToGrammar(path, new ISyntacticSequencerPDAProvider.GetGrammarElement(), new GrammarAlias.GrammarAliasFactory());
        }

        @Override
        public ISyntacticSequencerPDAProvider.ISynAbsorberState getSource() {
            return this.source;
        }

        public GrammarAlias.AbstractElementAlias getSyntax() {
            Pda<ISyntacticSequencerPDAProvider.ISynState, RuleCall> pathToTarget = this.getPathToTarget();
            return new NfaToGrammar().nfaToGrammar(pathToTarget, new ISyntacticSequencerPDAProvider.GetGrammarElement(), new GrammarAlias.GrammarAliasFactory());
        }

        @Override
        public String toString() {
            return this.getSyntax().toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class Filter
        implements Predicate<ISyntacticSequencerPDAProvider.ISynState> {
            private Filter() {
            }

            @Override
            public boolean apply(ISyntacticSequencerPDAProvider.ISynState input) {
                AbstractElement ge = input.getGrammarElement();
                return ge instanceof Keyword || GrammarUtil.isDatatypeRuleCall(ge) || GrammarUtil.isEnumRuleCall(ge) || GrammarUtil.isTerminalRuleCall(ge);
            }
        }
    }
}

