/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceDescriptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptionsProvider {
    public static final String NAMED_BUILDER_SCOPE = "org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE";
    public static final String LIVE_SCOPE = "org.eclipse.xtext.scoping.LIVE_SCOPE";
    @Inject
    @Named(value="org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE")
    private Provider<IResourceDescriptions> builderScopeResourceDescriptions;
    @Inject
    @Named(value="org.eclipse.xtext.scoping.LIVE_SCOPE")
    private Provider<IResourceDescriptions> liveScopeResourceDescriptions;
    @Inject
    private Provider<IResourceDescriptions> resourceDescriptions;

    public IResourceDescriptions getResourceDescriptions(Resource resource) {
        Map<Object, Object> loadOptions = resource.getResourceSet().getLoadOptions();
        IResourceDescriptions result = this.createResourceDescriptions();
        if (loadOptions.containsKey(NAMED_BUILDER_SCOPE)) {
            result = this.createBuilderScopeResourceDescriptions();
        }
        if (loadOptions.containsKey(LIVE_SCOPE)) {
            result = this.createLiveScopeResourceDescriptions();
        }
        if (result instanceof IResourceDescriptions.IContextAware) {
            ((IResourceDescriptions.IContextAware)result).setContext(resource);
        }
        return result;
    }

    public IResourceDescriptions createLiveScopeResourceDescriptions() {
        return this.liveScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createBuilderScopeResourceDescriptions() {
        return this.builderScopeResourceDescriptions.get();
    }

    public IResourceDescriptions createResourceDescriptions() {
        return this.resourceDescriptions.get();
    }

    public void setBuilderScopeResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.builderScopeResourceDescriptions = resourceDescriptions;
    }

    public void setResourceDescriptions(Provider<IResourceDescriptions> resourceDescriptions) {
        this.resourceDescriptions = resourceDescriptions;
    }
}

