/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainer
extends AbstractCompoundSelectable
implements IContainer {
    protected Iterable<IResourceDescription> getSelectables() {
        return this.getResourceDescriptions();
    }

    @Override
    public int getResourceDescriptionCount() {
        return Iterables.size(this.getResourceDescriptions());
    }

    @Override
    public boolean hasResourceDescription(URI uri) {
        return this.getResourceDescription(uri) != null;
    }

    @Override
    public IResourceDescription getResourceDescription(final URI uri) {
        return Iterables.find(this.getResourceDescriptions(), new Predicate<IResourceDescription>(){

            @Override
            public boolean apply(IResourceDescription input) {
                return uri.equals(input.getURI());
            }
        });
    }

    @Override
    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getNormalizedResourceURI(object);
        IResourceDescription description = this.getResourceDescription(resourceURI);
        if (description == null) {
            return Collections.emptyList();
        }
        return description.getExportedObjectsByObject(object);
    }
}

