/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.containers.IAllContainersState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetBasedAllContainersState
implements IAllContainersState {
    private SetMultimap<String, URI> container2URIs;
    private SetMultimap<URI, String> uri2container;
    private List<String> containers;

    public void configure(List<String> containers, Multimap<String, URI> container2Uris) {
        this.containers = containers;
        this.container2URIs = HashMultimap.create(container2Uris);
        this.uri2container = Multimaps.invertFrom(HashMultimap.create(container2Uris), HashMultimap.create());
    }

    @Override
    public List<String> getVisibleContainerHandles(String handle) {
        return this.containers;
    }

    @Override
    public Collection<URI> getContainedURIs(String containerHandle) {
        return this.container2URIs.get(containerHandle);
    }

    @Override
    public boolean isEmpty(String containerHandle) {
        return this.getContainedURIs(containerHandle).isEmpty();
    }

    @Override
    public String getContainerHandle(URI uri) {
        Set<String> set = this.uri2container.get(uri);
        if (set != null && !set.isEmpty()) {
            return set.iterator().next();
        }
        return null;
    }
}

