/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.AbstractEObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectDescription
extends AbstractEObjectDescription {
    private final Map<String, String> userData;
    private final QualifiedName qualifiedName;
    private final EObject element;
    private URI normalizedURI;

    public EObjectDescription(QualifiedName qualifiedName, EObject element, Map<String, String> userData) {
        if (qualifiedName == null) {
            throw new NullPointerException("qualified name may not be null");
        }
        this.qualifiedName = qualifiedName;
        this.element = element;
        this.userData = userData;
    }

    public static IEObjectDescription create(String simpleName, EObject element, Map<String, String> userData) {
        return EObjectDescription.create(QualifiedName.create(simpleName), element, userData);
    }

    public static IEObjectDescription create(String simpleName, EObject element) {
        return EObjectDescription.create(QualifiedName.create(simpleName), element, Collections.<String, String>emptyMap());
    }

    public static IEObjectDescription create(QualifiedName qualifiedName, EObject element, Map<String, String> userData) {
        return new EObjectDescription(qualifiedName, element, userData);
    }

    public static IEObjectDescription create(QualifiedName qualifiedName, EObject element) {
        return EObjectDescription.create(qualifiedName, element, Collections.<String, String>emptyMap());
    }

    @Override
    public EObject getEObjectOrProxy() {
        return this.element;
    }

    @Override
    public URI getEObjectURI() {
        if (this.normalizedURI == null) {
            this.normalizedURI = this.normalize(this.element, EcoreUtil.getURI(this.element));
        }
        return this.normalizedURI;
    }

    protected URI normalize(EObject element, URI uri) {
        if (element != null && element.eResource() != null && element.eResource().getResourceSet() != null) {
            return element.eResource().getResourceSet().getURIConverter().normalize(uri);
        }
        return uri;
    }

    @Override
    public QualifiedName getName() {
        return this.qualifiedName;
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getUserData(String name) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(name);
    }

    @Override
    public String[] getUserDataKeys() {
        if (this.userData == null) {
            return Strings.EMPTY_ARRAY;
        }
        return this.userData.keySet().toArray(new String[this.userData.size()]);
    }

    @Override
    public EClass getEClass() {
        return this.element.eClass();
    }
}

