/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parsetree.reconstr.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.parsetree.reconstr.IEObjectConsumer;
import org.eclipse.xtext.parsetree.reconstr.IParseTreeConstructor;
import org.eclipse.xtext.parsetree.reconstr.ITokenSerializer;
import org.eclipse.xtext.parsetree.reconstr.impl.AbstractParseTreeConstructor;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstState;
import org.eclipse.xtext.parsetree.reconstr.impl.TreeConstructionNFAProvider;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeConstructionReportImpl
implements IParseTreeConstructor.TreeConstructionReport {
    private static final int THRESHOLD = 10;
    protected SortedSet<Pair<Integer, AbstractParseTreeConstructor.AbstractToken>> deadends = Sets.newTreeSet(new Comparator<Pair<Integer, AbstractParseTreeConstructor.AbstractToken>>(){

        @Override
        public int compare(Pair<Integer, AbstractParseTreeConstructor.AbstractToken> o1, Pair<Integer, AbstractParseTreeConstructor.AbstractToken> o2) {
            return o1.getFirst().compareTo(o2.getFirst());
        }
    });
    protected TreeConstructionDiagnosticImpl diagnostic;
    @Inject
    protected ITokenSerializer.IEnumLiteralSerializer enumSerializer;
    @Inject
    protected TreeConstructionNFAProvider nfaProvider;
    private ITextRegion previousLocation;
    protected EObject root;
    protected AbstractParseTreeConstructor.AbstractToken success;
    @Inject
    protected ITokenSerializer.IValueSerializer valueSerializer;

    protected void addDeadEnd(int depth, AbstractParseTreeConstructor.AbstractToken deadend) {
        if (this.deadends.size() >= 10 && depth < this.deadends.first().getFirst()) {
            return;
        }
        if (this.deadends.size() >= 10) {
            this.deadends.remove(this.deadends.first());
        }
        this.deadends.add(Tuples.pair(depth, deadend));
    }

    protected String checkUnconsumed(AbstractParseTreeConstructor.AbstractToken token, IEObjectConsumer instanceDescription) {
        if (token.getGrammarElement() == null) {
            return null;
        }
        boolean finalNode = ((TreeConstState)this.nfaProvider.getNFA(token.getGrammarElement())).isEndState();
        if (!finalNode || instanceDescription.isConsumed()) {
            return null;
        }
        ParserRule parserRule = GrammarUtil.containingParserRule(token.getGrammarElement());
        StringBuffer b2 = new StringBuffer();
        b2.append("Can not leave rule '");
        b2.append(parserRule.getName());
        b2.append("' since the current object '");
        b2.append(instanceDescription.getEObject().eClass().getName());
        b2.append("' has features with unconsumed values: ");
        Map<EStructuralFeature, Integer> unconsumedTokens = instanceDescription.getUnconsumed();
        int i = 0;
        for (Map.Entry<EStructuralFeature, Integer> unconsumedFeature2NumberEntry : unconsumedTokens.entrySet()) {
            b2.append("'");
            b2.append(unconsumedFeature2NumberEntry.getKey().getName());
            b2.append("':");
            b2.append(unconsumedFeature2NumberEntry.getValue());
            if (++i == unconsumedTokens.size()) continue;
            b2.append(", ");
        }
        return b2.toString();
    }

    public Set<EObject> collectConsumedEObjects() {
        HashSet<EObject> result = new HashSet<EObject>();
        Iterator<AbstractParseTreeConstructor.AbstractToken> iterator = this.getDeadends().iterator();
        while (iterator.hasNext()) {
            AbstractParseTreeConstructor.AbstractToken endToken;
            AbstractParseTreeConstructor.AbstractToken currentToken = endToken = iterator.next();
            while (currentToken.getNext() != null && currentToken.getNext().getLastRuleCallOrigin() != null && currentToken.getNext().getLastRuleCallOrigin().getGrammarElement() != null) {
                if (GrammarUtil.containingRule(currentToken.getNext().getLastRuleCallOrigin().getGrammarElement()) == GrammarUtil.containingRule(currentToken.getGrammarElement())) {
                    result.add(currentToken.getNext().getEObjectConsumer().getEObject());
                }
                currentToken = currentToken.getNext();
            }
        }
        return result;
    }

    protected List<String> collectDiagnostics(AbstractParseTreeConstructor.AbstractToken token) {
        AbstractParseTreeConstructor.AbstractToken currentFollowerToken;
        int i = 0;
        IEObjectConsumer instanceDescription = token.tryConsume();
        ArrayList<String> diagnsotics = new ArrayList<String>();
        while ((currentFollowerToken = token.createFollower(i++, instanceDescription)) != null) {
            StringBuffer b2 = new StringBuffer();
            b2.append(currentFollowerToken.getClass().getSimpleName());
            b2.append(": ");
            String diagnostic = this.getDiagnosticMessage(currentFollowerToken);
            if (diagnostic == null) {
                b2.append("n/a");
            } else {
                b2.append(diagnostic);
            }
            diagnsotics.add(b2.toString());
        }
        String consumedTokenAsString = this.checkUnconsumed(token, instanceDescription);
        if (consumedTokenAsString != null) {
            diagnsotics.add(consumedTokenAsString);
        }
        return diagnsotics;
    }

    protected TreeConstructionDiagnosticImpl createDiagnostic(AbstractParseTreeConstructor.AbstractToken token) {
        return new TreeConstructionDiagnosticImpl(token);
    }

    public List<AbstractParseTreeConstructor.AbstractToken> getDeadends() {
        ArrayList<AbstractParseTreeConstructor.AbstractToken> deadends = Lists.newArrayList();
        for (Pair pair : this.deadends) {
            deadends.add((AbstractParseTreeConstructor.AbstractToken)pair.getSecond());
        }
        Collections.reverse(deadends);
        return deadends;
    }

    protected String getDiagnosticMessage(AbstractParseTreeConstructor.AbstractToken token) {
        if (token instanceof AbstractParseTreeConstructor.AssignmentToken) {
            return this.getDiagnosticMessage((AbstractParseTreeConstructor.AssignmentToken)token);
        }
        return null;
    }

    protected String getDiagnosticMessage(AbstractParseTreeConstructor.AssignmentToken token) {
        Assignment ass = (Assignment)token.getGrammarElement();
        Object value = token.getEObjectConsumer().getConsumable(ass.getFeature(), false);
        if (value == null) {
            EStructuralFeature f = token.getEObjectConsumer().getEObject().eClass().getEStructuralFeature(ass.getFeature());
            if (f == null) {
                return "The current object of type '" + token.getEObjectConsumer().getEObject().eClass().getName() + "' does not have a feature named '" + ass.getFeature() + "'";
            }
            String cls = f.getEContainingClass() == token.getEObjectConsumer().getEObject().eClass() ? f.getEContainingClass().getName() : String.valueOf(f.getEContainingClass().getName()) + "(" + token.getEObjectConsumer().getEObject().eClass().getName() + ")";
            String feat = String.valueOf(cls) + "." + f.getName();
            if (f.isMany()) {
                int size = ((List)token.getEObjectConsumer().getEObject().eGet(f)).size();
                return "All " + size + " values of " + feat + " have been consumed. " + "More are needed to continue here.";
            }
            return String.valueOf(feat) + " is not set.";
        }
        ErrorAcceptor err = new ErrorAcceptor();
        for (RuleCall ruleCall : GrammarUtil.containedRuleCalls(token.getGrammarElement())) {
            if (!(ruleCall.getRule() instanceof EnumRule ? this.enumSerializer.isValid(token.getEObject(), ruleCall, value, err) : ruleCall.getRule().getType().getClassifier() instanceof EDataType && this.valueSerializer.isValid(token.getEObject(), ruleCall, value, err))) continue;
            return null;
        }
        return err.getMessage();
    }

    @Override
    public List<IParseTreeConstructor.TreeConstructionDiagnostic> getDiagnostics() {
        if (this.isSuccess()) {
            return null;
        }
        ArrayList<IParseTreeConstructor.TreeConstructionDiagnostic> result = Lists.newArrayList();
        for (AbstractParseTreeConstructor.AbstractToken deadEndToken : this.getDeadends()) {
            result.add(this.createDiagnostic(deadEndToken));
        }
        return result;
    }

    @Override
    public ITextRegion getPreviousLocation() {
        return this.previousLocation;
    }

    public AbstractParseTreeConstructor.AbstractToken getSuccess() {
        return this.success;
    }

    @Override
    public boolean isSuccess() {
        return this.success != null;
    }

    public void setPreviousLocation(ITextRegion previousLocation) {
        this.previousLocation = previousLocation;
    }

    public void setRoot(EObject root) {
        this.root = root;
    }

    protected void setSuccess(AbstractParseTreeConstructor.AbstractToken succes) {
        this.success = succes;
    }

    public String toString() {
        if (this.isSuccess()) {
            return "Serialization has been successful";
        }
        StringBuffer b2 = new StringBuffer();
        b2.append("<# of serialized tokens>: <EObject path> ");
        b2.append("\"<serializable fragment, starting from the end>\":\n");
        b2.append("  -> <possible reasons for not continuing>\n");
        b2.append(Joiner.on("\n").join(this.getDiagnostics()));
        return b2.toString();
    }

    protected class ErrorAcceptor
    implements ITokenSerializer.IErrorAcceptor {
        protected StringBuilder builder;

        protected ErrorAcceptor() {
        }

        public void error(String message) {
            if (this.builder == null) {
                this.builder = new StringBuilder();
            } else {
                this.builder.append(", ");
            }
            this.builder.append(message);
        }

        public String getMessage() {
            return this.builder == null ? null : this.builder.toString();
        }
    }

    protected class TreeConstructionDiagnosticImpl
    implements IParseTreeConstructor.TreeConstructionDiagnostic {
        protected AbstractParseTreeConstructor.AbstractToken deadend;
        protected Map<AbstractParseTreeConstructor.AbstractToken, Integer> lengthCache = new HashMap<AbstractParseTreeConstructor.AbstractToken, Integer>(){

            @Override
            public Integer get(Object key) {
                AbstractParseTreeConstructor.AbstractToken token = (AbstractParseTreeConstructor.AbstractToken)key;
                Integer result = (Integer)super.get(key);
                if (result == null) {
                    int length = 0;
                    AbstractParseTreeConstructor.AbstractToken currentToken = token;
                    while ((currentToken = currentToken.getNext()) != null) {
                        ++length;
                    }
                    result = length;
                    this.put(token, length);
                }
                return result;
            }
        };
        protected Map<EObject, TreeConstructionDiagnosticImpl> semanticElement2diagnostic;

        public TreeConstructionDiagnosticImpl(AbstractParseTreeConstructor.AbstractToken deadend) {
            this.deadend = deadend;
        }

        public EObject getEObject() {
            return this.deadend.getEObjectConsumer().getEObject();
        }

        public String getLikelyErrorReasons() {
            return this.getLikelyErrorReasons("");
        }

        public String getLikelyErrorReasons(String prefix) {
            StringBuffer b2 = new StringBuffer(prefix);
            b2.append(this.lengthCache.get(this.deadend));
            b2.append(":");
            b2.append(EmfFormatter.objPath(this.deadend.getEObjectConsumer().getEObject()));
            b2.append(": \"");
            b2.append(this.deadend.dumpTokens(10, 50, true));
            b2.append("\":");
            for (String diagnosticAsString : TreeConstructionReportImpl.this.collectDiagnostics(this.deadend)) {
                b2.append("\n");
                b2.append(prefix);
                b2.append("  -> ");
                b2.append(diagnosticAsString);
            }
            return b2.toString();
        }

        public String toString() {
            return this.getLikelyErrorReasons();
        }
    }
}

