/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.nodemodel.impl.BasicNodeTreeIterator;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.RootNode;
import org.eclipse.xtext.nodemodel.util.NodeTreeIterator;
import org.eclipse.xtext.nodemodel.util.ReversedBidiTreeIterable;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
implements INode,
BidiTreeIterable<INode> {
    private CompositeNode parent;
    private AbstractNode prev;
    private AbstractNode next;
    private Object grammarElementOrArray;

    @Override
    public ICompositeNode getParent() {
        if (this.parent != null) {
            return this.parent.resolveAsParent();
        }
        return null;
    }

    protected CompositeNode basicGetParent() {
        return this.parent;
    }

    protected void basicSetParent(CompositeNode parent) {
        this.parent = parent;
    }

    @Override
    public BidiTreeIterable<INode> getAsTreeIterable() {
        return this;
    }

    @Override
    public BidiTreeIterator<INode> iterator() {
        return new NodeTreeIterator(this);
    }

    @Override
    public BidiTreeIterable<INode> reverse() {
        return new ReversedBidiTreeIterable<INode>(this);
    }

    @Override
    public Iterable<ILeafNode> getLeafNodes() {
        return new Iterable<ILeafNode>(){

            @Override
            public Iterator<ILeafNode> iterator() {
                return Iterators.filter(AbstractNode.this.basicIterator(), ILeafNode.class);
            }
        };
    }

    public BidiTreeIterator<AbstractNode> basicIterator() {
        return new BasicNodeTreeIterator(this);
    }

    @Override
    public String getText() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getTotalOffset();
            int length = this.getTotalLength();
            return rootNode.getText().substring(offset, offset + length);
        }
        return null;
    }

    @Override
    public int getTotalStartLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getTotalOffset();
            return this.basicGetLineOfOffset(rootNode, offset);
        }
        return 1;
    }

    protected int basicGetLineOfOffset(INode rootNode, int offset) {
        if (rootNode instanceof RootNode) {
            int[] lineBreakOffsets = ((RootNode)rootNode).basicGetLineBreakOffsets();
            int insertionPoint = Arrays.binarySearch(lineBreakOffsets, offset);
            if (insertionPoint >= 0) {
                return insertionPoint + 1;
            }
            return -insertionPoint;
        }
        String leadingText = rootNode.getText().substring(0, offset);
        int result = Strings.countLines(leadingText);
        return result + 1;
    }

    @Override
    public int getStartLine() {
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            int offset = this.getOffset();
            return this.basicGetLineOfOffset(rootNode, offset);
        }
        return 1;
    }

    @Override
    public int getEndLine() {
        int offset = this.getOffset();
        int length = this.getLength();
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return this.basicGetLineOfOffset(rootNode, offset + length);
        }
        return 1;
    }

    @Override
    public int getTotalEndLine() {
        int offset = this.getTotalEndOffset();
        ICompositeNode rootNode = this.getRootNode();
        if (rootNode != null) {
            return this.basicGetLineOfOffset(rootNode, offset);
        }
        return 1;
    }

    @Override
    public int getOffset() {
        UnmodifiableIterator<ILeafNode> leafIter = Iterators.filter(this.basicIterator(), ILeafNode.class);
        int firstLeafOffset = -1;
        while (leafIter.hasNext()) {
            ILeafNode leaf = (ILeafNode)leafIter.next();
            if (firstLeafOffset == -1) {
                firstLeafOffset = leaf.getTotalOffset();
            }
            if (leaf.isHidden()) continue;
            return leaf.getTotalOffset();
        }
        if (firstLeafOffset != -1) {
            return firstLeafOffset;
        }
        return this.getTotalOffset();
    }

    @Override
    public int getLength() {
        BidiTreeIterator<AbstractNode> iter = this.basicIterator();
        while (iter.hasPrevious()) {
            INode prev = (INode)iter.previous();
            if (!(prev instanceof ILeafNode) || ((ILeafNode)prev).isHidden()) continue;
            int offset = this.getOffset();
            return prev.getTotalEndOffset() - offset;
        }
        return this.getTotalLength();
    }

    @Override
    public int getTotalEndOffset() {
        return this.getTotalOffset() + this.getTotalLength();
    }

    @Override
    public ICompositeNode getRootNode() {
        if (this.parent == null) {
            return null;
        }
        CompositeNode candidate = this.parent;
        while (candidate.basicGetParent() != null) {
            candidate = candidate.basicGetParent();
        }
        return candidate.getRootNode();
    }

    @Override
    public EObject getSemanticElement() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getSemanticElement();
    }

    protected EObject basicGetSemanticElement() {
        return null;
    }

    @Override
    public boolean hasDirectSemanticElement() {
        return this.basicGetSemanticElement() != null;
    }

    @Override
    public EObject getGrammarElement() {
        return (EObject)this.grammarElementOrArray;
    }

    protected Object basicGetGrammarElement() {
        return this.grammarElementOrArray;
    }

    protected void basicSetGrammarElement(Object grammarElementOrArray) {
        this.grammarElementOrArray = grammarElementOrArray;
    }

    @Override
    public SyntaxErrorMessage getSyntaxErrorMessage() {
        return null;
    }

    @Override
    public INode getPreviousSibling() {
        if (!this.hasPreviousSibling()) {
            return null;
        }
        return this.prev;
    }

    protected AbstractNode basicGetPreviousSibling() {
        return this.prev;
    }

    protected void basicSetPreviousSibling(AbstractNode prev) {
        this.prev = prev;
    }

    @Override
    public INode getNextSibling() {
        if (!this.hasNextSibling()) {
            return null;
        }
        return this.next;
    }

    protected AbstractNode basicGetNextSibling() {
        return this.next;
    }

    protected void basicSetNextSibling(AbstractNode next) {
        this.next = next;
    }

    @Override
    public boolean hasPreviousSibling() {
        return this.basicHasPreviousSibling();
    }

    protected boolean basicHasPreviousSibling() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.basicGetFirstChild() != this;
    }

    @Override
    public boolean hasNextSibling() {
        return this.basicHasNextSibling();
    }

    protected boolean basicHasNextSibling() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.basicGetLastChild() != this;
    }

    @Override
    public boolean hasSiblings() {
        return this.basicHasSiblings();
    }

    protected boolean basicHasSiblings() {
        return this.prev != this;
    }
}

