/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.naming;

import com.google.inject.ImplementedBy;
import java.util.regex.Pattern;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;

@ImplementedBy(value=DefaultImpl.class)
public interface IQualifiedNameConverter {
    public String toString(QualifiedName var1);

    public QualifiedName toQualifiedName(String var1);

    public static class DefaultImpl
    implements IQualifiedNameConverter {
        public String toString(QualifiedName qualifiedName) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            if (qualifiedName.getSegmentCount() == 1) {
                return qualifiedName.getFirstSegment();
            }
            StringBuilder builder = new StringBuilder();
            boolean isFirst = true;
            for (String segment : qualifiedName.getSegments()) {
                if (!isFirst) {
                    builder.append(this.getDelimiter());
                }
                isFirst = false;
                builder.append(segment);
            }
            return builder.toString();
        }

        public QualifiedName toQualifiedName(String qualifiedNameAsString) {
            if (qualifiedNameAsString == null) {
                throw new IllegalArgumentException("Qualified name cannot be null");
            }
            if (qualifiedNameAsString.equals("")) {
                throw new IllegalArgumentException("Qualified name cannot be empty");
            }
            if (Strings.isEmpty(this.getDelimiter())) {
                return QualifiedName.create(qualifiedNameAsString);
            }
            String[] segments = qualifiedNameAsString.split(Pattern.quote(this.getDelimiter()));
            return QualifiedName.create(segments);
        }

        public String getDelimiter() {
            return ".";
        }
    }
}

