/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private boolean validateAll = true;
    private boolean stopOnError = true;

    public void setValidateAll(boolean validateAll) {
        this.validateAll = validateAll;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public boolean isValidateAll() {
        return this.validateAll;
    }

    public void validate(ResourceSet resourceSet, IResourceServiceProvider.Registry registry, Issues issues) {
        ArrayList<Resource> resources = Lists.newArrayList(resourceSet.getResources());
        for (Resource resource : resources) {
            try {
                resource.load(null);
                IResourceServiceProvider provider = registry.getResourceServiceProvider(resource.getURI());
                if (provider == null) continue;
                List<Issue> result = provider.getResourceValidator().validate(resource, CheckMode.ALL, null);
                for (Issue issue : result) {
                    switch (issue.getSeverity()) {
                        case ERROR: {
                            issues.addError(issue.getMessage(), issue);
                            break;
                        }
                        case WARNING: {
                            issues.addWarning(issue.getMessage(), issue);
                            break;
                        }
                        case INFO: {
                            issues.addInfo(issue.getMessage(), issue);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new WorkflowInterruptedException("Couldn't load resource (" + resource.getURI() + ")", e);
            }
        }
        if (this.isStopOnError() && issues.hasErrors()) {
            String errorMessage = this.toString(issues);
            throw new WorkflowInterruptedException("Validation problems: \n" + errorMessage);
        }
    }

    public String toString(Issues issues) {
        if (!issues.hasErrors() && !issues.hasWarnings()) {
            return "No issues.";
        }
        StringBuilder result = new StringBuilder();
        if (issues.hasErrors()) {
            MWEDiagnostic[] errors = issues.getErrors();
            if (errors.length == 1) {
                result.append("1 error:\n");
            } else {
                result.append(errors.length).append(" errors:\n");
            }
            this.appendMessages(result, errors);
        }
        if (issues.hasWarnings()) {
            MWEDiagnostic[] warnings = issues.getWarnings();
            if (issues.hasErrors()) {
                result.append('\n');
            }
            if (warnings.length == 1) {
                result.append("1 warning:\n");
            } else {
                result.append(warnings.length).append(" warnings:\n");
            }
            this.appendMessages(result, warnings);
        }
        return result.toString();
    }

    protected void appendMessages(StringBuilder result, MWEDiagnostic[] diagnostics) {
        Multimap<URI, MWEDiagnostic> issuesPerURI = this.groupByURI(diagnostics);
        boolean first = true;
        for (URI uri : issuesPerURI.keySet()) {
            if (!first) {
                result.append('\n');
            }
            first = false;
            if (uri != null) {
                result.append('\t').append(uri.lastSegment()).append(" - ");
                if (uri.isFile()) {
                    result.append(uri.toFileString());
                } else {
                    result.append(uri);
                }
            }
            for (MWEDiagnostic diagnostic : issuesPerURI.get(uri)) {
                Issue issue = (Issue)diagnostic.getElement();
                result.append("\n\t\t").append(issue.getLineNumber()).append(": ").append(diagnostic.getMessage());
            }
        }
    }

    protected Multimap<URI, MWEDiagnostic> groupByURI(MWEDiagnostic[] diagnostic) {
        Multimap<URI, MWEDiagnostic> result = Multimaps.newMultimap(Maps.newLinkedHashMap(), new Supplier<Collection<MWEDiagnostic>>(){

            @Override
            public Collection<MWEDiagnostic> get() {
                return Sets.newTreeSet(Validator.this.getDiagnosticComparator());
            }
        });
        result.putAll(Multimaps.index(Arrays.asList(diagnostic), new Function<MWEDiagnostic, URI>(){

            @Override
            public URI apply(MWEDiagnostic from) {
                Issue issue = (Issue)from.getElement();
                URI uriToProblem = issue.getUriToProblem();
                return uriToProblem != null ? uriToProblem.trimFragment() : null;
            }
        }));
        return result;
    }

    protected Comparator<MWEDiagnostic> getDiagnosticComparator() {
        return new MWEDiagnosticComparator();
    }

    public static class Disabled
    extends Validator {
        public void validate(ResourceSet resourceSet, IResourceServiceProvider.Registry registry, Issues issues) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MWEDiagnosticComparator
    implements Comparator<MWEDiagnostic> {
        @Override
        public int compare(MWEDiagnostic o1, MWEDiagnostic o2) {
            Issue issue1 = (Issue)o1.getElement();
            Issue issue2 = (Issue)o2.getElement();
            int lineNumberCompare = this.nullSafeCompare(issue1.getLineNumber(), issue2.getLineNumber());
            if (lineNumberCompare != 0) {
                return lineNumberCompare;
            }
            int offsetCompare = this.nullSafeCompare(issue1.getOffset(), issue2.getOffset());
            if (offsetCompare != 0) {
                return offsetCompare;
            }
            return Strings.notNull(o1.getMessage()).compareTo(Strings.notNull(o2.getMessage()));
        }

        protected int nullSafeCompare(Integer x, Integer y) {
            return this.notNull(x).compareTo(this.notNull(y));
        }

        protected Integer notNull(Integer x) {
            return x != null ? x : Integer.valueOf(-1);
        }
    }
}

