/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTraverser {
    public Multimap<String, URI> resolvePathes(List<String> pathes, Predicate<URI> isValidPredicate) {
        HashMultimap<String, URI> uris = HashMultimap.create();
        for (String path : pathes) {
            Set<URI> resourceUris = this.findAllResourceUris(path, isValidPredicate);
            uris.putAll(path, resourceUris);
        }
        return uris;
    }

    public Set<URI> findAllResourceUris(String path, Predicate<URI> isValidPredicate) {
        File file = new File(path);
        if (file.isDirectory()) {
            return this.traverseDir(file, isValidPredicate);
        }
        if (file.isFile()) {
            return this.traverseArchive(file, isValidPredicate);
        }
        throw new IllegalArgumentException("Unsupported path : " + path + " (only folders and archives are supported).");
    }

    protected Set<URI> traverseArchive(File file, Predicate<URI> isValidPredicate) {
        try {
            HashSet<URI> result = Sets.newHashSet();
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                URI uri = this.getUri(file, entry);
                if (uri == null || !isValidPredicate.apply(uri)) continue;
                result.add(uri);
            }
            return result;
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    protected URI getUri(File file, ZipEntry entry) {
        URI fileToArchive = URI.createFileURI(file.getAbsolutePath());
        return URI.createURI("archive:" + fileToArchive + "!/" + entry.getName());
    }

    protected Set<URI> traverseDir(File file, Predicate<URI> isValidPredicate) {
        HashSet<URI> result = Sets.newHashSet();
        File[] files = file.listFiles();
        if (files == null) {
            return result;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                result.addAll(this.traverseDir(f, isValidPredicate));
            } else {
                URI uri = URI.createFileURI(f.getAbsolutePath());
                if (isValidPredicate.apply(uri)) {
                    result.add(uri);
                }
            }
            ++n2;
        }
        return result;
    }
}

