/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.lazy;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyLinkingResource
extends XtextResource {
    private static final Logger log = Logger.getLogger(LazyLinkingResource.class);
    @Inject
    private ILinkingService linkingService;
    @Inject
    private LazyURIEncoder encoder;
    @Inject
    private ILinkingDiagnosticMessageProvider diagnosticMessageProvider;
    @Inject
    private LinkingHelper linkingHelper;
    private boolean eagerLinking = false;
    private LinkedHashSet<Triple<EObject, EReference, INode>> resolving = Sets.newLinkedHashSet();

    @Override
    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
        if (options != null && Boolean.TRUE.equals(options.get(OPTION_RESOLVE_ALL))) {
            EcoreUtil.resolveAll(this);
        }
    }

    @Override
    protected void doLinking() {
        super.doLinking();
        if (this.isEagerLinking()) {
            EcoreUtil.resolveAll(this);
        }
    }

    public void resolveLazyCrossReferences(CancelIndicator mon) {
        CancelIndicator monitor = mon == null ? CancelIndicator.NullImpl : mon;
        TreeIterator iterator = EcoreUtil.getAllContents(this, true);
        while (iterator.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            InternalEObject source = (InternalEObject)iterator.next();
            EStructuralFeature[] eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)((Object)source.eClass().getEAllStructuralFeatures())).crossReferences();
            if (eStructuralFeatures == null) continue;
            EStructuralFeature[] eStructuralFeatureArray = eStructuralFeatures;
            int n = eStructuralFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature crossRef = eStructuralFeatureArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                this.resolveLazyCrossReference(source, crossRef);
                ++n2;
            }
        }
    }

    protected void resolveLazyCrossReference(InternalEObject source, EStructuralFeature crossRef) {
        block13: {
            EObject target;
            block12: {
                if (crossRef.isDerived()) {
                    return;
                }
                if (!crossRef.isMany()) break block12;
                InternalEList list = (InternalEList)source.eGet(crossRef);
                int i = 0;
                while (i < list.size()) {
                    EObject proxy = (EObject)list.basicGet(i);
                    if (proxy.eIsProxy()) {
                        EObject target2;
                        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
                        String fragment = proxyURI.fragment();
                        if (this.getEncoder().isCrossLinkFragment(this, fragment) && (target2 = this.getEObject(fragment)) != null) {
                            try {
                                source.eSetDeliver(false);
                                list.setUnique(i, target2);
                            }
                            finally {
                                source.eSetDeliver(true);
                            }
                        }
                    }
                    ++i;
                }
                break block13;
            }
            EObject proxy = (EObject)source.eGet(crossRef, false);
            if (proxy == null || !proxy.eIsProxy()) break block13;
            URI proxyURI = ((InternalEObject)proxy).eProxyURI();
            String fragment = proxyURI.fragment();
            if (this.getEncoder().isCrossLinkFragment(this, fragment) && (target = this.getEObject(fragment)) != null) {
                try {
                    source.eSetDeliver(false);
                    source.eSet(crossRef, (Object)target);
                }
                finally {
                    source.eSetDeliver(true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized EObject getEObject(String uriFragment) {
        try {
            if (!this.getEncoder().isCrossLinkFragment(this, uriFragment)) return super.getEObject(uriFragment);
            Triple<EObject, EReference, INode> triple = this.getEncoder().decode(this, uriFragment);
            try {
                if (!this.resolving.add(triple)) {
                    EObject eObject = this.handleCyclicResolution(triple);
                    return eObject;
                }
                Set<String> unresolveableProxies = this.getCache().get("UNRESOLVEABLE_PROXIES", this, new Provider<Set<String>>(){

                    @Override
                    public Set<String> get() {
                        return Sets.newHashSet();
                    }
                });
                if (unresolveableProxies.contains(uriFragment)) {
                    return null;
                }
                EReference reference = (EReference)triple.getSecond();
                List<EObject> linkedObjects = this.getLinkingService().getLinkedObjects((EObject)triple.getFirst(), reference, triple.getThird());
                if (linkedObjects.isEmpty()) {
                    unresolveableProxies.add(uriFragment);
                    this.createAndAddDiagnostic(triple);
                    return null;
                }
                if (linkedObjects.size() > 1) {
                    throw new IllegalStateException("linkingService returned more than one object for fragment " + uriFragment);
                }
                EObject result = linkedObjects.get(0);
                if (!EcoreUtil2.isAssignableFrom(reference.getEReferenceType(), result.eClass())) {
                    log.error("An element of type " + result.getClass().getName() + " is not assignable to the reference " + reference.getEContainingClass().getName() + "." + reference.getName());
                    unresolveableProxies.add(uriFragment);
                    this.createAndAddDiagnostic(triple);
                    return null;
                }
                this.removeDiagnostic(triple);
                EObject eObject = result;
                return eObject;
            }
            finally {
                this.resolving.remove(triple);
            }
        }
        catch (RuntimeException e) {
            this.getErrors().add(new ExceptionDiagnostic(e));
            log.error("resolution of uriFragment '" + uriFragment + "' failed.", e);
            throw new WrappedException(e);
        }
    }

    protected EObject handleCyclicResolution(Triple<EObject, EReference, INode> triple) throws AssertionError {
        throw new AssertionError((Object)("Cyclic resolution of lazy links : " + this.getReferences(triple, this.resolving)));
    }

    protected String getReferences(Triple<EObject, EReference, INode> triple, LinkedHashSet<Triple<EObject, EReference, INode>> resolving2) {
        StringBuffer buffer = new StringBuffer();
        boolean found = false;
        for (Triple triple2 : resolving2) {
            boolean bl = found = found || triple2.equals(triple);
            if (!found) continue;
            buffer.append(this.getQualifiedName((EReference)triple2.getSecond())).append("->");
        }
        buffer.append(this.getQualifiedName((EReference)triple.getSecond()));
        return buffer.toString();
    }

    private String getQualifiedName(EReference eReference) {
        return String.valueOf(eReference.getEContainingClass().getName()) + "." + eReference.getName();
    }

    protected void createAndAddDiagnostic(Triple<EObject, EReference, INode> triple) {
        Resource.Diagnostic diagnostic;
        List<Resource.Diagnostic> list;
        if (this.isValidationDisabled()) {
            return;
        }
        DiagnosticMessage message = this.createDiagnosticMessage(triple);
        if (message != null && !(list = this.getDiagnosticList(message)).contains(diagnostic = this.createDiagnostic(triple, message))) {
            list.add(diagnostic);
        }
    }

    protected void removeDiagnostic(Triple<EObject, EReference, INode> triple) {
        DiagnosticMessage message = this.createDiagnosticMessage(triple);
        List<Resource.Diagnostic> list = this.getDiagnosticList(message);
        if (!list.isEmpty()) {
            Resource.Diagnostic diagnostic = this.createDiagnostic(triple, message);
            list.remove(diagnostic);
        }
    }

    protected Resource.Diagnostic createDiagnostic(Triple<EObject, EReference, INode> triple, DiagnosticMessage message) {
        XtextLinkingDiagnostic diagnostic = new XtextLinkingDiagnostic(triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData());
        return diagnostic;
    }

    protected List<Resource.Diagnostic> getDiagnosticList(DiagnosticMessage message) throws AssertionError {
        if (message != null) {
            switch (message.getSeverity()) {
                case ERROR: {
                    return this.getErrors();
                }
                case WARNING: {
                    return this.getWarnings();
                }
            }
            throw new AssertionError((Object)("Unexpected severity: " + (Object)((Object)message.getSeverity())));
        }
        return Collections.emptyList();
    }

    protected DiagnosticMessage createDiagnosticMessage(Triple<EObject, EReference, INode> triple) {
        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticMessageContext(triple);
        DiagnosticMessage message = this.diagnosticMessageProvider.getUnresolvedProxyMessage(context);
        return message;
    }

    protected ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext createDiagnosticMessageContext(Triple<EObject, EReference, INode> triple) {
        return new DiagnosticMessageContext(triple, this.linkingHelper);
    }

    public void setLinkingService(ILinkingService linkingService) {
        this.linkingService = linkingService;
    }

    public ILinkingService getLinkingService() {
        return this.linkingService;
    }

    public void setEncoder(LazyURIEncoder encoder) {
        this.encoder = encoder;
    }

    public LazyURIEncoder getEncoder() {
        return this.encoder;
    }

    public void setEagerLinking(boolean eagerLinking) {
        this.eagerLinking = eagerLinking;
    }

    public boolean isEagerLinking() {
        return this.eagerLinking;
    }

    public ILinkingDiagnosticMessageProvider getDiagnosticMessageProvider() {
        return this.diagnosticMessageProvider;
    }

    public void setDiagnosticMessageProvider(ILinkingDiagnosticMessageProvider diagnosticMessageProvider) {
        this.diagnosticMessageProvider = diagnosticMessageProvider;
    }

    public LinkingHelper getLinkingHelper() {
        return this.linkingHelper;
    }

    public void setLinkingHelper(LinkingHelper linkingHelper) {
        this.linkingHelper = linkingHelper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DiagnosticMessageContext
    implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
        private final Triple<EObject, EReference, INode> triple;
        private final LinkingHelper linkingHelper;

        protected DiagnosticMessageContext(Triple<EObject, EReference, INode> triple, LinkingHelper helper) {
            this.triple = triple;
            this.linkingHelper = helper;
        }

        @Override
        public EObject getContext() {
            return (EObject)this.triple.getFirst();
        }

        @Override
        public EReference getReference() {
            return (EReference)this.triple.getSecond();
        }

        @Override
        public String getLinkText() {
            return this.linkingHelper.getCrossRefNodeAsString(this.triple.getThird(), true);
        }
    }
}

