/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.linking.impl;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.linking.impl.AbstractLinker;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.nodemodel.INode;

public abstract class AbstractCleaningLinker
extends AbstractLinker {
    private static final Logger log = Logger.getLogger(AbstractCleaningLinker.class);

    public void linkModel(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        long now;
        boolean debug = log.isDebugEnabled();
        long time = System.currentTimeMillis();
        this.beforeModelLinked(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("beforeModelLinked took: " + (now - time) + "ms");
            time = now;
        }
        this.doLinkModel(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("doLinkModel took: " + (now - time) + "ms");
            time = now;
        }
        this.afterModelLinked(model, diagnosticsConsumer);
        if (debug) {
            now = System.currentTimeMillis();
            log.debug("afterModelLinked took: " + (now - time) + "ms");
            time = now;
        }
    }

    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
    }

    protected abstract void doLinkModel(EObject var1, IDiagnosticConsumer var2);

    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        this.clearAllReferences(model);
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find(model.eResource());
        if (adapter != null) {
            adapter.clear();
        }
    }

    protected void clearAllReferences(EObject model) {
        this.clearReferences(model);
        TreeIterator<EObject> iter = model.eAllContents();
        while (iter.hasNext()) {
            this.clearReferences((EObject)iter.next());
        }
    }

    protected void clearReferences(EObject obj) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            this.clearReference(obj, ref);
        }
    }

    protected void clearReference(EObject obj, EReference ref) {
        if (!(ref.isContainment() || ref.isContainer() || ref.isDerived() || !ref.isChangeable() || ref.isTransient())) {
            obj.eUnset(ref);
        }
    }

    protected boolean shouldCheckParentNode(INode node) {
        AbstractElement grammarElement;
        Assignment assignment;
        return node.getGrammarElement() instanceof AbstractElement && (assignment = GrammarUtil.containingAssignment(grammarElement = (AbstractElement)node.getGrammarElement())) == null && node.getParent() != null && !node.getParent().hasDirectSemanticElement();
    }
}

