/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.serializer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.internal.Join;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccess;
import org.eclipse.xtext.generator.grammarAccess.GrammarAccessUtil;
import org.eclipse.xtext.generator.serializer.JavaFile;
import org.eclipse.xtext.serializer.analysis.GrammarAlias;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticSequencerUtil {
    @Inject
    protected IContextProvider contextProvider;
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    @Inject
    protected Grammar grammar;
    protected List<Pair<String, GrammarAlias.AbstractElementAlias>> ambiguousTransitions;
    @Inject
    protected GrammarAccess grammarAccess;

    protected List<ISyntacticSequencerPDAProvider.ISynAbsorberState> getAllPDAs() {
        ArrayList<ISyntacticSequencerPDAProvider.ISynAbsorberState> result = Lists.newArrayList();
        for (EObject context : this.contextProvider.getAllContexts(this.grammar)) {
            for (EClass type : this.contextProvider.getTypesForContext(context)) {
                result.add(this.pdaProvider.getPDA(context, type));
            }
        }
        return result;
    }

    protected void collectAllAmbiguousTransitions(ISyntacticSequencerPDAProvider.ISynFollowerOwner state, Set<ISyntacticSequencerPDAProvider.ISynTransition> result, Set<Object> visited) {
        if (!visited.add(state)) {
            return;
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynTransition && ((ISyntacticSequencerPDAProvider.ISynTransition)state).isSyntacticallyAmbiguous()) {
            result.add((ISyntacticSequencerPDAProvider.ISynTransition)state);
        }
        if (state instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            for (ISyntacticSequencerPDAProvider.ISynTransition trans : ((ISyntacticSequencerPDAProvider.ISynAbsorberState)state).getOutTransitions()) {
                this.collectAllAmbiguousTransitions(trans, result, visited);
            }
        } else {
            for (ISyntacticSequencerPDAProvider.ISynState follower : state.getFollowers()) {
                this.collectAllAmbiguousTransitions(follower, result, visited);
            }
        }
    }

    protected Set<ISyntacticSequencerPDAProvider.ISynTransition> getAllAmbiguousTransitions() {
        HashSet<ISyntacticSequencerPDAProvider.ISynTransition> result = Sets.newHashSet();
        for (ISyntacticSequencerPDAProvider.ISynAbsorberState start : this.getAllPDAs()) {
            this.collectAllAmbiguousTransitions(start, result, Sets.<Object>newHashSet());
        }
        return result;
    }

    public List<Pair<String, GrammarAlias.AbstractElementAlias>> getAllAmbiguousTransitionsBySyntax() {
        if (this.ambiguousTransitions != null) {
            return this.ambiguousTransitions;
        }
        HashMap result = Maps.newHashMap();
        for (ISyntacticSequencerPDAProvider.ISynTransition iSynTransition : this.getAllAmbiguousTransitions()) {
            for (GrammarAlias.AbstractElementAlias syntax : iSynTransition.getAmbiguousSyntaxes()) {
                ArrayList<ISyntacticSequencerPDAProvider.ISynTransition> list = (ArrayList<ISyntacticSequencerPDAProvider.ISynTransition>)result.get(syntax);
                if (list == null) {
                    list = Lists.newArrayList();
                    result.put(syntax, list);
                }
                list.add(iSynTransition);
            }
        }
        this.ambiguousTransitions = Lists.newArrayList();
        for (Map.Entry entry : result.entrySet()) {
            this.ambiguousTransitions.add(Tuples.create(this.elementAliasToIdentifyer((GrammarAlias.AbstractElementAlias)entry.getKey()), (GrammarAlias.AbstractElementAlias)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(this.ambiguousTransitions, new Comparator<Pair<String, GrammarAlias.AbstractElementAlias>>(){

            @Override
            public int compare(Pair<String, GrammarAlias.AbstractElementAlias> o1, Pair<String, GrammarAlias.AbstractElementAlias> o2) {
                return o1.getFirst().compareTo(o2.getFirst());
            }
        });
        return this.ambiguousTransitions;
    }

    protected String elementAliasToIdentifyer(GrammarAlias.AbstractElementAlias alias, Set<String> rules, boolean isNested) {
        String card = null;
        if (alias.isMany() && alias.isOptional()) {
            card = "a";
        } else if (alias.isMany()) {
            card = "p";
        } else if (alias.isOptional()) {
            card = "q";
        }
        if (alias instanceof GrammarAlias.TokenAlias) {
            GrammarAlias.TokenAlias ele = (GrammarAlias.TokenAlias)alias;
            rules.add(GrammarUtil.containingRule(ele.getToken()).getName());
            card = card == null ? "" : "_" + card;
            return String.valueOf(GrammarAccessUtil.getUniqueElementName(ele.getToken())) + card;
        }
        if (alias instanceof GrammarAlias.GroupAlias) {
            ArrayList<String> children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer(child, rules, true));
            }
            String body = Join.join("_", children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        if (alias instanceof GrammarAlias.AlternativeAlias) {
            ArrayList<String> children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.AlternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToIdentifyer(child, rules, true));
            }
            Collections.sort(children);
            String body = Join.join("_or_", children);
            if (isNested || card != null) {
                card = card == null ? "" : card;
                return "__" + body + "__" + card;
            }
            return body;
        }
        throw new RuntimeException("unknown element");
    }

    public String elementAliasToConstructor(GrammarAlias.AbstractElementAlias alias, JavaFile file) {
        String many = String.valueOf(alias.isMany());
        String optional = String.valueOf(alias.isOptional());
        if (alias instanceof GrammarAlias.TokenAlias) {
            GrammarAlias.TokenAlias ele = (GrammarAlias.TokenAlias)alias;
            String eleAlias = file.imported(GrammarAlias.TokenAlias.class);
            String eleAcc = "grammarAccess." + this.grammarAccess.gaAccessor(ele.getToken());
            return "new " + eleAlias + "(" + optional + ", " + many + ", " + eleAcc + ")";
        }
        if (alias instanceof GrammarAlias.GroupAlias) {
            ArrayList<String> children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.GroupAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor(child, file));
            }
            String body = Join.join(", ", children);
            String grpAlias = file.imported(GrammarAlias.GroupAlias.class);
            return "new " + grpAlias + "(" + optional + ", " + many + ", " + body + ")";
        }
        if (alias instanceof GrammarAlias.AlternativeAlias) {
            ArrayList<String> children = Lists.newArrayList();
            for (GrammarAlias.AbstractElementAlias child : ((GrammarAlias.AlternativeAlias)alias).getChildren()) {
                children.add(this.elementAliasToConstructor(child, file));
            }
            Collections.sort(children);
            String body = Join.join(", ", children);
            String altAlias = file.imported(GrammarAlias.AlternativeAlias.class);
            return "new " + altAlias + "(" + optional + ", " + many + ", " + body + ")";
        }
        throw new RuntimeException("unknown element");
    }

    protected String elementAliasToIdentifyer(GrammarAlias.AbstractElementAlias alias) {
        HashSet<String> rulesSet = Sets.newHashSet();
        String body = this.elementAliasToIdentifyer(alias, rulesSet, false);
        ArrayList<String> rulesList = Lists.newArrayList(rulesSet);
        Collections.sort(rulesList);
        String rule = Join.join("_", rulesList);
        return String.valueOf(rule) + "_" + body;
    }
}

