/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.ex;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.BindFactory;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.DefaultGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.parser.antlr.Lexer;
import org.eclipse.xtext.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalAntlrLexerFragment
extends DefaultGeneratorFragment {
    private String lexerGrammar;
    private boolean highlighting;
    private boolean runtime;
    private boolean contentAssist;
    private List<String> antlrParams = Lists.newArrayList();
    private AntlrToolFacade antlrTool = new AntlrToolFacade();

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        String[] result = this.antlrParams.toArray(new String[this.antlrParams.size()]);
        return result;
    }

    public void setAntlrTool(AntlrToolFacade facade) {
        this.antlrTool = facade;
    }

    public AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        super.generate(grammar, ctx);
        String srcGen = "SRC_GEN";
        String src = "SRC";
        if (this.contentAssist || this.highlighting) {
            srcGen = "SRC_GEN_UI";
            src = "SRC_UI";
        }
        String srcGenPath = ctx.getOutput().getOutlet(srcGen).getPath();
        String srcPath = ctx.getOutput().getOutlet(src).getPath();
        String grammarFile = String.valueOf(srcPath) + "/" + this.getLexerGrammar().replace('.', '/') + ".g";
        String generateTo = "";
        if (this.lexerGrammar.lastIndexOf(46) != -1) {
            generateTo = this.lexerGrammar.substring(0, this.lexerGrammar.lastIndexOf(46));
        }
        generateTo = String.valueOf(srcGenPath) + "/" + generateTo.replace('.', '/');
        this.addAntlrParam("-fo");
        this.addAntlrParam(generateTo);
        this.getAntlrTool().runWithParams(grammarFile, this.getAntlrParams());
        String javaFile = String.valueOf(srcGenPath) + "/" + this.getLexerGrammar().replace('.', '/') + ".java";
        this.suppressWarningsImpl(javaFile);
    }

    protected void suppressWarningsImpl(String javaFile) {
        String content = Files.readFileIntoString(javaFile);
        content = new SuppressWarningsProcessor().process(content);
        Files.writeStringIntoFile(javaFile, content);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        if (this.contentAssist && this.highlighting || this.runtime && this.highlighting || this.contentAssist && this.runtime) {
            issues.addError("Only one of those flags is allowed: contentAssist, runtime, highlighting flag");
        }
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(Grammar grammar) {
        if (this.runtime) {
            return new BindFactory().addConfiguredBinding("RuntimeLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.parser.antlr.LexerBindings.RUNTIME" + ")).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(Grammar grammar) {
        if (this.highlighting) {
            return new BindFactory().addConfiguredBinding("HighlightingLexer", "binder.bind(" + Lexer.class.getName() + ".class)" + ".annotatedWith(com.google.inject.name.Names.named(" + "org.eclipse.xtext.ui.LexerUIBindings.HIGHLIGHTING" + ")).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        if (this.contentAssist) {
            return new BindFactory().addConfiguredBinding("ContentAssistLexer", "binder.bind(org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.class).annotatedWith(com.google.inject.name.Names.named(org.eclipse.xtext.ui.LexerUIBindings.CONTENT_ASSIST)).to(" + this.lexerGrammar + ".class)").getBindings();
        }
        return Collections.emptySet();
    }

    public void setLexerGrammar(String lexerGrammar) {
        this.lexerGrammar = lexerGrammar;
    }

    public String getLexerGrammar() {
        return this.lexerGrammar;
    }

    public void setHighlighting(boolean highlighting) {
        this.highlighting = highlighting;
    }

    public boolean isHighlighting() {
        return this.highlighting;
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setContentAssist(boolean contentAssist) {
        this.contentAssist = contentAssist;
    }

    public boolean isContentAssist() {
        return this.contentAssist;
    }
}

