/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.AbstractGeneratorFragment;
import org.eclipse.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;
import org.eclipse.xtext.generator.parser.packrat.PackratParserFragment;
import org.eclipse.xtext.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAntlrGeneratorFragment
extends AbstractGeneratorFragment {
    private AntlrToolFacade antlrTool = new AntlrToolFacade();
    private AntlrOptions options = new AntlrOptions();
    private List<String> antlrParams = Lists.newArrayList();

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (!this.antlrTool.isWorkable()) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment '" + PackratParserFragment.class.getName() + "' in your mwe2 file instead.");
        }
    }

    public void setAntlrTool(AntlrToolFacade facade) {
        this.antlrTool = facade;
    }

    public AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }

    public AntlrOptions getOptions() {
        return this.options;
    }

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        String[] result = this.antlrParams.toArray(new String[this.antlrParams.size()]);
        return result;
    }

    @Override
    protected List<Object> getParameters(Grammar grammar) {
        return Collections.singletonList(this.options);
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        AbstractRule firstRule = (AbstractRule)grammar.getRules().get(0);
        if (!(firstRule instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)firstRule)) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
        super.generate(grammar, ctx);
    }

    protected void splitLexerClassFile(String filename) throws IOException {
        String content = Files.readFileIntoString(filename);
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        Files.writeStringIntoFile(filename, splitter.transform());
    }

    protected void splitParserClassFile(String filename) throws IOException {
        String content = Files.readFileIntoString(filename);
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, this.getOptions().getFieldsPerClass());
        Files.writeStringIntoFile(filename, splitter.transform());
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, String absoluteParserFileName) {
        try {
            if (this.containsUnorderedGroup(grammar)) {
                String javaFile = absoluteParserFileName.replaceAll("\\.g$", this.getParserFileNameSuffix());
                this.simplifyUnorderedGroupPredicates(javaFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getParserFileNameSuffix() {
        return "Parser.java";
    }

    protected void simplifyUnorderedGroupPredicates(String javaFile) throws IOException {
        String content = Files.readFileIntoString(javaFile);
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        Files.writeStringIntoFile(javaFile, newContent);
    }

    private void suppressWarningsImpl(String javaFile) {
        String content = Files.readFileIntoString(javaFile);
        content = new SuppressWarningsProcessor().process(content);
        Files.writeStringIntoFile(javaFile, content);
    }

    protected void suppressWarnings(String grammarFileName) {
        this.suppressWarnings(grammarFileName, grammarFileName);
    }

    protected void suppressWarnings(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        this.suppressWarningsImpl(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()));
        this.suppressWarningsImpl(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()));
    }

    protected String getLexerFileNameSuffix() {
        return "Lexer.java";
    }

    protected void splitParserAndLexerIfEnabled(String absoluteLexerGrammarFileName, String absoluteParserGrammarFileName) {
        if (this.getOptions().isClassSplitting()) {
            try {
                this.splitLexerClassFile(absoluteLexerGrammarFileName.replaceAll("\\.g$", this.getLexerFileNameSuffix()));
                this.splitParserClassFile(absoluteParserGrammarFileName.replaceAll("\\.g$", this.getParserFileNameSuffix()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void splitParserAndLexerIfEnabled(String absoluteGrammarFileName) {
        this.splitParserAndLexerIfEnabled(absoluteGrammarFileName, absoluteGrammarFileName);
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        for (ParserRule rule : GrammarUtil.allParserRules(grammar)) {
            if (!Iterators.filter(rule.eAllContents(), UnorderedGroup.class).hasNext()) continue;
            return true;
        }
        return false;
    }
}

