/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import com.google.inject.Guice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextRuntimeModule;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.grammarAccess.UnicodeCharacterDatabaseNames;
import org.eclipse.xtext.parsetree.reconstr.Serializer;
import org.eclipse.xtext.resource.SaveOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrammarAccessUtil {
    private static Serializer xtextSerializer;

    public static String getClassName(EObject obj) {
        return obj.eClass().getName();
    }

    private static List<String> getElementDescription(AbstractElement element) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractElement container = element;
        while (container != null) {
            result.addAll(0, GrammarAccessUtil.getSingleElementDescription(container));
            AbstractElement abstractElement = container = container.eContainer() instanceof AbstractElement ? (AbstractElement)container.eContainer() : null;
        }
        return result;
    }

    private static List<String> getSingleElementDescription(AbstractElement ele) {
        if (ele instanceof Keyword) {
            return Collections.singletonList(((Keyword)ele).getValue());
        }
        if (ele instanceof Assignment) {
            return Collections.singletonList(((Assignment)ele).getFeature());
        }
        if (ele instanceof RuleCall) {
            return Collections.singletonList(((RuleCall)ele).getRule().getName());
        }
        if (ele instanceof Action) {
            Action a2 = (Action)ele;
            ArrayList<String> r = new ArrayList<String>();
            if (a2.getType() != null && a2.getType().getClassifier() != null) {
                r.add(a2.getType().getClassifier().getName());
            }
            if (a2.getFeature() != null && !"".equals(a2.getFeature())) {
                r.add(a2.getFeature());
            }
            return r;
        }
        if (ele instanceof CrossReference) {
            CrossReference cr = (CrossReference)ele;
            if (cr.getType() != null && cr.getType().getClassifier() != null) {
                return Collections.singletonList(cr.getType().getClassifier().getName());
            }
        } else if (ele instanceof EnumLiteralDeclaration) {
            EnumLiteralDeclaration decl = (EnumLiteralDeclaration)ele;
            return Collections.singletonList(decl.getEnumLiteral().getName());
        }
        return Collections.emptyList();
    }

    public static String serialize(EObject obj, String prefix) {
        String s;
        try {
            SaveOptions options = SaveOptions.newBuilder().format().getOptions();
            s = GrammarAccessUtil.getSerializer().serialize(obj, options);
        }
        catch (Exception e) {
            s = e.toString();
        }
        s = String.valueOf(prefix) + s.trim().replaceAll("[\\r\\n]", "\n" + prefix).replaceAll("/\\*", "/ *").replaceAll("\\*/", "* /");
        return s;
    }

    private static Serializer getSerializer() {
        if (xtextSerializer == null) {
            xtextSerializer = Guice.createInjector(new XtextRuntimeModule()).getInstance(Serializer.class);
        }
        return xtextSerializer;
    }

    private static String getElementPath(AbstractElement ele) {
        EObject obj = ele;
        StringBuffer buf = new StringBuffer();
        while (!(obj.eContainer() instanceof AbstractRule) && obj.eContainer() != null) {
            EObject tmp = obj.eContainer();
            buf.insert(0, tmp.eContents().indexOf(obj));
            buf.insert(0, "_");
            obj = tmp;
        }
        return buf.toString();
    }

    private static String getElementTypeDescription(AbstractElement ele) {
        if (ele instanceof RuleCall) {
            AbstractRule r = ((RuleCall)ele).getRule();
            return String.valueOf(r.eClass().getName()) + "Call";
        }
        return ele.eClass().getName();
    }

    public static String getGrammarAccessFQName(Grammar grammar, Naming naming) {
        return String.valueOf(naming.basePackageRuntime(grammar)) + ".services." + GrammarUtil.getName(grammar) + "GrammarAccess";
    }

    public static String getUniqueElementName(AbstractElement ele) {
        block3: {
            try {
                if (ele != null) break block3;
                return "null";
            }
            catch (Throwable t) {
                t.printStackTrace();
                return "failure";
            }
        }
        ArrayList<String> r = new ArrayList<String>();
        r.addAll(GrammarAccessUtil.getElementDescription(ele));
        r.add(GrammarAccessUtil.getElementTypeDescription(ele));
        r.add(GrammarAccessUtil.getElementPath(ele));
        return GrammarAccessUtil.toJavaIdentifier(r, true);
    }

    private static String toJavaIdentifier(List<String> text, boolean uppercaseFirst) {
        Iterator<String> i = text.iterator();
        StringBuffer b2 = new StringBuffer(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), true, uppercaseFirst));
        while (i.hasNext()) {
            b2.append(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), false, true));
        }
        return b2.toString();
    }

    private static String toJavaIdentifierSegmentInt(String text, boolean isFirst, boolean uppercaseFirst) {
        boolean start = isFirst;
        boolean up = true;
        StringBuffer r = new StringBuffer();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            boolean valid = GrammarAccessUtil.isValidJavaLatinIdentifier(start, c2);
            if (valid) {
                if (start) {
                    r.append(uppercaseFirst ? Character.toUpperCase(c2) : Character.toLowerCase(c2));
                } else {
                    r.append(up ? Character.toUpperCase(c2) : c2);
                }
                up = false;
                start = false;
            } else {
                up = true;
            }
            ++n2;
        }
        return r.toString();
    }

    public static boolean isValidJavaLatinIdentifier(boolean start, char c2) {
        boolean valid = c2 >= 'A' && c2 <= 'Z';
        valid = valid || c2 >= 'a' && c2 <= 'z';
        valid = valid || c2 == '\u00e4' || c2 == '\u00f6' || c2 == '\u00fc' || c2 == '\u00c4' || c2 == '\u00d6' || c2 == '\u00dc';
        boolean bl = valid = valid || c2 == '_';
        if (!start) {
            valid = valid || c2 >= '0' && c2 <= '9';
        }
        return valid;
    }

    private static String toJavaIdentifierSegment(String text, boolean isFirst, boolean uppercaseFirst) {
        String r = GrammarAccessUtil.toJavaIdentifierSegmentInt(text, isFirst, uppercaseFirst);
        if (r.length() > 0) {
            return r;
        }
        StringBuffer b2 = new StringBuffer();
        char[] cArray = text.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            String n3 = UnicodeCharacterDatabaseNames.getCharacterName(c2);
            if (n3 != null) {
                b2.append(String.valueOf(n3) + " ");
            }
            ++n2;
        }
        return GrammarAccessUtil.toJavaIdentifierSegmentInt(b2.toString().toLowerCase().trim(), isFirst, true);
    }

    public static String toJavaIdentifier(String text, Boolean uppercaseFirst) {
        try {
            return GrammarAccessUtil.toJavaIdentifierSegment(text, true, uppercaseFirst);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "%_FAILURE_(" + text + ")%";
        }
    }
}

