/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.generator.CompositeGeneratorFragment;
import org.eclipse.xtext.generator.IGeneratorFragment;
import org.eclipse.xtext.generator.ImplicitRuntimeFragment;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.generator.ImplicitUiFragment;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageConfig
extends CompositeGeneratorFragment {
    private static final Logger LOG = Logger.getLogger(LanguageConfig.class);
    private Grammar grammar;
    private List<String> fileExtensions = new ArrayList<String>();

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        if (LOG.isInfoEnabled()) {
            LOG.info("generating infrastructure for " + grammar.getName() + " with fragments : " + Strings.toString(this.fragments, new ToStringFunction(", "), ", "));
        }
        super.generate(grammar, ctx);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.isCheckFileExtension()) {
            for (String extension : this.fileExtensions) {
                char[] charArray = extension.toCharArray();
                if (!Character.isJavaIdentifierPart(charArray[0])) {
                    issues.addError("file extension '" + extension + "' starts with a non identifier letter : '" + charArray[0] + "'", this);
                }
                int i = 1;
                while (i < charArray.length) {
                    char c2 = charArray[i];
                    if (!Character.isJavaIdentifierPart(c2)) {
                        issues.addError("file extension '" + extension + "' contains non identifier letter : '" + c2 + "'", this);
                    }
                    ++i;
                }
            }
        }
        if (this.getGrammar() == null) {
            issues.addError("property 'uri' is mandatory for element 'language'.", this);
        }
    }

    protected boolean isCheckFileExtension() {
        return true;
    }

    public void setFileExtensions(String fileExtensions) {
        String[] split;
        if ("".equals(fileExtensions.trim())) {
            return;
        }
        String[] stringArray = split = fileExtensions.split("\\s*,\\s*");
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.fileExtensions.add(string);
            ++n2;
        }
    }

    public List<String> getFileExtensions(Grammar g) {
        if (this.fileExtensions.isEmpty()) {
            String lowerCase = GrammarUtil.getName(g).toLowerCase();
            if (LOG.isInfoEnabled()) {
                LOG.info("No explicit fileExtensions configured. Using '*." + lowerCase + "'.");
            }
            return Collections.singletonList(lowerCase);
        }
        return this.fileExtensions;
    }

    public void initialize(boolean isUi) {
        if (isUi) {
            this.fragments.add(0, new ImplicitUiFragment(this.getFileExtensions(this.getGrammar())));
        }
        this.fragments.add(0, new ImplicitRuntimeFragment());
    }

    public void setUri(String uri) {
        XtextResourceSet rs = new XtextResourceSet();
        XtextResource resource = (XtextResource)rs.getResource(URI.createURI(uri), true);
        if (resource.getContents().isEmpty()) {
            throw new IllegalArgumentException("Couldn't load grammar for '" + uri + "'.");
        }
        if (!resource.getErrors().isEmpty()) {
            LOG.error(resource.getErrors());
            throw new IllegalStateException("Problem parsing '" + uri + "':" + resource.getErrors().toString());
        }
        Grammar grammar = (Grammar)resource.getContents().get(0);
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(XtextPackage.eINSTANCE);
        if (validator != null) {
            DiagnosticChain chain = new DiagnosticChain(){

                public void add(Diagnostic diagnostic) {
                    if (diagnostic.getSeverity() == 4) {
                        if (diagnostic.getException() == null) {
                            throw new IllegalStateException(diagnostic.getMessage());
                        }
                        throw new IllegalStateException(diagnostic.getMessage(), diagnostic.getException());
                    }
                }

                public void addAll(Diagnostic diagnostic) {
                    this.add(diagnostic);
                }

                public void merge(Diagnostic diagnostic) {
                    throw new UnsupportedOperationException();
                }
            };
            validator.validate(grammar, chain, null);
            TreeIterator<EObject> iterator = grammar.eAllContents();
            while (iterator.hasNext()) {
                validator.validate((EObject)iterator.next(), chain, null);
            }
        }
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ToStringFunction
    implements Function<IGeneratorFragment, String> {
        private String delim;

        public ToStringFunction(String string) {
            this.delim = string;
        }

        @Override
        public String apply(IGeneratorFragment from) {
            if (from instanceof CompositeGeneratorFragment) {
                return Strings.toString(((CompositeGeneratorFragment)from).fragments, this, this.delim);
            }
            return from.getClass().getSimpleName();
        }
    }
}

