/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.emf.mwe.core.WorkflowInterruptedException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.generator.Binding;
import org.eclipse.xtext.generator.IGeneratorFragment;
import org.eclipse.xtext.generator.LoggingGeneratorFragment;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.generator.NamingAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeGeneratorFragment
implements IGeneratorFragment,
NamingAware {
    private static Logger LOG = Logger.getLogger(CompositeGeneratorFragment.class);
    protected final List<IGeneratorFragment> fragments = new ArrayList<IGeneratorFragment>();
    private Naming naming;

    public void addFragment(IGeneratorFragment fragment) {
        if (this.naming != null && fragment instanceof NamingAware) {
            ((NamingAware)((Object)fragment)).registerNaming(this.naming);
        }
        this.fragments.add(fragment);
    }

    public void addFragments(CompositeGeneratorFragment fragment) {
        if (this.naming != null) {
            fragment.registerNaming(this.naming);
        }
        this.fragments.add(fragment);
    }

    public void addLog(LoggingGeneratorFragment message) {
        message.setLevel(Level.INFO);
        this.addFragment(message);
    }

    public void addWarn(LoggingGeneratorFragment message) {
        message.setLevel(Level.WARN);
        this.addFragment(message);
    }

    @Override
    public void addToPluginXmlRt(Grammar grammar, XpandExecutionContext ctx) {
        for (IGeneratorFragment fragment : this.fragments) {
            fragment.addToPluginXmlRt(grammar, ctx);
        }
    }

    @Override
    public void addToPluginXmlUi(Grammar grammar, XpandExecutionContext ctx) {
        for (IGeneratorFragment fragment : this.fragments) {
            fragment.addToPluginXmlUi(grammar, ctx);
        }
    }

    @Override
    public void addToStandaloneSetup(Grammar grammar, XpandExecutionContext ctx) {
        for (IGeneratorFragment fragment : this.fragments) {
            fragment.addToStandaloneSetup(grammar, ctx);
        }
    }

    @Override
    public void generate(Grammar grammar, XpandExecutionContext ctx) {
        for (IGeneratorFragment fragment : this.fragments) {
            try {
                fragment.generate(grammar, ctx);
            }
            catch (WorkflowInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public String[] getExportedPackagesRt(final Grammar grammar) {
        return this.internalGetExportedPackages(grammar, new Function<IGeneratorFragment, String[]>(){

            @Override
            public String[] apply(IGeneratorFragment param) {
                return param.getExportedPackagesRt(grammar);
            }
        });
    }

    @Override
    public String[] getImportedPackagesRt(final Grammar grammar) {
        return this.internalGetImportedPackages(grammar, new Function<IGeneratorFragment, String[]>(){

            @Override
            public String[] apply(IGeneratorFragment param) {
                return param.getImportedPackagesRt(grammar);
            }
        });
    }

    @Override
    public String[] getExportedPackagesUi(final Grammar grammar) {
        return this.internalGetExportedPackages(grammar, new Function<IGeneratorFragment, String[]>(){

            @Override
            public String[] apply(IGeneratorFragment param) {
                return param.getExportedPackagesUi(grammar);
            }
        });
    }

    @Override
    public String[] getImportedPackagesUi(final Grammar grammar) {
        return this.internalGetImportedPackages(grammar, new Function<IGeneratorFragment, String[]>(){

            @Override
            public String[] apply(IGeneratorFragment param) {
                return param.getImportedPackagesUi(grammar);
            }
        });
    }

    @Override
    public Set<Binding> getGuiceBindingsRt(final Grammar grammar) {
        return this.internalGetGuiceBindings(grammar, new Function<IGeneratorFragment, Set<Binding>>(){

            @Override
            public Set<Binding> apply(IGeneratorFragment param) {
                return param.getGuiceBindingsRt(grammar);
            }
        });
    }

    @Override
    public Set<Binding> getGuiceBindingsUi(final Grammar grammar) {
        return this.internalGetGuiceBindings(grammar, new Function<IGeneratorFragment, Set<Binding>>(){

            @Override
            public Set<Binding> apply(IGeneratorFragment param) {
                return param.getGuiceBindingsUi(grammar);
            }
        });
    }

    private String[] internalGetExportedPackages(Grammar grammar, Function<IGeneratorFragment, String[]> func) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (IGeneratorFragment f : this.fragments) {
            String[] exportedPackages = func.apply(f);
            if (exportedPackages == null) continue;
            all.addAll(Arrays.asList(exportedPackages));
        }
        return all.toArray(new String[all.size()]);
    }

    private String[] internalGetImportedPackages(Grammar grammar, Function<IGeneratorFragment, String[]> func) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (IGeneratorFragment f : this.fragments) {
            String[] importedPackages = func.apply(f);
            if (importedPackages == null) continue;
            all.addAll(Arrays.asList(importedPackages));
        }
        return all.toArray(new String[all.size()]);
    }

    private Set<Binding> internalGetGuiceBindings(Grammar grammar, Function<IGeneratorFragment, Set<Binding>> func) {
        LinkedHashSet<Binding> bindings = new LinkedHashSet<Binding>();
        for (IGeneratorFragment module : this.fragments) {
            Set<Binding> temp = func.apply(module);
            if (temp == null) continue;
            for (Binding entry : temp) {
                if (bindings.contains(entry)) {
                    Iterator iterator = bindings.iterator();
                    while (iterator.hasNext()) {
                        Binding binding = (Binding)iterator.next();
                        if (!binding.equals(entry)) continue;
                        if (binding.isFinal()) {
                            throw new IllegalStateException("Cannot override final binding '" + binding + "'");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("replacing binding : " + binding);
                            LOG.debug(" with new binding : " + entry);
                        }
                        iterator.remove();
                        break;
                    }
                }
                bindings.add(entry);
            }
        }
        return bindings;
    }

    @Override
    public String[] getRequiredBundlesRt(Grammar grammar) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (IGeneratorFragment f : this.fragments) {
            String[] requiredBundlesRt = f.getRequiredBundlesRt(grammar);
            if (requiredBundlesRt == null) continue;
            all.addAll(Arrays.asList(requiredBundlesRt));
        }
        return all.toArray(new String[all.size()]);
    }

    @Override
    public String[] getRequiredBundlesUi(Grammar grammar) {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (IGeneratorFragment f : this.fragments) {
            String[] requiredBundlesUi = f.getRequiredBundlesUi(grammar);
            if (requiredBundlesUi == null) continue;
            all.addAll(Arrays.asList(requiredBundlesUi));
        }
        return all.toArray(new String[all.size()]);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        for (IGeneratorFragment fragment : this.fragments) {
            fragment.checkConfiguration(issues);
        }
    }

    @Override
    public void registerNaming(Naming n) {
        this.naming = n;
        for (IGeneratorFragment f : this.fragments) {
            if (!(f instanceof NamingAware)) continue;
            ((NamingAware)((Object)f)).registerNaming(n);
        }
    }
}

