/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.conversion.impl;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INTValueConverter
extends AbstractLexerBasedConverter<Integer> {
    @Override
    protected String toEscapedString(Integer value) {
        return value.toString();
    }

    @Override
    protected void assertValidValue(Integer value) {
        super.assertValidValue(value);
        if (value < 0) {
            throw new ValueConverterException(String.valueOf(this.getRuleName()) + "-value may not be negative (value:" + value + ").", null, null);
        }
    }

    @Override
    public Integer toValue(String string, INode node) {
        if (Strings.isEmpty(string)) {
            throw new ValueConverterException("Couldn't convert empty string to int.", node, null);
        }
        try {
            int intValue = Integer.parseInt(string, 10);
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to int.", node, e);
        }
    }
}

