/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.TypeNotFoundException;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeScope
extends AbstractScope {
    private final IJvmTypeProvider typeProvider;
    private final IQualifiedNameConverter qualifiedNameConverter;
    private final Predicate<IEObjectDescription> filter;

    protected AbstractTypeScope(IJvmTypeProvider typeProvider, IQualifiedNameConverter qualifiedNameConverter, Predicate<IEObjectDescription> filter) {
        super(IScope.NULLSCOPE, false);
        this.typeProvider = typeProvider;
        this.qualifiedNameConverter = qualifiedNameConverter;
        this.filter = filter;
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription result;
        block6: {
            JvmType type;
            block5: {
                type = this.typeProvider.findTypeByName(this.qualifiedNameConverter.toString(name));
                if (type != null) break block5;
                return null;
            }
            result = EObjectDescription.create(name, (EObject)type);
            if (this.filter == null || this.filter.apply(result)) break block6;
            return null;
        }
        try {
            return result;
        }
        catch (TypeNotFoundException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription result = this.getSingleElement(name);
        if (result != null) {
            return Collections.singleton(result);
        }
        return Collections.emptySet();
    }

    @Override
    public Iterable<IEObjectDescription> getElements(EObject object) {
        if (object instanceof JvmIdentifiableElement) {
            Set<IEObjectDescription> result = Collections.singleton(EObjectDescription.create(this.qualifiedNameConverter.toQualifiedName(((JvmIdentifiableElement)object).getQualifiedName()), object));
            return this.filterResult(result);
        }
        return Collections.emptySet();
    }

    protected Iterable<IEObjectDescription> filterResult(Iterable<IEObjectDescription> unfiltered) {
        if (this.filter == null) {
            return unfiltered;
        }
        return Iterables.filter(unfiltered, this.filter);
    }

    @Override
    public Iterable<IEObjectDescription> getAllElements() {
        return this.filterResult(this.internalGetAllElements());
    }

    protected Iterable<IEObjectDescription> internalGetAllElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Iterable<IEObjectDescription> getAllLocalElements() {
        throw new UnsupportedOperationException();
    }

    public IJvmTypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

