/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.ClassURIHelper;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredTypeFactory
implements ITypeFactory<Class<?>> {
    private static final Logger log = Logger.getLogger(DeclaredTypeFactory.class);
    private final ClassURIHelper uriHelper;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    @Inject
    public DeclaredTypeFactory(ClassURIHelper uriHelper) {
        this.uriHelper = uriHelper;
    }

    public JvmDeclaredType createType(Class<?> clazz) {
        if (clazz.isAnonymousClass() || clazz.isSynthetic()) {
            throw new IllegalStateException("Cannot create type for anonymous or synthetic classes");
        }
        if (clazz.isAnnotation()) {
            return this.createAnnotationType(clazz);
        }
        if (clazz.isEnum()) {
            return this.createEnumerationType(clazz);
        }
        JvmGenericType result = TypesFactory.eINSTANCE.createJvmGenericType();
        result.setInterface(clazz.isInterface());
        this.setTypeModifiers(clazz, result);
        this.setVisibility(clazz, result);
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null && clazz.getPackage() != null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.createConstructors(clazz, result);
        this.createFields(clazz, result);
        this.setSuperTypes(clazz, result);
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        int n = typeVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariable<Class<?>> variable = typeVariableArray[n2];
            result.getTypeParameters().add(this.createTypeParameter(variable, result));
            ++n2;
        }
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void createAnnotationValues(AnnotatedElement annotated, JvmAnnotationTarget result) {
        Annotation[] annotationArray = annotated.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.createAnnotationReference(result, annotation);
            ++n2;
        }
    }

    protected JvmAnnotationReference createAnnotationReference(JvmAnnotationTarget result, Annotation annotation) {
        JvmAnnotationReference annotationReference = TypesFactory.eINSTANCE.createJvmAnnotationReference();
        result.getAnnotations().add(annotationReference);
        Class<? extends Annotation> type = annotation.annotationType();
        annotationReference.setAnnotation(this.createAnnotationProxy(type));
        Method[] methodArray = type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            try {
                JvmAnnotationValue annotationValue;
                Object value = method.invoke((Object)annotation, EMPTY_ARRAY);
                if (method.getReturnType().isArray()) {
                    annotationValue = this.createArrayAnnotationValue(value, method.getReturnType());
                    annotationReference.getValues().add(annotationValue);
                    annotationValue.setOperation(this.createMethodProxy(method));
                } else {
                    annotationValue = this.createAnnotationValue(value, method.getReturnType());
                    annotationReference.getValues().add(annotationValue);
                    annotationValue.setOperation(this.createMethodProxy(method));
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
            ++n2;
        }
        return annotationReference;
    }

    protected JvmEnumerationLiteral createEnumLiteralProxy(Enum<?> e) {
        JvmEnumerationLiteral enumLiteralProxy = TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        InternalEObject internalEObject = (InternalEObject)((Object)enumLiteralProxy);
        Class<?> type = e.getDeclaringClass();
        try {
            Field field = type.getDeclaredField(e.toString());
            internalEObject.eSetProxyURI(this.uriHelper.getFullURI(field));
        }
        catch (Exception exception) {
            log.error(exception.getMessage(), exception);
            return null;
        }
        return enumLiteralProxy;
    }

    protected JvmAnnotationValue createArrayAnnotationValue(Object value, Class<?> type) {
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array type: " + type.getCanonicalName());
        }
        Class<?> componentType = type.getComponentType();
        JvmAnnotationValue result = this.createAnnotationValue(componentType);
        int length = Array.getLength(value);
        if (length > 0) {
            ArrayList<Object> valuesAsList = Lists.newArrayListWithExpectedSize(length);
            if (componentType.isPrimitive() || String.class.equals(componentType)) {
                int i = 0;
                while (i < length) {
                    valuesAsList.add(Array.get(value, i));
                    ++i;
                }
            } else if (componentType.equals(Class.class)) {
                int i = 0;
                while (i < length) {
                    Class referencedClass = (Class)Array.get(value, i);
                    valuesAsList.add(this.createTypeReference(referencedClass));
                    ++i;
                }
            } else if (componentType.isAnnotation()) {
                int i = 0;
                while (i < length) {
                    Annotation nestedAnnotation = (Annotation)Array.get(value, i);
                    this.createAnnotationReference((JvmAnnotationTarget)((Object)result), nestedAnnotation);
                    ++i;
                }
            } else if (componentType.isEnum()) {
                int i = 0;
                while (i < length) {
                    Enum e = (Enum)Array.get(value, i);
                    JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(e);
                    valuesAsList.add(proxy);
                    ++i;
                }
            }
            if (!componentType.isAnnotation()) {
                result.eSet(result.eClass().getEStructuralFeature("values"), valuesAsList);
            }
        }
        return result;
    }

    protected JvmAnnotationValue createAnnotationValue(Object value, Class<?> type) {
        JvmAnnotationValue result = this.createAnnotationValue(type);
        if (type.isPrimitive() || String.class.equals(type)) {
            result.eSet(result.eClass().getEStructuralFeature("values"), Collections.singleton(value));
        } else if (type.equals(Class.class)) {
            Class referencedClass = (Class)value;
            JvmTypeReference reference = this.createTypeReference(referencedClass);
            result.eSet(result.eClass().getEStructuralFeature("values"), Collections.singleton(reference));
        } else if (type.isAnnotation()) {
            Annotation nestedAnnotation = (Annotation)value;
            this.createAnnotationReference((JvmAnnotationTarget)((Object)result), nestedAnnotation);
        } else if (type.isEnum()) {
            Enum e = (Enum)value;
            JvmEnumerationLiteral proxy = this.createEnumLiteralProxy(e);
            result.eSet(result.eClass().getEStructuralFeature("values"), Collections.singleton(proxy));
        }
        return result;
    }

    protected JvmAnnotationValue createAnnotationValue(Class<?> type) {
        if (String.class.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmStringAnnotationValue();
        }
        if (Class.class.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmTypeAnnotationValue();
        }
        if (type.isAnnotation()) {
            return TypesFactory.eINSTANCE.createJvmAnnotationAnnotationValue();
        }
        if (type.isEnum()) {
            return TypesFactory.eINSTANCE.createJvmEnumAnnotationValue();
        }
        if (Integer.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmIntAnnotationValue();
        }
        if (Boolean.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmBooleanAnnotationValue();
        }
        if (Long.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmLongAnnotationValue();
        }
        if (Byte.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmByteAnnotationValue();
        }
        if (Short.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmShortAnnotationValue();
        }
        if (Float.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmFloatAnnotationValue();
        }
        if (Double.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmDoubleAnnotationValue();
        }
        if (Character.TYPE.equals(type)) {
            return TypesFactory.eINSTANCE.createJvmCharAnnotationValue();
        }
        throw new IllegalArgumentException("Unexpected type: " + type.getCanonicalName());
    }

    protected JvmAnnotationType createAnnotationProxy(Class<? extends Annotation> type) {
        InternalEObject proxy = (InternalEObject)((Object)TypesFactory.eINSTANCE.createJvmAnnotationType());
        URI uri = this.uriHelper.getFullURI(type);
        proxy.eSetProxyURI(uri);
        return (JvmAnnotationType)((Object)proxy);
    }

    protected JvmOperation createMethodProxy(Method method) {
        InternalEObject proxy = (InternalEObject)((Object)TypesFactory.eINSTANCE.createJvmOperation());
        URI uri = this.uriHelper.getFullURI(method);
        proxy.eSetProxyURI(uri);
        return (JvmOperation)((Object)proxy);
    }

    protected void setTypeModifiers(Class<?> clazz, JvmDeclaredType result) {
        result.setAbstract(Modifier.isAbstract(clazz.getModifiers()));
        result.setFinal(Modifier.isFinal(clazz.getModifiers()));
        result.setStatic(Modifier.isStatic(clazz.getModifiers()));
    }

    protected void createNestedTypes(Class<?> clazz, JvmDeclaredType result) {
        Class<?>[] classArray = clazz.getDeclaredClasses();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> declaredClass = classArray[n2];
            if (!declaredClass.isAnonymousClass() && !declaredClass.isSynthetic()) {
                result.getMembers().add(this.createType(declaredClass));
            }
            ++n2;
        }
    }

    public JvmAnnotationType createAnnotationType(Class<?> clazz) {
        JvmAnnotationType result = TypesFactory.eINSTANCE.createJvmAnnotationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setSuperTypes(Class<?> clazz, JvmDeclaredType result) {
        if (clazz.getGenericSuperclass() != null) {
            result.getSuperTypes().add(this.createTypeReference(clazz.getGenericSuperclass()));
        }
        Type[] typeArray = clazz.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            result.getSuperTypes().add(this.createTypeReference(type));
            ++n2;
        }
        if (result.getSuperTypes().isEmpty() && !Object.class.equals(clazz)) {
            result.getSuperTypes().add(this.createTypeReference((Type)((Object)Object.class)));
        }
    }

    protected void createFields(Class<?> clazz, JvmDeclaredType result) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!field.isSynthetic()) {
                result.getMembers().add(this.createField(field));
            }
            ++n2;
        }
    }

    protected void createConstructors(Class<?> clazz, JvmDeclaredType result) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (!constructor.isSynthetic()) {
                result.getMembers().add(this.createConstructor(constructor));
            }
            ++n2;
        }
    }

    protected void createMethods(Class<?> clazz, JvmDeclaredType result) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isSynthetic()) {
                JvmOperation operation = this.createOperation(method);
                if (clazz.isAnnotation()) {
                    this.setDefaultValue(operation, method);
                }
                result.getMembers().add(operation);
            }
            ++n2;
        }
    }

    private void setDefaultValue(JvmOperation operation, Method method) {
        Object defaultValue = method.getDefaultValue();
        if (defaultValue != null) {
            if (method.getReturnType().isArray()) {
                JvmAnnotationValue annotationValue = this.createArrayAnnotationValue(defaultValue, method.getReturnType());
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            } else {
                JvmAnnotationValue annotationValue = this.createAnnotationValue(defaultValue, method.getReturnType());
                operation.setDefaultValue(annotationValue);
                annotationValue.setOperation(operation);
            }
        }
    }

    public JvmEnumerationType createEnumerationType(Class<?> clazz) {
        JvmEnumerationType result = TypesFactory.eINSTANCE.createJvmEnumerationType();
        result.internalSetIdentifier(clazz.getName());
        result.setSimpleName(clazz.getSimpleName());
        if (clazz.getDeclaringClass() == null) {
            result.setPackageName(clazz.getPackage().getName());
        }
        this.setVisibility(clazz, result);
        this.setTypeModifiers(clazz, result);
        this.createNestedTypes(clazz, result);
        this.createMethods(clazz, result);
        this.createFields(clazz, result);
        this.createConstructors(clazz, result);
        this.setSuperTypes(clazz, result);
        this.createAnnotationValues(clazz, result);
        return result;
    }

    protected void setVisibility(Class<?> clazz, JvmMember result) {
        if (Modifier.isPrivate(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(clazz.getModifiers())) {
            result.setVisibility(JvmVisibility.PUBLIC);
        }
    }

    public JvmTypeParameter createTypeParameter(TypeVariable<?> variable, JvmMember container) {
        JvmTypeParameter result = TypesFactory.eINSTANCE.createJvmTypeParameter();
        result.setName(variable.getName());
        if (variable.getBounds().length != 0) {
            Type[] typeArray = variable.getBounds();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type bound = typeArray[n2];
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                upperBound.setTypeReference(this.createTypeReference(bound));
                result.getConstraints().add(upperBound);
                ++n2;
            }
        }
        return result;
    }

    public JvmTypeReference createTypeReference(Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = arrayType.getGenericComponentType();
            return this.createArrayTypeReference(componentType);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(this.createProxy(parameterizedType.getRawType()));
            int i = 0;
            while (i < parameterizedType.getActualTypeArguments().length) {
                JvmTypeReference argument = this.createTypeArgument(parameterizedType.getActualTypeArguments()[i], parameterizedType.getRawType(), i);
                result.getArguments().add(argument);
                ++i;
            }
            return result;
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Class arrayType = (Class)type;
            Class<?> componentType = arrayType.getComponentType();
            return this.createArrayTypeReference(componentType);
        }
        JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
        result.setType(this.createProxy(type));
        return result;
    }

    protected JvmTypeReference createArrayTypeReference(Type componentType) {
        JvmTypeReference componentTypeReference = this.createTypeReference(componentType);
        if (componentTypeReference != null) {
            JvmGenericArrayTypeReference result = TypesFactory.eINSTANCE.createJvmGenericArrayTypeReference();
            JvmArrayType resultArray = TypesFactory.eINSTANCE.createJvmArrayType();
            result.setType(resultArray);
            resultArray.setComponentType(componentTypeReference);
            return result;
        }
        return null;
    }

    public JvmTypeReference createTypeArgument(Type actualTypeArgument, Type rawType, int i) {
        if (actualTypeArgument instanceof WildcardType) {
            Type boundType;
            int n;
            int n2;
            Type[] typeArray;
            WildcardType wildcardType = (WildcardType)actualTypeArgument;
            JvmWildcardTypeReference result = TypesFactory.eINSTANCE.createJvmWildcardTypeReference();
            if (wildcardType.getUpperBounds().length != 0) {
                JvmUpperBound upperBound = TypesFactory.eINSTANCE.createJvmUpperBound();
                typeArray = wildcardType.getUpperBounds();
                n2 = typeArray.length;
                n = 0;
                while (n < n2) {
                    boundType = typeArray[n];
                    JvmTypeReference upperBoundType = this.createTypeReference(boundType);
                    upperBound.setTypeReference(upperBoundType);
                    ++n;
                }
                result.getConstraints().add(upperBound);
            }
            if (wildcardType.getLowerBounds().length != 0) {
                JvmLowerBound lowerBound = TypesFactory.eINSTANCE.createJvmLowerBound();
                typeArray = wildcardType.getLowerBounds();
                n2 = typeArray.length;
                n = 0;
                while (n < n2) {
                    boundType = typeArray[n];
                    JvmTypeReference lowerBoundType = this.createTypeReference(boundType);
                    lowerBound.setTypeReference(lowerBoundType);
                    ++n;
                }
                result.getConstraints().add(lowerBound);
            }
            return result;
        }
        JvmTypeReference result = this.createTypeReference(actualTypeArgument);
        return result;
    }

    public JvmType createProxy(Type type) {
        InternalEObject proxy = (InternalEObject)((Object)TypesFactory.eINSTANCE.createJvmVoid());
        URI uri = this.uriHelper.getFullURI(type);
        proxy.eSetProxyURI(uri);
        return (JvmType)((Object)proxy);
    }

    public JvmField createField(Field field) {
        JvmField result = !field.isEnumConstant() ? TypesFactory.eINSTANCE.createJvmField() : TypesFactory.eINSTANCE.createJvmEnumerationLiteral();
        result.internalSetIdentifier(String.valueOf(field.getDeclaringClass().getName()) + "." + field.getName());
        result.setSimpleName(field.getName());
        result.setFinal(Modifier.isFinal(field.getModifiers()));
        result.setStatic(Modifier.isStatic(field.getModifiers()));
        this.setVisibility(result, field.getModifiers());
        result.setType(this.createTypeReference(field.getGenericType()));
        this.createAnnotationValues(field, result);
        return result;
    }

    public <T> JvmConstructor createConstructor(Constructor<T> constructor) {
        JvmConstructor result = TypesFactory.eINSTANCE.createJvmConstructor();
        this.enhanceExecutable(result, constructor, constructor.getDeclaringClass().getSimpleName(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations());
        result.setVarArgs(constructor.isVarArgs());
        this.enhanceGenericDeclaration(result, constructor);
        Type[] typeArray = constructor.getGenericExceptionTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameterType = typeArray[n2];
            result.getExceptions().add(this.createTypeReference(parameterType));
            ++n2;
        }
        this.createAnnotationValues(constructor, result);
        return result;
    }

    public void setVisibility(JvmMember result, int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            result.setVisibility(JvmVisibility.PRIVATE);
        } else if (Modifier.isProtected(modifiers)) {
            result.setVisibility(JvmVisibility.PROTECTED);
        } else if (Modifier.isPublic(modifiers)) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(JvmVisibility.DEFAULT);
        }
    }

    public void enhanceExecutable(JvmExecutable result, Member member, String simpleName, Type[] parameterTypes, Annotation[][] annotations) {
        StringBuilder fqName = new StringBuilder(48);
        fqName.append(member.getDeclaringClass().getName());
        fqName.append('.');
        fqName.append(simpleName);
        fqName.append('(');
        int i = 0;
        while (i < parameterTypes.length) {
            if (i != 0) {
                fqName.append(',');
            }
            this.uriHelper.computeTypeName(parameterTypes[i], fqName);
            ++i;
        }
        fqName.append(')');
        result.internalSetIdentifier(fqName.toString());
        result.setSimpleName(simpleName);
        this.setVisibility(result, member.getModifiers());
        i = 0;
        Type[] typeArray = parameterTypes;
        int n = parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameterType = typeArray[n2];
            result.getParameters().add(this.createFormalParameter(parameterType, "p" + i, result, annotations[i]));
            ++i;
            ++n2;
        }
    }

    public void enhanceGenericDeclaration(JvmExecutable result, GenericDeclaration declaration) {
        TypeVariable<?>[] typeVariableArray = declaration.getTypeParameters();
        int n = typeVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TypeVariable<?> variable = typeVariableArray[n2];
            result.getTypeParameters().add(this.createTypeParameter(variable, result));
            ++n2;
        }
    }

    public JvmOperation createOperation(Method method) {
        JvmOperation result = TypesFactory.eINSTANCE.createJvmOperation();
        this.enhanceExecutable(result, method, method.getName(), method.getGenericParameterTypes(), method.getParameterAnnotations());
        result.setVarArgs(method.isVarArgs());
        this.enhanceGenericDeclaration(result, method);
        result.setAbstract(Modifier.isAbstract(method.getModifiers()));
        result.setFinal(Modifier.isFinal(method.getModifiers()));
        result.setStatic(Modifier.isStatic(method.getModifiers()));
        result.setReturnType(this.createTypeReference(method.getGenericReturnType()));
        Type[] typeArray = method.getGenericExceptionTypes();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameterType = typeArray[n2];
            result.getExceptions().add(this.createTypeReference(parameterType));
            ++n2;
        }
        this.createAnnotationValues(method, result);
        return result;
    }

    public JvmFormalParameter createFormalParameter(Type parameterType, String paramName, JvmMember container, Annotation[] annotations) {
        JvmFormalParameter result = TypesFactory.eINSTANCE.createJvmFormalParameter();
        result.setName(paramName);
        result.setParameterType(this.createTypeReference(parameterType));
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            this.createAnnotationReference(result, annotation);
            ++n2;
        }
        return result;
    }
}

