/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.lazy.LazyLinkingResource;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.util.CancelIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreUtil2
extends EcoreUtil {
    private static Logger log = Logger.getLogger(EcoreUtil2.class);
    private static final String delim = "\u00ab";
    private static Map<EReference, String> exernalFormCache = new MapMaker().weakKeys().makeMap();

    public static <T extends EObject> T getContainerOfType(EObject ele, Class<T> type) {
        if (type.isAssignableFrom(ele.getClass())) {
            return (T)ele;
        }
        if (ele.eContainer() != null) {
            return EcoreUtil2.getContainerOfType(ele.eContainer(), type);
        }
        return null;
    }

    public static <T extends EObject> T clone(T eObject) {
        return EcoreUtil.copy(eObject);
    }

    public static <T extends EObject> T cloneWithProxies(T original) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        EObject copy = copier.copy(original);
        copier.copyReferences();
        return (T)copy;
    }

    public static <T extends EObject> T cloneIfContained(T eObject) {
        if (eObject.eContainer() != null || eObject.eResource() != null) {
            return EcoreUtil2.clone(eObject);
        }
        return eObject;
    }

    public static <T extends ResourceSet> T clone(T target, ResourceSet source) {
        EList<Resource> resources = source.getResources();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        for (Resource resource : resources) {
            Resource resource2 = target.createResource(resource.getURI());
            resource2.getContents().addAll(copier.copyAll(resource.getContents()));
        }
        copier.copyReferences();
        return target;
    }

    public static <T extends EObject> List<T> getAllContentsOfType(EObject ele, Class<T> type) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator<EObject> allContents = ele.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!type.isAssignableFrom(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    public static <T> List<T> typeSelect(List<?> elements, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (Object ele : elements) {
            if (ele == null || !clazz.isAssignableFrom(ele.getClass())) continue;
            result.add(clazz.cast(ele));
        }
        return result;
    }

    public static <T> List<T> collect(Collection<? extends EObject> instances, int featureId, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>(instances.size());
        for (EObject eObject : instances) {
            if (eObject == null) {
                throw new NullPointerException("obj may not be null");
            }
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureId);
            if (feature == null) {
                throw new NullPointerException("feature may not be null");
            }
            Object object = eObject.eGet(feature);
            if (object == null) continue;
            result.add(type.cast(object));
        }
        return result;
    }

    public static <T extends EObject> List<T> eAllOfType(EObject ele, Class<T> type) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (type.isAssignableFrom(ele.getClass())) {
            result.add(ele);
        }
        TreeIterator<EObject> allContents = ele.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (!type.isAssignableFrom(object.getClass())) continue;
            result.add(object);
        }
        return result;
    }

    public static TreeIterator<EObject> eAll(final EObject obj) {
        return new TreeIterator<EObject>(){
            private TreeIterator<EObject> it = null;
            private int index = 0;

            @Override
            public void prune() {
                switch (this.index) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.it = null;
                        break;
                    }
                    default: {
                        if (this.it == null) break;
                        this.it.prune();
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.index == 0) {
                    return true;
                }
                if (this.it != null) {
                    return this.it.hasNext();
                }
                return false;
            }

            @Override
            public EObject next() {
                if (this.index++ == 0) {
                    this.it = obj.eAllContents();
                    return obj;
                }
                if (this.it != null) {
                    return (EObject)this.it.next();
                }
                return null;
            }

            @Override
            public void remove() {
                if (this.index == 0) {
                    EcoreUtil.remove(obj);
                }
                if (this.it != null) {
                    this.it.remove();
                }
            }
        };
    }

    public static Iterable<EObject> eAllContents(final EObject n) {
        return new Iterable<EObject>(){

            @Override
            public Iterator<EObject> iterator() {
                return EcoreUtil2.eAll(n);
            }
        };
    }

    public static List<EObject> eAllContentsAsList(EObject ele) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator<EObject> iterator = ele.eAllContents();
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public static List<EObject> eAllContentsAsList(Resource resource) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator<EObject> iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public static final EPackage loadEPackage(String uriAsString, ClassLoader classLoader) {
        if (EPackage.Registry.INSTANCE.containsKey(uriAsString)) {
            return EPackage.Registry.INSTANCE.getEPackage(uriAsString);
        }
        URI uri = URI.createURI(uriAsString);
        uri = new ClassloaderClasspathUriResolver().resolve(classLoader, uri);
        Resource resource = new ResourceSetImpl().getResource(uri, true);
        TreeIterator<EObject> allContents = resource.getAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            if (!(next instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)next;
            return ePackage;
        }
        log.error("Could not load EPackage with nsURI" + uriAsString);
        return null;
    }

    public static String getURIFragment(EObject eObject) {
        Resource resource = eObject.eResource();
        String fragment = resource.getURIFragment(eObject);
        return fragment;
    }

    public static EClassifier getCompatibleType(EClassifier typeA, EClassifier typeB) {
        if (typeA.equals(typeB)) {
            return typeA;
        }
        if (!(typeA instanceof EClass) || !(typeB instanceof EClass)) {
            return null;
        }
        List<EClass> sortedCandidates = EcoreUtil2.getSortedCommonCompatibleTypeCandidates((EClass)typeA, (EClass)typeB);
        for (EClass candidate : sortedCandidates) {
            if (!EcoreUtil2.isCommonCompatibleType(candidate, sortedCandidates)) continue;
            return candidate;
        }
        return EcorePackage.Literals.EOBJECT;
    }

    private static boolean isLooslyCompatibleWith(EClass classA, EClass classB) {
        return classA.equals(classB) || classA.getEAllSuperTypes().contains(classB) || classB.getEAllSuperTypes().contains(classA);
    }

    private static boolean isCommonCompatibleType(EClass candidate, List<EClass> candidates) {
        for (EClass otherCandidate : candidates) {
            if (EcoreUtil2.isLooslyCompatibleWith(candidate, otherCandidate)) continue;
            return false;
        }
        return true;
    }

    private static List<EClass> getSortedCommonCompatibleTypeCandidates(EClass classA, EClass classB) {
        List<EClass> result = EcoreUtil2.getCompatibleTypesOf(classA);
        List<EClass> compatibleTypesOfB = EcoreUtil2.getCompatibleTypesOf(classB);
        result.retainAll(compatibleTypesOfB);
        Collections.sort(result, new EClassTypeHierarchyComparator());
        return result;
    }

    public static List<EClass> getCompatibleTypesOf(EClass eClass) {
        ArrayList<EClass> ca = new ArrayList<EClass>(eClass.getEAllSuperTypes());
        ca.add(eClass);
        return ca;
    }

    private static void collectAllSuperTypes(Set<EClass> collectedTypes, EClass eClass) {
        for (EClass superType : eClass.getESuperTypes()) {
            if (!collectedTypes.add(superType)) continue;
            EcoreUtil2.collectAllSuperTypes(collectedTypes, superType);
        }
    }

    public static Collection<EClass> getAllSuperTypes(EClass eClass) {
        HashSet<EClass> allSuperTypes = new HashSet<EClass>();
        EcoreUtil2.collectAllSuperTypes(allSuperTypes, eClass);
        return Collections.unmodifiableSet(allSuperTypes);
    }

    public static boolean isAssignableFrom(EClass target, EClass candidate) {
        return candidate != null && (target == EcorePackage.Literals.EOBJECT || target.isSuperTypeOf(candidate));
    }

    public static List<EObject> getAllReferencedObjects(EObject referer, EReference reference) {
        if (reference.getUpperBound() == 1) {
            EObject eObject = (EObject)referer.eGet(reference);
            if (eObject != null) {
                return Collections.singletonList(eObject);
            }
            return Collections.emptyList();
        }
        return (List)referer.eGet(reference);
    }

    public static boolean isValidUri(Resource resource, URI uri) {
        URI normalized;
        URIConverter uriConverter;
        block5: {
            ResourceSet resourceSet;
            URI newURI;
            block4: {
                newURI = EcoreUtil2.getResolvedImportUri(resource, uri);
                try {
                    resourceSet = resource.getResourceSet();
                    if (resourceSet.getResource(uri, false) == null) break block4;
                    return true;
                }
                catch (RuntimeException e) {
                    log.trace("Cannot load resource: " + newURI, e);
                    return false;
                }
            }
            uriConverter = resourceSet.getURIConverter();
            normalized = uriConverter.normalize(newURI);
            if (normalized == null || !"platform".equals(normalized.scheme()) || normalized.isPlatform()) break block5;
            return false;
        }
        return uriConverter.exists(normalized, Collections.emptyMap());
    }

    public static boolean isValidUri(EObject context, URI uri) {
        return EcoreUtil2.isValidUri(context.eResource(), uri);
    }

    private static URI getResolvedImportUri(Resource context, URI uri) {
        URI contextURI = context.getURI();
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public static Resource getResource(Resource context, String uri) {
        URI newURI = EcoreUtil2.getResolvedImportUri(context, URI.createURI(uri));
        try {
            return context.getResourceSet().getResource(newURI, true);
        }
        catch (RuntimeException e) {
            log.trace("Cannot load resource: " + newURI, e);
            return null;
        }
    }

    public static ResourceSet getResourceSet(Notifier ctx) {
        if (ctx instanceof EObject) {
            Resource eResource = ((EObject)ctx).eResource();
            if (eResource != null) {
                return eResource.getResourceSet();
            }
        } else {
            if (ctx instanceof Resource) {
                return ((Resource)ctx).getResourceSet();
            }
            if (ctx instanceof ResourceSet) {
                return (ResourceSet)ctx;
            }
        }
        return null;
    }

    public static void resolveAll(Resource resource, CancelIndicator monitor) {
        TreeIterator<EObject> i = resource.getAllContents();
        while (!monitor.isCanceled() && i.hasNext()) {
            EObject eObject = (EObject)i.next();
            EcoreUtil2.resolveCrossReferences(eObject, monitor);
        }
    }

    public static void resolveLazyCrossReferences(Resource resource, CancelIndicator monitor) {
        if (resource instanceof LazyLinkingResource) {
            ((LazyLinkingResource)resource).resolveLazyCrossReferences(monitor);
        } else {
            EcoreUtil2.resolveAll(resource, monitor);
        }
    }

    public static void resolveAll(EObject eObject, CancelIndicator monitor) {
        EcoreUtil2.resolveCrossReferences(eObject, monitor);
        TreeIterator<EObject> i = eObject.eAllContents();
        while (!monitor.isCanceled() && i.hasNext()) {
            EObject childEObject = (EObject)i.next();
            EcoreUtil2.resolveCrossReferences(childEObject, monitor);
        }
    }

    private static void resolveCrossReferences(EObject eObject, CancelIndicator monitor) {
        Iterator i = eObject.eCrossReferences().iterator();
        while (!monitor.isCanceled() && i.hasNext()) {
            i.next();
        }
    }

    public static String toExternalForm(EReference ref) {
        if (ref == null) {
            return null;
        }
        String result = exernalFormCache.get(ref);
        if (result == null) {
            EClass class1 = ref.getEContainingClass();
            if (class1 == null) {
                result = EcoreUtil.getURI(ref).toString();
            } else {
                StringBuilder buff = new StringBuilder(class1.getEPackage().getNsURI());
                buff.append(delim).append(class1.getName());
                buff.append(delim).append(class1.getFeatureID(ref));
                result = buff.toString();
            }
            exernalFormCache.put(ref, result);
        }
        return result;
    }

    public static EReference getEReferenceFromExternalForm(EPackage.Registry registry, String externalForm) {
        if (externalForm == null) {
            return null;
        }
        String[] split = externalForm.split(delim);
        if (split.length != 3) {
            URI uri = URI.createURI(externalForm);
            URI packURI = uri.trimFragment();
            EPackage ePackage = registry.getEPackage(packURI.toString());
            if (ePackage == null) {
                return null;
            }
            EReference result = (EReference)ePackage.eResource().getEObject(uri.fragment());
            return result;
        }
        EPackage ePackage = registry.getEPackage(split[0]);
        if (ePackage == null) {
            return null;
        }
        EClass clazz = (EClass)ePackage.getEClassifier(split[1]);
        if (clazz == null) {
            return null;
        }
        return (EReference)clazz.getEStructuralFeature(Integer.valueOf(split[2]));
    }

    public static boolean hasSameURI(EObject o0, EObject o1) {
        return EcoreUtil.getURI(o0).equals(EcoreUtil.getURI(o1));
    }

    public static URI getNormalizedResourceURI(EObject eObject) {
        if (eObject.eResource() != null) {
            return EcoreUtil2.getNormalizedURI(eObject.eResource());
        }
        return URIConverter.INSTANCE.normalize(EcoreUtil.getURI(eObject).trimFragment());
    }

    public static URI getNormalizedURI(EObject eObject) {
        URI rawURI = EcoreUtil.getURI(eObject);
        Resource resource = eObject.eResource();
        if (resource != null && resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(rawURI);
        }
        return URIConverter.INSTANCE.normalize(rawURI);
    }

    public static URI getNormalizedURI(Resource resource) {
        if (resource.getResourceSet() != null) {
            return resource.getResourceSet().getURIConverter().normalize(resource.getURI());
        }
        return URIConverter.INSTANCE.normalize(resource.getURI());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EClassTypeHierarchyComparator
    implements Comparator<EClass> {
        private EClassTypeHierarchyComparator() {
        }

        @Override
        public int compare(EClass classA, EClass classB) {
            if (classA.getEAllSuperTypes().contains(classB)) {
                return -1;
            }
            if (classB.getEAllSuperTypes().contains(classA)) {
                return 1;
            }
            return 0;
        }
    }
}

