/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.utils.AbstractEMFWorkflowComponent;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtend.util.stdlib.DynamicEcoreHelper;
import org.eclipse.xtend.util.stdlib.tracing.M2CTraceElement;
import org.eclipse.xtend.util.stdlib.tracing.M2MTraceElement;
import org.eclipse.xtend.util.stdlib.tracing.MapList;
import org.eclipse.xtend.util.stdlib.tracing.TraceElement;
import org.eclipse.xtend.util.stdlib.tracing.TraceStore;

public class TraceComponent
extends AbstractEMFWorkflowComponent {
    private static final String COMPONENT_NAME = "Trace Component";
    private String traceModelSlotName;
    private String traceName;
    private static TraceStore traceStore = new TraceStore();
    private static Stack<String> fileStack = new Stack();
    private static int tokenValue = 0;
    private static MapList cache = new MapList();

    public static void createTrace(Object from, Object to, String kind) {
        M2MTraceElement t = new M2MTraceElement(kind, (EObject)from, (EObject)to);
        traceStore.add(t);
    }

    public static void createTrace(Object from, Collection to, String kind) {
        M2MTraceElement t = new M2MTraceElement(kind, (EObject)from, to);
        traceStore.add(t);
    }

    public static void createTrace(Collection from, Object to, String kind) {
        M2MTraceElement t = new M2MTraceElement(kind, from, (EObject)to);
        traceStore.add(t);
    }

    public static String createCodeTrace(Object from, String kind) {
        if (!fileStack.isEmpty()) {
            String currentFile = fileStack.peek();
            String token = TraceComponent.createNewToken();
            M2CTraceElement t = new M2CTraceElement(kind, (EObject)from, currentFile, token);
            traceStore.add(t);
            return token;
        }
        return "<unknown>";
    }

    private static String createNewToken() {
        return "TRACE_" + tokenValue++;
    }

    public static Object getSingleTraceTarget(Object from, String kind) {
        List traces = traceStore.getTraces(from, kind);
        if (traces.size() == 0) {
            return null;
        }
        M2MTraceElement e = (M2MTraceElement)traces.get(0);
        return e.getTargets().get(0);
    }

    public static Object getTraceTargets(Object from, String kind) {
        List traces = traceStore.getTraces(from, kind);
        ArrayList<EObject> targets = new ArrayList<EObject>();
        for (M2MTraceElement te : traces) {
            targets.addAll(te.getTargets());
        }
        return targets;
    }

    public String getLogMessage() {
        return "building trace model in slot '" + this.traceModelSlotName + "'";
    }

    public static void clearTrace() {
        traceStore.clear();
    }

    public void setTraceModelSlot(String slot) {
        this.traceModelSlotName = slot;
    }

    public void setTraceName(String name) {
        this.traceName = name;
    }

    public void checkConfiguration(Issues issues) {
        if (this.traceModelSlotName == null) {
            issues.addError(this, "you have to specify a traceModelSlot");
        }
        if (this.traceName == null) {
            issues.addError(this, "you have to specify a traceName");
        }
    }

    public void invokeInternal(WorkflowContext ctx, ProgressMonitor mon, Issues issues) {
        this.setUseSingleGlobalResourceSet(true);
        try {
            StandaloneSetup setup = new StandaloneSetup();
            setup.addRegisterEcoreFile("platform:/resource/eclipse.xtend.util.stdlib/src/org/eclipse/xtend/util/stdlib/trace.ecore");
            EPackage pack = setup.getPackage("http://openarchitectureware.org/trace");
            DynamicEcoreHelper h = new DynamicEcoreHelper(pack);
            EObject model = h.create("Trace");
            this.createElementList(h, model);
            this.createBySource(h, model);
            ctx.set(this.traceModelSlotName, model);
        }
        catch (Exception e) {
            issues.addError(this, e.getMessage());
        }
    }

    private void createBySource(DynamicEcoreHelper h, EObject model) {
        for (EObject source : cache.getKeys()) {
            EObject bySource = h.create("TraceBySource");
            h.set(bySource, "source", source);
            List traces = cache.get(source);
            for (EObject item : traces) {
                h.add(bySource, "items", item);
            }
            h.add(model, "traceBySource", bySource);
        }
    }

    private void createElementList(DynamicEcoreHelper h, EObject model) {
        EObject list = h.create("TraceList");
        h.set(model, "list", list);
        for (TraceElement element : traceStore.getAllTraces()) {
            EObject item = null;
            if (element instanceof M2MTraceElement) {
                M2MTraceElement m2m = (M2MTraceElement)element;
                item = h.create("M2MTraceItem");
                h.set(item, "kind", m2m.getKind());
                h.addAll(item, "from", m2m.getSources());
                h.addAll(item, "to", m2m.getTargets());
                h.add(list, "items", item);
            } else {
                M2CTraceElement m2c = (M2CTraceElement)element;
                item = h.create("M2CTraceItem");
                h.set(item, "kind", m2c.getKind());
                h.addAll(item, "from", m2c.getSources());
                h.set(item, "targetFile", m2c.getFileName());
                h.set(item, "token", m2c.getToken());
                h.add(list, "items", item);
            }
            for (EObject source : element.getSources()) {
                cache.add(source, item);
            }
        }
    }

    public static void reportFileOpen(String path) {
        fileStack.push(path);
    }

    public static void reportFileClose() {
        fileStack.pop();
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

