/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.util.stdlib;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class SlotPrinter
extends AbstractWorkflowComponent2 {
    private static final Log LOG = LogFactory.getLog(SlotPrinter.class);
    private static final int TRACE = 0;
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 3;
    private static final String[] LEVELS = new String[]{"TRACE", "DEBUG", "INFO", "WARN"};
    private static final String COMPONENT_NAME = "Slot Printer";
    private String slotName;
    private String message;
    private int level = 2;

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setSlotName(String name) {
        this.slotName = name;
    }

    public void setLevel(String lvl) {
        int i = Arrays.binarySearch(LEVELS, lvl);
        if (i == -1) {
            throw new IllegalArgumentException(lvl);
        }
        this.level = i;
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.slotName == null) {
            issues.addError(this, "slotName not specified");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        StringBuffer b2 = new StringBuffer();
        if (this.message != null) {
            b2.append(String.valueOf(this.message) + ": ");
        }
        b2.append("(slot: " + this.slotName + ")");
        b2.append(ctx.get(this.slotName));
        switch (this.level) {
            case 0: {
                LOG.trace(b2);
                break;
            }
            case 1: {
                LOG.debug(b2);
                break;
            }
            case 2: {
                LOG.info(b2);
                break;
            }
            case 3: {
                LOG.warn(b2);
            }
        }
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

